/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class AtomicLongFieldUpdater {
    public static AtomicLongFieldUpdater newUpdater(Class clazz, String string) {
        return new LockedUpdater(clazz, string);
    }

    public abstract boolean compareAndSet(Object var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(Object var1, long var2, long var4);

    public abstract void set(Object var1, long var2);

    public abstract long get(Object var1);

    public long getAndSet(Object object, long l2) {
        long l3;
        while (!this.compareAndSet(object, l3 = this.get(object), l2)) {
        }
        return l3;
    }

    public long getAndIncrement(Object object) {
        long l2;
        long l3;
        while (!this.compareAndSet(object, l3 = this.get(object), l2 = l3 + 1L)) {
        }
        return l3;
    }

    public long getAndDecrement(Object object) {
        long l2;
        long l3;
        while (!this.compareAndSet(object, l3 = this.get(object), l2 = l3 - 1L)) {
        }
        return l3;
    }

    public long getAndAdd(Object object, long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(object, l4 = this.get(object), l3 = l4 + l2)) {
        }
        return l4;
    }

    public long incrementAndGet(Object object) {
        long l2;
        long l3;
        while (!this.compareAndSet(object, l3 = this.get(object), l2 = l3 + 1L)) {
        }
        return l2;
    }

    public long decrementAndGet(Object object) {
        long l2;
        long l3;
        while (!this.compareAndSet(object, l3 = this.get(object), l2 = l3 - 1L)) {
        }
        return l2;
    }

    public long addAndGet(Object object, long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(object, l4 = this.get(object), l3 = l4 + l2)) {
        }
        return l3;
    }

    private static class LockedUpdater
    extends AtomicLongFieldUpdater {
        private final Class tclass;
        private final Field fclass;

        public LockedUpdater(Class clazz, String string) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(string);
                field.setAccessible(true);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz2 = field.getType();
            if (clazz2 != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(field.getModifiers())) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.tclass = clazz;
            this.fclass = field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean compareAndSet(Object object, long l2, long l3) {
            if (!this.tclass.isInstance(object)) {
                throw new ClassCastException();
            }
            try {
                Object object2 = object;
                synchronized (object2) {
                    long l4 = this.fclass.getLong(object);
                    if (l4 != l2) {
                        return false;
                    }
                    this.fclass.setLong(object, l3);
                    return true;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public boolean weakCompareAndSet(Object object, long l2, long l3) {
            return this.compareAndSet(object, l2, l3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object object, long l2) {
            if (!this.tclass.isInstance(object)) {
                throw new ClassCastException();
            }
            try {
                Object object2 = object;
                synchronized (object2) {
                    this.fclass.setLong(object, l2);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long get(Object object) {
            if (!this.tclass.isInstance(object)) {
                throw new ClassCastException();
            }
            try {
                Object object2 = object;
                synchronized (object2) {
                    return this.fclass.getLong(object);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

