/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class SpaceURLDialog
extends JDialog {
    private BorderLayout borderLayout1 = new BorderLayout();
    private CardLayout cardLayout = new CardLayout();
    private JButton butAdd = new JButton();
    private JButton butCancel = new JButton();
    private JButton butOK = new JButton();
    private JComboBox cmboxProtocol = new JComboBox();
    private JComboBox cmboxAttributeValue = new JComboBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JLabel labContainer = new JLabel();
    private JLabel labEqual = new JLabel();
    private JLabel labHost = new JLabel();
    private JLabel labProtocol = new JLabel();
    private JLabel labSpace = new JLabel();
    private JPanel panAttributes = new JPanel();
    private JPanel panBuilder = new JPanel();
    private JPanel panCenter = new JPanel();
    private JPanel panel1 = new JPanel();
    private JPanel panOptions = new JPanel();
    private JPanel panSouth = new JPanel();
    private JPanel panOptionsTextField = new JPanel();
    private JPanel panOptionsRadioButtons = new JPanel();
    private JScrollPane scrollPaneAttributes = new JScrollPane();
    private JTextField txtfAttributesSet = new JTextField();
    private JTextField txtfContainer = new JTextField();
    private JTextField txtfHost = new JTextField();
    private JTextField txtfSpace = new JTextField();
    private JRadioButton rbutOptionsTrue = new JRadioButton();
    private JRadioButton rbutOptionsFalse = new JRadioButton();
    private ButtonGroup radioButtonGroup = new ButtonGroup();
    private JList listAttributes = new JList();
    private SpaceBrowser spaceBrowserOwner;
    private boolean isPressedOK;
    public static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
    static /* synthetic */ Class class$java$lang$String;

    public SpaceURLDialog(SpaceBrowser spaceBrowser, String string, boolean bl2) {
        super(spaceBrowser, string, bl2);
        this.spaceBrowserOwner = spaceBrowser;
        try {
            this.jbInit();
            this.initListeners();
            this.setSize(500, 377);
            JSpaceUtilities.setCenterAWTWindow(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initListeners() throws Exception {
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = SpaceURLDialog.this.txtfAttributesSet.getText().trim().length() > 0;
                SpaceURLDialog.this.txtfAttributesSet.setText(SpaceURLDialog.this.txtfAttributesSet.getText().trim() + (bl2 ? "&" : "") + SpaceURLDialog.this.listAttributes.getSelectedValue() + '=' + SpaceURLDialog.this.cmboxAttributeValue.getSelectedItem());
            }
        });
        this.butOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (JSpaceUtilities.isEmpty(SpaceURLDialog.this.txtfSpace.getText(), true)) {
                        JOptionPane.showMessageDialog(SpaceURLDialog.this, "Unable to create valid space URL. Please provide space name.", "Invalid Space URL", 2);
                        return;
                    }
                    SpaceURLDialog.this.getSpaceUrl();
                    SpaceURLDialog.this.isPressedOK = true;
                    SpaceURLDialog.this.dispose();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(SpaceURLDialog.this, "Not allowed input arguments", "Error message", 0);
                }
            }
        });
        this.butCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceURLDialog.this.isPressedOK = false;
                SpaceURLDialog.this.dispose();
            }
        });
        this.listAttributes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                Attribute attribute = (Attribute)SpaceURLDialog.this.listAttributes.getSelectedValue();
                if (attribute.getName().equals("schema")) {
                    SpaceURLDialog.this.updateSchemasCombo();
                } else {
                    SpaceURLDialog.this.cmboxAttributeValue.setModel(new DefaultComboBoxModel<Object>(attribute.getPredefinedValues()));
                }
                SpaceURLDialog.this.cmboxAttributeValue.setEditable(attribute.isEditable());
                SpaceURLDialog.this.butAdd.setEnabled(attribute.hasPredefinedValues());
            }
        });
        this.cmboxAttributeValue.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                SpaceURLDialog.this.updateAddButtonMode(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                SpaceURLDialog.this.updateAddButtonMode(keyEvent);
            }
        });
        this.cmboxAttributeValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceURLDialog.this.updateAddButtonMode(actionEvent);
            }
        });
    }

    public void setVisible(boolean bl2) {
        Attribute attribute;
        if (bl2 && (attribute = (Attribute)this.listAttributes.getSelectedValue()) != null && attribute.getName().equals("schema")) {
            this.updateSchemasCombo();
        }
        super.setVisible(bl2);
    }

    private void updateSchemasCombo() {
        this.cmboxAttributeValue.setModel(this.spaceBrowserOwner.getSchemasComboBoxModel());
    }

    private void updateAddButtonMode(EventObject eventObject) {
        Object object = null;
        if (eventObject instanceof KeyEvent) {
            object = this.cmboxAttributeValue.getEditor().getItem();
        } else if (eventObject instanceof ActionEvent) {
            object = this.cmboxAttributeValue.getSelectedItem();
        }
        if (object instanceof String && ((String)object).length() > 0) {
            this.butAdd.setEnabled(true);
        } else {
            this.butAdd.setEnabled(false);
        }
    }

    private void jbInit() throws Exception {
        this.listAttributes.setModel(new AttributesListModel());
        this.listAttributes.setVisibleRowCount(7);
        this.listAttributes.setSelectionMode(0);
        this.rbutOptionsTrue.setText("true");
        this.rbutOptionsFalse.setText("false");
        this.radioButtonGroup.add(this.rbutOptionsFalse);
        this.radioButtonGroup.add(this.rbutOptionsTrue);
        this.panOptionsRadioButtons.add(this.rbutOptionsTrue);
        this.panOptionsRadioButtons.add(this.rbutOptionsFalse);
        this.panOptionsTextField.add(this.cmboxAttributeValue);
        this.panOptions.setLayout(this.cardLayout);
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        this.panOptions.add(clazz.getName(), this.panOptionsTextField);
        this.panOptions.add(Boolean.TYPE.getName(), this.panOptionsRadioButtons);
        this.cmboxProtocol.setModel(new DefaultComboBoxModel<Object>(SpaceURL.AVAILABLE_PROTOCOLS.toArray()));
        Dimension dimension = new Dimension(60, 21);
        this.cmboxProtocol.setPreferredSize(dimension);
        this.cmboxProtocol.setMinimumSize(dimension);
        this.cmboxAttributeValue.setPreferredSize(dimension);
        this.cmboxAttributeValue.setMinimumSize(dimension);
        this.panel1.setLayout(this.borderLayout1);
        this.butCancel.setText("Cancel");
        this.butOK.setText("Apply");
        this.panCenter.setLayout(this.gridBagLayout1);
        this.panBuilder.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Builder"));
        this.panBuilder.setLayout(this.gridBagLayout2);
        this.labProtocol.setText("Protocol:");
        this.labHost.setText("Host:");
        this.labContainer.setText("Container:");
        this.labSpace.setText("Space:");
        this.panAttributes.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Attributes Set"));
        this.panAttributes.setLayout(this.gridBagLayout3);
        this.labEqual.setText("equals");
        this.butAdd.setText("Add");
        this.butAdd.setEnabled(false);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.panSouth, "South");
        this.panSouth.add((Component)this.butOK, null);
        this.panSouth.add((Component)this.butCancel, null);
        this.panel1.add((Component)this.panCenter, "Center");
        this.panCenter.add((Component)this.panBuilder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panBuilder.add((Component)this.labProtocol, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.cmboxProtocol, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.labHost, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.txtfHost, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.labContainer, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.txtfContainer, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.labSpace, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.txtfSpace, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panBuilder.add((Component)this.panAttributes, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPaneAttributes.getViewport().add((Component)this.listAttributes, null);
        this.panAttributes.add((Component)this.scrollPaneAttributes, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.labEqual, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panAttributes.add((Component)this.cmboxAttributeValue, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panAttributes.add((Component)this.txtfAttributesSet, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panAttributes.add((Component)this.butAdd, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void setUrl(String string) {
        try {
            this.setSpaceUrl(SpaceURLParser.parseURL(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSpaceUrl(SpaceURL spaceURL) {
        this.cmboxProtocol.setSelectedItem(spaceURL.getProtocol());
        this.txtfHost.setText(spaceURL.getHost());
        this.txtfContainer.setText(spaceURL.getContainerName());
        this.txtfSpace.setText(spaceURL.getSpaceName());
        int n2 = spaceURL.getURL().indexOf(63);
        if (n2 != -1) {
            this.txtfAttributesSet.setText(spaceURL.getURL().substring(n2 + 1));
        } else {
            this.txtfAttributesSet.setText("");
        }
    }

    public String getUrl() {
        String string = this.cmboxProtocol.getSelectedItem().toString();
        StringBuffer stringBuffer = new StringBuffer().append(string).append(string.indexOf(58) != -1 ? "//" : "://").append(this.txtfHost.getText().trim()).append('/').append(this.txtfContainer.getText().trim()).append('/').append(this.txtfSpace.getText().trim());
        if (this.txtfSpace.getText().trim().length() > 0 && this.txtfAttributesSet.getText().trim().length() > 0) {
            stringBuffer.append('?').append(this.txtfAttributesSet.getText().trim());
        }
        return stringBuffer.toString();
    }

    public SpaceURL getSpaceUrl() throws MalformedURLException {
        return SpaceURLParser.parseURL(this.getUrl());
    }

    public boolean isPressedOK() {
        return this.isPressedOK;
    }

    public class AttributesListModel
    extends DefaultListModel {
        public AttributesListModel() {
            this.addElement(new Attribute("groups"));
            this.addElement(new Attribute("locators"));
            this.addElement(new Attribute("clustername"));
            this.addElement(new Attribute("clustergroup"));
            this.addElement(new Attribute("timeout"));
            this.addElement(new Attribute("fifo", true));
            this.addElement(new Attribute("destroy", true));
            this.addElement(new Attribute("create", true));
            this.addElement(new Attribute("useLocalCache", true));
            this.addElement(new Attribute("updateMode", new Object[]{_Integer.valueOf(1), _Integer.valueOf(2)}));
            this.addElement(new Attribute("versioned", true));
            this.addElement(new Attribute("securityManager", true));
            this.addElement(new Attribute("NOWriteLease", true));
            this.addElement(new Attribute("mirror", true));
            this.addElement(new Attribute("schema", new Object[]{""}, true));
            this.addElement(new Attribute("cluster_schema", ResourceLoader.getClusterSchemas()));
            this.addElement(new Attribute("total_members"));
            this.addElement(new Attribute("backup_id"));
            this.addElement(new Attribute("id"));
            this.addElement(new Attribute("properties"));
        }
    }

    public class Attribute {
        public String name;
        public Object[] predefinedValues;
        public boolean isEditable;

        public Attribute(String string) {
            this(string, null, true);
        }

        public Attribute(String string, Object[] objectArray) {
            this(string, objectArray, false);
        }

        public Attribute(String string, boolean bl2) {
            this(string, (Object[])(bl2 ? BOOLEAN_VALUES : null), false);
        }

        public Attribute(String string, Object[] objectArray, boolean bl2) {
            this.name = string;
            this.predefinedValues = objectArray;
            this.isEditable = bl2;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEditable() {
            return this.isEditable;
        }

        public boolean hasPredefinedValues() {
            return this.predefinedValues != null && this.predefinedValues.length > 0;
        }

        public Object[] getPredefinedValues() {
            return this.predefinedValues != null ? this.predefinedValues : new Object[]{};
        }

        public String toString() {
            return this.name;
        }
    }
}

