/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.core.client.ClientUIDHandler;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.client.version.map.MapVersionTable;
import com.j_spaces.map.Attribute;
import com.j_spaces.map.Envelope;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.IMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.sf.retrotranslator.runtime.java.lang.Deprecated_;

public abstract class AbstractMap
implements IMap {
    public static final int NONE_COMPRESSION = 0;
    public static final int ZIP_COMPRESSION = 1;
    public Transaction _transaction;
    public long _timeToLive = Long.MAX_VALUE;
    public long _timeout = 0L;
    public IJSpace _spaceProxy;
    public final int _compression;
    public static MapVersionTable _entryInfos;
    public boolean _isVersioned;
    private static Logger a;
    static /* synthetic */ Class class$com$j_spaces$map$AbstractMap;

    public AbstractMap(IJSpace iJSpace, long l2, Transaction transaction, int n2, boolean bl2) {
        this._spaceProxy = iJSpace;
        this._transaction = transaction;
        this._timeToLive = l2;
        this._isVersioned = bl2;
        switch (n2) {
            case 1: {
                this._compression = 3;
                break;
            }
            default: {
                this._compression = 0;
            }
        }
        this.setVersioned(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setVersioned(boolean bl2) {
        this._isVersioned = bl2;
        this._spaceProxy.setOptimisticLocking(bl2);
        if (!this._isVersioned || _entryInfos != null) return;
        Class<?> clazz = class$com$j_spaces$map$AbstractMap;
        if (clazz == null) {
            clazz = class$com$j_spaces$map$AbstractMap = new AbstractMap[0].getClass().getComponentType();
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_entryInfos != null) return;
            _entryInfos = new MapVersionTable();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final boolean isVersioned() {
        return this._isVersioned;
    }

    public final void setTimeToLive(long l2) {
        this._timeToLive = l2;
    }

    public final long getTimeToLive() {
        return this._timeToLive;
    }

    public final void setWaitForResponse(long l2) {
        this._timeout = l2;
    }

    public final long getWaitForResponse() {
        return this._timeout;
    }

    public abstract Object internalPut(Object var1, Object var2, Attribute[] var3, long var4) throws CacheException;

    public abstract Object internalGet(Object var1, long var2, boolean var4) throws CacheException;

    public abstract Object internalRemove(Object var1, long var2) throws CacheException;

    public final Object put(Object object, Object object2, long l2) {
        return this.put(object, object2, null, l2);
    }

    @Deprecated_
    public final Object put(Object object, Object object2, Attribute[] attributeArray, long l2) {
        if (object2 == null || object == null) {
            throw new NullPointerException("Key or value can not be null.");
        }
        if (!(object2 instanceof Serializable)) {
            throw new CacheException("Error putting Object " + object2.getClass() + " in the cache. " + object2.getClass() + " must be serializable.");
        }
        Object object3 = object2;
        try {
            object3 = JSpaceProxyUtil.serializeFieldValue(object2, this._compression, false);
        }
        catch (IOException iOException) {
            throw new CacheException(iOException);
        }
        return this.internalPut(object, object3, attributeArray, l2);
    }

    @Deprecated_
    public final Object put(Object object, Object object2, Attribute[] attributeArray) {
        return this.put(object, object2, attributeArray, this._timeToLive);
    }

    public final Object put(Object object, Object object2) {
        return this.put(object, object2, null, this._timeToLive);
    }

    public void putAll(Map map) {
        if (map instanceof GSMapImpl) {
            throw new IllegalArgumentException("Only java.util.Map or classes derived from java.util.Map are allowed.");
        }
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Map getAll(Collection collection) throws com.j_spaces.javax.cache.CacheException {
        HashMap hashMap = new HashMap(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            hashMap.put(e2, this.get(e2));
        }
        return hashMap;
    }

    public Object get(Object object) {
        return this.get(object, this._timeout);
    }

    public Object get(Object object, long l2) {
        return this.internalGet(object, l2, false);
    }

    public Attribute[] getAttributes(Object object, long l2) {
        return (Attribute[])this.internalGet(object, l2, true);
    }

    public final Attribute[] getAttributes(Object object) {
        return this.getAttributes(object, this._timeout);
    }

    public final Attribute getAttribute(Object object, String string) {
        Attribute[] attributeArray = this.getAttributes(object);
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Attribute attribute = attributeArray[i2];
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public int size() {
        try {
            return this._spaceProxy.count(new Envelope(), this._transaction);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object object) {
        return this.remove(object, this._timeout);
    }

    public Object remove(Object object, long l2) {
        return this.internalRemove(object, l2);
    }

    public final void setTransaction(Transaction transaction) {
        this._transaction = transaction;
    }

    public final Transaction getTransaction() {
        return this._transaction;
    }

    public void load(Object object) throws com.j_spaces.javax.cache.CacheException {
    }

    public void loadAll(Collection collection) throws com.j_spaces.javax.cache.CacheException {
    }

    public final IJSpace getMasterSpace() {
        if (this._spaceProxy instanceof DCacheSpaceImpl) {
            return ((DCacheSpaceImpl)this._spaceProxy).getRemoteSpace();
        }
        return this._spaceProxy;
    }

    public final IJSpace getLocalSpace() {
        if (this._spaceProxy instanceof DCacheSpaceImpl) {
            return ((DCacheSpaceImpl)this._spaceProxy).getLocalSpace();
        }
        return null;
    }

    public Envelope buildEnvelope(Object object, Object object2, Attribute[] attributeArray, String string) throws IOException {
        Envelope envelope = new Envelope(object, object2, attributeArray, string);
        envelope.m_UID = ClientUIDHandler.createUIDFromName(object, Envelope.ENVELOPE_CLASS_NAME);
        if (this._isVersioned) {
            envelope.m_VersionID = _entryInfos.getEntryVersion(object2, object);
        }
        return envelope;
    }

    public Envelope buildKeyEnvelope(Object object) throws IOException {
        String string = ClientUIDHandler.createUIDFromName(object, Envelope.ENVELOPE_CLASS_NAME);
        Envelope envelope = new Envelope(string, object);
        return envelope;
    }

    public void log(String string, Exception exception) {
        if (a.isLoggable(Level.FINE)) {
            if (exception != null) {
                a.log(Level.FINE, this.toString() + " " + string + " | ", exception);
            } else {
                a.fine(string);
            }
        }
    }

    public void log(String string) {
        this.log(string, null);
    }

    static {
        a = Logger.getLogger("com.gigaspaces.cache");
    }
}

