/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StringsUtils {
    public static final String EMPTY = "";
    private static final String[] a = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"};
    private static final String[] b = new String[]{"AND", "AS", "BETWEEN", "DISTINCT", "EMPTY", "FALSE", "FROM", "IN", "IS", "LIKE", "MEMBER", "NOT", "NULL", "OBJECT", "OF", "OR", "SELECT", "UNKNOWN", "TRUE", "WHERE"};
    public static int listMax = 10;
    public static int listBorder = 3;

    public static final boolean isEjbQlIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < b.length; ++i2) {
            if (!b[i2].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        return string.equals(EMPTY);
    }

    public static final boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            if (Character.isJavaIdentifierPart(cArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaKeyword(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < a.length; ++i2) {
            if (!a[i2].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final void toString(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        if (object instanceof String) {
            StringsUtils.toString(stringBuffer, (String)object);
            return;
        }
        if (object instanceof Vector) {
            StringsUtils.toString(stringBuffer, (Vector)object);
            return;
        }
        if (object instanceof Hashtable) {
            StringsUtils.toString(stringBuffer, (Hashtable)object);
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            StringsUtils.toString(stringBuffer, object, clazz.getComponentType());
            return;
        }
        stringBuffer.append(object.toString());
    }

    public static final String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return StringsUtils.toString((String)object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringsUtils.toString(stringBuffer, object);
        return stringBuffer.toString();
    }

    public static final void toByteArray(ByteArrayOutputStream byteArrayOutputStream, String string) {
        if (string == null) {
            return;
        }
        byteArrayOutputStream.write(34);
        int n2 = string.length();
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' && c2 <= '~') {
                switch (c2) {
                    case '\"': 
                    case '\\': {
                        byteArrayOutputStream.write(92);
                    }
                }
                byteArrayOutputStream.write(c2);
                continue;
            }
            byteArrayOutputStream.write(92);
            switch (c2) {
                case '\b': {
                    byteArrayOutputStream.write(98);
                    continue block10;
                }
                case '\t': {
                    byteArrayOutputStream.write(116);
                    continue block10;
                }
                case '\n': {
                    byteArrayOutputStream.write(110);
                    continue block10;
                }
                case '\f': {
                    byteArrayOutputStream.write(102);
                    continue block10;
                }
                case '\r': {
                    byteArrayOutputStream.write(114);
                    continue block10;
                }
                default: {
                    byteArrayOutputStream.write(117);
                    int n3 = c2 >> 4;
                    int n4 = c2 & 0xF;
                    n4 = n4 < 10 ? (n4 += 48) : (n4 += 87);
                    int n5 = n3 >> 4;
                    n3 = (n3 &= 0xF) < 10 ? (n3 += 48) : (n3 += 87);
                    int n6 = n5 >> 4;
                    n5 = (n5 &= 0xF) < 10 ? (n5 += 48) : (n5 += 87);
                    n6 = n6 < 10 ? (n6 += 48) : (n6 += 87);
                    byteArrayOutputStream.write(n6);
                    byteArrayOutputStream.write(n5);
                    byteArrayOutputStream.write(n3);
                    byteArrayOutputStream.write(n4);
                }
            }
        }
        byteArrayOutputStream.write(34);
    }

    public static final void toString(StringBuffer stringBuffer, String string) {
        if (string == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append(StringsUtils.toString(string));
    }

    public static final String toString(String string) {
        if (string == null) {
            return "null";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringsUtils.toByteArray(byteArrayOutputStream, string);
        return byteArrayOutputStream.toString();
    }

    public static final void toString(StringBuffer stringBuffer, Object object, Class clazz) {
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                StringsUtils.toString(stringBuffer, (boolean[])object);
            } else if (clazz == Character.TYPE) {
                StringsUtils.toString(stringBuffer, (char[])object);
            } else if (clazz == Byte.TYPE) {
                StringsUtils.toString(stringBuffer, (byte[])object);
            } else if (clazz == Short.TYPE) {
                StringsUtils.toString(stringBuffer, (short[])object);
            } else if (clazz == Integer.TYPE) {
                StringsUtils.toString(stringBuffer, (int[])object);
            } else if (clazz == Long.TYPE) {
                StringsUtils.toString(stringBuffer, (long[])object);
            } else if (clazz == Float.TYPE) {
                StringsUtils.toString(stringBuffer, (float[])object);
            } else if (clazz == Double.TYPE) {
                StringsUtils.toString(stringBuffer, (double[])object);
            }
            return;
        }
        Object[] objectArray = (Object[])object;
        stringBuffer.append("(");
        int n2 = objectArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, objectArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, objectArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, objectArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toStringArray(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            StringsUtils.toString(stringBuffer, object);
            return;
        }
        StringsUtils.toString(stringBuffer, object, clazz.getComponentType());
    }

    public static final String toStringArray(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return StringsUtils.toString(object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringsUtils.toString(stringBuffer, object, clazz.getComponentType());
        return stringBuffer.toString();
    }

    public static final void toString(StringBuffer stringBuffer, boolean[] blArray) {
        if (blArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = blArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(blArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(blArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(blArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, byte[] byArray) {
        if (byArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = byArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(byArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(byArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(byArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, char[] cArray) {
        if (cArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = cArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(cArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(cArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(cArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, short[] sArray) {
        if (sArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = sArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(sArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(sArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(sArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, int[] nArray) {
        if (nArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = nArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(nArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(nArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(nArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, long[] lArray) {
        if (lArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = lArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(lArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(lArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(lArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, float[] fArray) {
        if (fArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = fArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(fArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(fArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(fArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, double[] dArray) {
        if (dArray == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = dArray.length;
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(",");
                stringBuffer.append(dArray[i2]);
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                stringBuffer.append(dArray[n3]);
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                stringBuffer.append(dArray[n2 - n3]);
            }
        }
        stringBuffer.append(")");
    }

    public static final void toString(StringBuffer stringBuffer, Vector vector) {
        if (vector == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = vector.size();
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, enumeration.nextElement());
            }
        } else {
            int n3;
            int n4 = n2 / 2;
            if (listBorder < n4) {
                n4 = listBorder;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, vector.elementAt(n3));
            }
            stringBuffer.append(",...");
            for (n3 = n4; n3 > 0; --n3) {
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, vector.elementAt(n2 - n3));
            }
        }
        stringBuffer.append(")");
    }

    public static final String toString(Vector vector) {
        if (vector == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringsUtils.toString(stringBuffer, vector);
        return stringBuffer.toString();
    }

    public static final void toString(StringBuffer stringBuffer, Hashtable hashtable) {
        if (hashtable == null) {
            stringBuffer.append("null");
            return;
        }
        stringBuffer.append("(");
        int n2 = hashtable.size();
        stringBuffer.append(n2);
        if (listMax == -1 || n2 <= listMax) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k2 = enumeration.nextElement();
                stringBuffer.append(",(");
                StringsUtils.toString(stringBuffer, k2);
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, hashtable.get(k2));
                stringBuffer.append(")");
            }
        } else {
            int n3 = n2;
            if (listBorder < n3) {
                n3 = listBorder;
            }
            Enumeration enumeration = hashtable.keys();
            for (int i2 = 0; i2 < n3; ++i2) {
                Object k3 = enumeration.nextElement();
                stringBuffer.append(",(");
                StringsUtils.toString(stringBuffer, k3);
                stringBuffer.append(",");
                StringsUtils.toString(stringBuffer, hashtable.get(k3));
                stringBuffer.append(")");
            }
            if (n3 < n2) {
                stringBuffer.append(",...");
            }
        }
        stringBuffer.append(")");
    }

    public static final String toString(Hashtable hashtable) {
        if (hashtable == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringsUtils.toString(stringBuffer, hashtable);
        return stringBuffer.toString();
    }
}

