/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IRemoteJSpace;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.RequestPacket;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SocketSession;
import com.j_spaces.jdbc.driver.Blob;
import com.j_spaces.jdbc.driver.Clob;
import com.j_spaces.jdbc.driver.GDatabaseMetaData;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import com.j_spaces.jdbc.driver.GStatement;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GConnection
implements Connection {
    private Socket a = null;
    private QueryProcessor b = null;
    private boolean c = true;
    private boolean d = false;
    private static Object e = new Object();
    private String f = null;
    private boolean g = false;
    private SocketSession h = null;
    public static final String MANUALY_INIT_CONNECTION = "MANUALY_INIT_CONNECTION";
    private static Logger i = Logger.getLogger("com.gigaspaces.persistent");

    private GConnection(IJSpace iJSpace) throws SQLException {
        InetSocketAddress inetSocketAddress = null;
        try {
            IRemoteJSpace iRemoteJSpace = ((IDirectSpaceProxy)iJSpace).getRemoteJSpace();
            inetSocketAddress = iRemoteJSpace.getLightSocketAddress("QueryProcessorWorker");
            this.a = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.f = "jdbc:gigaspaces:" + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        }
        catch (Exception exception) {
            if (i.isLoggable(Level.INFO)) {
                i.info("\n **********************************************************************\n *  Error: The query processor has not been initialized !\n *        Please check QueryProcessorWorker definition in your schema\n  ********************************************************************** \n\n");
            }
            throw new SQLException("The query processor has not been initialized ");
        }
    }

    public GConnection(QueryProcessor queryProcessor) throws SQLException {
        this.b = queryProcessor;
        this.h = queryProcessor.createLocalSession();
        this.g = true;
        this.c = QueryProcessor.AUTO_COMMIT;
    }

    public GConnection(String string, boolean bl2, Properties properties) throws SQLException {
        try {
            if (string.indexOf("url:") < 0 || bl2) {
                this.a(string, bl2, properties);
            } else {
                this.initGConnection(string);
            }
        }
        catch (Exception exception) {
            if (i.isLoggable(Level.SEVERE)) {
                i.log(Level.SEVERE, exception.getMessage(), exception);
            }
            throw new SQLException("Can't connect to QueryProcessor please check your url");
        }
    }

    public void initGConnection(String string) {
        block2: {
            InetSocketAddress inetSocketAddress = null;
            try {
                String string2 = string.substring("jdbc:gigaspaces:url:".length());
                IJSpace iJSpace = (IJSpace)SpaceFinder.find(string2);
                IRemoteJSpace iRemoteJSpace = ((IDirectSpaceProxy)iJSpace).getRemoteJSpace();
                inetSocketAddress = iRemoteJSpace.getLightSocketAddress("QueryProcessorWorker");
                this.a = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                this.f = "jdbc:gigaspaces:" + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
            }
            catch (Exception exception) {
                if (!i.isLoggable(Level.INFO)) break block2;
                i.info("Query processor not found !\n       Space not exist [ " + string.substring("jdbc:gigaspaces:url:".length()) + "]\n" + "       Please check your url [ " + string + " ]\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, boolean bl2, Properties properties) throws SQLException {
        this.g = bl2;
        try {
            if (this.g) {
                if (this.b == null) {
                    Object object = e;
                    synchronized (object) {
                        String string2 = System.getProperty("com.gigaspaces.embeddedQP.properties");
                        if (string2 == null) {
                            string2 = System.getProperty("com.gs.embeddedQP.properties");
                        }
                        if (properties.getProperty("SPACE_URL") == null) {
                            if (string2 == null) {
                                throw new IOException("must include -Dcom.gigaspaces.embeddedQP.properties=filename when running an embedded QueryProcessor");
                            }
                            Properties properties2 = new Properties();
                            FileInputStream fileInputStream = new FileInputStream(string2);
                            properties2.load(fileInputStream);
                            this.b = QueryProcessor.getQpInstance(null, properties2, null, true);
                            fileInputStream.close();
                        } else if (properties.getProperty(MANUALY_INIT_CONNECTION) == null) {
                            this.b = QueryProcessor.getQpInstance(null, properties, null, true);
                        }
                    }
                }
                if (this.b != null) {
                    this.h = this.b.createLocalSession();
                    this.f = string;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring("jdbc:gigaspaces:".length()), ":");
                String string3 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (i.isLoggable(Level.FINE)) {
                    i.fine("QueryProcessor: got IP: " + string3 + " and port: " + n2);
                }
                InetAddress inetAddress = InetAddress.getByName(string3);
                this.a = new Socket(inetAddress, n2);
                this.f = string;
            }
            this.c = QueryProcessor.AUTO_COMMIT;
        }
        catch (UnknownHostException unknownHostException) {
            if (i.isLoggable(Level.SEVERE)) {
                i.log(Level.SEVERE, unknownHostException.getMessage(), unknownHostException);
            }
            throw new SQLException("Error creating connection - Unknown host", "GSP", -137);
        }
        catch (IOException iOException) {
            if (i.isLoggable(Level.SEVERE)) {
                i.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            throw new SQLException("Error creating connection or reading QP properties");
        }
    }

    public void reinit(Properties properties, IJSpace iJSpace) {
        this.b = new QueryProcessor(null, iJSpace, true);
        this.h = this.b.createLocalSession();
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("Command not Supported!", "GSP", -132);
    }

    public int getTransactionIsolation() throws SQLException {
        return 1;
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        try {
            if (this.a != null) {
                this.a.close();
                this.a = null;
            }
            if (this.g) {
                this.b.closeLocalSession(this.h);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void commit() throws SQLException {
        if (this.c) {
            throw new SQLException("Cannot commit an autocommit connection", "GSP", -139);
        }
        this.sendStatement("COMMIT");
    }

    public void rollback() throws SQLException {
        if (this.c) {
            throw new SQLException("Cannot rollback an autocommit connection", "GSP", -140);
        }
        this.sendStatement("ROLLBACK");
    }

    public boolean getAutoCommit() throws SQLException {
        return this.c;
    }

    public boolean isClosed() throws SQLException {
        return this.a == null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setHoldability(int n2) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        if (n2 != 1) {
            throw new SQLException("This isolation level is not supported");
        }
    }

    public void setAutoCommit(boolean bl2) throws SQLException {
        if (this.c != bl2) {
            RequestPacket requestPacket = new RequestPacket();
            requestPacket.setType((byte)4);
            ResponsePacket responsePacket = this.writeRequestPacket(requestPacket);
            this.a(responsePacket);
            this.c = !this.c;
        }
    }

    public void setUseSingleSpace(boolean bl2) throws SQLException {
        if (this.d != bl2) {
            RequestPacket requestPacket = new RequestPacket();
            requestPacket.setType((byte)5);
            requestPacket.setStatement(Boolean.toString(bl2));
            ResponsePacket responsePacket = this.writeRequestPacket(requestPacket);
            this.a(responsePacket);
            this.d = !this.d;
        }
    }

    public void setReadOnly(boolean bl2) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new GDatabaseMetaData(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public Statement createStatement() throws SQLException {
        return new GStatement(this);
    }

    public Statement createStatement(int n2, int n3) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        GPreparedStatement gPreparedStatement = new GPreparedStatement(this, string);
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.setType((byte)2);
        requestPacket.setStatement(string);
        ResponsePacket responsePacket = this.writeRequestPacket(requestPacket);
        this.a(responsePacket);
        return gPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not Supported!");
    }

    public Socket getSocket() {
        return this.a;
    }

    public ResponsePacket writeRequestPacket(RequestPacket requestPacket) throws SQLException {
        try {
            if (!this.g) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(requestPacket);
                objectOutputStream.flush();
                byteArrayOutputStream.writeTo(this.a.getOutputStream());
                byteArrayOutputStream.flush();
                ObjectInputStream objectInputStream = new ObjectInputStream(this.a.getInputStream());
                ResponsePacket responsePacket = (ResponsePacket)objectInputStream.readObject();
                objectOutputStream.close();
                return responsePacket;
            }
            return this.b.handleEmbeddedRequest(requestPacket, this.h);
        }
        catch (IOException iOException) {
            if (i.isLoggable(Level.SEVERE)) {
                i.log(Level.SEVERE, "Error occurred while writing request", iOException);
            }
            throw new SQLException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (i.isLoggable(Level.SEVERE)) {
                i.log(Level.SEVERE, "Error occurred while reading response", classNotFoundException);
            }
            SQLException sQLException = new SQLException(classNotFoundException.getMessage());
            sQLException.initCause(classNotFoundException);
            throw sQLException;
        }
    }

    private void a(ResponsePacket responsePacket) throws SQLException {
        if (responsePacket.getException() != null) {
            throw responsePacket.getException();
        }
    }

    public Blob createBlob(byte[] byArray) throws SQLException {
        return new Blob(byArray, this);
    }

    public Clob createClob(String string) throws SQLException {
        return new Clob(string, this);
    }

    public ResponsePacket sendStatement(String string) throws SQLException {
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.setType((byte)1);
        requestPacket.setStatement(string);
        ResponsePacket responsePacket = this.writeRequestPacket(requestPacket);
        this.a(responsePacket);
        return responsePacket;
    }

    public ResponsePacket sendPreparedStatement(String string, Object[] objectArray) throws SQLException {
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.setType((byte)3);
        requestPacket.setStatement(string);
        requestPacket.setPreparedValues(objectArray);
        ResponsePacket responsePacket = this.writeRequestPacket(requestPacket);
        this.a(responsePacket);
        return responsePacket;
    }

    public String getUrl() {
        return this.f;
    }

    public static GConnection getInstance(IJSpace iJSpace) throws SQLException {
        return new GConnection(iJSpace);
    }
}

