/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class StatisticsContext
implements Externalizable {
    public AtomicLong currentCount = new AtomicLong();
    public AtomicLong previousCount = new AtomicLong();
    public double average;
    private static final long serialVersionUID = 1L;

    public double getAverage() {
        return this.average;
    }

    public long getCurrentCount() {
        return this.currentCount.get();
    }

    public String toString() {
        return "count: " + this.currentCount.longValue() + ", average time (op/ms): " + this.average;
    }

    public void calculateAverage(long l2) {
        this.average = (double)(this.currentCount.get() - this.previousCount.get()) / (double)l2;
        this.previousCount.set(this.currentCount.get());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.currentCount.get());
        objectOutput.writeLong(this.previousCount.get());
        objectOutput.writeDouble(this.average);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.currentCount = new AtomicLong(objectInput.readLong());
        this.previousCount = new AtomicLong(objectInput.readLong());
        this.average = objectInput.readDouble();
    }

    public void setCurrentCount(AtomicLong atomicLong) {
        this.currentCount = atomicLong;
    }
}

