/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.dynamic.mapping;

import com.j_spaces.core.EntryPacket;
import com.j_spaces.core.IRemoteJSpace;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.core.cluster.dynamic.NotLogicOwnerException;
import com.j_spaces.core.cluster.dynamic.mapping.LogicSpace;
import com.j_spaces.core.cluster.dynamic.mapping.LogicSpaceMap;
import com.j_spaces.core.cluster.dynamic.mapping.MappingListener;
import com.j_spaces.core.cluster.dynamic.mapping.MigrationEntryPacket;
import com.j_spaces.core.cluster.dynamic.mapping.PhysicalSpace;
import com.j_spaces.obf.bn;
import com.j_spaces.obf.ha;
import com.j_spaces.obf.mu;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class DynamicClusterManager
extends LogicSpaceMap {
    private static Logger _logger = Logger.getLogger("com.gigaspaces.core.cluster.dynamic");
    public static final int DONT_CARE_LOGIC = -1;
    public static final int ONLY_OWNER_LOGIC = -2;
    private static final Integer ZERO = _Integer.valueOf(0);
    private transient int[] _backupOwnerCounters;
    private transient String _localName;
    private transient bn _retriever;
    private transient String _clusterName;
    private transient IRemoteJSpace _localSpace;
    private transient ha _locker;
    private transient mu _backupsCounters;

    public DynamicClusterManager(IRemoteJSpace iRemoteJSpace, DynamicClusterManager dynamicClusterManager, String string, String string2) {
        super(dynamicClusterManager);
        this._backupOwnerCounters = new int[this.backupSize()];
        this._backupsCounters = new mu();
        this.init(iRemoteJSpace, string, string2);
    }

    public DynamicClusterManager(IRemoteJSpace iRemoteJSpace, int n2, int n3, String string, String string2) {
        super(n2, n3, string);
        this.init(iRemoteJSpace, string, string2);
    }

    private void init(IRemoteJSpace iRemoteJSpace, String string, String string2) {
        SpaceURL spaceURL;
        block2: {
            this._localName = string;
            this._clusterName = string2;
            this._localSpace = iRemoteJSpace;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string3 = "jini://*/" + stringTokenizer.nextToken() + "/" + stringTokenizer.nextToken();
            spaceURL = null;
            try {
                spaceURL = SpaceURLParser.parseURL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Failed parsing member space url:", malformedURLException);
            }
        }
        JSpaceClusteredProxy.LBProxyHolder lBProxyHolder = new JSpaceClusteredProxy.LBProxyHolder(string, spaceURL, iRemoteJSpace);
        this.addPhysical(string, lBProxyHolder);
        this._retriever = new bn(this);
        this._retriever.start();
    }

    public void stopUsing(int n2) {
        this.stopUsing(n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUsing(int n2, boolean bl2) {
        try {
            this.readLock();
            LogicSpace logicSpace = this._logics[n2];
            if (bl2) {
                logicSpace.unLock();
            } else {
                logicSpace.unUse();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public int startUsing(EntryPacket entryPacket, boolean bl2) throws NotLogicOwnerException {
        int n2 = entryPacket._logicID;
        if (this.startUsing(n2, bl2, true)) {
            return n2;
        }
        String string = this.getPhysicalName(n2);
        throw new NotLogicOwnerException((JSpaceClusteredProxy.LBProxyHolder)this._LBproxies.get((Object)string), n2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startUsing(int n2, boolean bl2, boolean bl3) throws NotLogicOwnerException {
        block6: {
            try {
                this.readLock();
                LogicSpace logicSpace = this._logics[n2];
                if (bl2 && logicSpace.isOwner(this._localName)) {
                    if (bl3) {
                        logicSpace.use();
                    } else {
                        logicSpace.lock();
                    }
                    break block6;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.readUnlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysical(String string, JSpaceClusteredProxy.LBProxyHolder lBProxyHolder) {
        try {
            this.writeLock();
            this.addPhysical(string);
            this._LBproxies.putIfAbsent((Object)string, (Object)lBProxyHolder);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removePhysical(String string) {
        super.removePhysical(string);
        this._LBproxies.remove((Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOwner(Integer n2) {
        try {
            this.readLock();
            boolean bl2 = ((PhysicalSpace)this._physicals.get(this._localName)).isOwner(n2);
            return bl2;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean startSendingSpace(Integer n2, Integer n3) throws NotLogicOwnerException {
        return this.startUsing(n2, true, false);
    }

    public void finishSendingSpace(String string, Integer n2, int n3) throws NotLogicOwnerException {
        this.changeMapping(this._localName, string, n2, n3);
        this.stopUsing(n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieverSpace(int n2, int n3) {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Try to retrieve logicID=" + n2 + " ,backupNum=" + n3);
            }
            this.writeLock();
            String string = this._logics[n2].getOwnerName();
            JSpaceClusteredProxy.LBProxyHolder lBProxyHolder = (JSpaceClusteredProxy.LBProxyHolder)this._LBproxies.get((Object)string);
            this.changeMapping(string, this._localName, n2, n3);
            SpaceCopyStatus spaceCopyStatus = ((IInternalRemoteJSpaceAdmin)((Object)this._localSpace)).spaceCopy(lBProxyHolder.m_MemberUrl.getURL(), new MigrationEntryPacket(n2, n3), true, 1000);
            if (spaceCopyStatus.getCauseException() != null) {
                Exception exception = spaceCopyStatus.getCauseException();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Fail to retrieve logicID=" + n2 + " ,backupNum=" + n3, exception);
                }
                spaceCopyStatus.getCauseException().printStackTrace();
                this.changeMapping(this._localName, string, n2, n3);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (RemoteException remoteException) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Fail to retrieve logicID=" + n2 + " ,backupNum=" + n3, remoteException);
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.writeUnlock();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Finish retrieving logicID=" + n2 + " ,backupNum=" + n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeMapping(String string, String string2, int n2, int n3) {
        try {
            this.writeLock();
            boolean bl2 = super.changeMapping(string, string2, n2, n3);
            if (bl2) {
                if (this._localName.equals(string)) {
                    int n4 = n3;
                    this._backupOwnerCounters[n4] = this._backupOwnerCounters[n4] - 1;
                } else if (this._localName.equals(string2)) {
                    int n5 = n3;
                    this._backupOwnerCounters[n5] = this._backupOwnerCounters[n5] + 1;
                    this.notifyChange(string, string2, n2, n3);
                }
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void notifyChange(String string, String string2, int n2, int n3) {
        if (n3 == 0) {
            List list = this._logics[n2].getPhysicalSpaces();
            if (this._localName.equals(string) && !this._localName.equals(string2)) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    this._backupsCounters.b(((PhysicalSpace)list.get(i2)).getName());
                }
            } else if (this._localName.equals(string2) && !this._localName.equals(string)) {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    this._backupsCounters.a(((PhysicalSpace)list.get(i3)).getName());
                }
            }
        } else if (this._localName.equals(this._logics[n2].getOwnerName())) {
            this._backupsCounters.a(string2);
            this._backupsCounters.b(string);
        }
    }

    public String getLocalName() {
        return this._localName;
    }

    public void setMappingListener(MappingListener mappingListener) {
        this._backupsCounters.a(mappingListener);
    }
}

