/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.lookup.ServiceItem;

public class RestartSpace
extends AbstractSpaceCommand {
    private OptionHandler a;
    public static final String OPERATION_NAME = "restart";

    public RestartSpace() {
        String[] stringArray = new String[]{"h", "help", "url", "c", "cluster"};
        this.a = new OptionHandler(Formatter.fromArray((String[])stringArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = 1;
    }

    public String getUsage() {
        StringBuffer stringBuffer = this.getBasicUsage();
        stringBuffer.append("\n*****************************************************\n");
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            Map map = this.a.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            if (!map.containsKey("url")) {
                IJSpace[] iJSpaceArray = this.getSelectedSpaceProxies(bufferedReader);
                this.a(iJSpaceArray);
                return "";
            }
            String string2 = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(string2, true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object object = null;
            try {
                object = this.find(string2);
            }
            catch (FinderException finderException) {
                return "";
            }
            if (object == null) {
                CLIUtilities.printWrongServiceURLMessage(string2);
                return "";
            }
            IJSpace iJSpace = null;
            if (object instanceof IJSpaceContainer) {
                SpaceURL spaceURL = SpaceURLParser.parseURL(string2);
                ServiceItem[] serviceItemArray = this.getContainerSpaces((IJSpaceContainer)object, spaceURL.getProtocol());
                IJSpace[] iJSpaceArray = this.getSelectedFromListSpaceProxies(serviceItemArray, bufferedReader);
                this.a(iJSpaceArray);
                return "";
            }
            if (object instanceof IJSpace) {
                iJSpace = (IJSpace)object;
            }
            ClusterPolicy clusterPolicy = this.getClusterPolicy(iJSpace);
            String string3 = iJSpace.getName();
            if (clusterPolicy != null) {
                if (map.containsKey("c") || map.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    this.a(clusterPolicy);
                } else {
                    IJSpace[] iJSpaceArray = this.getAllClusterMembers(clusterPolicy, bufferedReader);
                    if (iJSpaceArray == null) {
                        return "No cluster members found.";
                    }
                    this.a(iJSpaceArray);
                }
            } else {
                System.out.print("Restart space <" + string3 + "> ... ");
                this.a((IRemoteJSpaceAdmin)iJSpace.getAdmin());
                System.out.println(" successful.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            System.out.println(" fail.");
            _logger.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ClusterPolicy clusterPolicy) throws RemoteException, FinderException, NoSuchNameException {
        Map map = this.getClusterMembersAdminSpaces(clusterPolicy);
        Set set = map.entrySet();
        System.out.println("There are " + map.size() + " cluster spaces to be restarted.");
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)entry.getValue();
            String string = (String)entry.getKey();
            try {
                System.out.print(n2 + " Restart <" + string + "> cluster member... ");
                this.a(iRemoteJSpaceAdmin);
                System.out.println(" successful");
            }
            catch (Exception exception) {
                System.out.println(" fail");
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
            finally {
                ++n2;
            }
        }
    }

    private void a(IJSpace[] iJSpaceArray) {
        if (iJSpaceArray != null) {
            int n2 = iJSpaceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = iJSpaceArray[i2].getName();
                System.out.print("Started to restart <" + string + "> space (" + (i2 + 1) + " of " + n2 + ")...");
                try {
                    this.a((IRemoteJSpaceAdmin)iJSpaceArray[i2].getAdmin());
                    System.out.println(" successful");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(" fail");
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }
    }

    private void a(IRemoteJSpaceAdmin iRemoteJSpaceAdmin) throws RemoteException {
        iRemoteJSpaceAdmin.restart();
    }
}

