/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.LinkedList;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AspectJAutoProxyBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String PROXY_TARGET_ATTRIBUTE = "proxy-target-class";
    private static final String PROXY_TARGET_CLASS = Conventions.attributeNameToPropertyName("proxy-target-class");

    AspectJAutoProxyBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        AopNamespaceUtils.registerAtAspectJAutoProxyCreatorIfNecessary(parserContext, element);
        this.extendBeanDefinition(registry, element);
        return null;
    }

    private void extendBeanDefinition(BeanDefinitionRegistry registry, Element element) {
        BeanDefinition beanDef = registry.getBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
        String proxyTargetClass = element.getAttribute(PROXY_TARGET_ATTRIBUTE);
        if (StringUtils.hasText(proxyTargetClass)) {
            beanDef.getPropertyValues().addPropertyValue(PROXY_TARGET_CLASS, proxyTargetClass);
        }
        if (element.hasChildNodes()) {
            this.addIncludePatterns(element, beanDef);
        }
    }

    private void addIncludePatterns(Element element, BeanDefinition beanDef) {
        LinkedList<String> includePatterns = new LinkedList<String>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element include = (Element)node;
            String patternText = include.getAttribute("name");
            includePatterns.add(patternText);
        }
        beanDef.getPropertyValues().addPropertyValue("includePatterns", includePatterns);
    }
}

