/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.ConditionalTestCase;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractSpringContextTests
extends ConditionalTestCase {
    private static Map contextKeyToContextMap = new HashMap();

    public AbstractSpringContextTests() {
    }

    public AbstractSpringContextTests(String name) {
        super(name);
    }

    public final void addContext(Object key, ConfigurableApplicationContext context) {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        contextKeyToContextMap.put(this.contextKeyString(key), context);
    }

    protected final boolean hasCachedContext(Object contextKey) {
        return contextKeyToContextMap.containsKey(contextKey);
    }

    protected final ConfigurableApplicationContext getContext(Object key) throws Exception {
        String keyString = this.contextKeyString(key);
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)contextKeyToContextMap.get(keyString);
        if (ctx == null) {
            ctx = this.loadContext(key);
            ctx.registerShutdownHook();
            contextKeyToContextMap.put(keyString, ctx);
        }
        return ctx;
    }

    protected final void setDirty(Object contextKey) {
        String keyString = this.contextKeyString(contextKey);
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)contextKeyToContextMap.remove(keyString);
        if (ctx != null) {
            ctx.close();
        }
    }

    protected String contextKeyString(Object contextKey) {
        return ObjectUtils.nullSafeToString((Object)contextKey);
    }

    protected abstract ConfigurableApplicationContext loadContext(Object var1) throws Exception;
}

