/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.core.CollectionFactory;

public class CustomMapEditor
extends PropertyEditorSupport {
    private final Class mapType;
    private final boolean nullAsEmptyMap;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$SortedMap;

    public CustomMapEditor(Class mapType) {
        this(mapType, false);
    }

    public CustomMapEditor(Class mapType, boolean nullAsEmptyMap) {
        if (mapType == null) {
            throw new IllegalArgumentException("Map type is required");
        }
        if (!(class$java$util$Map == null ? (class$java$util$Map = CustomMapEditor.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type [" + mapType.getName() + "] does not implement [java.util.Map]");
        }
        this.mapType = mapType;
        this.nullAsEmptyMap = nullAsEmptyMap;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (value == null && this.nullAsEmptyMap) {
            super.setValue(this.createMap(this.mapType, 0));
        } else if (value == null || this.mapType.isInstance(value) && !this.alwaysCreateNewMap()) {
            super.setValue(value);
        } else if (value instanceof Map) {
            Map source = (Map)value;
            Map target = this.createMap(this.mapType, source.size());
            Iterator it = source.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                target.put(this.convertKey(entry.getKey()), this.convertValue(entry.getValue()));
            }
            super.setValue(target);
        } else {
            throw new IllegalArgumentException("Value cannot be converted to Map: " + value);
        }
    }

    protected Map createMap(Class mapType, int initialCapacity) {
        if (!mapType.isInterface()) {
            try {
                return (Map)mapType.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not instantiate map class [" + mapType.getName() + "]: " + ex.getMessage());
            }
        }
        if ((class$java$util$SortedMap == null ? (class$java$util$SortedMap = CustomMapEditor.class$("java.util.SortedMap")) : class$java$util$SortedMap).equals(mapType)) {
            return new TreeMap();
        }
        return CollectionFactory.createLinkedMapIfPossible(initialCapacity);
    }

    protected boolean alwaysCreateNewMap() {
        return false;
    }

    protected Object convertKey(Object key) {
        return key;
    }

    protected Object convertValue(Object value) {
        return value;
    }

    public String getAsText() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

