/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public abstract class StringUtilities {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static /* synthetic */ Class class$java$sql$Types;

    public static String encodeXMLEntities(String string) {
        if (string == null) {
            return "null";
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String encode(String string, boolean bl2, boolean bl3) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        block11: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    if (bl2) {
                        stringBuffer.append("&nbsp;");
                        continue block11;
                    }
                    if (bl3) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    continue block11;
                }
                case '\t': {
                    if (bl2) {
                        stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        continue block11;
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block11;
                }
                case '\"': {
                    if (bl2) {
                        stringBuffer.append("&quot;");
                        continue block11;
                    }
                    stringBuffer.append('\"');
                    continue block11;
                }
                case '>': {
                    if (bl2) {
                        stringBuffer.append("&gt;");
                        continue block11;
                    }
                    stringBuffer.append('>');
                    continue block11;
                }
                case '<': {
                    if (bl2) {
                        stringBuffer.append("&lt;");
                        continue block11;
                    }
                    stringBuffer.append('<');
                    continue block11;
                }
                case '\n': {
                    if (bl2) {
                        stringBuffer.append("<BR>");
                        continue block11;
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block11;
                }
                case '\r': {
                    if (bl2) {
                        stringBuffer.append("<BR>");
                        continue block11;
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block11;
                }
                default: {
                    if (c2 < ' ' || c2 > '~') {
                        if (bl2) {
                            stringBuffer.append('&');
                            stringBuffer.append('#');
                        } else {
                            stringBuffer.append('\\');
                            stringBuffer.append('u');
                        }
                        stringBuffer.append(StringUtilities.toHex(c2 >> 12 & 0xF));
                        stringBuffer.append(StringUtilities.toHex(c2 >> 8 & 0xF));
                        stringBuffer.append(StringUtilities.toHex(c2 >> 4 & 0xF));
                        stringBuffer.append(StringUtilities.toHex(c2 & 0xF));
                        continue block11;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if ((n4 = string.charAt(n3++)) == 92) {
                if ((n4 = string.charAt(n3++)) == 117) {
                    int n5 = 0;
                    block6: for (int i2 = 0; i2 < 4; ++i2) {
                        n4 = string.charAt(n3++);
                        switch (n4) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n5 = (n5 << 4) + n4 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n5 = (n5 << 4) + 10 + n4 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n5 = (n5 << 4) + 10 + n4 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n5);
                    continue;
                }
                if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 102) {
                    n4 = 12;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public static int charCount(String string, char c2, boolean bl2) {
        if (string == null) {
            return -1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != c2 || i2 < 1) continue;
            if (string.charAt(i2 - 1) == '\\') {
                if (!bl2) continue;
                ++n2;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public static String getTypeStringForObject(Object object) {
        if (object instanceof String) {
            return "VARCHAR";
        }
        if (object instanceof Byte) {
            return "TINYINT";
        }
        if (object instanceof Boolean) {
            return "BOOLEAN";
        }
        if (object instanceof Short) {
            return "SMALLINT";
        }
        if (object instanceof Integer) {
            return "INTEGER";
        }
        if (object instanceof Long || object instanceof BigInteger) {
            return "BIGINT";
        }
        if (object instanceof Double || object instanceof Float) {
            return "DOUBLE";
        }
        if (object instanceof BigDecimal) {
            return "DECIMAL";
        }
        if (object instanceof Timestamp) {
            return "TIMESTAMP";
        }
        if (object instanceof Time) {
            return "TIME";
        }
        if (object instanceof Ref) {
            return "REF";
        }
        if (object instanceof Date) {
            return "DATE";
        }
        if (object instanceof Clob) {
            return "CLOB";
        }
        if (object instanceof Blob) {
            return "BLOB";
        }
        if (object instanceof byte[] || object instanceof InputStream) {
            return "LONGVARBINARY";
        }
        if (object instanceof Reader) {
            return "LONGVARCHAR";
        }
        return "JAVA_OBJECT";
    }

    public static String getTypeforValue(int n2) {
        try {
            Class<?> clazz = class$java$sql$Types;
            if (clazz == null) {
                clazz = class$java$sql$Types = new Types[0].getClass().getComponentType();
            }
            Class<?> clazz2 = clazz;
            Field[] fieldArray = clazz2.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                String string = fieldArray[i2].getName();
                int n3 = fieldArray[i2].getInt(null);
                if (n3 != n2) continue;
                return string;
            }
            return "OTHER";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getHTMLColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getBlue());
        String string3 = Integer.toHexString(color.getGreen());
        string = string.length() == 1 ? "0" + string : string;
        string2 = string2.length() == 1 ? "0" + string2 : string2;
        string3 = string3.length() == 1 ? "0" + string3 : string3;
        return "#" + string + string3 + string2;
    }

    public static Font parseFontString(String string) {
        try {
            String string2 = string.substring(0, string.indexOf(","));
            int n2 = Integer.parseInt(string.substring(string.indexOf(",") + 1));
            return new Font(string2, 0, n2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getFontString(Font font) {
        return font.getName().concat(",".concat(Integer.toString(font.getSize())));
    }

    public static String getHumanReadableSize(long l2) {
        long l3 = (long)Math.pow(2.0, 20.0);
        long l4 = (long)Math.pow(2.0, 10.0);
        long l5 = (long)Math.pow(2.0, 30.0);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        double d2 = 0.0;
        long l6 = Math.abs(l2);
        String string = "";
        if (l6 / l5 >= 1L) {
            d2 = (double)l6 / (double)l5;
            string = "GB";
        } else if (l6 / l3 >= 1L) {
            d2 = (double)l6 / (double)l3;
            string = "MB";
        } else if (l6 / l4 >= 1L) {
            d2 = (double)l6 / (double)l4;
            string = "KB";
        } else {
            d2 = l6;
            string = "b";
        }
        return numberFormat.format((double)(l2 < 0L ? -1 : 1) * d2) + string;
    }

    public static String removeSubString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string3 = string.toUpperCase();
        int n2 = string3.indexOf(string2.toUpperCase());
        int n3 = n2 + string2.length();
        if (n2 >= 0 && n3 <= string.length() - 1) {
            stringBuffer.delete(n2, n3);
        }
        return stringBuffer.toString();
    }

    public static String[] getSQLParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&", true, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            char c2;
            String string2 = stringTokenizer.nextToken(" \r\n\t,");
            char c3 = c2 = string2.length() >= 2 ? string2.charAt(1) : string2.charAt(0);
            if (c2 == '&' || c2 == '<' || c2 == '>') {
                try {
                    stringTokenizer.nextToken("&");
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
            arrayList.add(string2);
            try {
                stringTokenizer.nextToken("&");
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static String applySQLParameters(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            int n2 = stringBuffer.toString().indexOf("&" + string2);
            stringBuffer.replace(n2, n2 + string2.length() + 1, string3);
        }
        return stringBuffer.toString();
    }

    public static Rectangle parseRectangle(String string) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false, false);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            switch (n2) {
                case 0: {
                    rectangle.setLocation(n3, 0);
                    break;
                }
                case 1: {
                    rectangle.setLocation(rectangle.x, n3);
                    break;
                }
                case 2: {
                    rectangle.setSize(n3, 0);
                    break;
                }
                case 3: {
                    rectangle.setSize(rectangle.width, n3);
                }
            }
            ++n2;
        }
        return rectangle;
    }

    public static String formatBreak(int n2, String string, String string2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\r\n ", false, true);
        int n3 = n2;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n3 < stringBuffer.length() + string3.length() + 2) {
                stringBuffer.append(bl2 ? "<br>" : "\n");
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                n3 = stringBuffer.length() + n2;
            }
            stringBuffer.append(string3);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String formatRectangle(Rectangle rectangle) {
        return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    }

    public static String oneLine(String string) {
        if (string == null) {
            return "null";
        }
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        string = string.replace('\t', ' ');
        return string;
    }

    public static String stripCharacters(String string, String string2) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (string2.indexOf(c2) >= 0) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static Object processString(String string, int n2, String string2) throws ParseException {
        String string3 = string2.trim().concat(";");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";", false, true);
        StringTokenizer stringTokenizer2 = new StringTokenizer("", ",", false, true);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("");
        String string4 = SystemConfig.getInstance().getFormatForSQLType(n2);
        if (string4 != null) {
            simpleDateFormat.applyPattern(string4);
        }
        stringTokenizer.setQuotesEnabled(true);
        stringTokenizer2.setQuotesEnabled(false);
        String string5 = string;
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string6 = stringTokenizer.nextToken().trim();
            String string7 = string6.toUpperCase();
            String string8 = null;
            if (string6.indexOf(40) >= 1 && string6.endsWith(")")) {
                int n4 = string6.indexOf(40) + 1;
                n3 = string6.lastIndexOf(41);
                string8 = string6.substring(n4, n3);
                stringTokenizer2.setString(string8.concat(","));
                string7 = string7.substring(0, n4 - 1);
            }
            if (string8 == null) {
                if (string7.equals("NATIVETOASCII")) {
                    string5 = StringUtilities.encode(string5, false, false);
                    continue;
                }
                if (string7.equals("ASCIITONATIVE")) {
                    string5 = StringUtilities.decode(string5);
                    continue;
                }
                if (string7.equals("TRIM")) {
                    string5 = string5.trim();
                    continue;
                }
                if (string7.equals("TOUPPER")) {
                    string5 = string5.toUpperCase();
                    continue;
                }
                if (!string7.equals("TOLOWER")) continue;
                string5 = string5.toLowerCase();
                continue;
            }
            String[] stringArray = stringTokenizer2.toArray();
            if (string7.equals("REPLACEALL")) {
                string5 = string5.replaceAll(stringArray[0], stringArray[1]);
                continue;
            }
            if (string7.equals("REPLACEFIRST")) {
                string5 = string5.replaceFirst(stringArray[0], stringArray[1]);
                continue;
            }
            if (string7.equals("REPLACE")) {
                string5 = string5.replace(stringArray[0].charAt(0), stringArray[1].charAt(0));
                continue;
            }
            if (string7.equals("SUBSTRING")) {
                n3 = Integer.parseInt(stringArray[0]);
                int n5 = -1;
                n5 = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : string5.length();
                string5 = string5.substring(n3, n5);
                continue;
            }
            if (string7.equals("FORMAT")) {
                String string9 = StringUtilities.decode(stringArray[0]);
                string5 = MessageFormat.format(string9, string5);
                continue;
            }
            if (string7.equals("PATTERN")) {
                simpleDateFormat.applyLocalizedPattern(stringArray[0]);
                continue;
            }
            if (string7.equals("TIMEZONE")) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(stringArray[0]));
                continue;
            }
            if (string7.equals("STRIP")) {
                String string10 = StringUtilities.decode(stringArray[0]);
                string5 = StringUtilities.stripCharacters(string5, string10);
                continue;
            }
            if (!string7.equals("DELETE")) continue;
            String string11 = StringUtilities.decode(stringArray[0]);
            string5 = StringUtilities.removeSubString(string5, string11);
        }
        if (!string5.equalsIgnoreCase(string)) {
            return JDBCUtilities.convertValue(string5, n2, simpleDateFormat);
        }
        return null;
    }

    private static char toHex(int n2) {
        return hexDigit[n2 & 0xF];
    }

    public static void validateParameters(String[] stringArray, int n2, boolean bl2, String string) {
        String[] stringArray2 = new String[]{string, Integer.toString(n2)};
        if (stringArray.length < n2) {
            String string2 = BasicUtilities.getString("Not_Enough_Parameters", stringArray2);
            throw new IllegalArgumentException(string2);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) {
                String string3 = BasicUtilities.getString("Not_Enough_Parameters", stringArray2);
                throw new IllegalArgumentException(string3);
            }
            if (stringArray[i2].trim().length() != 0 || bl2) continue;
            String string4 = BasicUtilities.getString("Blank_Parameter_Invaid", stringArray2);
            throw new IllegalArgumentException(string4);
        }
    }
}

