/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.isqlviewer.core.ConfigConstants;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class EditorPropertyPage
extends AbstractPropertyPage
implements ItemListener,
ListSelectionListener,
PropertyChangeListener {
    private boolean isSelecting = false;
    private JLabel lblFontLabel = new JLabel("");
    private JButton btnFntChange = new JButton();
    private JButton btnColor = new JButton(new AbstractPropertyPage.ColorChangeAction(this));
    private JButton btnBgcolor = new JButton();
    private String[] colorIDs = new String[]{BasicUtilities.getString("Editor_Syntax_Keywords"), BasicUtilities.getString("Editor_Syntax_Tablespace"), BasicUtilities.getString("Editor_Syntax_Objects"), BasicUtilities.getString("Editor_Syntax_Functions"), BasicUtilities.getString("Editor_Syntax_Strings"), BasicUtilities.getString("Editor_Syntax_Parameters"), BasicUtilities.getString("Editor_Syntax_Comment"), BasicUtilities.getString("Editor_Syntax_Mutli_Comment"), BasicUtilities.getString("Editor_Syntax_Other")};
    private Hashtable mapColors = new Hashtable();
    private Hashtable mapItalic = new Hashtable();
    private Hashtable mapBolded = new Hashtable();
    private Hashtable mapPrefs = new Hashtable();
    private JCheckBox chkBold = new JCheckBox(BasicUtilities.getString("Editor_Syntax_Bold"));
    private JCheckBox chkItal = new JCheckBox(BasicUtilities.getString("Editor_Syntax_Italic"));
    private JCheckBox chkCaret = new JCheckBox(BasicUtilities.getString("Editor_Enable_Caret_Offset_Txt"));
    private JCheckBox chkHighlight = new JCheckBox(BasicUtilities.getString("Editor_Syntax_Enable_Txt"));
    private JCheckBox chkCntxtHelp = new JCheckBox(BasicUtilities.getString("Editor_Help_Enable_Txt"));
    private JList jlsSyntaxes = new JList<String>(this.colorIDs);

    public EditorPropertyPage() {
        this.mapPrefs.put(this.colorIDs[0], "editor.sql-keywords");
        this.mapPrefs.put(this.colorIDs[1], "editor.tablespace");
        this.mapPrefs.put(this.colorIDs[2], "editor.local-obj");
        this.mapPrefs.put(this.colorIDs[3], "editor.functions");
        this.mapPrefs.put(this.colorIDs[4], "editor.literals");
        this.mapPrefs.put(this.colorIDs[5], "editor.parameters");
        this.mapPrefs.put(this.colorIDs[1], "editor.sline-comments");
        this.mapPrefs.put(this.colorIDs[2], "editor.multicomment-color");
        this.mapPrefs.put(this.colorIDs[6], "editor.default-color");
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "initUI()");
        }
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("Editor_Property_Page");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Edit16");
    }

    public synchronized void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.isSelecting = true;
        String string = (String)this.jlsSyntaxes.getSelectedValue();
        String string2 = (String)this.mapPrefs.get(string);
        if (string2 == null) {
            return;
        }
        Color color = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = string2;
        if (this.mapColors.containsKey(string2)) {
            color = (Color)this.mapColors.get(string2);
        } else {
            string3 = ConfigConstants.createStyleKey(string2, "color");
            color = prefs.getColor(string3);
        }
        if (this.mapBolded.containsKey(string2)) {
            bl2 = (Boolean)this.mapBolded.get(string2);
        } else {
            string3 = ConfigConstants.createStyleKey(string2, "bolded");
            bl2 = prefs.getBoolean(string3);
        }
        if (this.mapItalic.containsKey(string2)) {
            bl3 = (Boolean)this.mapItalic.get(string2);
        } else {
            string3 = ConfigConstants.createStyleKey(string2, "italics");
            bl3 = prefs.getBoolean(string3);
        }
        this.chkItal.setSelected(bl3);
        this.chkBold.setSelected(bl2);
        this.btnColor.setForeground(color);
        this.isSelecting = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isSelecting) {
            String string = (String)this.jlsSyntaxes.getSelectedValue();
            String string2 = (String)this.mapPrefs.get(string);
            Color color = this.btnColor.getForeground();
            this.setModified(true);
            this.mapColors.put(string2, color);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.isSelecting) {
            String string = (String)this.jlsSyntaxes.getSelectedValue();
            String string2 = (String)this.mapPrefs.get(string);
            this.mapItalic.put(string2, this.chkItal.isSelected());
            this.mapBolded.put(string2, this.chkBold.isSelected());
            this.setModified(true);
        }
    }

    public void saveProperties() {
        Serializable serializable;
        String string;
        Iterator iterator = this.mapColors.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            serializable = (Color)this.mapColors.get(string = ConfigConstants.createStyleKey(string, "color"));
            if (serializable == null) continue;
            prefs.putColor(string, (Color)serializable);
        }
        iterator = this.mapBolded.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            serializable = (Boolean)this.mapBolded.get(string = ConfigConstants.createStyleKey(string, "bolded"));
            if (serializable == null) continue;
            prefs.putBoolean(string, (Boolean)serializable);
        }
        iterator = this.mapItalic.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            serializable = (Boolean)this.mapItalic.get(string = ConfigConstants.createStyleKey(string, "italics"));
            if (serializable == null) continue;
            prefs.putBoolean(string, (Boolean)serializable);
        }
        super.saveProperties();
    }

    public void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkCaret.setToolTipText(BasicUtilities.getString("Editor_Enable_Caret_Offset_Tip"));
        this.chkHighlight.setToolTipText(BasicUtilities.getString("Editor_Syntax_Enable_Tip"));
        this.chkCntxtHelp.setToolTipText(BasicUtilities.getString("Editor_Help_Enable_Tip"));
        this.jlsSyntaxes.addListSelectionListener(this);
        this.chkBold.addItemListener(this);
        this.chkItal.addItemListener(this);
        this.jlsSyntaxes.setSelectedIndex(0);
        this.lblFontLabel.setLabelFor(this.btnFntChange);
        this.lblFontLabel.setName("Editor_Font");
        this.btnFntChange.setFont(prefs.getFont("editor.font"));
        this.btnFntChange.setAction(new AbstractPropertyPage.FontChangeAction(this, this.btnFntChange.getFont(), this.lblFontLabel));
        this.btnColor.addPropertyChangeListener("foreground", this);
        this.setPropertyForComponent(this.chkCaret, "editor.caretoffset-enabled");
        this.setFontPropertyForComponent(this.btnFntChange, "editor.font");
        this.setColorPropertyForComponent(this.btnBgcolor, "editor.background-color");
        this.setPropertyForComponent(this.chkCntxtHelp, "editor.context-help.enabled");
        this.setPropertyForComponent(this.chkHighlight, "editor.syntax-help.enabled");
        EditorPropertyPage.constrain(0, 0, 1, 9, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.lblFontLabel, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnFntChange, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 2, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Editor_Background_Color", null), UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnBgcolor, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 3, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkCaret, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 4, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkCntxtHelp, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 5, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkHighlight, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 6, 2, 1, 0.0, 0.0, 10, 2);
        this.add(EditorPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 6, 2, 1, 0.0, 0.0, 10, 2);
        this.add(Box.createVerticalStrut(16), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 7, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Editor_Syntax_Options", null), UI_CONSTRAINT);
        JScrollPane jScrollPane = new JScrollPane(this.jlsSyntaxes);
        Dimension dimension = this.jlsSyntaxes.getPreferredSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width + 24, this.jlsSyntaxes.getCellBounds((int)0, (int)4).height));
        EditorPropertyPage.constrain(1, 8, 2, 4, 0.0, 0.0, 10, 0);
        this.add((Component)jScrollPane, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 8, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Color_Label", null), UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 9, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnColor, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 10, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkBold, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 11, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkItal, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 13, 3, 1, 0.0, 1.0, 17, 0);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        EditorPropertyPage.constrain(4, 0, 1, 12, 1.0, 0.0, 10, 0);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }
}

