/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.MovableListModel;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ClassListCellRenderer;
import org.isqlviewer.swing.JFileList;
import org.isqlviewer.swing.JListUISupport;
import org.isqlviewer.swing.JNumberEditor;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.DriverPropertyEditor;
import org.isqlviewer.ui.LoginOptionPane;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class ServiceManager
extends JDialog {
    private static final String MOVE_DOWN_ACTION = "isql.moveSelctionDown";
    private static final String MOVE_UP_ACTION = "isql.moveSelctionUp";
    private static final int ACTION_OK = 0;
    private static final int ACTION_MOVE_UP = 1;
    private static final int ACTION_MOVE_DOWN = 2;
    private static final int ACTION_TEST = 3;
    private static final int ACTION_APPLY = 4;
    private static final int ACTION_CANCEL = 5;
    private static final int ACTION_COPY = 6;
    private static final int ACTION_DELETE = 7;
    private static final int ACTION_NEW = 8;
    private static final int ACTION_UNDELETE = 9;
    private static final int ACTION_CONFIG = 10;
    private static final int ACTION_SCAN = 11;
    private static final int ACTION_REFRESH = 12;
    private static final int ACTION_EDIT_PROPERTY = 13;
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private static final Random SEED = new Random(System.currentTimeMillis());
    private SystemConfig systemConfig = SystemConfig.getInstance();
    private ServiceProvider provider = this.systemConfig.getServiceProvider();
    private UserPreferences prefs = this.systemConfig.getPreferences();
    private MovableListModel mdlServices = new MovableListModel();
    private ServiceSupport inputSupport = new ServiceSupport(null);
    private Vector toBeDeleted = new Vector();
    private Vector toBeSaved = new Vector();
    private Vector newServices = new Vector();
    private Hashtable lazyCache = new Hashtable();
    private JTabbedPane jtpServiceEditor = new JTabbedPane(1);
    private JToolBar jtbActions = ActionToolBar.createNullInstance();
    private JList jlsServices = new JList(this.mdlServices);
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnTest = new JButton(BasicUtilities.getString("Test"));
    private JButton btnApply = new JButton(BasicUtilities.getString("Save_Apply"));
    private JButton btnCancel = new JButton(BasicUtilities.getString("Cancel"));
    private JButton btnCreate = new JButton(BasicUtilities.loadIconResource("New16"));
    private JButton btnMoveUp = new JButton(BasicUtilities.loadIconResource("Up16"));
    private JButton btnCopy = new JButton(BasicUtilities.loadIconResource("Copy16"));
    private JButton btnMoveDn = new JButton(BasicUtilities.loadIconResource("Down16"));
    private JButton btnDeleteSv = new JButton(BasicUtilities.loadIconResource("Delete16"));
    private JButton btnConfig = new JButton(BasicUtilities.loadIconResource("Preferences16"));
    private JButton btnUndelete = new JButton(BasicUtilities.loadIconResource("Rollback16"));
    private JButton btnScan = new JButton(BasicUtilities.loadIconResource("WebCheck16"));
    private LocalServiceEditor localEditor = new LocalServiceEditor();
    private RemoteServiceEditor remoteEditor = new RemoteServiceEditor();
    private AdvancedServiceEditor advancedEditor = new AdvancedServiceEditor(null);
    private JFileList jflResources = new JFileList();
    private WizardPanel pnlEditor = new WizardPanel();
    private boolean isLoadingService = false;
    static /* synthetic */ Class class$java$awt$Frame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(Frame frame) {
        ServiceManager serviceManager = null;
        try {
            serviceManager = new ServiceManager(frame);
            serviceManager.setLocationRelativeTo(frame);
            serviceManager.show();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ServiceManager::showDialog(Frame)");
        }
        finally {
            serviceManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object;
        Iterator<Object> iterator;
        if (!this.toBeSaved.isEmpty()) {
            iterator = this.toBeSaved.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                String string = object.toString().trim().toUpperCase();
                ServiceDefinition serviceDefinition = (ServiceDefinition)this.lazyCache.get(string);
                if (serviceDefinition == null) continue;
                try {
                    if (Boolean.getBoolean("isql.debug")) {
                        String string2 = BasicUtilities.getString("Saving_Service", string);
                        System.out.println(string2);
                    }
                    this.provider.saveService(serviceDefinition);
                }
                catch (Throwable throwable) {
                    String string3 = BasicUtilities.getString("Error_Saving_Service", string);
                    BasicUtilities.showExceptionPopup(this, throwable, string3);
                }
                finally {
                    serviceDefinition.close();
                }
            }
        }
        if (!this.toBeDeleted.isEmpty()) {
            iterator = this.toBeDeleted.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                try {
                    this.provider.removeService((String)object);
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "ServiceManager::dispose()");
                }
            }
        }
        if (!this.lazyCache.isEmpty()) {
            iterator = this.lazyCache.values().iterator();
            while (iterator.hasNext()) {
                try {
                    object = (ServiceDefinition)iterator.next();
                    ((ServiceDefinition)object).close();
                    iterator.remove();
                }
                catch (Throwable throwable) {}
            }
            this.lazyCache.clear();
        }
        super.dispose();
    }

    private ServiceManager(Frame frame) {
        super(frame, "", true);
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("ServiceManager::initUI()", throwable);
        }
        this.pack();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.loadServiceList();
                break;
            }
            case 201: {
                if (this.toBeDeleted.isEmpty() && this.toBeSaved.isEmpty()) break;
                int n2 = JOptionPane.showConfirmDialog(this, BasicUtilities.getString("Service_Cancel_Confirm"));
                if (n2 == 2) {
                    return;
                }
                if (n2 != 0) break;
                this.cancel(false);
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void initUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 5));
        this.jtbActions.setOrientation(0);
        this.jtbActions.setFloatable(false);
        this.jtbActions.add(this.btnConfig);
        this.jtbActions.add(this.btnScan);
        this.jtbActions.add(this.btnCreate);
        this.jtbActions.add(this.btnCopy);
        this.jtbActions.add(this.btnUndelete);
        this.jtbActions.add(this.btnDeleteSv);
        this.btnApply.addActionListener(this.inputSupport);
        this.btnApply.setActionCommand(Integer.toString(4));
        this.btnApply.setToolTipText(BasicUtilities.getString("Save_Apply_Tip"));
        this.btnOK.addActionListener(this.inputSupport);
        this.btnOK.setActionCommand(Integer.toString(0));
        this.btnOK.setToolTipText(BasicUtilities.getString("OK_Tip"));
        this.btnCancel.addActionListener(this.inputSupport);
        this.btnCancel.setActionCommand(Integer.toString(5));
        this.btnCancel.setToolTipText(BasicUtilities.getString("Cancel_Tip"));
        this.btnCopy.addActionListener(this.inputSupport);
        this.btnCopy.setActionCommand(Integer.toString(6));
        this.btnCopy.setToolTipText(BasicUtilities.getString("Copy_Tip"));
        this.btnUndelete.addActionListener(this.inputSupport);
        this.btnUndelete.setActionCommand(Integer.toString(9));
        this.btnUndelete.setToolTipText(BasicUtilities.getString("Service_Undelete_Tip"));
        this.btnTest.addActionListener(this.inputSupport);
        this.btnTest.setActionCommand(Integer.toString(3));
        this.btnTest.setToolTipText(BasicUtilities.getString("Test_Tip"));
        this.btnDeleteSv.addActionListener(this.inputSupport);
        this.btnDeleteSv.setActionCommand(Integer.toString(7));
        this.btnDeleteSv.setToolTipText(BasicUtilities.getString("Delete_Tip"));
        this.btnCreate.addActionListener(this.inputSupport);
        this.btnCreate.setActionCommand(Integer.toString(8));
        this.btnCreate.setToolTipText(BasicUtilities.getString("New_Tip"));
        this.btnConfig.addActionListener(this.inputSupport);
        this.btnConfig.setActionCommand(Integer.toString(10));
        this.btnConfig.setToolTipText(BasicUtilities.getString("Service_Option_Tip"));
        this.btnScan.addActionListener(this.inputSupport);
        this.btnScan.setActionCommand(Integer.toString(11));
        this.btnScan.setToolTipText(BasicUtilities.getString("Service_Scan_Tip"));
        this.jlsServices.setCellRenderer(new ServiceRenderer(null));
        this.jlsServices.setSelectionMode(0);
        this.jlsServices.addListSelectionListener(this.inputSupport);
        JListUISupport.install(this.jlsServices, false);
        ActionMap actionMap = this.jlsServices.getActionMap();
        actionMap.put(MOVE_UP_ACTION, new ServiceAction(1));
        actionMap.put(MOVE_DOWN_ACTION, new ServiceAction(2));
        InputMap inputMap = this.jlsServices.getInputMap();
        inputMap.put(BasicUtilities.createKeyStroke(38, BasicUtilities.CMD_MASK), MOVE_UP_ACTION);
        inputMap.put(BasicUtilities.createKeyStroke(40, BasicUtilities.CMD_MASK), MOVE_DOWN_ACTION);
        ServiceManager.constrain(0, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel2.add((Component)this.jtbActions, UI_CONSTRAINT);
        ServiceManager.constrain(0, 1, 1, 1, 0.0, 1.0, 10, 1);
        jPanel2.add((Component)new JScrollPane(this.jlsServices), UI_CONSTRAINT);
        ServiceManager.constrain(1, 0, 1, 2, 1.0, 1.0, 11, 1);
        jPanel2.add((Component)this.jtpServiceEditor, UI_CONSTRAINT);
        this.pnlEditor.add((Component)this.localEditor, "local");
        this.pnlEditor.add((Component)this.remoteEditor, "remote");
        this.pnlEditor.showCard(this.localEditor);
        this.localEditor.registerChangeListeners(this.inputSupport);
        this.remoteEditor.registerChangeListeners(this.inputSupport);
        this.advancedEditor.registerChangeListeners(this.inputSupport);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.btnOK);
        jPanel3.add(this.btnApply);
        jPanel3.add(this.btnTest);
        jPanel3.add(this.btnCancel);
        jPanel3.add(Box.createHorizontalGlue());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        ServiceManager.constrain(0, 0, 1, 3, 0.0, 0.0, 17, 0);
        jPanel4.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        ServiceManager.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel4.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        ServiceManager.constrain(1, 1, 1, 1, 1.0, 1.0, 10, 1);
        jPanel4.add((Component)this.jflResources, UI_CONSTRAINT);
        ServiceManager.constrain(2, 0, 1, 3, 0.0, 0.0, 17, 0);
        jPanel4.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        ServiceManager.constrain(1, 2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel4.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        JLabel jLabel = new JLabel(BasicUtilities.getString("Resource_List_Tip"));
        this.jflResources.add((Component)jLabel, "South");
        this.jflResources.addChangeListener(this.inputSupport);
        this.jtpServiceEditor.addTab(BasicUtilities.getString("General_Property_Page"), this.pnlEditor);
        this.jtpServiceEditor.addTab(BasicUtilities.getString("Advanced_Tab_Label"), this.advancedEditor);
        this.jtpServiceEditor.addTab(BasicUtilities.getString("Resources_Tab_Label"), jPanel4);
        this.jtpServiceEditor.addChangeListener(this.inputSupport);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
    }

    private void storeServiceList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.mdlServices.getSize(); ++i2) {
            Object e2 = this.mdlServices.get(i2);
            String string = null;
            string = e2 instanceof ServiceDefinition ? ((ServiceDefinition)e2).getName() : (String)e2;
            arrayList.add(string);
        }
        this.provider.setPreferredServiceOrder(arrayList);
        arrayList.clear();
        arrayList = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancel(boolean bl2) {
        if (bl2) {
            this.dispatchEvent(new WindowEvent(this, 201));
            return;
        }
        if (!this.newServices.isEmpty()) {
            Iterator iterator = this.newServices.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                String string = e2.toString().trim().toUpperCase();
                try {
                    if (this.provider.deregisterService(string)) continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    BasicUtilities.HandleException(illegalArgumentException, BasicUtilities.getString("Service_Register_Error"));
                }
            }
        }
        this.newServices.clear();
        this.toBeSaved.clear();
        this.toBeDeleted.clear();
    }

    private void addNewService(boolean bl2, String stringArray) {
        Object object;
        Object e2 = this.jlsServices.getSelectedValue();
        ServiceDefinition serviceDefinition = null;
        if (e2 instanceof ServiceDefinition) {
            serviceDefinition = (ServiceDefinition)e2;
        }
        if (bl2 && serviceDefinition != null) {
            serviceDefinition = (ServiceDefinition)serviceDefinition.clone();
        } else {
            object = new String[]{BasicUtilities.getString("SM_LocalService"), BasicUtilities.getString("SM_RemoteService")};
            Object object2 = JOptionPane.showInputDialog(this, BasicUtilities.getString("SM_Create_New_Service"), BasicUtilities.getString("SM_Choose_Service_Type"), 1, null, object, null);
            if (object2 == null) {
                return;
            }
            serviceDefinition = new ServiceDefinition(this.systemConfig.getJDBCDefaults(), true);
            if (object2 == object[1]) {
                serviceDefinition.setRemoteEnabled(true, "");
            }
        }
        object = stringArray;
        boolean bl3 = false;
        if (bl2) {
            object = this.createUniqueName((String)stringArray);
        } else if (object == null) {
            object = Long.toHexString(SEED.nextLong()).toUpperCase();
            while (this.lazyCache.containsKey(object)) {
                object = Long.toHexString(SEED.nextLong()).toUpperCase();
            }
        } else {
            bl3 = true;
        }
        serviceDefinition.setName((String)object);
        try {
            if (this.provider.registerService(serviceDefinition, null)) {
                String string = object.toUpperCase();
                this.lazyCache.put(string, serviceDefinition);
                this.toBeSaved.add(string);
                this.newServices.add(string);
                if (!bl3) {
                    this.mdlServices.addElement(serviceDefinition);
                    this.mdlServices.reload();
                    this.jlsServices.setSelectedIndex(this.mdlServices.size() - 1);
                } else {
                    int n2 = this.mdlServices.indexOf(e2);
                    this.mdlServices.setElementAt(serviceDefinition, n2);
                    this.jlsServices.setSelectedIndex(n2);
                }
            } else {
                JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Register_Error"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BasicUtilities.showExceptionPopup(this, illegalArgumentException, illegalArgumentException.getMessage());
        }
    }

    private void loadServiceList() {
        this.mdlServices.clear();
        Collection collection = this.provider.getRegisteredServices(true);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) continue;
            String string = e2.toString();
            this.mdlServices.addElement(string);
        }
        boolean bl2 = this.mdlServices.isEmpty();
        if (bl2) {
            this.jlsServices.clearSelection();
        } else {
            this.jlsServices.setSelectedIndex(0);
        }
        this.toggleActions();
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
    }

    private void processActionEvent(int n2) {
        int n3 = this.jlsServices.getSelectedIndex();
        Object e2 = this.jlsServices.getSelectedValue();
        ServiceDefinition serviceDefinition = null;
        String string = null;
        if (e2 instanceof ServiceDefinition) {
            serviceDefinition = (ServiceDefinition)e2;
            string = serviceDefinition.getName().toUpperCase();
        } else {
            string = e2 != null ? ((String)e2).toUpperCase() : "";
        }
        switch (n2) {
            case 10: {
                PreferencesEditor.showDialog(this, 3);
                break;
            }
            case 7: {
                if (this.toBeDeleted.contains(string)) break;
                this.toBeDeleted.add(string);
                this.jtpServiceEditor.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.mdlServices.moveDown(n3);
                this.jlsServices.setSelectedIndex(Math.min(n3 + 1, this.mdlServices.getSize()));
                break;
            }
            case 1: {
                this.mdlServices.moveUP(n3);
                this.jlsServices.setSelectedIndex(Math.max(n3 - 1, 0));
                break;
            }
            case 9: {
                if (!this.toBeDeleted.contains(string)) break;
                this.toBeDeleted.remove(string);
                break;
            }
            case 11: {
                this.cancel(false);
                try {
                    this.provider.detectServices();
                }
                catch (Throwable throwable) {
                    BasicUtilities.showExceptionPopup(this, throwable, throwable.getMessage());
                }
                this.loadServiceList();
            }
            case 4: {
                this.applyChanges(serviceDefinition, true);
                break;
            }
            case 6: 
            case 8: {
                String string2 = n2 == 6 ? string : null;
                this.addNewService(n2 == 6, string2);
                break;
            }
            case 5: {
                this.dispatchEvent(new WindowEvent(this, 201));
                break;
            }
            case 0: {
                if (serviceDefinition != null) {
                    this.applyChanges(serviceDefinition, true);
                }
                this.dispose();
                this.storeServiceList();
                break;
            }
            case 13: {
                this.showPropertyEditor();
                break;
            }
            case 3: {
                this.applyChanges(serviceDefinition, false);
                this.testService();
                break;
            }
            default: {
                this.markChanged();
            }
        }
        this.toggleActions();
        this.mdlServices.reload(n3);
    }

    private void toggleActions() {
        int n2 = this.jlsServices.getSelectedIndex();
        Object e2 = this.jlsServices.getSelectedValue();
        String string = null;
        if (e2 == null || n2 < 0) {
            this.btnUndelete.setEnabled(false);
            this.btnDeleteSv.setEnabled(false);
            this.btnCopy.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDn.setEnabled(false);
            this.btnApply.setEnabled(false);
            this.btnTest.setEnabled(false);
            this.localEditor.setEditable(false);
            this.remoteEditor.setEditable(false);
            this.jtpServiceEditor.setEnabledAt(0, false);
            this.jtpServiceEditor.setEnabledAt(1, false);
            this.jtpServiceEditor.setEnabledAt(2, false);
        } else {
            string = e2 instanceof ServiceDefinition ? ((ServiceDefinition)e2).getName().toUpperCase() : ((String)e2).toUpperCase();
            this.btnUndelete.setEnabled(this.toBeDeleted.contains(string));
            this.btnDeleteSv.setEnabled(!this.btnUndelete.isEnabled());
            boolean bl2 = this.btnDeleteSv.isEnabled();
            boolean bl3 = bl2 ? this.toBeSaved.contains(string) : false;
            int n3 = this.mdlServices.getSize();
            this.btnCopy.setEnabled(n2 >= 0 && n2 < n3 && bl2);
            this.btnMoveUp.setEnabled(n2 >= 1 && bl2);
            this.btnMoveDn.setEnabled(n2 < n3 - 1 && bl2);
            this.btnApply.setEnabled(bl3 && bl2);
            this.btnTest.setEnabled(bl2);
            this.localEditor.setEditable(bl2);
            this.remoteEditor.setEditable(bl2);
            this.jtpServiceEditor.setEnabledAt(0, bl2);
            this.jtpServiceEditor.setEnabledAt(1, bl2);
            this.jtpServiceEditor.setEnabledAt(2, bl2);
        }
    }

    private void applyChanges(ServiceDefinition serviceDefinition, boolean bl2) {
        Object object;
        if (serviceDefinition == null) {
            BasicUtilities.beep();
            return;
        }
        String string = serviceDefinition.getName().trim().toUpperCase();
        if (serviceDefinition.isRemote()) {
            this.remoteEditor.applyChange(serviceDefinition);
            object = this.jflResources.getResources();
            serviceDefinition.setRemoteProperty("local-resources", new ArrayList<URL>(Arrays.asList(object)));
        } else {
            this.localEditor.applyChange(serviceDefinition);
            this.advancedEditor.applyChanges(serviceDefinition);
            object = this.jflResources.getResources();
            serviceDefinition.setResourceList(new ArrayList<URL>(Arrays.asList(object)));
        }
        object = serviceDefinition.getName();
        this.setTitle(BasicUtilities.getString("Service_Manager_Title", (String)object));
        this.jflResources.setBorder(new TitledBorder(BasicUtilities.getString("Resource_Pane_Title", (String)object)));
        if (bl2) {
            try {
                this.toBeSaved.remove(string);
                this.newServices.remove(string);
                if (!this.provider.saveService(serviceDefinition)) {
                    String string2 = BasicUtilities.getString("Service_Failed_to_Save");
                    BasicUtilities.beep();
                    JOptionPane.showMessageDialog(this, string2, "", 2);
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.showExceptionPopup(this, throwable, throwable.getMessage());
            }
        }
    }

    private ServiceDefinition loadService(String string) {
        if (this.lazyCache.containsKey(string = string.toUpperCase())) {
            return (ServiceDefinition)this.lazyCache.get(string);
        }
        try {
            ServiceDefinition serviceDefinition = this.provider.serviceForName(string, false);
            this.lazyCache.put(string.toUpperCase(), serviceDefinition);
            return serviceDefinition;
        }
        catch (Throwable throwable) {
            int n2 = JOptionPane.showConfirmDialog(this, BasicUtilities.getString("Service_Load_Error_Auto_Make", string), "", 0, 3);
            if (n2 == 0) {
                this.addNewService(false, string);
                return (ServiceDefinition)this.lazyCache.get(string.toUpperCase());
            }
            this.provider.deregisterService(string);
            return null;
        }
    }

    private void showPropertyEditor() {
        if (this.isLoadingService) {
            return;
        }
        Object e2 = this.jlsServices.getSelectedValue();
        if (e2 == null) {
            return;
        }
        ServiceDefinition serviceDefinition = null;
        if (!(e2 instanceof ServiceDefinition)) {
            return;
        }
        serviceDefinition = (ServiceDefinition)e2;
        if (serviceDefinition != null) {
            this.applyChanges(serviceDefinition, false);
            if (DriverPropertyEditor.showDialog(this, serviceDefinition)) {
                this.markChanged();
            }
        } else {
            BasicUtilities.beep();
        }
    }

    private String createUniqueName(String string) {
        if (!this.lazyCache.containsKey(string.toUpperCase()) && !this.mdlServices.contains(string)) {
            return string;
        }
        int n2 = 0;
        String string2 = BasicUtilities.getString("Service_Copy_Template", new String[]{string, ""});
        while (this.lazyCache.containsKey(string2)) {
            string2 = BasicUtilities.getString("Service_Copy_Template", new String[]{string, "(" + ++n2 + ")"});
        }
        return string2.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markChanged() {
        if (this.isLoadingService) {
            return;
        }
        int n2 = this.jlsServices.getSelectedIndex();
        Object e2 = this.jlsServices.getSelectedValue();
        if (e2 == null) {
            return;
        }
        ServiceDefinition serviceDefinition = null;
        String string = null;
        if (e2 instanceof ServiceDefinition) {
            serviceDefinition = (ServiceDefinition)e2;
            string = serviceDefinition.getName().trim().toUpperCase();
        } else {
            string = e2.toString().trim().toUpperCase();
        }
        if (!this.toBeSaved.contains(string)) {
            Vector vector = this.toBeSaved;
            synchronized (vector) {
                this.toBeSaved.add(string);
                this.mdlServices.reload(n2);
                this.toggleActions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void testService() {
        block25: {
            block24: {
                block23: {
                    var1_1 = (ServiceDefinition)this.jlsServices.getSelectedValue();
                    if (var1_1 == null) {
                        BasicUtilities.beep();
                        return;
                    }
                    var2_2 = null;
                    var3_3 = null;
                    var1_1.close();
                    try {
                        var2_2 = var1_1.createConnection();
                    }
                    catch (ClassNotFoundException var4_4) {
                        var3_3 = new String[]{var1_1.getDriverClass()};
                        var5_10 = BasicUtilities.getString("Driver_Registration_Error", var3_3);
                        BasicUtilities.showExceptionPopup(this, var4_4, var5_10);
                        return;
                    }
                    catch (SQLException var4_5) {
                        var3_3 = new String[]{var1_1.getDriverClass(), var1_1.getURL()};
                        var5_11 = BasicUtilities.getString("Service_URL_Error", var3_3);
                        BasicUtilities.showExceptionPopup(this, var4_5, var5_11);
                        if (var2_2 != null && var2_2.getVerboseOn()) {
                            BasicUtilities.HandleException(var4_5, var5_11, var2_2.getDebugOn());
                        }
                        return;
                    }
                    catch (Throwable var4_6) {
                        var3_3 = new String[]{var1_1.getName()};
                        var5_12 = BasicUtilities.getString("Service_Creation_Error", var3_3);
                        BasicUtilities.showExceptionPopup(this, var4_6, var5_12);
                        BasicUtilities.HandleException(var4_6, var5_12);
                        return;
                    }
                    if (var2_2 == null) {
                        return;
                    }
                    if (!var1_1.isPromptRequired()) ** GOTO lbl47
                    v0 = ServiceManager.class$java$awt$Frame;
                    if (v0 == null) {
                        v0 = ServiceManager.class$java$awt$Frame = new Frame[0].getClass().getComponentType();
                    }
                    if ((var5_13 /* !! */  = LoginOptionPane.showDialog(var4_7 = (Frame)SwingUtilities.getAncestorOfClass(v0, this))) != null) break block23;
                    JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Creation_Failed", var1_1.getName()));
                    try {
                        var2_2.disconnect();
                    }
                    catch (Throwable var6_14) {
                        // empty catch block
                    }
                    return;
                }
                var2_2.updateAutheticationTokens(var5_13 /* !! */ [0], var5_13 /* !! */ [1]);
lbl47:
                // 2 sources

                if (var2_2.initialize()) {
                    JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Created", var1_1.getName()));
                    break block24;
                }
                JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Creation_Failed", var1_1.getName()));
            }
            try {
                var2_2.disconnect();
            }
            catch (Throwable var4_8) {}
            break block25;
            catch (Throwable var4_9) {
                try {
                    var3_3 = new String[]{var1_1.getName()};
                    var5_13 /* !! */  = BasicUtilities.getString("Service_Creation_Error", var3_3);
                    BasicUtilities.showExceptionPopup(this, var4_9, (String)var5_13 /* !! */ );
                    return;
                }
                catch (Throwable var7_16) {
                    throw var7_16;
                }
                finally {
                    try {
                        var2_2.disconnect();
                    }
                    catch (Throwable var6_15) {}
                }
            }
        }
        var1_1 = null;
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        ServiceManager.UI_CONSTRAINT.gridx = n2;
        ServiceManager.UI_CONSTRAINT.gridy = n3;
        ServiceManager.UI_CONSTRAINT.gridwidth = n4;
        ServiceManager.UI_CONSTRAINT.gridheight = n5;
        ServiceManager.UI_CONSTRAINT.weightx = d2;
        ServiceManager.UI_CONSTRAINT.weighty = d3;
        ServiceManager.UI_CONSTRAINT.anchor = n6;
        ServiceManager.UI_CONSTRAINT.fill = n7;
    }

    public static class 1 {
    }

    private static class AdvancedServiceEditor
    extends JPanel
    implements ActionListener,
    FocusListener {
        private ButtonGroup grpJdbcOpts = new ButtonGroup();
        private JRadioButton rdoGlobalOpt = new JRadioButton(BasicUtilities.getString("Use_Global_Setting"));
        private JRadioButton rdoEnableOpt = new JRadioButton(BasicUtilities.getString("Enable"));
        private JRadioButton rdoDisableOpt = new JRadioButton(BasicUtilities.getString("Disable"));
        private JCheckBox chkCustProps = new JCheckBox(BasicUtilities.getString("Use_Global_JDBC_Settings"));
        private JCheckBox chkAutoCmt = new JCheckBox();
        private JCheckBox chkIsSecure = new JCheckBox();
        private JTextField txtSchema = new JTextField();
        private JComboBox cmbJdbcOpts = new JComboBox<String>(new String[]{BasicUtilities.getString("Enable_Auto_Connect_Text"), BasicUtilities.getString("Enabled_Generated_Keys"), BasicUtilities.getString("Enable_Verbose_Text"), BasicUtilities.getString("Enable_Debug_Text"), BasicUtilities.getString("Log_Queries_Text"), BasicUtilities.getString("Echo_Result_Text"), BasicUtilities.getString("Allow_Escape_Text"), BasicUtilities.getString("Enable_Reverse_Fetch_Text"), BasicUtilities.getString("Enable_JDBC_Trace_Text"), BasicUtilities.getString("LoginTimeout"), BasicUtilities.getString("QueryTimeout"), BasicUtilities.getString("MaxFldSz"), BasicUtilities.getString("MaxRows")});
        private static final String[] prefsKeys = new String[]{"jdbc.keepalive-enabled", "jdbc.resultsetkeys-enabled", "jdbc.verbose-enabled", "jdbc.debug-enabled", "jdbc.echo-query", "jdbc.echo-rowcount", "jdbc.escapeProc-enabled", "jdbc.reverseFetch-enabled", "jdbc.trace-enabled", "jdbc.timeout-login", "jdbc.timeout-query", "jdbc.max-fieldsize", "jdbc.max-rows"};
        private JNumberEditor optionEditor = new JNumberEditor(0, 6);
        private Properties currentPrefs = null;

        private AdvancedServiceEditor() {
            super(new GridBagLayout());
            this.initUI();
        }

        public void setService(ServiceDefinition serviceDefinition) {
            this.currentPrefs = serviceDefinition.getPreferences();
            if (serviceDefinition != null && !serviceDefinition.isRemote()) {
                this.txtSchema.setText(serviceDefinition.getPreferredSchema());
                this.chkCustProps.setEnabled(true);
                this.txtSchema.setEnabled(true);
                this.chkCustProps.setSelected(this.currentPrefs == null || this.currentPrefs.isEmpty());
                this.setAdvancedOptionEnabled(!this.chkCustProps.isSelected());
                if (!this.chkCustProps.isSelected() && this.currentPrefs != null) {
                    String string = this.currentPrefs.getProperty("jdbc.autocommit-enabled");
                    boolean bl2 = Boolean.valueOf(string);
                    this.chkAutoCmt.setSelected(bl2);
                    string = this.currentPrefs.getProperty("jdbc.autocommit-enabled");
                    bl2 = Boolean.valueOf(string);
                    this.chkAutoCmt.setSelected(bl2);
                    this.chkIsSecure.setSelected(serviceDefinition.isSecure());
                } else {
                    UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
                    this.chkIsSecure.setSelected(userPreferences.getBoolean("general.security-enabled"));
                    this.chkAutoCmt.setSelected(userPreferences.getBoolean("jdbc.autocommit-enabled"));
                }
            } else {
                this.setAdvancedOptionEnabled(false);
                this.chkCustProps.setEnabled(false);
                this.txtSchema.setEnabled(false);
            }
        }

        public void registerChangeListeners(ServiceSupport serviceSupport) {
            this.rdoDisableOpt.addActionListener(serviceSupport);
            this.rdoEnableOpt.addActionListener(serviceSupport);
            this.chkCustProps.addActionListener(serviceSupport);
            this.rdoGlobalOpt.addActionListener(serviceSupport);
            this.chkAutoCmt.addActionListener(serviceSupport);
            this.chkIsSecure.addActionListener(serviceSupport);
            this.optionEditor.getDocument().addDocumentListener(serviceSupport);
            this.txtSchema.getDocument().addDocumentListener(serviceSupport);
        }

        public void applyChanges(ServiceDefinition serviceDefinition) {
            if (serviceDefinition != null) {
                serviceDefinition.setPreferredSchema(this.txtSchema.getText());
                if (this.chkCustProps.isSelected()) {
                    serviceDefinition.setPreferences(null);
                    SystemConfig systemConfig = SystemConfig.getInstance();
                    UserPreferences userPreferences = systemConfig.getPreferences();
                    serviceDefinition.setSecurityEnabled(userPreferences.getBoolean("general.security-enabled"));
                } else {
                    if (this.currentPrefs == null) {
                        this.currentPrefs = new Properties(null);
                    }
                    String string = Boolean.toString(this.chkAutoCmt.isSelected());
                    this.currentPrefs.setProperty("jdbc.autocommit-enabled", string);
                    serviceDefinition.setPreferences(this.currentPrefs);
                    serviceDefinition.setSecurityEnabled(this.chkIsSecure.isSelected());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n2 = this.cmbJdbcOpts.getSelectedIndex();
            if (object == this.chkCustProps) {
                this.setAdvancedOptionEnabled(!this.chkCustProps.isSelected());
            } else if (object == this.cmbJdbcOpts) {
                if (this.currentPrefs == null) {
                    this.currentPrefs = new Properties(null);
                }
                boolean bl2 = n2 <= prefsKeys.length - 4;
                String string = prefsKeys[n2];
                this.rdoDisableOpt.setEnabled(bl2);
                if (!this.currentPrefs.containsKey(string)) {
                    this.rdoGlobalOpt.setSelected(true);
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                } else if (bl2) {
                    this.optionEditor.setEnabled(false);
                    boolean bl3 = Boolean.valueOf(this.currentPrefs.getProperty(string));
                    if (bl3) {
                        this.rdoEnableOpt.setSelected(true);
                    } else {
                        this.rdoDisableOpt.setSelected(true);
                    }
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                } else {
                    this.rdoEnableOpt.setSelected(true);
                    this.optionEditor.setEnabled(true);
                    this.optionEditor.setText(this.currentPrefs.getProperty(string, ""));
                }
            } else if (object == this.rdoGlobalOpt) {
                if (this.currentPrefs != null) {
                    String string = prefsKeys[n2];
                    this.currentPrefs.remove(string);
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                }
            } else if (object == this.rdoEnableOpt) {
                if (this.currentPrefs == null) {
                    this.currentPrefs = new Properties(null);
                }
                boolean bl4 = n2 <= prefsKeys.length - 4;
                String string = prefsKeys[n2];
                if (bl4) {
                    this.currentPrefs.setProperty(string, Boolean.toString(true));
                } else {
                    this.optionEditor.setEnabled(true);
                }
            } else if (object == this.rdoDisableOpt) {
                if (this.currentPrefs == null) {
                    this.currentPrefs = new Properties(null);
                }
                boolean bl5 = n2 <= prefsKeys.length - 4;
                String string = prefsKeys[n2];
                if (bl5) {
                    this.currentPrefs.setProperty(string, Boolean.toString(false));
                } else {
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                    this.currentPrefs.setProperty(string, "0");
                }
            } else if (object == this.chkAutoCmt || object == this.chkIsSecure) {
                // empty if block
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.currentPrefs == null) {
                this.currentPrefs = new Properties(null);
            }
            int n2 = this.cmbJdbcOpts.getSelectedIndex();
            String string = prefsKeys[n2];
            this.currentPrefs.setProperty(string, this.optionEditor.getText());
        }

        private void setAdvancedOptionEnabled(boolean bl2) {
            this.rdoGlobalOpt.setEnabled(bl2);
            this.rdoEnableOpt.setEnabled(bl2);
            this.rdoDisableOpt.setEnabled(bl2);
            this.cmbJdbcOpts.setEnabled(bl2);
            this.chkIsSecure.setEnabled(bl2);
            this.chkAutoCmt.setEnabled(bl2);
            this.optionEditor.setEnabled(false);
        }

        private void initUI() {
            this.chkAutoCmt.addActionListener(this);
            this.chkAutoCmt.setText(BasicUtilities.getString("Auto_Commit_On_Close"));
            this.chkAutoCmt.setToolTipText(BasicUtilities.getString("Auto_Commit_On_Close_Tip"));
            this.chkIsSecure.addActionListener(this);
            this.chkIsSecure.setText(BasicUtilities.getString("Is_Service_Secure"));
            this.chkIsSecure.setToolTipText(BasicUtilities.getString("Is_Service_Secure_Tip"));
            this.txtSchema.setToolTipText(BasicUtilities.getString("Choose_Preffered_Schema_Tip"));
            this.rdoGlobalOpt.addActionListener(this);
            this.rdoEnableOpt.addActionListener(this);
            this.rdoDisableOpt.addActionListener(this);
            this.cmbJdbcOpts.addActionListener(this);
            this.chkCustProps.addActionListener(this);
            this.grpJdbcOpts.add(this.rdoGlobalOpt);
            this.grpJdbcOpts.add(this.rdoEnableOpt);
            this.grpJdbcOpts.add(this.rdoDisableOpt);
            this.optionEditor.setEnabled(false);
            this.optionEditor.addFocusListener(this);
            JLabel jLabel = null;
            ServiceManager.constrain(0, 0, 1, 10, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("Choose_Preffered_Schema"));
            ServiceManager.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 2);
            this.add((Component)jLabel, UI_CONSTRAINT);
            ServiceManager.constrain(2, 1, 2, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.txtSchema, UI_CONSTRAINT);
            ServiceManager.constrain(1, 2, 3, 1, 1.0, 0.0, 17, 0);
            this.add((Component)this.chkCustProps, UI_CONSTRAINT);
            ServiceManager.constrain(1, 3, 1, 1, 0.0, 0.0, 17, 0);
            jLabel = new JLabel(BasicUtilities.getString("Select_JDBC_Option"));
            this.add((Component)jLabel, UI_CONSTRAINT);
            ServiceManager.constrain(1, 4, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.cmbJdbcOpts, UI_CONSTRAINT);
            ServiceManager.constrain(1, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.rdoGlobalOpt, UI_CONSTRAINT);
            ServiceManager.constrain(2, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.rdoEnableOpt, UI_CONSTRAINT);
            ServiceManager.constrain(3, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.rdoDisableOpt, UI_CONSTRAINT);
            ServiceManager.constrain(2, 6, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.optionEditor, UI_CONSTRAINT);
            ServiceManager.constrain(1, 7, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkIsSecure, UI_CONSTRAINT);
            ServiceManager.constrain(1, 8, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkAutoCmt, UI_CONSTRAINT);
            ServiceManager.constrain(1, 9, 3, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
            ServiceManager.constrain(4, 0, 1, 10, 1.0, 0.0, 17, 2);
            this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        }

        public /* synthetic */ AdvancedServiceEditor(1 var1_1) {
            this();
        }
    }

    private static class LocalServiceEditor
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private DefaultComboBoxModel mdlDrivers = new DefaultComboBoxModel();
        private JComboBox cmbDrivers = new JComboBox(this.mdlDrivers);
        private JTextField txtAlias = new JTextField();
        private JTextField txtURL = new JTextField();
        private JTextField txtUser = new JTextField();
        private JTextField txtDriver = (JTextField)this.cmbDrivers.getEditor().getEditorComponent();
        private JTextField txtURLExample = new JTextField();
        private JPasswordField txtPassword = new JPasswordField(16);
        private JCheckBox chkUseXProps = new JCheckBox("", false);
        private JCheckBox chkUsePrompt = new JCheckBox("", false);
        private JButton btnXtendEdit = new JButton(BasicUtilities.getString("Elipsis"));
        private ClassListCellRenderer classRenderer = new ClassListCellRenderer();
        private Properties drivers = SystemConfig.getInstance().getDriverDefinitions();
        private boolean passwordUpdated = false;
        private boolean isInitializing = false;

        public LocalServiceEditor() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "LocalServiceEditor::initUI()");
            }
        }

        public void setEditable(boolean bl2) {
            this.txtAlias.setEnabled(bl2);
            this.cmbDrivers.setEnabled(bl2);
            this.txtURL.setEnabled(bl2);
            this.txtUser.setEnabled(bl2);
            this.txtPassword.setEnabled(bl2);
            this.chkUseXProps.setEnabled(bl2);
            this.chkUsePrompt.setEnabled(bl2);
            this.btnXtendEdit.setEnabled(bl2);
            if (bl2) {
                this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
                this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
                this.btnXtendEdit.setEnabled(this.chkUseXProps.isSelected());
            }
        }

        public void applyResourceChanges(ServiceDefinition serviceDefinition) {
            if (serviceDefinition != null) {
                SystemConfig systemConfig = SystemConfig.getInstance();
                UserPreferences userPreferences = systemConfig.getPreferences();
                ClassLoader classLoader = serviceDefinition.getClassLoader();
                this.classRenderer.setClassLoader(serviceDefinition.getClassLoader());
                if (userPreferences.getBoolean("general.alldrivers-visible")) {
                    boolean bl2 = userPreferences.getBoolean("general.driversort-enabled");
                    Iterator<Object> iterator = this.drivers.keySet().iterator();
                    String[] stringArray = (String[])(bl2 ? new Object[this.mdlDrivers.getSize()] : null);
                    this.mdlDrivers.removeAllElements();
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        String string = object.toString();
                        try {
                            Class.forName(string, false, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            continue;
                        }
                        if (bl2) {
                            stringArray[n2++] = string;
                        }
                        this.mdlDrivers.addElement(string);
                    }
                    if (bl2) {
                        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                    }
                    this.drivers = null;
                    iterator = null;
                    classLoader = null;
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.mdlDrivers.addElement(stringArray[n2]);
                    }
                    stringArray = null;
                }
            }
        }

        public void updateAuthentication() {
            this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
            this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
        }

        public void registerChangeListeners(ServiceSupport serviceSupport) {
            this.btnXtendEdit.addActionListener(serviceSupport);
            this.chkUsePrompt.addActionListener(serviceSupport);
            this.chkUseXProps.addActionListener(serviceSupport);
            this.cmbDrivers.addActionListener(serviceSupport);
            this.txtAlias.addFocusListener(serviceSupport);
            this.txtUser.getDocument().addDocumentListener(serviceSupport);
            this.txtURL.getDocument().addDocumentListener(serviceSupport);
            this.txtPassword.getDocument().addDocumentListener(serviceSupport);
            this.txtDriver.getDocument().addDocumentListener(serviceSupport);
            this.txtAlias.getDocument().addDocumentListener(serviceSupport);
        }

        public void applyChange(ServiceDefinition serviceDefinition) {
            serviceDefinition.setDriverClass((String)this.cmbDrivers.getSelectedItem());
            serviceDefinition.setURL(this.txtURL.getText());
            if (this.chkUsePrompt.isSelected()) {
                serviceDefinition.setUserName(null);
                serviceDefinition.setPassword(null);
            } else {
                serviceDefinition.setUserName(this.txtUser.getText());
                if (this.passwordUpdated) {
                    String string = new String(this.txtPassword.getPassword());
                    serviceDefinition.setPassword(string);
                }
            }
            if (!this.chkUseXProps.isSelected()) {
                serviceDefinition.setProperties(null);
            }
        }

        public void setService(ServiceDefinition serviceDefinition) {
            this.isInitializing = true;
            if (serviceDefinition == null) {
                if (this.mdlDrivers.getSize() >= 1) {
                    this.cmbDrivers.setSelectedIndex(0);
                }
                this.txtAlias.setText("");
                this.txtURL.setText("");
                this.chkUsePrompt.setSelected(false);
                this.txtUser.setText("");
                this.txtPassword.setText("");
                this.txtPassword.setEnabled(true);
                this.txtUser.setEnabled(true);
                this.chkUseXProps.setSelected(false);
                this.passwordUpdated = false;
            } else {
                this.txtAlias.setText(serviceDefinition.getName());
                this.txtURL.setText(serviceDefinition.getURL());
                this.chkUsePrompt.setSelected(serviceDefinition.isPromptRequired());
                this.cmbDrivers.setSelectedItem(serviceDefinition.getDriverClass());
                if (this.chkUsePrompt.isSelected()) {
                    this.txtUser.setText("");
                } else {
                    this.txtUser.setText(serviceDefinition.getUserName());
                }
                this.txtPassword.setText("");
                this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
                this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
                Properties properties = serviceDefinition.getProperties();
                this.chkUseXProps.setSelected(properties != null && !properties.isEmpty());
                this.btnXtendEdit.setEnabled(this.chkUseXProps.isSelected());
                this.passwordUpdated = false;
            }
            this.isInitializing = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
            this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
            this.btnXtendEdit.setEnabled(this.chkUseXProps.isSelected());
            if (object == this.cmbDrivers) {
                String string = (String)this.cmbDrivers.getSelectedItem();
                this.txtURLExample.setText(this.drivers.getProperty(string == null ? "" : string, ""));
                this.txtURLExample.setCaretPosition(0);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkPasswordUpdate(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkPasswordUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkPasswordUpdate(documentEvent);
        }

        private void checkPasswordUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            if (this.isInitializing) {
                return;
            }
            if (document == this.txtPassword.getDocument()) {
                this.passwordUpdated = true;
            }
        }

        private void initUI() {
            this.chkUseXProps.setText(BasicUtilities.getString("Extended_Properties"));
            this.chkUseXProps.setToolTipText(BasicUtilities.getString("Extended_Properties_Tip"));
            this.chkUsePrompt.setText(BasicUtilities.getString("SERV_Auth_Prompt"));
            this.chkUsePrompt.setToolTipText(BasicUtilities.getString("SERV_Auth_Prompt_Tip"));
            this.btnXtendEdit.setToolTipText(BasicUtilities.getString("Extended_Properties_Tip"));
            this.txtURLExample.setEditable(false);
            this.txtPassword.getDocument().addDocumentListener(this);
            this.btnXtendEdit.setPreferredSize(new Dimension(16, 16));
            BasicUtilities.lockComponentToPerferredSize(this.btnXtendEdit);
            this.btnXtendEdit.setEnabled(false);
            this.btnXtendEdit.setActionCommand(Integer.toString(13));
            this.cmbDrivers.setEditable(true);
            this.cmbDrivers.setRenderer(this.classRenderer);
            this.cmbDrivers.setMaximumRowCount(5);
            this.cmbDrivers.addActionListener(this);
            BasicUtilities.localizeTextComponent(this.txtAlias, null);
            BasicUtilities.localizeTextComponent(this.txtDriver, null);
            BasicUtilities.localizeTextComponent(this.txtURLExample, null);
            BasicUtilities.localizeTextComponent(this.txtURL, null);
            BasicUtilities.localizeTextComponent(this.txtUser, null);
            BasicUtilities.localizeTextComponent(this.txtPassword, null);
            this.txtAlias.addActionListener(this);
            this.chkUsePrompt.addActionListener(this);
            this.chkUseXProps.addActionListener(this);
            this.btnXtendEdit.addActionListener(this);
            ServiceManager.constrain(0, 0, 1, 10, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            JLabel jLabel = new JLabel(BasicUtilities.getString("SERV_Name_Label"));
            ServiceManager.constrain(1, 1, 2, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_Driver_Label"));
            ServiceManager.constrain(1, 2, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_Ex_URL_Label"));
            ServiceManager.constrain(1, 3, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_URL_Label"));
            ServiceManager.constrain(1, 4, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_User_Label"));
            ServiceManager.constrain(1, 5, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_Pass_Label"));
            ServiceManager.constrain(1, 6, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            ServiceManager.constrain(3, 1, 2, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtAlias, UI_CONSTRAINT);
            ServiceManager.constrain(2, 2, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.cmbDrivers, UI_CONSTRAINT);
            ServiceManager.constrain(2, 3, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtURLExample, UI_CONSTRAINT);
            ServiceManager.constrain(2, 4, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtURL, UI_CONSTRAINT);
            ServiceManager.constrain(2, 5, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtUser, UI_CONSTRAINT);
            ServiceManager.constrain(2, 6, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtPassword, UI_CONSTRAINT);
            ServiceManager.constrain(4, 7, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnXtendEdit, UI_CONSTRAINT);
            ServiceManager.constrain(2, 7, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkUseXProps, UI_CONSTRAINT);
            ServiceManager.constrain(2, 8, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkUsePrompt, UI_CONSTRAINT);
            ServiceManager.constrain(5, 0, 1, 10, 0.0, 1.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 9, 4, 1, 1.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            SystemConfig systemConfig = SystemConfig.getInstance();
            UserPreferences userPreferences = systemConfig.getPreferences();
            if (!userPreferences.getBoolean("general.alldrivers-visible")) {
                boolean bl2 = userPreferences.getBoolean("general.driversort-enabled");
                String[] stringArray = (String[])this.drivers.keySet().toArray();
                this.mdlDrivers.removeAllElements();
                if (bl2) {
                    Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                }
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.mdlDrivers.addElement(stringArray[i2]);
                }
                stringArray = null;
            }
            systemConfig = null;
            userPreferences = null;
        }
    }

    private static class RemoteServiceEditor
    extends JPanel {
        private JLabel lblVersion = new JLabel();
        private JTextField lblURL = new JTextField();
        private JTextField txtURL = new JTextField();
        private JTextField txtAlias = new JTextField();
        private JButton btnLocalize = new JButton(BasicUtilities.loadIconResource("Server16"));
        private JButton btnRefresh = new JButton(BasicUtilities.loadIconResource("Refresh16"));
        private DateFormat fmt = DateFormat.getDateTimeInstance(2, 3);

        public RemoteServiceEditor() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "RemoteServiceEditor::initUI()");
            }
        }

        public void registerChangeListeners(ServiceSupport serviceSupport) {
            this.txtAlias.addFocusListener(serviceSupport);
            this.txtAlias.getDocument().addDocumentListener(serviceSupport);
            this.txtURL.getDocument().addDocumentListener(serviceSupport);
        }

        public void setEditable(boolean bl2) {
            this.txtAlias.setEnabled(bl2);
            this.txtURL.setEnabled(bl2);
            this.btnLocalize.setEnabled(bl2);
            this.btnRefresh.setEnabled(bl2);
        }

        public void setService(ServiceDefinition serviceDefinition) {
            if (serviceDefinition == null || !serviceDefinition.isRemote()) {
                BasicUtilities.beep();
            }
            this.txtAlias.setText(serviceDefinition.getName());
            this.lblURL.setText(serviceDefinition.getURL());
            try {
                long l2 = Long.parseLong((String)serviceDefinition.getRemoteConfig("version"));
                this.lblVersion.setText(this.fmt.format(new Date(l2)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.txtURL.setText((String)serviceDefinition.getRemoteConfig("url"));
        }

        public void applyChange(ServiceDefinition serviceDefinition) {
            if (serviceDefinition == null || !serviceDefinition.isRemote()) {
                BasicUtilities.beep();
            }
            String string = this.txtAlias.getText().trim();
            String string2 = serviceDefinition.getName();
            if (!string2.equalsIgnoreCase(string)) {
                ServiceProvider serviceProvider = SystemConfig.getInstance().getServiceProvider();
                try {
                    if (serviceProvider.removeService(string2)) {
                        serviceProvider.registerService(string, null);
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            serviceDefinition.setName(string);
            serviceDefinition.setRemoteProperty("url", this.txtURL.getText());
        }

        private void initUI() {
            BasicUtilities.localizeTextComponent(this.txtAlias, null);
            BasicUtilities.localizeTextComponent(this.txtURL, null);
            BasicUtilities.localizeTextComponent(this.lblURL, null);
            this.lblURL.setEditable(false);
            this.btnRefresh.setToolTipText(BasicUtilities.getString("Service_Refresh_Tip"));
            this.btnRefresh.setHorizontalAlignment(0);
            this.btnRefresh.setFocusPainted(false);
            this.btnRefresh.setActionCommand(Integer.toString(12));
            this.btnLocalize.setToolTipText(BasicUtilities.getString("Service_Localize_Tip"));
            this.btnLocalize.setHorizontalAlignment(0);
            this.btnLocalize.setFocusPainted(false);
            ServiceManager.constrain(0, 0, 1, 10, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            JLabel jLabel = new JLabel(BasicUtilities.getString("Service_Version"));
            ServiceManager.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_URL_Label"));
            ServiceManager.constrain(1, 2, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("Service_URL"));
            ServiceManager.constrain(1, 3, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("SERV_Name_Label"));
            ServiceManager.constrain(1, 4, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)jLabel, UI_CONSTRAINT);
            ServiceManager.constrain(2, 1, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.lblVersion, UI_CONSTRAINT);
            ServiceManager.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnLocalize, UI_CONSTRAINT);
            ServiceManager.constrain(2, 2, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.lblURL, UI_CONSTRAINT);
            ServiceManager.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnRefresh, UI_CONSTRAINT);
            ServiceManager.constrain(2, 3, 2, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.txtURL, UI_CONSTRAINT);
            ServiceManager.constrain(2, 4, 2, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.txtAlias, UI_CONSTRAINT);
            ServiceManager.constrain(1, 9, 4, 1, 1.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            ServiceManager.constrain(4, 0, 1, 10, 0.0, 1.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        }
    }

    private class ServiceSupport
    implements ActionListener,
    FocusListener,
    ChangeListener,
    DocumentListener,
    ListSelectionListener {
        private int lastSelection = -1;
        private boolean resourcesChanged = false;

        private ServiceSupport() {
        }

        public void syncScreen(ServiceDefinition serviceDefinition) {
            if (serviceDefinition == null) {
                BasicUtilities.beep();
            } else {
                ServiceManager.this.jflResources.setResources(serviceDefinition.getResourceURLs());
                ServiceManager.this.advancedEditor.setService(serviceDefinition);
                if (serviceDefinition.isRemote()) {
                    ServiceManager.this.remoteEditor.setService(serviceDefinition);
                    ServiceManager.this.pnlEditor.showCard(ServiceManager.this.remoteEditor);
                } else {
                    ServiceManager.this.localEditor.setService(serviceDefinition);
                    ServiceManager.this.localEditor.applyResourceChanges(serviceDefinition);
                    ServiceManager.this.pnlEditor.showCard(ServiceManager.this.localEditor);
                }
            }
            String string = serviceDefinition == null ? "" : serviceDefinition.getName();
            ServiceManager.this.setTitle(BasicUtilities.getString("Service_Manager_Title", string));
            ServiceManager.this.jflResources.setBorder(new TitledBorder(BasicUtilities.getString("Resource_Pane_Title", string)));
            ServiceManager.this.jtpServiceEditor.setEnabled(serviceDefinition != null);
            if (ServiceManager.this.toBeDeleted.contains(string.toUpperCase()) || ServiceManager.this.prefs.getBoolean("servicemanager.switchtab-enabled")) {
                ServiceManager.this.jtpServiceEditor.setSelectedIndex(0);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ServiceDefinition serviceDefinition;
            int n2;
            block8: {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                n2 = ServiceManager.this.jlsServices.getSelectedIndex();
                Object var3_3 = null;
                serviceDefinition = null;
                if (this.lastSelection >= 0 && n2 != this.lastSelection) {
                    try {
                        serviceDefinition = (ServiceDefinition)ServiceManager.this.mdlServices.get(this.lastSelection);
                        ServiceManager.this.applyChanges(serviceDefinition, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                var3_3 = ServiceManager.this.jlsServices.getSelectedValue();
                ServiceManager.this.isLoadingService = true;
                if (var3_3 instanceof String) {
                    String string = var3_3;
                    serviceDefinition = ServiceManager.this.loadService(string);
                    if (serviceDefinition != null) {
                        ServiceManager.this.mdlServices.setElementAt(serviceDefinition, n2);
                        break block8;
                    } else {
                        ServiceManager.this.mdlServices.removeElement(var3_3);
                        ServiceManager.this.mdlServices.reload();
                        if (!ServiceManager.this.mdlServices.isEmpty()) {
                            ServiceManager.this.jlsServices.setSelectedIndex(0);
                            return;
                        }
                        ServiceManager.this.jlsServices.clearSelection();
                        return;
                    }
                }
                serviceDefinition = var3_3;
            }
            this.syncScreen(serviceDefinition);
            this.lastSelection = n2;
            ServiceManager.this.isLoadingService = false;
            ServiceManager.this.toggleActions();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(actionEvent.getActionCommand());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ServiceManager.this.processActionEvent(n2);
            }
            catch (Throwable throwable) {
                BasicUtilities.showExceptionPopup(ServiceManager.this, throwable, throwable.getMessage());
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ServiceManager.this.markChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ServiceManager.this.markChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ServiceManager.this.markChanged();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == ServiceManager.this.jtpServiceEditor) {
                if (!ServiceManager.this.isLoadingService) {
                    ServiceDefinition serviceDefinition = (ServiceDefinition)ServiceManager.this.jlsServices.getSelectedValue();
                    if (this.resourcesChanged) {
                        if (ServiceManager.this.jtpServiceEditor.getSelectedIndex() != 2 && !serviceDefinition.isRemote()) {
                            URL[] uRLArray = ServiceManager.this.jflResources.getResources();
                            serviceDefinition.setResourceList(new ArrayList<URL>(Arrays.asList(uRLArray)));
                            ServiceManager.this.localEditor.applyResourceChanges(serviceDefinition);
                        }
                        this.resourcesChanged = false;
                    }
                }
            } else {
                if (object == ServiceManager.this.jflResources) {
                    this.resourcesChanged = true;
                }
                ServiceManager.this.markChanged();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JTextComponent jTextComponent = (JTextComponent)focusEvent.getComponent();
            String string = jTextComponent.getText().trim();
            Object e2 = ServiceManager.this.mdlServices.get(this.lastSelection);
            if (!(e2 instanceof ServiceDefinition)) {
                return;
            }
            ServiceDefinition serviceDefinition = (ServiceDefinition)e2;
            String string2 = serviceDefinition.getName();
            if (!string2.equals(string)) {
                try {
                    if (ServiceManager.this.provider.removeService(string2)) {
                        ServiceManager.this.provider.registerService(string, null);
                        serviceDefinition.setName(string);
                        String string3 = string2.trim().toUpperCase();
                        ServiceManager.this.toBeSaved.remove(string3);
                        ServiceManager.this.toBeSaved.add(string.toUpperCase());
                        if (ServiceManager.this.newServices.contains(string3)) {
                            ServiceManager.this.newServices.remove(string3);
                            ServiceManager.this.newServices.add(string.trim().toUpperCase());
                        }
                    }
                }
                catch (Throwable throwable) {
                    jTextComponent.setText(string2);
                    serviceDefinition.setName(string2);
                    BasicUtilities.showExceptionPopup(ServiceManager.this, throwable, throwable.getMessage());
                }
                string2 = serviceDefinition.getName();
                ServiceManager.this.setTitle(BasicUtilities.getString("Service_Manager_Title", string2));
                ServiceManager.this.jflResources.setBorder(new TitledBorder(BasicUtilities.getString("Resource_Pane_Title", string2)));
                ServiceManager.this.mdlServices.reload(ServiceManager.this.jlsServices.getSelectedIndex());
            }
        }

        public /* synthetic */ ServiceSupport(1 var2_2) {
            this();
        }
    }

    private class ServiceRenderer
    extends DefaultListCellRenderer {
        private ServiceRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            ServiceDefinition serviceDefinition = null;
            if (object instanceof ServiceDefinition) {
                serviceDefinition = (ServiceDefinition)object;
                object = serviceDefinition.getName();
            }
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            object = ((String)object).trim().toUpperCase();
            if (serviceDefinition == null || !serviceDefinition.isRemote()) {
                this.setIcon(BasicUtilities.loadIconResource("Server16"));
            } else {
                this.setIcon(BasicUtilities.loadIconResource("WebComponent16"));
            }
            this.setEnabled(!ServiceManager.this.toBeDeleted.contains(object));
            if (ServiceManager.this.toBeSaved.contains(object)) {
                this.setFont(jList.getFont().deriveFont(1));
            }
            if (ServiceManager.this.newServices.contains(object)) {
                this.setForeground(jList.getSelectionForeground());
            }
            return this;
        }

        public /* synthetic */ ServiceRenderer(1 var2_2) {
            this();
        }
    }

    private class ServiceAction
    extends AbstractAction {
        public int actionID = 0;

        public ServiceAction(int n2) {
            this.actionID = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServiceManager.this.inputSupport.actionPerformed(new ActionEvent(actionEvent.getSource(), this.actionID, Integer.toString(this.actionID)));
        }
    }
}

