/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.JDBCSuggestor;
import org.isqlviewer.swing.SuggestionWindow;
import org.isqlviewer.swing.WindowWillShowListener;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class SQLEditor
extends JPanel {
    private SQLDocument document = new SQLDocument();
    private JTextPane editor = new JTextPane(this.document);
    private JLabel lblCaret = new JLabel();
    private JLabel lblMode = new JLabel();
    private JDBCSuggestor metaSuggestor = new JDBCSuggestor();
    private ListCellRenderer metaRenderer = new JDBCSuggestor.SuggestionRenderer(this.document);
    private EditorSupport support = new EditorSupport(this);
    private UndoManager undoManager = new UndoManager();
    private SuggestionWindow inline = null;

    public SQLEditor() {
        this((AppController)null);
    }

    public SQLEditor(AppController appController) {
        super(new BorderLayout());
        try {
            if (appController != null) {
                Window window = appController.getRootWindow();
                this.createContextHelp(window);
                this.setActionManager(appController.getActionManager());
                appController.setDefaultTextComponent(this.editor);
            }
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "SQLEditor::<init>", true);
        }
    }

    public String getText() {
        return this.editor.getText().trim();
    }

    public String getSelectedText() {
        String string = this.editor.getSelectedText();
        return string == null ? "" : string.trim();
    }

    public void createContextHelp(Window window) {
        if (this.inline != null) {
            this.inline.dispose();
        }
        this.inline = null;
        this.inline = new SuggestionWindow(window);
        this.inline.setModel(this.metaSuggestor);
        this.inline.setRenderer(new JDBCSuggestor.SuggestionRenderer(this.document));
        this.inline.setWindowListener(this.support);
        this.inline.setTextComponent(this.editor);
        if (BasicUtilities.isMac()) {
            this.inline.addKeyBinding(BasicUtilities.createKeyStroke(27, 512));
            this.inline.addKeyBinding(BasicUtilities.createKeyStroke(27, 9));
        }
        this.inline.addKeyBinding(BasicUtilities.createKeyStroke(32, 2));
        this.inline.addKeyBinding(BasicUtilities.createKeyStroke(32, 3));
    }

    public void setText(String string) {
        this.document.setStylesEnabled(false);
        this.editor.setText(string);
        this.document.setStylesEnabled(true);
        this.document.validateStyles();
    }

    public JTextComponent getEditor() {
        return this.editor;
    }

    public SQLDocument getDocument() {
        return this.document;
    }

    public String toHTML(String string) {
        try {
            return this.document.toHTML(string, true);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public String toHTML() {
        return this.toHTML(this.editor.getText());
    }

    public void requestFocus() {
        this.editor.requestFocus();
        this.support.caretUpdate(null);
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.editor.setEnabled(bl2);
        this.editor.setEditable(bl2);
        this.lblCaret.setEnabled(bl2);
        this.lblMode.setEnabled(bl2);
    }

    public void setEditable(boolean bl2) {
        this.editor.setEditable(bl2);
    }

    public void setCaretPosition(int n2) {
        try {
            this.editor.setCaretPosition(n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void configureWithConnection(DatabaseConnection databaseConnection) {
        this.updateConnection(databaseConnection);
    }

    private void initUI() throws Exception {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.editor), "Center");
        jPanel.add((Component)this.createStatusBar(), "South");
        this.add((Component)jPanel, "Center");
        this.setPreferredSize(new Dimension(320, 120));
        this.editor.setDropTarget(new DropTarget(this.editor, this.support));
        this.editor.setDragEnabled(true);
        BasicUtilities.localizeTextComponent(this.editor, this.undoManager);
        Keymap keymap = this.editor.getKeymap();
        KeyStroke keyStroke = null;
        OverwriteToggleAction overwriteToggleAction = null;
        overwriteToggleAction = new OverwriteToggleAction(this.document, this.lblMode);
        if (overwriteToggleAction != null && (keyStroke = BasicUtilities.isMac() ? KeyStroke.getKeyStroke(73, BasicUtilities.CMD_MASK, true) : KeyStroke.getKeyStroke(155, 0, false)) != null) {
            keymap.addActionForKeyStroke(keyStroke, overwriteToggleAction);
        }
    }

    private JComponent createStatusBar() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder();
        this.lblCaret.setBorder(border);
        this.lblMode.setBorder(border);
        this.lblCaret.setVerticalAlignment(0);
        this.lblMode.setVerticalAlignment(0);
        this.lblCaret.setHorizontalAlignment(0);
        this.lblMode.setHorizontalAlignment(0);
        Insets insets = new Insets(0, 0, 0, 0);
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        jPanel.add((Component)this.lblMode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add(Box.createHorizontalStrut(2), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add((Component)this.lblCaret, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        boolean bl2 = this.document.getOverwriteEnabled();
        String string = bl2 ? BasicUtilities.getString("Editor_Overwrite_Mode") : BasicUtilities.getString("Editor_Insert_Mode");
        this.lblMode.setText(" ".concat(string).concat(" "));
        return jPanel;
    }

    private void setActionManager(ActionManager actionManager) {
        Keymap keymap = this.editor.getKeymap();
        KeyStroke keyStroke = null;
        Action action = null;
        if (actionManager == null) {
            return;
        }
        IPCService iPCService = SystemConfig.getInstance().getIPCService();
        iPCService.subscribe(this.support, "isql-service-change");
        iPCService.subscribe(this.support, "isql-sql-message");
        action = actionManager.getAction(15);
        if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
            keymap.addActionForKeyStroke(keyStroke, action);
        }
        if ((action = actionManager.getAction(47)) != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
            keymap.addActionForKeyStroke(keyStroke, action);
        }
        if ((action = actionManager.getAction(17)) != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
            keymap.addActionForKeyStroke(keyStroke, action);
        }
        if ((action = actionManager.getAction(18)) != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
            keymap.addActionForKeyStroke(keyStroke, action);
        }
    }

    private void updateConnection(DatabaseConnection databaseConnection) {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        boolean bl2 = userPreferences.getBoolean("editor.syntax-help.enabled");
        boolean bl3 = userPreferences.getBoolean("editor.context-help.enabled");
        long l2 = System.currentTimeMillis();
        if (bl2) {
            this.document.updateConnection(databaseConnection);
        }
        if (bl3) {
            this.metaSuggestor.setConnection(databaseConnection);
        }
        l2 = System.currentTimeMillis() - l2;
        if (bl2 || bl3) {
            System.out.println(BasicUtilities.getString("MetaDataLoad_Info", Long.toString(l2)));
        }
    }

    private static class EditorSupport
    extends DropTargetAdapter
    implements CaretListener,
    FocusListener,
    IPCListener,
    PreferenceChangeListener,
    UndoableEditListener,
    WindowWillShowListener {
        public UserPreferences preferences = SystemConfig.getInstance().getPreferences();
        private SQLEditor owner = null;
        private NumberFormat nfmt = NumberFormat.getIntegerInstance();

        public EditorSupport(SQLEditor sQLEditor) {
            this.owner = sQLEditor;
            this.owner.editor.addFocusListener(this);
            this.owner.editor.addCaretListener(this);
            this.owner.document.addUndoableEditListener(this);
            this.preferences.addPreferenceChangeListener(this);
            this.nfmt.setMinimumIntegerDigits(3);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.owner.setCaretPosition(Math.max(0, this.owner.editor.getCaretPosition()));
            this.caretUpdate(null);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Object object = caretEvent == null ? this.owner.editor : caretEvent.getSource();
            int n2 = caretEvent == null ? this.owner.editor.getCaretPosition() : caretEvent.getDot();
            try {
                if (object instanceof JTextComponent) {
                    int n3 = 0;
                    int n4 = 0;
                    JTextComponent jTextComponent = (JTextComponent)object;
                    n3 = BasicUtilities.getCaretRow(n2, jTextComponent) + 1;
                    n4 = BasicUtilities.getCaretCol(n2, jTextComponent) + 1;
                    String string = this.nfmt.format(n3).concat(" : ").concat(this.nfmt.format(n4));
                    if (this.preferences.getBoolean("editor.caretoffset-enabled")) {
                        string = string.concat(", ").concat(this.nfmt.format(n2 + 1));
                    }
                    this.owner.lblCaret.setText(" ".concat(string).concat(" "));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (undoableEditEvent == null || undoableEditEvent.getEdit() == null) {
                return;
            }
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            String string = undoableEdit.getPresentationName();
            if (string != null && undoableEdit.canUndo()) {
                if (string.indexOf("style") < 0) {
                    this.owner.undoManager.addEdit(undoableEditEvent.getEdit());
                } else {
                    undoableEdit.die();
                }
            } else {
                undoableEdit.die();
            }
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent == null) {
                return;
            }
            String string = preferenceChangeEvent.getKey();
            String string2 = preferenceChangeEvent.getNewValue();
            SQLDocument sQLDocument = this.owner.document;
            JTextPane jTextPane = this.owner.editor;
            if (string2 == null) {
                try {
                    string2 = SystemConfig.getInstance().getPreferences().get(string);
                }
                finally {
                    return;
                }
            }
            if (string.equals("editor.background-color")) {
                Color color = Color.decode(string2);
                jTextPane.setBackground(color);
                sQLDocument.getStylizer().updateDefaultBackground(color);
                sQLDocument.validateStyles();
            }
            if (string.equals("editor.default-color")) {
                Color color = Color.decode(string2);
                jTextPane.setForeground(color);
                sQLDocument.getStylizer().updateDefaultForeground(color);
                sQLDocument.validateStyles();
            }
            if (string.equals("editor.font")) {
                Font font = StringUtilities.parseFontString(string2);
                jTextPane.setFont(font);
                sQLDocument.getStylizer().updateDefaultFont(font);
                sQLDocument.validateStyles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                JTextPane jTextPane = this.owner.editor;
                SQLDocument sQLDocument = this.owner.document;
                int n2 = jTextPane.viewToModel(dropTargetDropEvent.getLocation());
                int n3 = dropTargetDropEvent.getDropAction();
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(n3);
                    this.doFileDrop(dropTargetDropEvent, transferable);
                } else if (dropTargetDropEvent.isDataFlavorSupported(BasicUtilities.bookmarkFlavour)) {
                    dropTargetDropEvent.acceptDrop(n3);
                    SQLBookmark sQLBookmark = (SQLBookmark)transferable.getTransferData(BasicUtilities.bookmarkFlavour);
                    if (n3 == 1) {
                        sQLDocument.insertString(n2, sQLBookmark.getSQL(), null);
                        sQLDocument.validateStyles();
                        jTextPane.requestFocus();
                    } else {
                        this.owner.setText(sQLBookmark.getSQL());
                        jTextPane.requestFocus();
                    }
                    sQLBookmark.updateLastAcessTime();
                    SystemConfig.getInstance().getBookmarks().setModified();
                } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dropTargetDropEvent.acceptDrop(n3);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (n3 == 1) {
                        sQLDocument.insertString(n2, string, null);
                        sQLDocument.validateStyles();
                        jTextPane.requestFocus();
                    } else {
                        this.owner.setText(string);
                        jTextPane.requestFocus();
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "SQLEditor::drop()");
                dropTargetDropEvent.rejectDrop();
            }
            finally {
                dropTargetDropEvent.dropComplete(true);
            }
        }

        public void receiveMessage(Object object, String string, Object object2) {
            if (string.equals("isql-sql-message")) {
                if (object2 != null) {
                    this.owner.setText(object2.toString());
                }
            } else if (string.equals("isql-service-change")) {
                this.owner.configureWithConnection((DatabaseConnection)object2);
            }
        }

        public void windowWillShow(SuggestionWindow suggestionWindow, InputEvent inputEvent) throws Exception {
            int n2 = inputEvent.getModifiersEx();
            boolean bl2 = (n2 & 0x40) == 64;
            SQLDocument sQLDocument = this.owner.document;
            if (bl2) {
                suggestionWindow.setTitle("Functions");
                suggestionWindow.setModel(sQLDocument.getStylizer().getFunctions());
                suggestionWindow.setRenderer(null);
            } else {
                suggestionWindow.setTitle("Objects");
                suggestionWindow.setModel(this.owner.metaSuggestor);
                suggestionWindow.setRenderer(this.owner.metaRenderer);
            }
        }

        private void doFileDrop(DropTargetDropEvent dropTargetDropEvent, Transferable transferable) throws UnsupportedFlavorException, IOException {
            Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (!(object instanceof List)) {
                BasicUtilities.beep();
                dropTargetDropEvent.rejectDrop();
                return;
            }
            List list = (List)object;
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 instanceof File) {
                    File file = (File)e2;
                    try {
                        this.owner.document.loadFromFile(file);
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.beep();
                        BasicUtilities.HandleException(throwable);
                    }
                } else {
                    BasicUtilities.beep();
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
            }
        }
    }

    private static class OverwriteToggleAction
    extends AbstractAction {
        private SQLDocument doc = null;
        private JLabel lbl = null;

        public OverwriteToggleAction(SQLDocument sQLDocument, JLabel jLabel) {
            this.doc = sQLDocument;
            this.lbl = jLabel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl2 = !this.doc.getOverwriteEnabled();
            this.doc.setOverwriteEnabled(bl2);
            String string = bl2 ? BasicUtilities.getString("Editor_Overwrite_Mode") : BasicUtilities.getString("Editor_Insert_Mode");
            this.lbl.setText(" ".concat(string).concat(" "));
        }
    }
}

