/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.model.DriverPropertyTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.util.BasicUtilities;

public final class DriverPropertyEditor
extends JDialog
implements TableModelListener,
ActionListener {
    private DriverPropertyTableModel mdlProperties = null;
    private ITable tabProperties = new ITable((ActionManager)null);
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private ServiceDefinition service;
    private boolean isModified = false;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static final boolean showDialog(JDialog jDialog, ServiceDefinition serviceDefinition) {
        try {
            DriverPropertyEditor driverPropertyEditor = new DriverPropertyEditor(jDialog, serviceDefinition);
            driverPropertyEditor.pack();
            driverPropertyEditor.setSize(512, 380);
            driverPropertyEditor.setLocationRelativeTo(jDialog);
            driverPropertyEditor.setVisible(true);
            return driverPropertyEditor.isModified;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "DriverPropertyEditor::showDialog(JDialog, ServiceDefinition)");
            return false;
        }
    }

    private DriverPropertyEditor(JDialog jDialog, ServiceDefinition serviceDefinition) {
        super(jDialog, BasicUtilities.getString("XProp_Main_Title", serviceDefinition.getName()), true);
        this.setDefaultCloseOperation(2);
        this.service = serviceDefinition;
        try {
            DatabaseConnection databaseConnection = serviceDefinition.createConnection();
            this.mdlProperties = new DriverPropertyTableModel(databaseConnection.getDriverProperties(new Properties()));
            this.mdlProperties.setProperties(serviceDefinition.getProperties());
            this.tabProperties.setModel(this.mdlProperties);
            this.mdlProperties.addTableModelListener(this);
            Class<?> clazz = array$Ljava$lang$String;
            if (clazz == null) {
                clazz = array$Ljava$lang$String = new String[0].getClass();
            }
            this.tabProperties.setDefaultEditor(clazz, this.mdlProperties.getChoiceEditor());
        }
        catch (SQLException sQLException) {
            String string = BasicUtilities.getString("XProp_SQL_Exception", sQLException.getLocalizedMessage());
            BasicUtilities.showExceptionPopup(this, sQLException, string);
            throw new RuntimeException(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = BasicUtilities.getString("XProp_No_Class");
            BasicUtilities.showExceptionPopup(this, classNotFoundException, string);
            throw new RuntimeException(classNotFoundException);
        }
        catch (Exception exception) {
            String string = BasicUtilities.getString("XProp_General_Exception");
            BasicUtilities.showExceptionPopup(this, exception, string);
            throw new RuntimeException(exception);
        }
        catch (Error error) {
            String string = BasicUtilities.getString("XProp_Error");
            BasicUtilities.showExceptionPopup(this, error, string);
            throw new RuntimeException(error);
        }
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "DriverPropertyEditor::initUI()");
        }
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.btnOK.setText(BasicUtilities.getString("Save"));
        this.btnCancel.setText(BasicUtilities.getString("Cancel"));
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        JPanel jPanel = (JPanel)this.getContentPane();
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.btnOK);
        jToolBar.add(this.btnCancel);
        jPanel.add((Component)new JScrollPane(this.tabProperties), "Center");
        jPanel.add(Box.createVerticalStrut(6), "North");
        jPanel.add(Box.createHorizontalStrut(12), "West");
        jPanel.add(Box.createHorizontalStrut(12), "East");
        jPanel.add((Component)jToolBar, "South");
        BasicUtilities.optimizeTableView(this.tabProperties);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.isModified = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            if (!this.mdlProperties.hasRequiredData()) {
                BasicUtilities.beep();
                return;
            }
            this.service.setProperties(this.mdlProperties.toProperties());
            this.isModified = true;
        } else {
            this.isModified = false;
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

