/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JNumberEditor
extends JTextField
implements ComboBoxEditor,
TableCellEditor {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.getDefault());

    public JNumberEditor() {
        this(0, 10);
    }

    public JNumberEditor(int n2) {
        this(n2, 10);
    }

    public JNumberEditor(int n2, int n3) {
        super(n3);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(n2);
    }

    public int getValue() {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.getText());
        }
        catch (Exception exception) {
            toolkit.beep();
        }
        return n2;
    }

    public void setValue(int n2) {
        try {
            this.setText(this.integerFormatter.format(n2));
        }
        catch (Exception exception) {
            this.setText("0");
        }
    }

    public Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    public Component getEditorComponent() {
        return this;
    }

    public void setItem(Object object) {
        this.setValue(Integer.parseInt(object.toString()));
    }

    public Object getItem() {
        return "" + this.getValue();
    }

    public void addActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        super.removeActionListener(actionListener);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
        return this;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return new Integer(this.getValue());
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        return false;
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            for (int i2 = 0; i2 < cArray2.length; ++i2) {
                if (Character.isDigit(cArray[i2])) {
                    cArray2[n3++] = cArray[i2];
                    continue;
                }
                toolkit.beep();
            }
            super.insertString(n2, new String(cArray2, 0, n3), attributeSet);
        }
    }
}

