/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.isqlviewer.util.BasicUtilities;

public class FileClob
implements Clob {
    public File file;
    public StringBuffer clob = new StringBuffer("");

    public FileClob(File file) throws IOException {
        this.file = file;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        FileInputStream fileInputStream = new FileInputStream(this.file);
        BasicUtilities.copyStream(fileInputStream, byteArrayOutputStream);
        this.clob.append(new String(byteArrayOutputStream.toByteArray()));
        fileInputStream.close();
        fileInputStream = null;
        byteArrayOutputStream.close();
        byteArrayOutputStream = null;
    }

    public long length() {
        return this.file.length();
    }

    public void truncate(long l2) {
        this.clob.setLength((int)l2);
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new BufferedInputStream(new ByteArrayInputStream(this.clob.toString().getBytes()));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            return new BufferedReader(new InputStreamReader(this.getAsciiStream()));
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public String getSubString(long l2, int n2) throws SQLException {
        try {
            return this.clob.substring((int)l2, (int)l2 + n2);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public long position(Clob clob, long l2) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l2);
    }

    public long position(String string, long l2) {
        return this.clob.indexOf(string, (int)l2);
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        try {
            ClobAdapterStream clobAdapterStream = new ClobAdapterStream(null);
            clobAdapterStream.setOffset(l2);
            return new PrintStream(clobAdapterStream, true);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        try {
            ClobAdapterStream clobAdapterStream = new ClobAdapterStream(null);
            clobAdapterStream.setOffset(l2);
            return new PrintWriter(clobAdapterStream, true);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public int setString(long l2, String string, int n2, int n3) {
        this.clob.append(string.toCharArray(), n2, n3);
        return n3;
    }

    public int setString(long l2, String string) {
        return this.setString(l2, string, 0, string.length());
    }

    public static class 1 {
    }

    private class ClobAdapterStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private long offset = -1L;

        private ClobAdapterStream() {
        }

        public void setOffset(long l2) {
            this.offset = l2;
            if (this.offset > (long)FileClob.this.clob.length()) {
                this.offset = -1L;
            }
        }

        public synchronized void write(int n2) {
            char c2 = (char)(n2 &= 0xFF);
            this.buf.append(String.valueOf(c2));
        }

        public synchronized void write(byte[] byArray, int n2, int n3) {
            this.buf.append(new String(byArray, n2, n3));
        }

        public synchronized void write(byte[] byArray) {
            this.buf.append(new String(byArray));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                if (this.buf.length() > 0) {
                    if (this.offset < (long)FileClob.this.clob.length() && this.offset >= 0L) {
                        FileClob.this.clob.replace((int)this.offset, this.buf.length(), this.buf.toString());
                        this.offset += (long)this.buf.length();
                    } else {
                        FileClob.this.clob.append(this.buf.toString());
                        this.offset = FileClob.this.clob.length();
                    }
                }
                this.buf.setLength(0);
            }
        }

        public void close() {
            this.flush();
            this.buf.setLength(0);
        }

        public /* synthetic */ ClobAdapterStream(1 var2_2) {
            this();
        }
    }
}

