/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class BatchRunner
implements Runnable {
    private ArrayList batchCommands = new ArrayList();
    private FileReader batchReader;
    private File batchFile;
    private ProgressListener batchListener;
    private DatabaseConnection dbc;
    private String batchID = null;
    private boolean useTrans = true;
    private boolean overrideBatch = false;
    private NumberFormat nf = NumberFormat.getNumberInstance();

    public BatchRunner(File file, ProgressListener progressListener) {
        this.batchID = Long.toHexString(System.currentTimeMillis()).toUpperCase();
        this.setBatchListener(progressListener);
        this.batchFile = file;
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(32);
        this.nf.setMinimumFractionDigits(0);
        this.nf.setParseIntegerOnly(false);
    }

    public Object clone() {
        try {
            BatchRunner batchRunner = new BatchRunner(this.batchFile, this.batchListener);
            batchRunner.setStatements(this.batchCommands);
            batchRunner.setBatchParams(this.useTrans, this.overrideBatch);
            batchRunner.setConnection(this.dbc);
            batchRunner.batchID = new String(this.batchID);
            return batchRunner;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BatchRunner) {
            BatchRunner batchRunner = (BatchRunner)object;
            return batchRunner.getBatchID().equalsIgnoreCase(this.batchID);
        }
        return false;
    }

    public File getBatchFile() {
        return this.batchFile;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public void setConnection(DatabaseConnection databaseConnection) {
        if (databaseConnection != null) {
            this.dbc = databaseConnection;
        }
    }

    public DatabaseConnection getConnection() {
        return this.dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStatements(UserPreferences userPreferences) throws IOException {
        StreamTokenizer streamTokenizer = this.configureParser(userPreferences);
        StringBuffer stringBuffer = new StringBuffer("");
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            char c2 = '\u0000';
            boolean bl2 = userPreferences.getInt("batch.seperator-style") == 1;
            char c3 = userPreferences.get("batch.seperator-char").charAt(0);
            char c4 = '\u0000';
            switch (userPreferences.getInt("batch.literal-style")) {
                case 1: {
                    break;
                }
                case 2: {
                    c4 = '\'';
                    break;
                }
                case 3: {
                    c4 = userPreferences.get("batch.literal-char").charAt(0);
                    break;
                }
                default: {
                    c4 = '\"';
                }
            }
            while ((c2 = streamTokenizer.nextToken()) != '\uffffffff') {
                char c5 = c2;
                if (c2 == '\n') {
                    if (bl2) {
                        this.batchCommands.add(stringBuffer.toString().trim());
                        stringBuffer.setLength(0);
                        continue;
                    }
                    stringBuffer.append('\n');
                    continue;
                }
                if (c2 == '\ufffffffd') {
                    stringBuffer.append(streamTokenizer.sval.trim());
                    continue;
                }
                if (c2 == '\ufffffffe') {
                    stringBuffer.append(this.nf.format(streamTokenizer.nval));
                    continue;
                }
                if (c2 == c3) {
                    if (!bl2) {
                        this.batchCommands.add(stringBuffer.toString().trim());
                        stringBuffer.setLength(0);
                        continue;
                    }
                    stringBuffer.append(c5);
                    continue;
                }
                if (c2 == c4 && c4 != '\u0000') {
                    stringBuffer.append(c4);
                    stringBuffer.append(streamTokenizer.sval);
                    stringBuffer.append(c4);
                    continue;
                }
                if (!Character.isDefined(c5)) continue;
                stringBuffer.append(c5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatements(Collection collection) {
        ArrayList arrayList = this.batchCommands;
        synchronized (arrayList) {
            this.batchCommands.clear();
        }
        if (collection == null) {
            return;
        }
        arrayList = this.batchCommands;
        synchronized (arrayList) {
            this.batchCommands.addAll(collection);
        }
    }

    public Collection getStatements() {
        return this.batchCommands;
    }

    public void setBatchParams(boolean bl2, boolean bl3) {
        this.useTrans = bl2;
        this.overrideBatch = bl3;
    }

    public void run() {
        try {
            this.executeBatch();
        }
        catch (Throwable throwable) {
            String string = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Unexpected_Batch_Error");
            BasicUtilities.HandleException(throwable, string, true);
        }
    }

    public void setBatchListener(ProgressListener progressListener) {
        this.batchListener = progressListener;
    }

    private void doNotify(ProgressEvent progressEvent) {
        if (this.batchListener != null) {
            this.batchListener.progressUpdated(progressEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch() {
        ProgressEvent progressEvent = new ProgressEvent(this, 0, this.batchCommands.size());
        if (this.batchCommands.isEmpty() || this.dbc == null) {
            progressEvent.setProgress(progressEvent.getMaximum());
            this.doNotify(progressEvent);
            return;
        }
        try {
            this.dbc.initialize();
            boolean bl2 = this.dbc.getAutoCommit();
            this.dbc.executeBatch(this.batchCommands, this.overrideBatch, this.useTrans, new ActionForwarder(null));
            this.dbc.setAutoCommit(bl2);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, null, this.dbc.getDebugOn());
        }
        finally {
            progressEvent.setProgress(progressEvent.getMaximum());
            this.doNotify(progressEvent);
        }
        System.runFinalization();
    }

    private StreamTokenizer configureParser(UserPreferences userPreferences) throws IOException {
        this.batchReader = new FileReader(this.batchFile);
        StreamTokenizer streamTokenizer = new StreamTokenizer(this.batchReader);
        streamTokenizer.lowerCaseMode(userPreferences.getBoolean("batch.lowercase-enable"));
        streamTokenizer.ordinaryChar(32);
        switch (userPreferences.getInt("batch.literal-style")) {
            case 1: {
                break;
            }
            case 2: {
                streamTokenizer.quoteChar(39);
                break;
            }
            case 3: {
                streamTokenizer.quoteChar(userPreferences.get("batch.literal-char").charAt(0));
                break;
            }
            default: {
                streamTokenizer.quoteChar(34);
            }
        }
        switch (userPreferences.getInt("batch.comment-style")) {
            case 1: {
                break;
            }
            case 2: {
                streamTokenizer.slashSlashComments(true);
                break;
            }
            case 3: {
                streamTokenizer.slashStarComments(true);
                break;
            }
            default: {
                streamTokenizer.commentChar(userPreferences.get("batch.comment-char").charAt(0));
            }
        }
        switch (userPreferences.getInt("batch.seperator-style")) {
            case 1: {
                streamTokenizer.eolIsSignificant(true);
                break;
            }
            default: {
                char c2 = userPreferences.get("batch.seperator-char").charAt(0);
                streamTokenizer.eolIsSignificant(false);
                streamTokenizer.ordinaryChar(c2);
            }
        }
        return streamTokenizer;
    }

    public static class 1 {
    }

    private class ActionForwarder
    implements ProgressListener {
        private ActionForwarder() {
        }

        public void progressUpdated(ProgressEvent progressEvent) {
            if (BatchRunner.this.batchListener != null) {
                ProgressEvent progressEvent2 = new ProgressEvent(BatchRunner.this, progressEvent.getProgress(), progressEvent.getMaximum());
                progressEvent2.setNote(progressEvent2.getNote());
                BatchRunner.this.batchListener.progressUpdated(progressEvent2);
            }
        }

        public /* synthetic */ ActionForwarder(1 var2_2) {
            this();
        }
    }
}

