/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.renderers;

import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.renderers.AbstractDataRenderer;
import org.isqlviewer.util.BasicUtilities;

public class TextRenderer
extends AbstractDataRenderer {
    public String getName() {
        return BasicUtilities.getString("TxtViewer_Name");
    }

    public String getDescription() {
        return BasicUtilities.getString("TxtViewer_Desc");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Html16");
    }

    public boolean isPrintable(JComponent jComponent) {
        return false;
    }

    public JComponent getDataRenderer() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setDragEnabled(true);
        jEditorPane.setEditable(false);
        jEditorPane.setFont(SystemConfig.getInstance().getPreferences().getFont("editor.font"));
        BasicUtilities.localizeTextComponent(jEditorPane, null);
        return jEditorPane;
    }

    public Runnable renderContent(Object object, JComponent jComponent) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        return new TextRendererProcess((JEditorPane)jComponent, object);
    }

    public InputStream getBinaryStream(JComponent jComponent) {
        JEditorPane jEditorPane = (JEditorPane)jComponent;
        return new ByteArrayInputStream(jEditorPane.getText().getBytes());
    }

    private static class TextRendererProcess
    implements Runnable {
        private JEditorPane view = null;
        private Object data = null;

        public TextRendererProcess(JEditorPane jEditorPane, Object object) {
            this.view = jEditorPane;
            this.data = object;
        }

        public void run() {
            if (this.data == null || this.view == null) {
                return;
            }
            try {
                if (this.data instanceof String) {
                    String string = (String)this.data;
                    this.view.setText(string);
                } else if (this.data instanceof Clob) {
                    Clob clob = (Clob)this.data;
                    long l2 = clob.length();
                    String string = null;
                    if (l2 > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Clob_TooLarge"));
                        string = clob.getSubString(0L, 0x7FFFFFFE);
                    } else if (l2 < 0L) {
                        System.out.println(BasicUtilities.getString("Clob_LengthError"));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1);
                        InputStream inputStream = clob.getAsciiStream();
                        BasicUtilities.copyStream(inputStream, byteArrayOutputStream);
                        string = byteArrayOutputStream.toString();
                        inputStream.close();
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.close();
                    } else {
                        string = clob.getSubString(0L, (int)l2);
                    }
                    this.view.setText(string);
                } else if (this.data instanceof Blob) {
                    Blob blob = (Blob)this.data;
                    String string = null;
                    long l3 = blob.length();
                    if (l3 > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Blob_TooLarge"));
                        string = new String(blob.getBytes(0L, 0x7FFFFFFE));
                    } else if (l3 < 0L) {
                        System.out.println(BasicUtilities.getString("Blob_LengthError"));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1);
                        InputStream inputStream = blob.getBinaryStream();
                        BasicUtilities.copyStream(inputStream, byteArrayOutputStream);
                        string = new String(byteArrayOutputStream.toByteArray());
                        inputStream.close();
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.close();
                    } else {
                        string = new String(blob.getBytes(0L, (int)l3));
                    }
                    this.view.setText(string);
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
                    XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
                    xMLEncoder.writeObject(this.data);
                    xMLEncoder.flush();
                    byteArrayOutputStream.flush();
                    this.view.setText(new String(byteArrayOutputStream.toByteArray()));
                    xMLEncoder.close();
                    byteArrayOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "TextRenderer::run()");
            }
            this.updateContentType();
        }

        private void updateContentType() {
            String string = this.view.getText();
            if (string.regionMatches(true, 0, "<html>", 0, 6)) {
                this.view.setContentType("text/html");
            } else {
                this.view.setContentType("text/plain");
            }
        }
    }
}

