/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ResultSetTableModel
extends EnhancedTableModel {
    private Random seed = new Random(System.currentTimeMillis());
    private boolean isShowingMetaData = false;
    private boolean allowMetaCopy = true;
    private EnhancedTableModel metaData = new EnhancedTableModel();
    private ResultSet rs = null;
    private ArrayList primaryKeys = null;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Array;

    public ResultSetTableModel(ResultSet resultSet, ResultSetViewer resultSetViewer, boolean bl2) {
        if (resultSet != null) {
            this.setData(resultSet, resultSetViewer);
        }
        this.allowMetaCopy = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showMetaData() {
        if (!this.isShowingMetaData) {
            ResultSetTableModel resultSetTableModel = this;
            synchronized (resultSetTableModel) {
                this.isShowingMetaData = true;
            }
            this.fireTableStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showResultSetData() {
        if (this.isShowingMetaData) {
            ResultSetTableModel resultSetTableModel = this;
            synchronized (resultSetTableModel) {
                this.isShowingMetaData = false;
            }
            this.fireTableStructureChanged();
        }
    }

    public boolean isShowingMetadata() {
        return this.isShowingMetaData;
    }

    public Object getResultSetValue(int n2, int n3) {
        return super.getValueAt(n2, n3);
    }

    public Object getMetaDataValue(int n2, int n3) {
        return this.metaData.getValueAt(n2, n3);
    }

    public String getMetaColumnName(int n2) {
        return this.metaData.getColumnName(n2);
    }

    public int getMetaColumnCount() {
        return this.metaData.getColumnCount();
    }

    public Class getMetaColumnClass(int n2) {
        return this.metaData.getColumnClass(n2);
    }

    public int getMetaRowCount() {
        return this.metaData.getRowCount();
    }

    public String getResultSetColumnName(int n2) {
        return super.getColumnName(n2);
    }

    public int getResultSetColumnCount() {
        return super.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setData(ResultSet resultSet, ResultSetViewer resultSetViewer) {
        Object object;
        this.clearAllData();
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        this.rs = null;
        int n2 = -1;
        try {
            n2 = resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        if (JDBCUtilities.isUpdatable(resultSet)) {
            this.rs = resultSet;
        }
        if (this.allowMetaCopy) {
            this.copyMetaDataStore(resultSetMetaData);
        }
        String[] stringArray = new String[n2];
        for (int i2 = 1; i2 <= stringArray.length; ++i2) {
            try {
                stringArray[i2 - 1] = resultSetMetaData.getColumnLabel(i2);
                continue;
            }
            catch (Throwable throwable) {
                try {
                    stringArray[i2 - 1] = resultSetMetaData.getColumnName(i2);
                    continue;
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        }
        this.setColumns(stringArray);
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        boolean bl2 = userPreferences.getBoolean("general.ascii2native-enabled");
        int n3 = 0;
        try {
            object = resultSet.getStatement();
            if (object != null) {
                n3 = object.getMaxRows();
            }
        }
        catch (Throwable throwable) {
            ResultSetTableModel.traceError(throwable, "ResultSet::getStatement()");
        }
        try {
            if (!resultSet.isBeforeFirst()) {
                if (resultSet.getType() != 1003) {
                    resultSet.beforeFirst();
                } else {
                    object = BasicUtilities.getString("JDBC_Cursor_Off", Integer.toString(resultSet.getRow()));
                    System.err.println((String)object);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        block22: while (true) {
            try {
                while (resultSet.next()) {
                    if (n3 >= 1 && this.getRowCount() >= n3) {
                        object = BasicUtilities.getString("JDBC_MaxRows_Warning", Integer.toString(n3));
                        System.err.println((String)object);
                        break block22;
                    }
                    object = this.extractCurrentRow(resultSet, bl2);
                    Iterable iterable = this.dataStore;
                    synchronized (iterable) {
                        this.dataStore.add(object);
                    }
                    if (resultSetViewer != null) {
                        try {
                            iterable = resultSet.getWarnings();
                            if (iterable != null) {
                                resultSetViewer.recieveResultsetWarnings(resultSet, (SQLWarning)iterable);
                            }
                        }
                        catch (Throwable throwable) {
                            ResultSetTableModel.traceError(throwable, "ResultSet::getWarnings()");
                        }
                    }
                    try {
                        resultSet.clearWarnings();
                        continue block22;
                    }
                    catch (Throwable throwable) {
                        ResultSetTableModel.traceError(throwable, "ResultSet::clearWarnings()");
                    }
                }
                break;
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPrimaryKeys(Collection collection) {
        ArrayList arrayList = this.primaryKeys = this.primaryKeys == null ? new ArrayList() : this.primaryKeys;
        if (collection == null) {
            this.primaryKeys.clear();
            this.primaryKeys = null;
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ArrayList arrayList2 = this.primaryKeys;
                synchronized (arrayList2) {
                    this.primaryKeys.add(string.toUpperCase());
                }
            }
        }
    }

    public boolean isPrimaryKey(String string) {
        if (this.primaryKeys != null) {
            return this.primaryKeys.contains(string.toUpperCase());
        }
        return false;
    }

    public ResultSet toResultSet() {
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEditing() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.rs = null;
            }
        }
    }

    public EnhancedTableModel getMetadataAsModel() {
        return (EnhancedTableModel)this.metaData.clone();
    }

    public int applyFilter(String string) {
        if (this.isShowingMetaData) {
            int n2 = this.metaData.applyFilter(string);
            this.fireTableDataChanged();
            return n2;
        }
        return super.applyFilter(string);
    }

    public void clearFilter() {
        if (this.isShowingMetaData) {
            this.metaData.clearFilter();
            this.fireTableDataChanged();
        } else {
            super.clearFilter();
        }
    }

    public void refreshRow(int n2) throws SQLException {
        if (this.rs != null) {
            this.rs.cancelRowUpdates();
            UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
            boolean bl2 = userPreferences.getBoolean("general.ascii2native-enabled");
            if (this.rs.absolute(n2 + 1)) {
                this.rs.refreshRow();
                ArrayList arrayList = this.extractCurrentRow(this.rs, bl2);
                this.dataStore.set(n2, arrayList);
                this.fireTableRowsUpdated(n2, n2);
            } else {
                throw new SQLException("ResultSet::absolute(" + (n2 + 1) + ")");
            }
        }
    }

    public void createInsertRow() throws SQLException {
        if (this.rs != null) {
            int n2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.rs.moveToInsertRow();
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            block18: for (n2 = 1; n2 <= n3; ++n2) {
                int n4 = resultSetMetaData.getColumnType(n2);
                if (resultSetMetaData.isAutoIncrement(n2)) {
                    arrayList.add(null);
                    continue;
                }
                if (resultSetMetaData.isNullable(n2) == 1) {
                    this.rs.updateNull(n2);
                    arrayList.add(null);
                    continue;
                }
                switch (n4) {
                    case -1: 
                    case 1: 
                    case 12: {
                        arrayList.add("");
                        this.rs.updateString(n2, "");
                        continue block18;
                    }
                    case 91: {
                        Date date = new Date(System.currentTimeMillis());
                        arrayList.add(date);
                        this.rs.updateDate(n2, date);
                        continue block18;
                    }
                    case 92: {
                        Time time = new Time(System.currentTimeMillis());
                        arrayList.add(time);
                        this.rs.updateTime(n2, time);
                        continue block18;
                    }
                    case 93: {
                        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                        arrayList.add(timestamp);
                        this.rs.updateTimestamp(n2, timestamp);
                        continue block18;
                    }
                    case -6: {
                        Byte by2 = new Byte((byte)this.seed.nextInt());
                        arrayList.add(by2);
                        this.rs.updateByte(n2, (byte)by2);
                        continue block18;
                    }
                    case 5: {
                        Short s2 = new Short((short)this.seed.nextInt());
                        arrayList.add(s2);
                        this.rs.updateShort(n2, (short)s2);
                        continue block18;
                    }
                    case 4: {
                        Integer n5 = new Integer(this.seed.nextInt());
                        arrayList.add(n5);
                        this.rs.updateInt(n2, (int)n5);
                        continue block18;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Double d2 = new Double(this.seed.nextDouble());
                        arrayList.add(d2);
                        this.rs.updateDouble(n2, (double)d2);
                        continue block18;
                    }
                    case -5: {
                        Long l2 = new Long(this.seed.nextLong());
                        arrayList.add(l2);
                        this.rs.updateLong(n2, (long)l2);
                        continue block18;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimal = new BigDecimal(this.seed.nextDouble());
                        arrayList.add(bigDecimal);
                        this.rs.updateBigDecimal(n2, bigDecimal);
                        continue block18;
                    }
                    case -7: 
                    case 16: {
                        this.rs.updateBoolean(n2, (boolean)Boolean.FALSE);
                        continue block18;
                    }
                    case -4: 
                    case -3: {
                        byte[] byArray = new byte[]{};
                        arrayList.add(byArray);
                        this.rs.updateBytes(n2, byArray);
                        continue block18;
                    }
                    case 2004: {
                        ByteArrayBlob byteArrayBlob = new ByteArrayBlob(new byte[0]);
                        arrayList.add(byteArrayBlob);
                        this.rs.updateBlob(n2, (Blob)byteArrayBlob);
                        continue block18;
                    }
                    case 2005: {
                        try {
                            ByteArrayClob byteArrayClob = new ByteArrayClob("");
                            arrayList.add(byteArrayClob);
                            this.rs.updateClob(n2, (Clob)byteArrayClob);
                            continue block18;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    default: {
                        this.rs.updateObject(n2, (Object)"");
                    }
                }
            }
            this.rs.insertRow();
            n2 = this.getRowCount();
            this.addRow(arrayList);
            this.fireTableRowsInserted(n2, n2);
            this.rs.beforeFirst();
        }
    }

    public boolean isCellEditable(int n2, int n3) {
        if (!this.isShowingMetaData) {
            try {
                if (this.rs == null) {
                    return false;
                }
                ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
                int n4 = this.rs.getConcurrency();
                boolean bl2 = !resultSetMetaData.isReadOnly(n3 + 1) && !resultSetMetaData.isAutoIncrement(n3 + 1);
                return bl2 && n4 == 1008;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return false;
    }

    public void clearAll() {
        this.clearAllData();
        this.metaData.clearAllData();
        this.fireTableStructureChanged();
    }

    public void clear() {
        this.clearData();
        this.metaData.clearData();
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int n2) {
        if (this.isShowingMetaData) {
            return this.getMetaColumnClass(n2);
        }
        return super.getColumnClass(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeRow(int n2) {
        ArrayList arrayList = this.isShowingMetadata() ? this.metaData.dataStore : this.dataStore;
        try {
            if (this.rs != null && !this.isShowingMetadata()) {
                this.rs.absolute(n2 + 1);
                this.rs.deleteRow();
                this.rs.beforeFirst();
            }
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                arrayList.remove(n2);
            }
            this.fireTableRowsDeleted(n2, n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeColumn(int n2) {
        ArrayList arrayList = this.isShowingMetadata() ? this.metaData.dataStore : this.dataStore;
        Iterator iterator = arrayList.iterator();
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            try {
                if (this.isShowingMetaData) {
                    this.metaData.columns.remove(n2);
                } else {
                    this.columns.remove(n2);
                }
            }
            catch (Throwable throwable) {
                return;
            }
            while (iterator.hasNext()) {
                try {
                    ArrayList arrayList3 = (ArrayList)iterator.next();
                    arrayList3.remove(n2);
                }
                catch (Throwable throwable) {}
            }
        }
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        if (this.isShowingMetaData) {
            return this.getMetaColumnCount();
        }
        return this.getResultSetColumnCount();
    }

    public String getColumnName(int n2) {
        if (this.isShowingMetaData) {
            return this.getMetaColumnName(n2);
        }
        return this.getResultSetColumnName(n2);
    }

    public int getRowCount() {
        if (this.isShowingMetaData) {
            return this.metaData.getRowCount();
        }
        return super.getRowCount();
    }

    public Object getValueAt(int n2, int n3) {
        if (this.isShowingMetaData) {
            return this.getMetaDataValue(n2, n3);
        }
        return this.getResultSetValue(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n2, int n3) {
        if (!this.isShowingMetaData && this.rs != null) {
            block40: {
                if (!this.isCellEditable(n2, n3)) {
                    return;
                }
                int n4 = n3 + 1;
                int n5 = n2 + 1 + this.pageOffset * this.pageSize;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("");
                try {
                    int n6 = this.rs.getMetaData().getColumnType(n4);
                    if (!this.rs.absolute(n5)) break block40;
                    if (object == null) {
                        this.rs.updateNull(n4);
                    } else {
                        Object object2;
                        try {
                            object2 = SystemConfig.getInstance().getFormatForSQLType(n6);
                            if (object2 != null) {
                                simpleDateFormat.applyPattern((String)object2);
                                object = JDBCUtilities.convertValue(object, n6, simpleDateFormat);
                            } else {
                                object = JDBCUtilities.convertValue(object, n6, null);
                            }
                        }
                        catch (ParseException parseException) {
                            throw new IllegalArgumentException(parseException.getMessage());
                        }
                        object2 = JDBCUtilities.convertValue(object, n6, simpleDateFormat);
                        switch (n6) {
                            case 1: 
                            case 12: {
                                if (SystemConfig.getInstance().getPreferences().getBoolean("general.ascii2native-enabled")) {
                                    this.rs.updateString(n4, StringUtilities.encode((String)object, false, false));
                                    break;
                                }
                                this.rs.updateString(n4, (String)object2);
                                break;
                            }
                            case -6: {
                                this.rs.updateByte(n4, (byte)((Byte)object2));
                                break;
                            }
                            case 5: {
                                this.rs.updateShort(n4, (short)((Short)object2));
                                break;
                            }
                            case 4: {
                                this.rs.updateInt(n4, (int)((Integer)object2));
                                break;
                            }
                            case -5: {
                                this.rs.updateLong(n4, (long)((Long)object2));
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.rs.updateDouble(n4, (double)((Double)object2));
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.rs.updateBigDecimal(n4, (BigDecimal)object2);
                                break;
                            }
                            case -7: 
                            case 16: {
                                this.rs.updateBoolean(n4, (boolean)((Boolean)object2));
                                break;
                            }
                            case -4: 
                            case -3: {
                                ByteArrayBlob byteArrayBlob = (ByteArrayBlob)object2;
                                this.rs.updateBinaryStream(n4, byteArrayBlob.getBinaryStream(), (int)byteArrayBlob.length());
                                break;
                            }
                            case -1: {
                                ByteArrayClob byteArrayClob = (ByteArrayClob)object2;
                                this.rs.updateCharacterStream(n4, byteArrayClob.getCharacterStream(), (int)byteArrayClob.length());
                                break;
                            }
                            case 2004: {
                                this.rs.updateBlob(n4, (Blob)object2);
                                break;
                            }
                            case 2005: {
                                this.rs.updateClob(n4, (Clob)object2);
                                break;
                            }
                            case 91: {
                                this.rs.updateDate(n4, (Date)object2);
                                break;
                            }
                            case 92: {
                                this.rs.updateTime(n4, (Time)object2);
                                break;
                            }
                            case 93: {
                                this.rs.updateTimestamp(n4, (Timestamp)object2);
                                break;
                            }
                            default: {
                                this.rs.updateObject(n4, object);
                            }
                        }
                    }
                    this.rs.updateRow();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (SQLException sQLException) {
                    String[] stringArray = new String[]{sQLException.getMessage() != null ? sQLException.getMessage().trim() : "null", Integer.toString(sQLException.getErrorCode()), sQLException.getSQLState() == null ? "null" : sQLException.getSQLState()};
                    throw new IllegalArgumentException(BasicUtilities.getString("SQL_Exception", stringArray));
                }
                catch (Throwable throwable) {
                    String string = "ResultSetTableModel::setValue(" + object + ", " + n2 + "," + n3 + ")";
                    BasicUtilities.HandleException(throwable, string);
                }
                finally {
                    try {
                        this.rs.beforeFirst();
                    }
                    catch (Throwable throwable) {}
                }
            }
            super.setValueAt(object, n2, n3);
        } else {
            super.setValueAt(object, n2, n3);
        }
    }

    public boolean canSort(int n2, boolean bl2) {
        if (this.isShowingMetaData) {
            return this.metaData.canSort(n2, bl2);
        }
        return super.canSort(n2, bl2) && this.rs == null;
    }

    public void sort(int n2, boolean bl2) {
        if (this.isShowingMetadata()) {
            this.metaData.sort(n2, bl2);
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        } else {
            super.sort(n2, bl2);
        }
    }

    public int getIndexOfColumnName(String string) {
        if (this.isShowingMetadata()) {
            return this.metaData.getIndexOfColumnName(string);
        }
        return super.getIndexOfColumnName(string);
    }

    public boolean isUnique(Object object, int n2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.dataStore.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList2 = (ArrayList)iterator.next();
            arrayList.add(arrayList2.get(n2));
        }
        boolean bl2 = arrayList.contains(object);
        arrayList.clear();
        arrayList = null;
        return bl2;
    }

    public static boolean isFirst(ResultSet resultSet) {
        try {
            return resultSet.isFirst();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void traceError(Throwable throwable, String string) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            BasicUtilities.HandleException(throwable, string, true, printWriter);
        }
    }

    public ArrayList extractCurrentRow(ResultSet resultSet, boolean bl2) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (int i2 = 1; i2 <= n2; ++i2) {
            Object object;
            String[] stringArray;
            int n3 = -1;
            try {
                n3 = resultSetMetaData.getColumnType(i2);
            }
            catch (Throwable throwable) {
                n3 = 12;
            }
            try {
                switch (n3) {
                    case 91: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n4 = arrayList.size();
                            Class<?> clazz = class$java$sql$Date;
                            if (clazz == null) {
                                clazz = new Date[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n4, clazz);
                        }
                        arrayList.add(resultSet.getDate(i2));
                        break;
                    }
                    case 93: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n5 = arrayList.size();
                            Class<?> clazz = class$java$sql$Timestamp;
                            if (clazz == null) {
                                clazz = new Timestamp[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n5, clazz);
                        }
                        arrayList.add(resultSet.getTimestamp(i2));
                        break;
                    }
                    case 92: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n6 = arrayList.size();
                            Class<?> clazz = class$java$sql$Time;
                            if (clazz == null) {
                                clazz = new Time[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n6, clazz);
                        }
                        arrayList.add(resultSet.getTime(i2));
                        break;
                    }
                    case -6: {
                        arrayList.add(new Byte(resultSet.getByte(i2)));
                        break;
                    }
                    case 5: {
                        arrayList.add(new Short(resultSet.getShort(i2)));
                        break;
                    }
                    case 4: {
                        arrayList.add(new Integer(resultSet.getInt(i2)));
                        break;
                    }
                    case 2: 
                    case 3: {
                        arrayList.add(resultSet.getBigDecimal(i2));
                        break;
                    }
                    case 7: {
                        arrayList.add(new Float(resultSet.getFloat(i2)));
                        break;
                    }
                    case 6: 
                    case 8: {
                        arrayList.add(new Double(resultSet.getDouble(i2)));
                        break;
                    }
                    case -5: {
                        arrayList.add(new Long(resultSet.getLong(i2)));
                        break;
                    }
                    case -7: 
                    case 16: {
                        arrayList.add(new Boolean(resultSet.getBoolean(i2)));
                        break;
                    }
                    case -4: {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        stringArray = resultSet.getBinaryStream(i2);
                        BasicUtilities.copyStream((InputStream)stringArray, byteArrayOutputStream);
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n7 = arrayList.size();
                            Class<?> clazz = class$java$sql$Blob;
                            if (clazz == null) {
                                clazz = new Blob[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n7, clazz);
                        }
                        arrayList.add(new ByteArrayBlob(byteArrayOutputStream.toByteArray()));
                        break;
                    }
                    case -3: 
                    case -2: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n8 = arrayList.size();
                            Class<?> clazz = class$java$sql$Blob;
                            if (clazz == null) {
                                clazz = new Blob[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n8, clazz);
                        }
                        arrayList.add(new ByteArrayBlob(resultSet.getBytes(i2)));
                        break;
                    }
                    case -1: {
                        try {
                            object = resultSet.getCharacterStream(i2);
                            if (ResultSetTableModel.isFirst(resultSet)) {
                                int n9 = arrayList.size();
                                Class<?> clazz = class$java$sql$Clob;
                                if (clazz == null) {
                                    clazz = new Clob[0].getClass().getComponentType();
                                }
                                this.setClassforColumn(n9, clazz);
                            }
                            arrayList.add(new ByteArrayClob((Reader)object));
                            break;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    case 1: 
                    case 12: {
                        object = resultSet.getString(i2);
                        if (bl2 && object != null) {
                            object = StringUtilities.decode((String)object);
                        }
                        arrayList.add(object);
                        break;
                    }
                    case 2004: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n10 = arrayList.size();
                            Class<?> clazz = class$java$sql$Blob;
                            if (clazz == null) {
                                clazz = new Blob[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n10, clazz);
                        }
                        arrayList.add(resultSet.getBlob(i2));
                        break;
                    }
                    case 2005: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n11 = arrayList.size();
                            Class<?> clazz = class$java$sql$Clob;
                            if (clazz == null) {
                                clazz = new Clob[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n11, clazz);
                        }
                        arrayList.add(resultSet.getClob(i2));
                        break;
                    }
                    case 2006: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n12 = arrayList.size();
                            Class<?> clazz = class$java$sql$Ref;
                            if (clazz == null) {
                                clazz = new Ref[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n12, clazz);
                        }
                        arrayList.add(resultSet.getRef(i2));
                        break;
                    }
                    case 2003: {
                        if (ResultSetTableModel.isFirst(resultSet)) {
                            int n13 = arrayList.size();
                            Class<?> clazz = class$java$sql$Array;
                            if (clazz == null) {
                                clazz = new Array[0].getClass().getComponentType();
                            }
                            this.setClassforColumn(n13, clazz);
                        }
                        arrayList.add(resultSet.getArray(i2));
                        break;
                    }
                    default: {
                        Object object2 = resultSet.getObject(i2);
                        if (object2 != null && (object2.getClass().isArray() || object2 instanceof Number || object2 instanceof Collection || object2 instanceof Map)) {
                            arrayList.add(object2);
                            if (ResultSetTableModel.isFirst(resultSet) && object2 != null) {
                                this.setClassforColumn(arrayList.size(), object2.getClass());
                            }
                        } else {
                            arrayList.add("" + object2);
                            if (ResultSetTableModel.isFirst(resultSet) && object2 != null) {
                                int n14 = arrayList.size();
                                Class<?> clazz = class$java$lang$String;
                                if (clazz == null) {
                                    clazz = new String[0].getClass().getComponentType();
                                }
                                this.setClassforColumn(n14, clazz);
                            }
                        }
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                stringArray = new String[]{this.getColumnName(i2), JDBCUtilities.getTypeforValue(n3), sQLException.getMessage()};
                object = BasicUtilities.getString("Resultset_Pull_Error", stringArray);
                System.err.println((String)object);
                throw sQLException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            try {
                if (!resultSet.wasNull()) continue;
                arrayList.set(i2 - 1, null);
                continue;
            }
            catch (Throwable throwable) {
                ResultSetTableModel.traceError(throwable, "ResultSet::wasNull()");
            }
        }
        return arrayList;
    }

    private void copyMetaDataStore(ResultSetMetaData resultSetMetaData) {
        if (resultSetMetaData != null) {
            try {
                Object object;
                Object object2;
                int n2;
                this.metaData.clearAllData();
                int n3 = resultSetMetaData.getColumnCount();
                Class<?> clazz = resultSetMetaData.getClass();
                Method[] methodArray = clazz.getMethods();
                Class[] classArray = new Class[]{Integer.TYPE};
                Object[] objectArray = new Object[1];
                for (n2 = 0; n2 < methodArray.length; ++n2) {
                    object2 = methodArray[n2].getReturnType();
                    String string = methodArray[n2].getName();
                    if (!string.startsWith("get") && !string.startsWith("is") || !((Class)object2).isPrimitive() && !((Class)object2).getName().endsWith("String") || methodArray[n2].getParameterTypes().length != 1 || methodArray[n2].getParameterTypes()[0] != classArray[0]) continue;
                    object = BasicUtilities.getClassForPrimative((Class)object2);
                    Class<?> clazz2 = class$java$lang$Void;
                    if (clazz2 == null) {
                        clazz2 = new Void[0].getClass().getComponentType();
                    }
                    if (object == clazz2 || object == null) continue;
                    this.metaData.columns.add(string);
                }
                for (n2 = 1; n2 <= n3; ++n2) {
                    objectArray[0] = new Integer(n2);
                    object2 = new ArrayList(n3);
                    for (int i2 = 0; i2 < this.metaData.getColumnCount(); ++i2) {
                        try {
                            object = this.metaData.getColumnName(i2);
                            Method method = clazz.getMethod((String)object, classArray);
                            ((ArrayList)object2).add(method.invoke((Object)resultSetMetaData, objectArray));
                            continue;
                        }
                        catch (Throwable throwable) {
                            ((ArrayList)object2).add(BasicUtilities.getString("Not_Supported"));
                        }
                    }
                    this.metaData.addRow((ArrayList)object2);
                }
                for (n2 = 0; n2 < this.metaData.getColumnCount(); ++n2) {
                    object2 = this.metaData.getColumnName(n2);
                    if (!((String)object2).startsWith("get")) continue;
                    object2 = ((String)object2).substring(3);
                    this.metaData.columns.set(n2, object2);
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, BasicUtilities.getString("ResultsetMetaData_Error"), true);
            }
        }
    }

    public int getTrueRowCount() {
        if (this.isShowingMetaData) {
            return this.metaData.getTrueRowCount();
        }
        return super.getTrueRowCount();
    }
}

