/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class MetadataTreeModel
extends DefaultTreeModel {
    private static final DefaultMutableTreeNode UNCACHED_NODE = new DefaultMutableTreeNode("UNCACHED", false);
    private DatabaseMetaData metadata = null;
    private Vector lstTableTypes = null;
    private String currentCatlog = null;
    private String currentSchema = null;
    private MutableTreeNode nodeUDTS = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_User_Data_Types"), false);
    private MutableTreeNode nodeTypes = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Data_Types"), false);
    private MutableTreeNode nodeObjects = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Table_Types"), false);
    private MutableTreeNode nodeCatalog = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Catalogs"), false);
    private MutableTreeNode nodeSchema = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Schemas"), false);
    private MutableTreeNode nodeGeneral = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_General_Info"), false);
    private final DefaultMutableTreeNode nodeRoot = new DefaultMutableTreeNode("", true);
    private boolean procEnabled = true;
    private boolean metaEnabled = true;
    private boolean tabsEnabled = true;

    public String getCurrentCatlog() {
        return this.currentCatlog;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public MetadataTreeModel(DatabaseConnection databaseConnection) {
        super(new DefaultMutableTreeNode("", true));
        this.setRoot(this.nodeRoot);
        if (databaseConnection != null) {
            this.updateConnection(databaseConnection);
        }
    }

    public void updateConnection(DatabaseConnection databaseConnection) {
        if (databaseConnection == null && this.metadata == null) {
            return;
        }
        if (this.nodeRoot != null) {
            this.nodeRoot.removeAllChildren();
        }
        if (databaseConnection != null) {
            this.metadata = databaseConnection.getDatabaseInformation();
            this.nodeRoot.setUserObject(databaseConnection.getConnectionName());
            this.nodeRoot.setAllowsChildren(true);
            try {
                this.setSchema(this.metadata.getUserName(), false);
            }
            catch (Throwable throwable) {
                this.setSchema(null, false);
            }
            try {
                this.setCatalog(databaseConnection.getCatalog(), false);
            }
            catch (Throwable throwable) {
                this.setCatalog(null, false);
            }
        } else {
            this.nodeRoot.setUserObject("");
            this.nodeRoot.setAllowsChildren(false);
            this.metadata = null;
            this.lstTableTypes = null;
            this.currentCatlog = null;
            this.currentSchema = null;
            this.reload(this.nodeRoot);
        }
    }

    public synchronized void setCatalog(String string) {
        this.setCatalog(string, true);
    }

    public synchronized void setSchema(String string) {
        this.setSchema(string, true);
    }

    public synchronized void setCatalog(String string, boolean bl2) {
        this.currentCatlog = string != null ? string : null;
        if (bl2) {
            this.reload();
        }
    }

    public synchronized void setSchema(String string, boolean bl2) {
        this.currentSchema = string != null ? string : null;
        if (bl2) {
            this.reload();
        }
    }

    public synchronized void reload() {
        this.nodeRoot.removeAllChildren();
        this.initNodes();
        this.reload(this.nodeRoot);
    }

    public int getTableTypeCount() {
        try {
            return this.lstTableTypes.size();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public boolean isUncachedNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            return defaultMutableTreeNode2.getUserObject().toString().equalsIgnoreCase(UNCACHED_NODE.getUserObject().toString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTableTypeNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        defaultMutableTreeNode.removeAllChildren();
        ResultSet resultSet = null;
        if (this.tabsEnabled && this.isTableTypeNode(defaultMutableTreeNode)) {
            try {
                resultSet = this.metadata.getTables(this.currentCatlog, this.currentSchema, null, new String[]{string.trim()});
                Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, "TABLE_NAME", null);
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(objectArray[i2], true);
                    this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
                    if (!this.metaEnabled) continue;
                    this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), defaultMutableTreeNode2, 0);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
        } else if (this.procEnabled && this.isProcedureNode(defaultMutableTreeNode)) {
            try {
                resultSet = this.metadata.getProcedures(this.currentCatlog, this.currentSchema, null);
                Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, "PROCEDURE_NAME", null);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(objectArray[i3], true);
                    this.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, 0);
                    if (!this.metaEnabled) continue;
                    this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), defaultMutableTreeNode3, 0);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.reload(defaultMutableTreeNode);
    }

    public boolean isTableTypeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            if (this.isProcedureNode(defaultMutableTreeNode)) {
                return false;
            }
            if (defaultMutableTreeNode.getLevel() > 1) {
                return this.lstTableTypes.contains(defaultMutableTreeNode.getPath()[1].toString());
            }
            return this.lstTableTypes.contains(defaultMutableTreeNode.getUserObject().toString()) && !defaultMutableTreeNode.isRoot();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isProcedureNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            String string = defaultMutableTreeNode.getUserObject().toString();
            String string2 = BasicUtilities.getString("JDBC_Procedures");
            return string2.equalsIgnoreCase(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTableChildNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeAllChildren();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getPath()[1];
        if (this.isProcedureNode(defaultMutableTreeNode2)) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Columns"), false);
            this.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, 0);
            this.reload(defaultMutableTreeNode);
            return;
        }
        String string = defaultMutableTreeNode.getUserObject().toString();
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Columns"), true);
        this.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode, 0);
        this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), defaultMutableTreeNode4, 0);
        ResultSet resultSet = null;
        try {
            resultSet = this.metadata.getSuperTables(this.currentCatlog, this.currentSchema, string);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Super_Tables"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getIndexInfo(this.currentCatlog, this.currentSchema, string, false, false);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Indicies"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getPrimaryKeys(this.currentCatlog, this.currentSchema, string);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Primary_Keys"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getExportedKeys(this.currentCatlog, this.currentSchema, string);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Exported_Keys"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getImportedKeys(this.currentCatlog, this.currentSchema, string);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Imported_Keys"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getVersionColumns(this.currentCatlog, this.currentSchema, string);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Version_Columns"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getTablePrivileges(this.currentCatlog, this.currentSchema, string);
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Table_Privileges"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            resultSet = this.metadata.getColumnPrivileges(this.currentCatlog, this.currentSchema, string, "%");
            if (resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Column_Privileges"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            this.metadata.getConnection().clearWarnings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reload(defaultMutableTreeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumnChildNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeAllChildren();
        ResultSet resultSet = null;
        try {
            String string = defaultMutableTreeNode.getPath()[2].toString();
            resultSet = this.metadata.getColumns(this.currentCatlog, this.currentSchema, string, null);
            Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, "COLUMN_NAME", null);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(objectArray[i2], true);
                this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            this.metadata.getConnection().clearWarnings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reload(defaultMutableTreeNode);
    }

    public boolean isMetadataEnabled() {
        return this.metaEnabled;
    }

    public boolean isProceduresEnabled() {
        return this.procEnabled;
    }

    public boolean isTablesEnabled() {
        return this.tabsEnabled;
    }

    public void setMetadataEnabled(boolean bl2) {
        this.metaEnabled = bl2;
    }

    public void setProceduresEnabled(boolean bl2) {
        this.procEnabled = bl2;
    }

    public void setTablesEnabled(boolean bl2) {
        this.tabsEnabled = bl2;
    }

    public void addVector(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector, boolean bl2) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(iterator.next(), bl2);
            this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
            if (!bl2) continue;
            this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), defaultMutableTreeNode2, 0);
        }
    }

    public void initNodes() {
        if (this.metaEnabled) {
            this.insertNodeInto(this.nodeUDTS, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeTypes, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeObjects, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeCatalog, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeSchema, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeGeneral, this.nodeRoot, 0);
        }
        if (this.tabsEnabled) {
            this.addTableTypeNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableTypeNodes() {
        ResultSet resultSet = null;
        try {
            resultSet = this.metadata.getTableTypes();
            this.lstTableTypes = new Vector<Object>(Arrays.asList(JDBCUtilities.getSingleColumn(resultSet, "TABLE_TYPE", null)));
            Iterator iterator = this.lstTableTypes.iterator();
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (iterator.hasNext()) {
                String[] stringArray = new String[]{((String)iterator.next()).trim()};
                try {
                    resultSet = this.metadata.getTables(this.currentCatlog, this.currentSchema, null, stringArray);
                    if (resultSet.next()) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    iterator.remove();
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (this.procEnabled) {
                try {
                    resultSet = this.metadata.getProcedures(this.currentCatlog, this.currentSchema, null);
                    if (resultSet.next()) {
                        this.lstTableTypes.insertElementAt(BasicUtilities.getString("JDBC_Procedures"), 0);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.addVector(this.nodeRoot, this.lstTableTypes, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.metadata.getConnection().clearWarnings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

