/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.model.AbstractTreeModel;

public class HistoryTreeModel
extends AbstractTreeModel
implements ChangeListener {
    private final Object ROOT = new Object();
    private Calendar calendar = Calendar.getInstance();
    private HashMap dayMapper = new HashMap();
    private ArrayList keyList = null;
    private HistoryManager mgrHistory = null;

    public HistoryTreeModel(HistoryManager historyManager) {
        this.mgrHistory = historyManager;
        this.mgrHistory.addChangeListener(this);
        this.reload();
    }

    public void reload() {
        this.setData(this.mgrHistory.getHistory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Cloneable cloneable;
        if (this.keyList != null) {
            cloneable = this.keyList;
            synchronized (cloneable) {
                this.keyList.clear();
            }
        }
        if (this.dayMapper != null) {
            cloneable = this.dayMapper;
            synchronized (cloneable) {
                this.dayMapper.clear();
            }
        }
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null));
    }

    public void setData(Collection collection) {
        Object object;
        this.clear();
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof HistoryItem) || object == null) continue;
            HistoryItem historyItem = (HistoryItem)object;
            this.addHistoryItem(historyItem);
        }
        if (this.keyList != null) {
            object = this.keyList.toArray();
            Arrays.sort(object);
            this.keyList = new ArrayList(Arrays.asList(object));
        }
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null));
    }

    public Object getRoot() {
        return this.ROOT;
    }

    public Object getChild(Object object, int n2) {
        if (object == this.ROOT) {
            n2 = this.keyList.size() - 1 - n2;
            return this.keyList.get(n2);
        }
        ArrayList arrayList = (ArrayList)this.dayMapper.get(object);
        return arrayList.get(n2);
    }

    public int getChildCount(Object object) {
        if (object == this.ROOT) {
            return this.dayMapper.size();
        }
        ArrayList arrayList = (ArrayList)this.dayMapper.get(object);
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    public boolean isLeaf(Object object) {
        return object instanceof HistoryItem;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.ROOT) {
            int n2 = this.keyList.indexOf(object2);
            return this.keyList.size() - 1 - n2;
        }
        ArrayList arrayList = (ArrayList)this.dayMapper.get(object);
        return arrayList.indexOf(object2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.reload();
    }

    private boolean containsDayKey(Date date) {
        if (this.dayMapper.isEmpty()) {
            return false;
        }
        Iterator iterator = this.dayMapper.keySet().iterator();
        while (iterator.hasNext()) {
            Date date2 = (Date)iterator.next();
            this.calendar.setTime(date2);
            int n2 = this.calendar.get(6);
            this.calendar.setTime(date);
            int n3 = this.calendar.get(6);
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDayBranch(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        HashMap hashMap = this.dayMapper;
        synchronized (hashMap) {
            this.dayMapper.put(this.calendar.getTime(), new ArrayList());
            this.keyList = new ArrayList(this.dayMapper.keySet());
        }
    }

    private ArrayList getDayBrach(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return (ArrayList)this.dayMapper.get(this.calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistoryItem(HistoryItem historyItem) {
        ArrayList arrayList;
        Date date = historyItem.getTimeStamp();
        if (!this.containsDayKey(date)) {
            this.addDayBranch(date);
        }
        ArrayList arrayList2 = arrayList = this.getDayBrach(date);
        synchronized (arrayList2) {
            arrayList.add(historyItem);
        }
    }

    public void finalize() throws Throwable {
        this.mgrHistory.removeChangeListener(this);
        super.finalize();
    }
}

