/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;

public class DriverPropertyTableModel
extends EnhancedTableModel {
    private final String[] mColumnNames = new String[]{BasicUtilities.getString("Driver_Property_Required"), BasicUtilities.getString("Driver_Property_Name"), BasicUtilities.getString("Property_Choice_Value")};
    public DriverPropertyInfo[] data;
    public boolean tooltips = true;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public DriverPropertyTableModel() {
        this.setColumns(this.mColumnNames);
    }

    public DriverPropertyTableModel(DriverPropertyInfo[] driverPropertyInfoArray) {
        this();
        this.setData(driverPropertyInfoArray);
    }

    public DriverPropertyInfo getPropertyInfo(int n2) {
        String string = this.data[n2].name;
        String string2 = (String)this.getValueAt(n2, 1);
        if (!string2.equalsIgnoreCase(string)) {
            n2 = this.getRealRow(string2);
        }
        return this.data[n2];
    }

    public void setData(DriverPropertyInfo[] driverPropertyInfoArray) {
        this.clear();
        this.data = driverPropertyInfoArray;
        if (driverPropertyInfoArray != null) {
            for (int i2 = 0; i2 < driverPropertyInfoArray.length; ++i2) {
                ArrayList<Object> arrayList = new ArrayList<Object>(3);
                arrayList.add(new Boolean(driverPropertyInfoArray[i2].required));
                arrayList.add(driverPropertyInfoArray[i2].name);
                arrayList.add(driverPropertyInfoArray[i2].value);
                this.addRow(arrayList);
            }
            this.fireTableStructureChanged();
        } else {
            this.data = new DriverPropertyInfo[0];
        }
    }

    public void setToolTipsEnabled(boolean bl2) {
        this.tooltips = bl2;
    }

    public void setProperties(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        try {
            String[] stringArray = preferences.keys();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                int n2 = this.getRealRow(string);
                String string2 = preferences.get(string, "");
                if (string2 == null || n2 < 0) continue;
                this.setValueAt(string2, n2, 2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        try {
            String[] stringArray = properties.keySet().toArray(new String[0]);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                int n2 = this.getRealRow(string);
                String string2 = properties.getProperty(string, "");
                if (string2 == null || n2 < 0) continue;
                this.setValueAt(string2, n2, 2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            String string = (String)this.getValueAt(i2, 1);
            String string2 = (String)this.getValueAt(i2, 2);
            if (string == null || string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public DefaultCellEditor getChoiceEditor() {
        return new ChoiceRenderer();
    }

    public boolean hasRequiredData() {
        try {
            for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                try {
                    boolean bl2 = (Boolean)this.getValueAt(i2, 0);
                    String string = this.getValueAt(i2, 2).toString();
                    if (!bl2 || string != null) continue;
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            BasicUtilities.HandleException(exception);
            return false;
        }
        return true;
    }

    public Class getColumnClass(int n2) {
        switch (n2) {
            case 0: {
                Class<?> clazz = class$java$lang$Boolean;
                if (clazz == null) {
                    clazz = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
                }
                return clazz;
            }
            default: {
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = class$java$lang$String = new String[0].getClass().getComponentType();
                }
                return clazz;
            }
            case 2: 
        }
        Class<?> clazz = array$Ljava$lang$String;
        if (clazz == null) {
            clazz = array$Ljava$lang$String = new String[0].getClass();
        }
        return clazz;
    }

    public boolean isCellEditable(int n2, int n3) {
        return n3 == 2;
    }

    private int getRealRow(String string) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (!this.data[i2].name.equalsIgnoreCase(string)) continue;
            return i2;
        }
        return -1;
    }

    private class ChoiceRenderer
    extends DefaultCellEditor {
        public ChoiceRenderer() {
            super(new JComboBox());
        }

        private void createChoiceDelegate(final JComboBox jComboBox) {
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object object) {
                    jComboBox.setSelectedItem(object);
                }

                public Object getCellEditorValue() {
                    return jComboBox.getSelectedItem();
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    if (eventObject instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        return mouseEvent.getID() != 506;
                    }
                    return true;
                }
            };
        }

        private void createSingleDelegate(final JTextField jTextField) {
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object object) {
                    if (object != null) {
                        jTextField.setText(object.toString());
                    } else {
                        jTextField.setText("");
                    }
                }

                public Object getCellEditorValue() {
                    return jTextField.getText();
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    if (eventObject instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        return mouseEvent.getID() != 506;
                    }
                    return true;
                }
            };
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            try {
                String string = (String)DriverPropertyTableModel.this.getValueAt(n2, 1);
                n2 = DriverPropertyTableModel.this.getRealRow(string);
                if (n2 < 0) {
                    super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
                }
                boolean bl3 = DriverPropertyTableModel.this.data[n2].choices.length >= 0;
                JComboBox<String> jComboBox = null;
                if (bl3) {
                    jComboBox = new JComboBox<String>(DriverPropertyTableModel.this.data[n2].choices);
                    if (DriverPropertyTableModel.this.tooltips) {
                        jComboBox.setToolTipText(DriverPropertyTableModel.this.data[n2].description);
                    }
                    jComboBox.addActionListener(this.delegate);
                    jComboBox.setEditable(false);
                    jComboBox.setSelectedItem(object);
                    jComboBox.setMaximumRowCount(3);
                    this.createChoiceDelegate(jComboBox);
                    this.editorComponent = jComboBox;
                    jTable.setRowHeight(this.editorComponent.getPreferredSize().height);
                }
            }
            catch (Exception exception) {
                JTextField jTextField = new JTextField(object == null ? DriverPropertyTableModel.this.data[n2].value : object.toString());
                this.createSingleDelegate(jTextField);
                jTextField.addActionListener(this.delegate);
                if (DriverPropertyTableModel.this.tooltips) {
                    jTextField.setToolTipText(DriverPropertyTableModel.this.data[n2].description);
                }
                this.editorComponent = jTextField;
            }
            return super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
        }
    }
}

