/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class AbstractTreeModel
implements TreeModel {
    private transient Vector treeModelListeners;

    public final void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(treeModelListener)) {
            Vector vector = (Vector)this.treeModelListeners.clone();
            vector.removeElement(treeModelListener);
            this.treeModelListeners = vector;
            if (this.treeModelListeners.isEmpty()) {
                this.treeModelListeners = null;
            }
        }
    }

    public final void addTreeModelListener(TreeModelListener treeModelListener) {
        Vector vector;
        Vector vector2 = vector = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!vector.contains(treeModelListener)) {
            vector.addElement(treeModelListener);
            this.treeModelListeners = vector;
        }
    }

    public void reload() {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null));
    }

    public void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                    treeModelListener.treeNodesChanged(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                    treeModelListener.treeNodesInserted(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                    treeModelListener.treeNodesRemoved(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                    treeModelListener.treeStructureChanged(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

