/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class MapperPlugin
extends AbstractImportPlugin {
    private DefaultComboBoxModel mdlColumns = new DefaultComboBoxModel();
    private JComboBox jcbColumns = new JComboBox(this.mdlColumns);
    private JComboBox jcbTypes = new JComboBox();
    private JTextField txtIOptions = new JTextField();
    private HashMap nativeTypes = null;
    private static final String KEY_SQL_TYPE = "sqltype";
    private static final String KEY_SELECTED = "selection";
    private static final String KEY_COLUMN_REF = "column-ref";
    private static final String KEY_OPTIONS = "options";

    public boolean canChangeSelection() {
        return true;
    }

    public void handleDataModelChange(TableModel tableModel) {
        int n2;
        int n3 = tableModel.getColumnCount();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = tableModel.getColumnName(n2);
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (n2 = 0; n2 < n3; ++n2) {
            this.mdlColumns.addElement(stringArray[n2]);
        }
        if (n3 >= 1) {
            this.jcbColumns.setSelectedIndex(0);
        }
    }

    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        Object object = this.jcbColumns.getSelectedItem();
        if (object != null) {
            entry.put(KEY_COLUMN_REF, object);
        } else {
            entry.put(KEY_COLUMN_REF, "null");
        }
        object = this.jcbTypes.getSelectedItem();
        if (object != null) {
            entry.put(KEY_SELECTED, object);
            if (!this.nativeTypes.isEmpty()) {
                entry.put(KEY_SQL_TYPE, this.nativeTypes.get(object));
            } else {
                entry.put(KEY_SQL_TYPE, new Integer(JDBCUtilities.getTypeforName((String)object)));
            }
        } else {
            entry.put(KEY_SQL_TYPE, new Integer(12));
        }
        entry.setProperty(KEY_OPTIONS, this.txtIOptions.getText());
        return entry;
    }

    public void setEntry(ImportConfig.Entry entry) {
        this.jcbColumns.setSelectedItem(entry.get(KEY_COLUMN_REF));
        this.jcbTypes.setSelectedItem(entry.get(KEY_SELECTED));
        this.txtIOptions.setText(entry.getProperty(KEY_OPTIONS, ""));
    }

    public void handleColumnSelectionChange(String string, String string2) {
    }

    public void handleTableSelectionChange(String string, String string2) {
    }

    public void installEditor(Container container) {
        this.nativeTypes = JDBCUtilities.getNativeTypeMap(this.connection.getDatabaseInformation());
        if (this.nativeTypes.isEmpty()) {
            this.jcbTypes = new JComboBox<String>(JDBCUtilities.getSQLTypes(true));
        } else {
            String[] stringArray = (String[])this.nativeTypes.keySet().toArray();
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            this.jcbTypes = new JComboBox<String>(stringArray);
        }
        container.setLayout(new GridBagLayout());
        MapperPlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        MapperPlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Source_Column")), UI_CONSTRAINT);
        MapperPlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbColumns, UI_CONSTRAINT);
        MapperPlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_SQL_Type")), UI_CONSTRAINT);
        MapperPlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbTypes, UI_CONSTRAINT);
        MapperPlugin.constrain(1, 2, 1, 1, 0.0, 0.0, 10, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Type_Options")), UI_CONSTRAINT);
        MapperPlugin.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtIOptions, UI_CONSTRAINT);
        MapperPlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        MapperPlugin.constrain(0, 3, 4, 1, 1.0, 1.0, 10, 3);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
    }

    public ImportProcessor createProcessor() {
        return new StaticMapperProcessor(null);
    }

    public String getDescription() {
        return BasicUtilities.getString("Import_Map_Data");
    }

    public static class 1 {
    }

    private static class StaticMapperProcessor
    implements ImportProcessor {
        private int sqltype = 1111;
        private String options = "";
        private String preferredColumn = "";

        private StaticMapperProcessor() {
        }

        public boolean canSkip() {
            return false;
        }

        public int prepareImport(int n2, int n3, Map map, PreparedStatement preparedStatement, int n4) throws SQLException {
            Object v2 = map.get(this.preferredColumn);
            try {
                if (this.options.length() >= 1) {
                    String string = v2 == null ? "" : v2.toString();
                    Object object = StringUtilities.processString(string, this.sqltype, this.options);
                    if (object == null) {
                        object = v2;
                    }
                    JDBCUtilities.configurePreparedStatement(preparedStatement, n3, object, n4, false);
                } else {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("");
                    SystemConfig systemConfig = SystemConfig.getInstance();
                    String string = systemConfig.getFormatForSQLType(this.sqltype);
                    if (string != null) {
                        simpleDateFormat.applyLocalizedPattern(string);
                    }
                    Object object = JDBCUtilities.convertValue(v2, this.sqltype, simpleDateFormat);
                    JDBCUtilities.configurePreparedStatement(preparedStatement, n3, object, this.sqltype, false);
                }
            }
            catch (ParseException parseException) {
                BasicUtilities.HandleException(parseException);
                throw new SQLException(parseException.getMessage());
            }
            return 0;
        }

        public void setEntry(ImportConfig.Entry entry) {
            this.preferredColumn = entry.getProperty(MapperPlugin.KEY_COLUMN_REF, "");
            String string = entry.get(MapperPlugin.KEY_SQL_TYPE).toString();
            this.sqltype = Integer.parseInt(string);
            this.options = entry.getProperty(MapperPlugin.KEY_OPTIONS, "");
        }

        public /* synthetic */ StaticMapperProcessor(1 var1_1) {
            this();
        }
    }
}

