/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public class ExcelTableFilter
extends AbstractTableFilter {
    private static final int BIFF2_TYPE = 9;
    private static final int BIFF3_TYPE = 521;
    private static final int BIFF4_TYPE = 1033;
    private static final int BIFF5_8_TYPE = 2057;
    private StringBuffer sbuf = new StringBuffer();
    private int totalread = 0;
    private Vector SSTArray;

    public String getName() {
        return BasicUtilities.getString("Excel_Handler_Name");
    }

    public boolean isModeSupported(int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int n2) {
        return true;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Xcel16");
    }

    public int filterIn(EnhancedTableModel enhancedTableModel, File file, InputStream inputStream) throws IOException, InterruptedException {
        Preferences preferences = this.getConfiguration(0);
        int n2 = inputStream.available();
        this.setProgressMax(n2);
        String string = BasicUtilities.getString("Excel_Imp_Row_As_Columns");
        int n3 = preferences.getInt(string, -2);
        Vector<Object> vector = new Vector<Object>(0, 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            block20: while (true) {
                this.checkIfCancelled();
                block21: while (!bl3) {
                    switch (n4) {
                        case 9: 
                        case 521: 
                        case 1033: 
                        case 2057: {
                            n5 = this.readShort(inputStream);
                            if (this.isBOF(n4, n5)) {
                                bl3 = true;
                                continue block21;
                            }
                            n4 = n5;
                            break;
                        }
                        default: {
                            n4 = this.read(inputStream);
                            if (n4 != 9) break;
                            n4 = ((n4 & 0xFF) << 0) + ((this.read(inputStream) & 0xFF) << 8);
                        }
                    }
                    this.debug("Searching....  (" + Integer.toHexString(this.totalread) + ")");
                }
                this.debug("BOF @ (" + Integer.toHexString(this.totalread) + ")");
                bl3 = false;
                do {
                    if (n4 == 10 && n4 != -1) continue block20;
                    this.debug(Integer.toHexString(this.totalread) + ":(" + Integer.toHexString(n4) + "," + n5 + ")");
                    this.checkIfCancelled();
                    this.fireProgressUpdated(this.totalread);
                    switch (n4) {
                        case 9: {
                            this.info("Excel 2.1 Spreadsheet");
                            this.skip(inputStream, n5);
                            break;
                        }
                        case 521: {
                            this.info("Excel 3 Spreadsheet");
                            this.skip(inputStream, n5);
                            break;
                        }
                        case 1033: {
                            this.info("Excel 4 Spreadshee");
                            this.skip(inputStream, n5);
                            break;
                        }
                        case 2057: {
                            this.info("Excel 97/2000 Spreadsheet ");
                            this.skip(inputStream, n5);
                            break;
                        }
                        case 0: 
                        case 512: {
                            if (n5 == 8 && !bl2) {
                                this.readShort(inputStream);
                                enhancedTableModel.setRowCount(this.readShort(inputStream));
                                this.readShort(inputStream);
                                enhancedTableModel.setColumnCount(this.readShort(inputStream));
                                bl2 = true;
                            } else if (n5 == 14 && !bl2) {
                                this.skip(inputStream, 4L);
                                enhancedTableModel.setRowCount(this.readShort(inputStream));
                                this.skip(inputStream, 4L);
                                enhancedTableModel.setColumnCount(this.readShort(inputStream));
                                this.skip(inputStream, 2L);
                                bl2 = true;
                            } else if (n5 == 10 && !bl2) {
                                this.skip(inputStream, 2L);
                                enhancedTableModel.setRowCount(this.readShort(inputStream));
                                this.skip(inputStream, 2L);
                                enhancedTableModel.setColumnCount(this.readShort(inputStream));
                                this.skip(inputStream, 2L);
                                bl2 = true;
                            } else {
                                this.skip(inputStream, n5);
                            }
                            bl2 = true;
                            break;
                        }
                        case 3: 
                        case 515: {
                            n6 = this.readShort(inputStream);
                            n7 = this.readShort(inputStream);
                            if (n4 == 3) {
                                this.skip(inputStream, 3L);
                            } else {
                                this.skip(inputStream, 2L);
                            }
                            double d2 = this.readDouble(inputStream);
                            if (this.isColumnIdentifer(n6, n3, enhancedTableModel.getRowCount())) {
                                vector.add(Double.toString(d2));
                                break;
                            }
                            enhancedTableModel.setValueAt(new Double(d2), n6, n7);
                            break;
                        }
                        case 4: 
                        case 516: {
                            n6 = this.readShort(inputStream);
                            n7 = this.readShort(inputStream);
                            if (n4 == 4) {
                                this.skip(inputStream, 3L);
                            } else {
                                this.skip(inputStream, 2L);
                            }
                            n8 = n4 == 4 ? this.read(inputStream) : this.readShort(inputStream);
                            if (this.isColumnIdentifer(n6, n3, enhancedTableModel.getRowCount())) {
                                vector.add(this.readUTFBody(inputStream, n8));
                                break;
                            }
                            enhancedTableModel.setValueAt(this.readUTFBody(inputStream, n8), n6, n7);
                            break;
                        }
                        case 2: 
                        case 638: {
                            n6 = this.readShort(inputStream);
                            n7 = this.readShort(inputStream);
                            if (n4 == 2) {
                                this.skip(inputStream, 3L);
                            } else {
                                this.skip(inputStream, 2L);
                            }
                            if (this.isColumnIdentifer(n6, n3, enhancedTableModel.getRowCount())) {
                                vector.add(Integer.toString(this.readShort(inputStream)));
                                break;
                            }
                            if (n4 == 2) {
                                enhancedTableModel.setValueAt(new Integer(this.readShort(inputStream)), n6, n7);
                                break;
                            }
                            enhancedTableModel.setValueAt(this.readRKInteger(inputStream), n6, n7);
                            break;
                        }
                        case 253: {
                            n6 = this.readShort(inputStream);
                            n7 = this.readShort(inputStream);
                            this.skip(inputStream, 2L);
                            int n9 = this.readInteger(inputStream);
                            this.debug("SSTLabel(" + n6 + "," + n7 + "):" + n9);
                            if (this.isColumnIdentifer(n6, n3, enhancedTableModel.getRowCount())) {
                                vector.add(this.SSTArray.get(n9));
                                break;
                            }
                            try {
                                enhancedTableModel.setValueAt(this.SSTArray.get(n9), n6, n7);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 189: {
                            n6 = this.readShort(inputStream);
                            n7 = this.readShort(inputStream);
                            for (int i2 = 0; i2 < (n5 - 6) / 6; ++i2) {
                                this.skip(inputStream, 2L);
                                if (this.isColumnIdentifer(n6, n3, enhancedTableModel.getRowCount())) {
                                    vector.add(this.readRKInteger(inputStream));
                                    continue;
                                }
                                enhancedTableModel.setValueAt(this.readRKInteger(inputStream), n6, n7 + i2);
                            }
                            this.readShort(inputStream);
                            break;
                        }
                        case 252: {
                            int n10 = this.readInteger(inputStream);
                            this.readInteger(inputStream);
                            this.readSSTArray(inputStream, n10, n5 - 8);
                            break;
                        }
                        default: {
                            this.skip(inputStream, n5);
                        }
                    }
                    n4 = this.readShort(inputStream);
                    if (n4 != -1) continue;
                    return 0;
                } while ((n5 = this.readShort(inputStream)) != -1);
                break;
            }
            return 0;
        }
        catch (EOFException eOFException) {
            if (!vector.isEmpty()) {
                if (n3 == -1) {
                    enhancedTableModel.removeRow(enhancedTableModel.getRowCount() - 1);
                } else if (n3 >= 0) {
                    enhancedTableModel.removeRow(n3);
                }
            }
            return 0;
        }
    }

    public int filterOut(Object object, File file, OutputStream outputStream) {
        return 0;
    }

    public void loadProperties(int n2) {
        switch (n2) {
            case 0: {
                String string = this.getString("Excel_Imp_Row_As_Columns");
                String string2 = this.getString("Excel_Imp_Row_As_Columns_Tip");
                this.addProperty(string, null, "-2", false, string2);
                break;
            }
        }
    }

    public boolean isColumnIdentifer(int n2, int n3, int n4) {
        if (n3 > -2) {
            return n2 == n3 || n3 == -1 && n2 == n4 - 1;
        }
        return false;
    }

    public void skip(InputStream inputStream, long l2) throws IOException {
        inputStream.skip(l2);
        this.totalread = (int)((long)this.totalread + l2);
    }

    public int read(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        ++this.totalread;
        return n2;
    }

    public void readSSTArray(InputStream inputStream, int n2, int n3) throws IOException {
        if (this.SSTArray == null) {
            this.SSTArray = new Vector(n2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.readUTFBody(inputStream, n3), "\u0000\u0001", false);
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.length() < 1) continue;
            this.SSTArray.add(string);
            this.debug("SST[" + n4 + "] == " + this.SSTArray.get(n4));
            ++n4;
        }
    }

    public Number readRKInteger(InputStream inputStream) throws IOException {
        boolean bl2;
        int n2 = this.readInteger(inputStream);
        boolean bl3 = (n2 & 1) == 1;
        boolean bl4 = bl2 = (n2 & 2) != 2;
        if (bl2) {
            return new Float((double)((n2 & 0xFFFFFFFC) >> 2) * (bl3 ? 0.01 : 1.0));
        }
        if (bl3) {
            return new Float((double)((n2 & 0xFFFFFFFC) >> 2) * 0.01);
        }
        return new Integer((n2 & 0xFFFFFFFC) >> 2);
    }

    public boolean isBOF(int n2, int n3) {
        switch (n2) {
            case 9: {
                return n3 == 4;
            }
            case 521: 
            case 1033: {
                return n3 == 6;
            }
            case 2057: {
                return n3 == 16 || n3 == 8;
            }
        }
        return false;
    }

    public int readShort(InputStream inputStream) throws IOException {
        return ((this.read(inputStream) & 0xFF) << 0) + ((this.read(inputStream) & 0xFF) << 8);
    }

    public int readInteger(InputStream inputStream) throws IOException {
        return ((this.read(inputStream) & 0xFF) << 0) + ((this.read(inputStream) & 0xFF) << 8) + ((this.read(inputStream) & 0xFF) << 16) + ((this.read(inputStream) & 0xFF) << 24);
    }

    public long readLong(InputStream inputStream) throws IOException {
        return (((long)this.read(inputStream) & 0xFFL) << 0) + (((long)this.read(inputStream) & 0xFFL) << 8) + (((long)this.read(inputStream) & 0xFFL) << 16) + (((long)this.read(inputStream) & 0xFFL) << 24) + (((long)this.read(inputStream) & 0xFFL) << 32) + (((long)this.read(inputStream) & 0xFFL) << 40) + (((long)this.read(inputStream) & 0xFFL) << 48) + (((long)this.read(inputStream) & 0xFFL) << 56);
    }

    public double readDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(this.readLong(inputStream));
    }

    public String readUTFBody(InputStream inputStream, int n2) throws IOException {
        this.sbuf.setLength(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sbuf.append((char)this.read(inputStream));
        }
        return this.sbuf.toString();
    }
}

