/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.action;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.CoreAction;
import org.isqlviewer.core.action.DefaultActionManager;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ActionMenuBar;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.swing.JTextPopup;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class DefaultMenuBar
extends ActionMenuBar
implements IPCListener {
    private JMenu mnuService;
    private JMenu mnuCatalog;
    private JMenuItem RowColDeleteAction;
    private JMenuItem ResultToggleAction;
    private JMenuItem LockAction;
    private ButtonGroup grpCatalog;

    public DefaultMenuBar(ActionManager actionManager) {
        super(actionManager);
        SystemConfig systemConfig = SystemConfig.getInstance();
        IPCService iPCService = systemConfig.getIPCService();
        iPCService.subscribe(this, "isql-service-change");
    }

    public void receiveMessage(Object object, String string, Object object2) {
        if (string.equalsIgnoreCase("isql-service-change")) {
            DatabaseConnection databaseConnection = (DatabaseConnection)object2;
            int n2 = this.mnuService.getMenuComponentCount();
            Component component = this.mnuService.getMenuComponent(n2 - 1);
            component.setEnabled(object2 != null);
            this.mnuCatalog.removeAll();
            this.mnuCatalog.setVisible(false);
            this.grpCatalog = null;
            this.grpCatalog = new ButtonGroup();
            if (object2 != null) {
                Object[] objectArray = databaseConnection.getAvailableCatalogs();
                String string2 = databaseConnection.getCatalog();
                if (objectArray.length >= 2) {
                    this.mnuCatalog.setVisible(true);
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        String string3 = (String)objectArray[i2];
                        this.addDynamicAction(this.mnuCatalog, null, this.grpCatalog, -2, string3, false);
                        if (!string2.equalsIgnoreCase(string3)) continue;
                        AbstractButton abstractButton = (AbstractButton)this.mnuCatalog.getMenuComponent(i2);
                        this.grpCatalog.setSelected(abstractButton.getModel(), true);
                    }
                }
            }
        }
    }

    public void toggleDeleteColumnRowAction(Action action) {
        if (action == null) {
            return;
        }
        this.RowColDeleteAction.setAction(action);
        this.configureMenuItem(this.RowColDeleteAction, action);
    }

    public void toggleLockAction(Action action) {
        if (action == null) {
            return;
        }
        this.LockAction.setAction(action);
        this.configureMenuItem(this.LockAction, action);
    }

    public void toggleResultSetViewAction(Action action) {
        if (action == null) {
            return;
        }
        this.ResultToggleAction.setAction(action);
        this.configureMenuItem(this.ResultToggleAction, action);
    }

    public void refreshServiceMenu() {
        ServiceProvider serviceProvider = SystemConfig.getInstance().getServiceProvider();
        this.setServices(serviceProvider.getRegisteredServices(true), this.mnuService);
    }

    public void addEditMenu(JTextComponent jTextComponent) {
        JTextPopup jTextPopup = new JTextPopup();
        jTextPopup.addJTextComponent(jTextComponent, false);
        this.add((Component)jTextPopup.toJMenu(), 1);
    }

    public void configureMenu() {
        this.mnuCatalog = this.createFileMenu(BasicUtilities.getString("Menu_Catalog"), '0');
        this.add(this.createFileMenu(BasicUtilities.getString("MENU_File"), '0'));
        this.add(this.createServiceMenu(BasicUtilities.getString("MENU_Service"), '0'));
        this.add(this.mnuCatalog);
        this.add(this.createViewMenu(BasicUtilities.getString("MENU_View"), '0'));
        this.add(this.createTxMenu());
        this.add(this.createToolMenu(BasicUtilities.getString("MENU_Tool"), '0'));
        if (!BasicUtilities.isMac() || !Boolean.getBoolean("isql.mrj.enabled")) {
            JMenu jMenu = this.createMenu(BasicUtilities.getString("MENU_Help"), '0');
            this.addMenuItem(jMenu, this.manager.getAction(31));
            this.addMenuItem(jMenu, this.manager.getAction(23));
            this.add(jMenu);
        }
        this.receiveMessage(this, "isql-service-change", null);
    }

    public void setServices(Collection collection, JMenu jMenu) {
        if (jMenu == null) {
            jMenu = new JMenu();
        }
        jMenu.removeAll();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addDynamicAction(jMenu, "Server", null, -1, iterator.next().toString(), true);
        }
        jMenu.addSeparator();
        this.addMenuItem(jMenu, this.manager.getAction(25));
    }

    public void addDynamicAction(JMenu jMenu, String string, ButtonGroup buttonGroup, int n2, String string2, boolean bl2) {
        CoreAction coreAction = new CoreAction(string2, n2, DefaultActionManager.bundle);
        coreAction.putValue("Name", string2);
        coreAction.putValue("Default", string2);
        coreAction.putValue("ICON_NAME", string);
        if (bl2 && jMenu.getMenuComponentCount() >= 0 && jMenu.getMenuComponentCount() <= 9) {
            char c2 = Character.forDigit(jMenu.getMenuComponentCount(), 10);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(c2, BasicUtilities.CMD_MASK, true);
            coreAction.putValue("AcceleratorKey", keyStroke);
        }
        if (buttonGroup != null) {
            this.addRadioButtonMenuItem(jMenu, buttonGroup, coreAction);
        } else {
            this.addMenuItem(jMenu, (Action)coreAction);
        }
    }

    public void configureMenuItem(JMenuItem jMenuItem, Action action) {
        super.configureMenuItem(jMenuItem, action);
        if (action instanceof CoreAction) {
            CoreAction coreAction = (CoreAction)action;
            try {
                jMenuItem.setActionCommand((String)coreAction.getValue("Default"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jMenuItem.setText((String)coreAction.getValue("Default"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (BasicUtilities.isMac()) {
                    jMenuItem.setIcon(null);
                } else {
                    String string = (String)action.getValue("ICON_NAME");
                    if (string != null) {
                        jMenuItem.setIcon(this.manager.getSmallIcon(string, "png"));
                    } else {
                        jMenuItem.setIcon(this.manager.getSmallIcon("Spacer", "png"));
                    }
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }
    }

    private JMenu createServiceMenu(String string, char c2) {
        this.mnuService = this.createMenu(string, c2);
        this.refreshServiceMenu();
        return this.mnuService;
    }

    private JMenu createViewMenu(String string, char c2) {
        JMenu jMenu = this.createMenu(string, c2);
        JMenu jMenu2 = this.createMenu(BasicUtilities.getString("MENU_Toolbars"), '0');
        JMenu jMenu3 = this.createMenu(BasicUtilities.getString("MENU_Goto"), '0');
        JMenu jMenu4 = this.createMenu(BasicUtilities.getString("MENU_Resultset"), '0');
        if (!BasicUtilities.isMac()) {
            jMenu2.setIcon(this.manager.getSmallIcon("Spacer", "png"));
            jMenu3.setIcon(this.manager.getSmallIcon("Spacer", "png"));
            jMenu4.setIcon(this.manager.getSmallIcon("Spacer", "png"));
        }
        this.addMenuItem(jMenu3, this.manager.getAction(17));
        this.addMenuItem(jMenu3, this.manager.getAction(18));
        JCheckBoxAction jCheckBoxAction = new JCheckBoxAction(BasicUtilities.getString("File_Toolbar"), "0");
        JCheckBoxAction jCheckBoxAction2 = new JCheckBoxAction(BasicUtilities.getString("History_Toolbar"), "1");
        JCheckBoxAction jCheckBoxAction3 = new JCheckBoxAction(BasicUtilities.getString("Resultset_Toolbar"), "2");
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        this.addCheckBoxMenuItem(jMenu2, jCheckBoxAction, userPreferences.getBoolean("toolbar.file-visible"));
        this.addCheckBoxMenuItem(jMenu2, jCheckBoxAction2, userPreferences.getBoolean("toolbar.history-visible"));
        this.addCheckBoxMenuItem(jMenu2, jCheckBoxAction3, userPreferences.getBoolean("toolbar.resultset-visible"));
        jMenu.add(jMenu2);
        jMenu.add(jMenu3);
        jMenu.add(jMenu4);
        jMenu.addSeparator();
        this.addMenuItem(jMenu, this.manager.getAction(43));
        this.addMenuItem(jMenu, this.manager.getAction(44));
        this.addMenuItem(jMenu, this.manager.getAction(45));
        jMenu.addSeparator();
        this.addMenuItem(jMenu, this.manager.getAction(16));
        this.addMenuItem(jMenu, this.manager.getAction(7));
        this.addMenuItem(jMenu, this.manager.getAction(24));
        this.addMenuItem(jMenu, this.manager.getAction(35));
        this.RowColDeleteAction = new JMenuItem(this.manager.getAction(19));
        this.configureMenuItem(this.RowColDeleteAction, this.manager.getAction(19));
        jMenu4.add(this.RowColDeleteAction);
        this.ResultToggleAction = new JMenuItem(this.manager.getAction(27));
        this.configureMenuItem(this.ResultToggleAction, this.manager.getAction(27));
        jMenu4.add(this.ResultToggleAction);
        this.LockAction = new JMenuItem(this.manager.getAction(29));
        this.configureMenuItem(this.LockAction, this.manager.getAction(29));
        jMenu4.add(this.LockAction);
        this.addMenuItem(jMenu4, this.manager.getAction(28));
        return jMenu;
    }

    private JMenu createFileMenu(String string, char c2) {
        JMenu jMenu = this.createMenu(string, c2);
        JMenu jMenu2 = this.createMenu(BasicUtilities.getString("MENU_Import"), '0');
        JMenu jMenu3 = this.createMenu(BasicUtilities.getString("MENU_Export"), '0');
        if (!BasicUtilities.isMac()) {
            jMenu3.setIcon(this.manager.getSmallIcon("Spacer", "png"));
            jMenu2.setIcon(this.manager.getSmallIcon("Spacer", "png"));
        }
        this.addMenuItem(jMenu, this.manager.getAction(41));
        jMenu.addSeparator();
        this.addMenuItem(jMenu, this.manager.getAction(1));
        this.addMenuItem(jMenu, this.manager.getAction(5));
        jMenu.addSeparator();
        jMenu.add(jMenu2);
        this.addMenuItem(jMenu2, this.manager.getAction(9));
        this.addMenuItem(jMenu2, this.manager.getAction(6));
        jMenu.add(jMenu3);
        this.addMenuItem(jMenu3, this.manager.getAction(10));
        if (!BasicUtilities.isMac() || !Boolean.getBoolean("isql.mrj.enabled")) {
            jMenu.addSeparator();
            this.addMenuItem(jMenu, this.manager.getAction(8));
        }
        return jMenu;
    }

    private JMenu createToolMenu(String string, char c2) {
        JMenu jMenu = this.createMenu(string, c2);
        if (!Boolean.getBoolean("isql.mrj.enabled")) {
            this.addMenuItem(jMenu, this.manager.getAction(4));
        }
        this.addMenuItem(jMenu, this.manager.getAction(3));
        this.addMenuItem(jMenu, this.manager.getAction(34));
        this.addMenuItem(jMenu, this.manager.getAction(33));
        jMenu.addSeparator();
        this.addMenuItem(jMenu, this.manager.getAction(2));
        this.addMenuItem(jMenu, this.manager.getAction(36));
        this.addMenuItem(jMenu, this.manager.getAction(42));
        this.addMenuItem(jMenu, this.manager.getAction(46));
        return jMenu;
    }

    private JMenu createTxMenu() {
        JMenu jMenu = new JMenu(BasicUtilities.getString("Transaction"));
        this.addMenuItem(jMenu, this.manager.getAction(12));
        this.addMenuItem(jMenu, this.manager.getAction(14));
        this.addMenuItem(jMenu, this.manager.getAction(13));
        this.addMenuItem(jMenu, this.manager.getAction(48));
        return jMenu;
    }
}

