/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.UnsupportedEncodingException;
import org.garret.perst.StorageError;

public class Bytes {
    public static short unpack2(byte[] byArray, int n2) {
        return (short)(byArray[n2] << 8 | byArray[n2 + 1] & 0xFF);
    }

    public static int unpack4(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public static long unpack8(byte[] byArray, int n2) {
        return (long)Bytes.unpack4(byArray, n2) << 32 | (long)Bytes.unpack4(byArray, n2 + 4) & 0xFFFFFFFFL;
    }

    public static float unpackF4(byte[] byArray, int n2) {
        return Float.intBitsToFloat(Bytes.unpack4(byArray, n2));
    }

    public static double unpackF8(byte[] byArray, int n2) {
        return Double.longBitsToDouble(Bytes.unpack8(byArray, n2));
    }

    public static String unpackStr(byte[] byArray, int n2, String string) {
        int n3 = Bytes.unpack4(byArray, n2);
        n2 += 4;
        if (n3 >= 0) {
            char[] cArray = new char[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                cArray[i2] = (char)Bytes.unpack2(byArray, n2);
                n2 += 2;
            }
            return new String(cArray);
        }
        if (n3 < -1) {
            if (string != null) {
                try {
                    return new String(byArray, n2, -n3 - 2, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new StorageError(26);
                }
            }
            return new String(byArray, n2, -n3 - 2);
        }
        return null;
    }

    public static void pack2(byte[] byArray, int n2, short s2) {
        byArray[n2] = (byte)(s2 >> 8);
        byArray[n2 + 1] = (byte)s2;
    }

    public static void pack4(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    public static void pack8(byte[] byArray, int n2, long l2) {
        Bytes.pack4(byArray, n2, (int)(l2 >> 32));
        Bytes.pack4(byArray, n2 + 4, (int)l2);
    }

    public static void packF4(byte[] byArray, int n2, float f2) {
        Bytes.pack4(byArray, n2, Float.floatToIntBits(f2));
    }

    public static void packF8(byte[] byArray, int n2, double d2) {
        Bytes.pack8(byArray, n2, Double.doubleToLongBits(d2));
    }

    public static int packStr(byte[] byArray, int n2, String string, String string2) {
        if (string == null) {
            Bytes.pack4(byArray, n2, -1);
            n2 += 4;
        } else if (string2 == null) {
            int n3 = string.length();
            Bytes.pack4(byArray, n2, n3);
            n2 += 4;
            for (int i2 = 0; i2 < n3; ++i2) {
                Bytes.pack2(byArray, n2, (short)string.charAt(i2));
                n2 += 2;
            }
        } else {
            try {
                byte[] byArray2 = string.getBytes(string2);
                Bytes.pack4(byArray, n2, -2 - byArray2.length);
                System.arraycopy(byArray2, 0, byArray, n2 + 4, byArray2.length);
                n2 += 4 + byArray2.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new StorageError(26);
            }
        }
        return n2;
    }

    public static int sizeof(String string, String string2) {
        try {
            return string == null ? 4 : (string2 == null ? 4 + string.length() * 2 : 4 + new String(string).getBytes(string2).length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new StorageError(26);
        }
    }

    public static int sizeof(byte[] byArray, int n2) {
        int n3 = Bytes.unpack4(byArray, n2);
        if (n3 >= 0) {
            return 4 + n3 * 2;
        }
        if (n3 < -1) {
            return 2 - n3;
        }
        return 4;
    }
}

