/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.xmlrules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.gs.beanutils.ConvertUtils;
import org.apache.commons.gs.collections.ArrayStack;
import org.apache.commons.gs.digester.AbstractObjectCreationFactory;
import org.apache.commons.gs.digester.BeanPropertySetterRule;
import org.apache.commons.gs.digester.CallMethodRule;
import org.apache.commons.gs.digester.CallParamRule;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.FactoryCreateRule;
import org.apache.commons.gs.digester.ObjectCreateRule;
import org.apache.commons.gs.digester.ObjectParamRule;
import org.apache.commons.gs.digester.Rule;
import org.apache.commons.gs.digester.RuleSetBase;
import org.apache.commons.gs.digester.Rules;
import org.apache.commons.gs.digester.SetNestedPropertiesRule;
import org.apache.commons.gs.digester.SetNextRule;
import org.apache.commons.gs.digester.SetPropertiesRule;
import org.apache.commons.gs.digester.SetPropertyRule;
import org.apache.commons.gs.digester.SetRootRule;
import org.apache.commons.gs.digester.SetTopRule;
import org.apache.commons.gs.digester.xmlrules.CircularIncludeException;
import org.apache.commons.gs.digester.xmlrules.DigesterRulesSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DigesterRuleParser
extends RuleSetBase {
    public static final String DIGESTER_PUBLIC_ID = "-//Jakarta Apache //DTD digester-rules XML V1.0//EN";
    private String digesterDtdUrl;
    public Digester targetDigester;
    public String basePath = "";
    public PatternStack patternStack;
    private Set includedFiles = new HashSet();
    static /* synthetic */ Class class$org$apache$commons$gs$digester$Rule;

    public DigesterRuleParser() {
        this.patternStack = new PatternStack();
    }

    public DigesterRuleParser(Digester digester) {
        this.targetDigester = digester;
        this.patternStack = new PatternStack();
    }

    private DigesterRuleParser(Digester digester, PatternStack patternStack, Set set) {
        this.targetDigester = digester;
        this.patternStack = patternStack;
        this.includedFiles = set;
    }

    public void setTarget(Digester digester) {
        this.targetDigester = digester;
    }

    public void setBasePath(String string) {
        this.basePath = string == null ? "" : (string.length() > 0 && !string.endsWith("/") ? string + "/" : string);
    }

    public void setDigesterRulesDTD(String string) {
        this.digesterDtdUrl = string;
    }

    public String getDigesterRulesDTD() {
        return this.digesterDtdUrl;
    }

    public void add(Rule rule) {
        this.targetDigester.addRule(this.basePath + this.patternStack.toString(), rule);
    }

    public void addRuleInstances(Digester digester) {
        Class<?> clazz = class$org$apache$commons$gs$digester$Rule;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$digester$Rule = new Rule[0].getClass().getComponentType();
        }
        String string = clazz.getName();
        digester.register(DIGESTER_PUBLIC_ID, this.getDigesterRulesDTD());
        digester.addRule("*/pattern", new PatternRule("value"));
        digester.addRule("*/include", new IncludeRule());
        digester.addFactoryCreate("*/bean-property-setter-rule", new BeanPropertySetterRuleFactory(null));
        digester.addRule("*/bean-property-setter-rule", new PatternRule("pattern"));
        digester.addSetNext("*/bean-property-setter-rule", "add", string);
        digester.addFactoryCreate("*/call-method-rule", new CallMethodRuleFactory());
        digester.addRule("*/call-method-rule", new PatternRule("pattern"));
        digester.addSetNext("*/call-method-rule", "add", string);
        digester.addFactoryCreate("*/object-param-rule", new ObjectParamRuleFactory());
        digester.addRule("*/object-param-rule", new PatternRule("pattern"));
        digester.addSetNext("*/object-param-rule", "add", string);
        digester.addFactoryCreate("*/call-param-rule", new CallParamRuleFactory());
        digester.addRule("*/call-param-rule", new PatternRule("pattern"));
        digester.addSetNext("*/call-param-rule", "add", string);
        digester.addFactoryCreate("*/factory-create-rule", new FactoryCreateRuleFactory());
        digester.addRule("*/factory-create-rule", new PatternRule("pattern"));
        digester.addSetNext("*/factory-create-rule", "add", string);
        digester.addFactoryCreate("*/object-create-rule", new ObjectCreateRuleFactory());
        digester.addRule("*/object-create-rule", new PatternRule("pattern"));
        digester.addSetNext("*/object-create-rule", "add", string);
        digester.addFactoryCreate("*/set-properties-rule", new SetPropertiesRuleFactory());
        digester.addRule("*/set-properties-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-properties-rule", "add", string);
        digester.addRule("*/set-properties-rule/alias", new SetPropertiesAliasRule());
        digester.addFactoryCreate("*/set-property-rule", new SetPropertyRuleFactory());
        digester.addRule("*/set-property-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-property-rule", "add", string);
        digester.addFactoryCreate("*/set-nested-properties-rule", new SetNestedPropertiesRuleFactory());
        digester.addRule("*/set-nested-properties-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-nested-properties-rule", "add", string);
        digester.addRule("*/set-nested-properties-rule/alias", new SetNestedPropertiesAliasRule());
        digester.addFactoryCreate("*/set-top-rule", new SetTopRuleFactory());
        digester.addRule("*/set-top-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-top-rule", "add", string);
        digester.addFactoryCreate("*/set-next-rule", new SetNextRuleFactory());
        digester.addRule("*/set-next-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-next-rule", "add", string);
        digester.addFactoryCreate("*/set-root-rule", new SetRootRuleFactory());
        digester.addRule("*/set-root-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-root-rule", "add", string);
    }

    public /* synthetic */ DigesterRuleParser(Digester digester, PatternStack patternStack, Set set, 1 var4_4) {
        this(digester, patternStack, set);
    }

    public static class 1 {
    }

    protected class SetNestedPropertiesAliasRule
    extends Rule {
        public void begin(Attributes attributes) {
            String string = attributes.getValue("attr-name");
            String string2 = attributes.getValue("prop-name");
            SetNestedPropertiesRule setNestedPropertiesRule = (SetNestedPropertiesRule)this.digester.peek();
            setNestedPropertiesRule.addAlias(string, string2);
        }
    }

    protected class SetPropertiesAliasRule
    extends Rule {
        public void begin(Attributes attributes) {
            String string = attributes.getValue("attr-name");
            String string2 = attributes.getValue("prop-name");
            SetPropertiesRule setPropertiesRule = (SetPropertiesRule)this.digester.peek();
            setPropertiesRule.addAlias(string, string2);
        }
    }

    protected class SetRootRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("methodname");
            String string2 = attributes.getValue("paramtype");
            return string2 == null || string2.length() == 0 ? new SetRootRule(string) : new SetRootRule(string, string2);
        }
    }

    protected class SetNextRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("methodname");
            String string2 = attributes.getValue("paramtype");
            return string2 == null || string2.length() == 0 ? new SetNextRule(string) : new SetNextRule(string, string2);
        }
    }

    protected class SetTopRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("methodname");
            String string2 = attributes.getValue("paramtype");
            return string2 == null || string2.length() == 0 ? new SetTopRule(string) : new SetTopRule(string, string2);
        }
    }

    protected class SetNestedPropertiesRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            boolean bl2 = "true".equalsIgnoreCase(attributes.getValue("allow-unknown-child-elements"));
            SetNestedPropertiesRule setNestedPropertiesRule = new SetNestedPropertiesRule();
            setNestedPropertiesRule.setAllowUnknownChildElements(bl2);
            return setNestedPropertiesRule;
        }
    }

    protected class SetPropertyRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("value");
            return new SetPropertyRule(string, string2);
        }
    }

    protected class SetPropertiesRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            return new SetPropertiesRule();
        }
    }

    protected class ObjectCreateRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("classname");
            String string2 = attributes.getValue("attrname");
            return string2 == null || string2.length() == 0 ? new ObjectCreateRule(string) : new ObjectCreateRule(string, string2);
        }
    }

    protected class FactoryCreateRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("classname");
            String string2 = attributes.getValue("attrname");
            boolean bl2 = "true".equalsIgnoreCase(attributes.getValue("ignore-exceptions"));
            return string2 == null || string2.length() == 0 ? new FactoryCreateRule(string, bl2) : new FactoryCreateRule(string, string2, bl2);
        }
    }

    protected class ObjectParamRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) throws Exception {
            int n2 = Integer.parseInt(attributes.getValue("paramnumber"));
            String string = attributes.getValue("attrname");
            String string2 = attributes.getValue("type");
            String string3 = attributes.getValue("value");
            ObjectParamRule objectParamRule = null;
            if (string2 == null) {
                throw new RuntimeException("Attribute 'type' is required.");
            }
            Object object = null;
            Class<?> clazz = Class.forName(string2);
            object = string3 == null ? (Object)clazz.newInstance() : ConvertUtils.convert(string3, clazz);
            objectParamRule = string == null ? new ObjectParamRule(n2, object) : new ObjectParamRule(n2, string, object);
            return objectParamRule;
        }
    }

    protected class CallParamRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            int n2 = Integer.parseInt(attributes.getValue("paramnumber"));
            String string = attributes.getValue("attrname");
            String string2 = attributes.getValue("from-stack");
            String string3 = attributes.getValue("stack-index");
            CallParamRule callParamRule = null;
            if (string == null) {
                callParamRule = string3 != null ? new CallParamRule(n2, Integer.parseInt(string3)) : (string2 != null ? new CallParamRule(n2, Boolean.valueOf(string2)) : new CallParamRule(n2));
            } else if (string2 == null) {
                callParamRule = new CallParamRule(n2, string);
            } else {
                throw new RuntimeException("Attributes from-stack and attrname cannot both be present.");
            }
            return callParamRule;
        }
    }

    protected class CallMethodRuleFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) {
            CallMethodRule callMethodRule = null;
            String string = attributes.getValue("methodname");
            int n2 = 0;
            String string2 = attributes.getValue("targetoffset");
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
            if (attributes.getValue("paramcount") == null) {
                callMethodRule = new CallMethodRule(n2, string);
            } else {
                int n3 = Integer.parseInt(attributes.getValue("paramcount"));
                String string3 = attributes.getValue("paramtypes");
                if (string3 == null || string3.length() == 0) {
                    callMethodRule = new CallMethodRule(n2, string, n3);
                } else {
                    String[] stringArray = this.getParamTypes(string3);
                    callMethodRule = new CallMethodRule(n2, string, n3, stringArray);
                }
            }
            return callMethodRule;
        }

        private String[] getParamTypes(String string) {
            String[] stringArray;
            if (string != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                stringArray = arrayList.toArray(new String[0]);
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    private class BeanPropertySetterRuleFactory
    extends AbstractObjectCreationFactory {
        private BeanPropertySetterRuleFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            BeanPropertySetterRule beanPropertySetterRule = null;
            String string = attributes.getValue("propertyname");
            beanPropertySetterRule = string == null ? new BeanPropertySetterRule() : new BeanPropertySetterRule(string);
            return beanPropertySetterRule;
        }

        public /* synthetic */ BeanPropertySetterRuleFactory(1 var2_2) {
            this();
        }
    }

    private class RulesPrefixAdapter
    implements Rules {
        private Rules delegate;
        private String prefix;

        public RulesPrefixAdapter(String string, Rules rules) {
            this.prefix = string;
            this.delegate = rules;
        }

        public void add(String string, Rule rule) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.prefix);
            if (!string.startsWith("/")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
            this.delegate.add(stringBuffer.toString(), rule);
        }

        public void clear() {
            this.delegate.clear();
        }

        public Digester getDigester() {
            return this.delegate.getDigester();
        }

        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        public List match(String string) {
            return this.delegate.match(string);
        }

        public List match(String string, String string2) {
            return this.delegate.match(string, string2);
        }

        public List rules() {
            return this.delegate.rules();
        }

        public void setDigester(Digester digester) {
            this.delegate.setDigester(digester);
        }

        public void setNamespaceURI(String string) {
            this.delegate.setNamespaceURI(string);
        }
    }

    private class IncludeRule
    extends Rule {
        public void begin(Attributes attributes) throws Exception {
            String string;
            String string2 = attributes.getValue("path");
            if (string2 != null && string2.length() > 0) {
                this.includeXMLRules(string2);
            }
            if ((string = attributes.getValue("class")) != null && string.length() > 0) {
                this.includeProgrammaticRules(string);
            }
        }

        private void includeXMLRules(String string) throws IOException, SAXException, CircularIncludeException {
            URL uRL;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = DigesterRuleParser.this.getClass().getClassLoader();
            }
            if ((uRL = classLoader.getResource(string)) == null) {
                throw new FileNotFoundException("File \"" + string + "\" not found.");
            }
            string = uRL.toExternalForm();
            if (!DigesterRuleParser.this.includedFiles.add(string)) {
                throw new CircularIncludeException(string);
            }
            DigesterRuleParser digesterRuleParser = new DigesterRuleParser(DigesterRuleParser.this.targetDigester, DigesterRuleParser.this.patternStack, DigesterRuleParser.this.includedFiles, null);
            digesterRuleParser.setDigesterRulesDTD(DigesterRuleParser.this.getDigesterRulesDTD());
            Digester digester = new Digester();
            digester.addRuleSet(digesterRuleParser);
            digester.push(DigesterRuleParser.this);
            digester.parse(string);
            DigesterRuleParser.this.includedFiles.remove(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void includeProgrammaticRules(String string) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
            Class<?> clazz = Class.forName(string);
            DigesterRulesSource digesterRulesSource = (DigesterRulesSource)clazz.newInstance();
            Rules rules = DigesterRuleParser.this.targetDigester.getRules();
            RulesPrefixAdapter rulesPrefixAdapter = new RulesPrefixAdapter(DigesterRuleParser.this.patternStack.toString(), rules);
            DigesterRuleParser.this.targetDigester.setRules(rulesPrefixAdapter);
            try {
                digesterRulesSource.getRules(DigesterRuleParser.this.targetDigester);
            }
            finally {
                DigesterRuleParser.this.targetDigester.setRules(rules);
            }
        }
    }

    private class PatternRule
    extends Rule {
        private String attrName;
        private String pattern = null;

        public PatternRule(String string) {
            this.attrName = string;
        }

        public void begin(Attributes attributes) {
            this.pattern = attributes.getValue(this.attrName);
            if (this.pattern != null) {
                DigesterRuleParser.this.patternStack.push(this.pattern);
            }
        }

        public void end() {
            if (this.pattern != null) {
                DigesterRuleParser.this.patternStack.pop();
            }
        }
    }

    protected class PatternStack
    extends ArrayStack {
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                String string = this.get(i2).toString();
                if (string.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

