/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import java.util.logging.Level;
import org.apache.commons.gs.collections.ArrayStack;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.Rule;
import org.xml.sax.Attributes;

public class CallParamRule
extends Rule {
    public String attributeName = null;
    public int paramIndex = 0;
    public boolean fromStack = false;
    public int stackIndex = 0;
    public ArrayStack bodyTextStack;

    public CallParamRule(Digester digester, int n2) {
        this(n2);
    }

    public CallParamRule(Digester digester, int n2, String string) {
        this(n2, string);
    }

    public CallParamRule(int n2) {
        this(n2, null);
    }

    public CallParamRule(int n2, String string) {
        this.paramIndex = n2;
        this.attributeName = string;
    }

    public CallParamRule(int n2, boolean bl2) {
        this.paramIndex = n2;
        this.fromStack = bl2;
    }

    public CallParamRule(int n2, int n3) {
        this.paramIndex = n2;
        this.fromStack = true;
        this.stackIndex = n3;
    }

    public void begin(Attributes attributes) throws Exception {
        Object object;
        Object object2 = null;
        if (this.attributeName != null) {
            object2 = attributes.getValue(this.attributeName);
        } else if (this.fromStack) {
            object2 = this.digester.peek(this.stackIndex);
            if (this.digester.log.isLoggable(Level.FINE)) {
                object = new StringBuffer("[CallParamRule]{");
                ((StringBuffer)object).append(this.digester.match);
                ((StringBuffer)object).append("} Save from stack; from stack?").append(this.fromStack);
                ((StringBuffer)object).append("; object=").append(object2);
                this.digester.log.fine(((StringBuffer)object).toString());
            }
        }
        if (object2 != null) {
            object = (Object[])this.digester.peekParams();
            object[this.paramIndex] = object2;
        }
    }

    public void body(String string) throws Exception {
        if (this.attributeName == null && !this.fromStack) {
            if (this.bodyTextStack == null) {
                this.bodyTextStack = new ArrayStack();
            }
            this.bodyTextStack.push(string.trim());
        }
    }

    public void end(String string, String string2) {
        if (this.bodyTextStack != null && !this.bodyTextStack.empty()) {
            Object[] objectArray = (Object[])this.digester.peekParams();
            objectArray[this.paramIndex] = this.bodyTextStack.pop();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CallParamRule[");
        stringBuffer.append("paramIndex=");
        stringBuffer.append(this.paramIndex);
        stringBuffer.append(", attributeName=");
        stringBuffer.append(this.attributeName);
        stringBuffer.append(", from stack=");
        stringBuffer.append(this.fromStack);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

