/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.converters;

import java.util.List;
import org.apache.commons.gs.beanutils.ConversionException;
import org.apache.commons.gs.beanutils.converters.AbstractArrayConverter;

public final class LongArrayConverter
extends AbstractArrayConverter {
    private static long[] model = new long[0];

    public LongArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public LongArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                long[] lArray = new long[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    lArray[i2] = Long.parseLong(stringArray[i2]);
                }
                return lArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            long[] lArray = new long[list.size()];
            for (int i3 = 0; i3 < lArray.length; ++i3) {
                lArray[i3] = Long.parseLong((String)list.get(i3));
            }
            return lArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

