/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import com.j_spaces.tools.spacebrowser.statistics.ColorMap;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JComponent;

public class PieGraph
extends JComponent {
    private static final double SCALE_FACTOR = 1.05;
    private static final double OFFSET_FACTOR = 20.0;
    private static final int Y_AXIS_X_START = 55;
    private static ArrayList slices = null;
    private static ArrayList slicesTp = null;
    private static final int AXIS_HALF_WIDTH = 5;
    private static final int NUM_OF_INTERVALS = 10;
    private static final int Y_AXIS_TEXT_START = 5;
    private static final int TEXT_X_OFFSET = 5;
    private static final int TEXT_Y_OFFSET = 15;
    private static final double HEIGHT_OFFSET = 20.0;
    private static Hashtable slicesHash = new Hashtable();
    private static Hashtable slicesTpHash = new Hashtable();
    private Object space;
    private static int timeTp = 1;

    public PieGraph(Object object) {
        this.space = object;
        this.setBackground(Color.WHITE);
    }

    public void setPie(ArrayList arrayList, int n2) {
        timeTp = n2;
        if (slicesHash.get(this.space) != null) {
            slicesTpHash.put(this.space, slicesHash.get(this.space));
        }
        slicesHash.put(this.space, arrayList);
        this.repaint();
    }

    public PieValue getPieValue(int n2, Color color) {
        return new PieValue(n2, color);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (slicesHash.get(this.space) != null) {
            this.drawBar((Graphics2D)graphics, this.getBounds(), (ArrayList)slicesHash.get(this.space), (ArrayList)slicesTpHash.get(this.space), timeTp);
        }
    }

    public void drawBar(Graphics2D graphics2D, Rectangle2D rectangle2D, ArrayList arrayList, ArrayList arrayList2, int n2) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = (int)((PieValue)arrayList.get((int)i2)).value;
            d2 += (double)n3;
            if (!(d3 < (double)n3)) continue;
            d3 = n3;
        }
        double d5 = rectangle2D.getHeight() - 20.0;
        d4 = d3 * 1.05;
        this.drawAxis(graphics2D, rectangle2D, arrayList, (int)(d3 / (d4 += 20.0) * d5), d4);
        for (int i3 = 0; i3 < n4; ++i3) {
            int n5;
            Object object;
            n3 = (int)((PieValue)arrayList.get((int)i3)).value;
            int n6 = (int)(d5 * ((double)n3 / d4));
            int n7 = (int)(d5 - (double)n6);
            int n8 = n6;
            int n9 = (int)(rectangle2D.getWidth() / (double)(2 * n4 + 1));
            int n10 = (1 + 2 * i3) * n9;
            graphics2D.setColor(((PieValue)arrayList.get((int)i3)).color);
            graphics2D.fill3DRect(n10, n7, n9, n8, true);
            String string = new Integer(n3).toString();
            if (arrayList2 != null && arrayList2.size() > i3) {
                object = (PieValue)arrayList2.get(i3);
                n5 = (n3 - (int)((PieValue)object).value) / n2;
                string = string + ", " + new Integer(n5).toString() + " TP";
            }
            graphics2D.drawString("" + string, n10 + 5, n7 - 1);
            graphics2D.setColor(Color.BLACK);
            object = (String)ColorMap.instance().getNameMapping().get(((PieValue)arrayList.get((int)i3)).color);
            n5 = n10;
            if (((String)object).equals("Notify registration")) {
                n5 -= 20;
            }
            graphics2D.drawString((String)object, n5 + 5, (int)d5 + 15);
            graphics2D.draw3DRect(n10, n7, n9, n8, true);
            graphics2D.setColor(Color.GRAY);
        }
    }

    private void drawAxis(Graphics2D graphics2D, Rectangle2D rectangle2D, ArrayList arrayList, int n2, double d2) {
        int n3 = (int)(rectangle2D.getHeight() - 20.0);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(55, 0, 55, n3);
        int n4 = n3;
        while ((double)n4 > 20.0) {
            graphics2D.drawLine(50, n4, 60, n4);
            int n5 = (int)((double)(n3 - n4) * d2 / (double)n3);
            graphics2D.drawString("" + n5, 5, n4 - 1);
            n4 -= n3 / 10;
        }
        graphics2D.drawLine(55, n3, (int)rectangle2D.getWidth(), n3);
    }

    private class PieValue {
        public double value;
        public Color color;

        public PieValue(double d2, Color color) {
            this.value = d2;
            this.color = color;
        }
    }
}

