/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.LockedObjectsViewPanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class SpaceTransactionsPanel
extends JPanel {
    private JLabel testLabel = new JLabel("Test");
    private JTable _transactionsTable;
    private TransactionsTableModel _transactionsTableModel = new TransactionsTableModel();
    private final int CI_TRANSACTION_ID = 0;
    private final int CI_TRANSACTION_TYPE = 1;
    private final int CI_TRANSACTION_STATUS = 2;
    private final int CI_TRANSACTION_START_TIME = 3;
    private final int CI_TRANSACTION_LEASE = 4;
    private final int CI_NUMBER_OF_LOCKED_OBJECTS = 5;
    private LockedObjectsViewPanel _lockedObjectsViewPanel;
    private IJSpace curSpaceProxy;
    private RefreshPanel refreshPanel;
    private IInternalRemoteJSpaceAdmin spaceAdmin;
    private SpaceBrowser _spaceBrowser;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");

    public SpaceTransactionsPanel(SpaceBrowser spaceBrowser) {
        this._spaceBrowser = spaceBrowser;
        this.init();
    }

    public void setSpace(IJSpace iJSpace) {
        this.curSpaceProxy = iJSpace;
        try {
            this._lockedObjectsViewPanel.clear();
            this.spaceAdmin = (IInternalRemoteJSpaceAdmin)iJSpace.getAdmin();
        }
        catch (RemoteException remoteException) {
            _logger.log(Level.SEVERE, remoteException.toString(), remoteException);
        }
    }

    private void init() {
        this.setBorder(new TitledBorder("Active Transactions"));
        this._transactionsTable = new JTable(this._transactionsTableModel);
        JScrollPane jScrollPane = new JScrollPane(this._transactionsTable);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        JTableHeader jTableHeader = this._transactionsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this._transactionsTable.setAutoCreateColumnsFromModel(false);
        this._transactionsTable.setSelectionMode(0);
        this._transactionsTable.setAutoResizeMode(1);
        this._transactionsTable.setAutoscrolls(true);
        this.refreshPanel = new RefreshPanel(this._transactionsTableModel, false);
        this._lockedObjectsViewPanel = new LockedObjectsViewPanel(this._spaceBrowser);
        this.setLayout(new BorderLayout());
        this.add((Component)this.refreshPanel, "North");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, this._lockedObjectsViewPanel);
        jSplitPane.setDividerLocation(0.6);
        this.add((Component)jSplitPane, "Center");
        this.addSelectionListenerToTable();
    }

    private void addSelectionListenerToTable() {
        ListSelectionModel listSelectionModel = this._transactionsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n2 = listSelectionEvent.getFirstIndex();
                    TransactionInfo transactionInfo = SpaceTransactionsPanel.this._transactionsTableModel.getTransactionInfoAt(n2);
                    if (transactionInfo != null) {
                        try {
                            SpaceTransactionsPanel.this._spaceBrowser.setCursor(Cursor.getPredefinedCursor(3));
                            List list = SpaceTransactionsPanel.this.spaceAdmin.getLockedObjects(transactionInfo.getTrasaction());
                            SpaceTransactionsPanel.this._lockedObjectsViewPanel.displayLockedObjects(SpaceTransactionsPanel.this.curSpaceProxy, list, transactionInfo);
                        }
                        catch (RemoteException remoteException) {
                            _logger.log(Level.SEVERE, remoteException.toString(), remoteException);
                        }
                        finally {
                            SpaceTransactionsPanel.this._spaceBrowser.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                }
            }
        });
    }

    public static String getTransactionTypeName(int n2) {
        switch (n2) {
            case 0: {
                return "All";
            }
            case 2: {
                return "Jini";
            }
            case 1: {
                return "Local";
            }
            case 3: {
                return "XA";
            }
        }
        return "";
    }

    public static String getTransactionStatusName(int n2) {
        switch (n2) {
            case 6: {
                return "Aborted";
            }
            case 1: {
                return "Active";
            }
            case 5: {
                return "Commited";
            }
            case 4: {
                return "Not changed";
            }
            case 3: {
                return "Prepared";
            }
            case 2: {
                return "Voting";
            }
        }
        return "";
    }

    private class TransactionsTableModel
    extends DefaultTableModel
    implements IRefreshable {
        private String[] columnNames = new String[]{"ID", "Type", "Status", "Start Time", "Lease (msec)", "Locked Objects"};
        private List transactionInfoList = new ArrayList();
        private DateFormat df = DateFormat.getDateTimeInstance(2, 2);

        public Object getValueAt(int n2, int n3) {
            TransactionInfo transactionInfo = (TransactionInfo)this.transactionInfoList.get(n2);
            if (transactionInfo != null) {
                return this.getCellValue(transactionInfo, n3);
            }
            return null;
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public Class getColumnClass(int n2) {
            Object object = this.getValueAt(0, n2);
            if (object != null) {
                return object.getClass();
            }
            return null;
        }

        public int getRowCount() {
            return this.transactionInfoList == null ? 0 : this.transactionInfoList.size();
        }

        public List getWrappersList() {
            return this.transactionInfoList;
        }

        public TransactionInfo getTransactionInfoAt(int n2) {
            if (this.transactionInfoList.size() > n2) {
                return (TransactionInfo)this.transactionInfoList.get(n2);
            }
            return null;
        }

        public String getCellValue(TransactionInfo transactionInfo, int n2) {
            switch (n2) {
                case 1: {
                    return SpaceTransactionsPanel.getTransactionTypeName(transactionInfo.getType());
                }
                case 2: {
                    return SpaceTransactionsPanel.getTransactionStatusName(transactionInfo.getStatus());
                }
                case 5: {
                    return String.valueOf(transactionInfo.getNumberOfLockedObjects());
                }
                case 0: {
                    return String.valueOf(transactionInfo.getTxnId());
                }
                case 4: {
                    long l2 = transactionInfo.getLease();
                    if (l2 < 0L) {
                        return " - ";
                    }
                    return String.valueOf(l2);
                }
                case 3: {
                    return this.df.format(new Date(transactionInfo.getStartTime()));
                }
            }
            return "";
        }

        public void refresh() {
            TransactionInfo[] transactionInfoArray = null;
            try {
                transactionInfoArray = SpaceTransactionsPanel.this.spaceAdmin.getTransactionsInfo(0, 1);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                _logger.log(Level.FINE, noSuchObjectException.toString(), noSuchObjectException);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
            int n2 = this.transactionInfoList.size();
            if (n2 > 0) {
                this.fireTableRowsDeleted(0, n2 - 1);
            }
            if (transactionInfoArray != null) {
                this.transactionInfoList = new ArrayList(transactionInfoArray.length);
                TransactionInfo[] transactionInfoArray2 = transactionInfoArray;
                int n3 = transactionInfoArray2.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    TransactionInfo transactionInfo = transactionInfoArray2[i2];
                    this.transactionInfoList.add(transactionInfo);
                }
                if (this.transactionInfoList.size() > 0) {
                    this.fireTableRowsInserted(0, this.transactionInfoList.size() - 1);
                }
            }
        }

        public boolean isRunning() {
            return !SpaceTransactionsPanel.this.refreshPanel.isStop();
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

