/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.DropClassException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.spacebrowser.ClassPropertiesPanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.jini.core.lookup.ServiceID;
import net.jini.space.InternalSpaceException;

public class SpaceRuntimePanel
extends JPanel
implements IRefreshable {
    private SpaceRuntimeInfo runtime;
    private JPanel runtimePanel = new JPanel();
    private Border border1;
    private TitledBorder titledBorder1;
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JSplitPane tableSplitPane;
    private ClassPropertiesPanel classPropertiesPanel;
    private SpaceBrowser m_spaceBrowser;
    private IRemoteJSpaceAdmin spaceAdmin;
    private ServiceID _spaceID;
    private static final String DIALOG_RUNTIME_COLUMN = "dialog.runtime.columnname";
    private JButton queryButton;
    private JButton deleteButton;
    private JButton cleanButton;
    private JButton statisticsButton = new JButton("Statistics");
    private JPanel tablePanel;
    private JPanel tableControlPanel;
    private Hashtable querys = new Hashtable();
    public static int clickCount = 0;
    private JPopupMenu rightMenu;
    private JMenuItem deleteMenu;
    private JMenuItem clearMenu;
    private JMenuItem queryMenu;
    private String[] resColumn;
    private JTable table;
    private RuntimeTableModel model;
    private boolean isQueryExecutionEnabled;
    private RefreshPanel refreshPanel;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");

    public SpaceRuntimePanel(SpaceBrowser spaceBrowser, boolean bl2) {
        this.isQueryExecutionEnabled = bl2;
        this.rightMenu = new JPopupMenu();
        this.deleteMenu = new JMenuItem("Delete");
        this.clearMenu = new JMenuItem("Clean");
        this.queryMenu = new JMenuItem("Query");
        this.rightMenu.add(this.deleteMenu);
        this.rightMenu.add(this.clearMenu);
        this.rightMenu.add(this.queryMenu);
        this.queryMenu.setEnabled(bl2);
        this.m_spaceBrowser = spaceBrowser;
        this.model = new RuntimeTableModel();
        this.table = new JTable(this.model);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.queryButton = new JButton("Query");
        this.deleteButton = new JButton("Delete");
        this.cleanButton = new JButton("Clean");
        this.setControlEnabled(false);
        this.refreshPanel = new RefreshPanel(this, false);
        this.queryButton.setEnabled(bl2);
        this.resColumn = SpaceBrowser.getResources(DIALOG_RUNTIME_COLUMN);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.table.setAutoscrolls(true);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().addMouseListener(new ColumnSortListener());
        this.titledBorder1 = new TitledBorder(this.border1, "Classes List");
        this.setLayout(this.borderLayout2);
        this.runtimePanel.setLayout(this.borderLayout1);
        this.runtimePanel.setBorder(this.titledBorder1);
        this.add((Component)this.runtimePanel, "Center");
        this.classPropertiesPanel = new ClassPropertiesPanel();
        this.classPropertiesPanel.setPreferredSize(new Dimension(600, 300));
        this.tableControlPanel = new JPanel();
        this.queryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceRuntimePanel.this.queryRow();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceRuntimePanel.this.deleteRow();
            }
        });
        this.cleanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceRuntimePanel.this.cleanRow();
            }
        });
        this.queryMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceRuntimePanel.this.queryRow();
            }
        });
        this.deleteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceRuntimePanel.this.deleteRow();
            }
        });
        this.clearMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceRuntimePanel.this.cleanRow();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n2 = SpaceRuntimePanel.this.table.rowAtPoint(mouseEvent.getPoint());
                    SpaceRuntimePanel.this.table.setRowSelectionInterval(n2, n2);
                    if (SpaceRuntimePanel.this.table.getSelectedRow() > -1) {
                        SpaceRuntimePanel.this.rightMenu.show(SpaceRuntimePanel.this.table, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        if (this.m_spaceBrowser != null) {
            this.tableControlPanel.add(this.queryButton);
        }
        this.tableControlPanel.add(this.deleteButton);
        this.tableControlPanel.add(this.cleanButton);
        this.tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.tablePanel.add((Component)this.tableControlPanel, "South");
        this.tableSplitPane = new JSplitPane(0, this.tablePanel, this.classPropertiesPanel);
        this.tableSplitPane.setOneTouchExpandable(true);
        this.tableSplitPane.setDividerLocation(200);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        this.setPreferredSize(new Dimension(600, 600));
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!listSelectionModel.isSelectionEmpty()) {
                    SpaceRuntimePanel.this.setControlEnabled(SpaceRuntimePanel.this.m_spaceBrowser != null);
                    int n2 = listSelectionModel.getMinSelectionIndex();
                    Object object = SpaceRuntimePanel.this.model.getValueAt(n2, SpaceRuntimePanel.this.model.getColumnCount() - 1);
                    String string = (String)SpaceRuntimePanel.this.model.getValueAt(n2, 0);
                    SpaceRuntimePanel.this.classPropertiesPanel.setClassName(string);
                    SpaceRuntimePanel.this.classPropertiesPanel.setSpaceAdmin(SpaceRuntimePanel.this.spaceAdmin);
                    ClassPropertiesPanel classPropertiesPanel = SpaceRuntimePanel.this.classPropertiesPanel;
                    synchronized (classPropertiesPanel) {
                        SpaceRuntimePanel.this.classPropertiesPanel.notify();
                    }
                }
            }
        });
        this.runtimePanel.add((Component)this.refreshPanel, "North");
        this.runtimePanel.add((Component)this.tableSplitPane, "Center");
        for (int i2 = 0; i2 < this.resColumn.length; ++i2) {
            this.model.addColumn(this.resColumn[i2]);
        }
    }

    private void queryRow() {
        try {
            int n2 = this.table.getSelectedRow();
            String string = "select uid,* from " + this.model.getValueAt(n2, 0);
            this.m_spaceBrowser.selectSpaceOperationNode(this._spaceID, "Query");
            this.m_spaceBrowser.showQueryPanel(string, this.m_spaceBrowser.getSelectedSpaceNode());
        }
        catch (Exception exception) {
            SpaceBrowser.showException("Query", exception);
        }
    }

    private void deleteRow() {
        try {
            String string = this.model.getValueAt(this.table.getSelectedRow(), 0).toString();
            String string2 = this.m_spaceBrowser.getSelectedSpaceNode().toString();
            IJSpace iJSpace = (IJSpace)this.m_spaceBrowser.getSelectedSpaceNode().proxy();
            String string3 = "Are you sure you want to delete class " + string + " definition and all its instances from space \"" + string2 + "\"?";
            int n2 = JOptionPane.showConfirmDialog(this.m_spaceBrowser, string3, "Delete", 0, 2);
            if (n2 == 0) {
                this.deleteEntriesFromSpace(iJSpace, string);
            }
        }
        catch (Exception exception) {
            SpaceBrowser.showException("Deleting class", exception);
        }
    }

    private void deleteEntriesFromSpace(IJSpace iJSpace, String string) throws DropClassException, RemoteException {
        iJSpace.dropClass(string);
        this.model.removeRow(this.table.getSelectedRow());
        this.classPropertiesPanel.clearClassPropertiesDialog();
        this.setControlEnabled(false);
    }

    private void cleanRow() {
        try {
            String string = this.model.getValueAt(this.table.getSelectedRow(), 0).toString();
            IJSpace iJSpace = (IJSpace)this.m_spaceBrowser.getSelectedSpaceNode().proxy();
            String string2 = this.m_spaceBrowser.getSelectedSpaceNode().toString();
            if (iJSpace instanceof JSpaceClusteredProxy) {
                String string3 = "All class " + string + " instances will be removed from \"" + string2 + "\" space.\nSpace \"" + string2 + "\" is clustered.Please select operation target:";
                Object[] objectArray = new String[]{"All Cluster members", "Space \"" + string2 + "\"", "Cancel"};
                int n2 = JOptionPane.showOptionDialog(this.m_spaceBrowser, string3, "Clean", 2, 2, null, objectArray, objectArray[1]);
                if (n2 == 0) {
                    this.clearSpace(iJSpace, string);
                } else if (n2 == 1) {
                    IJSpace iJSpace2 = ((JSpaceClusteredProxy)iJSpace).getContainer().getSpace(string2, iJSpace.isEmbedded());
                    this.clearSpace(iJSpace2, string);
                }
            } else {
                String string4 = "Are you sure you want to delete all class " + string + " instances from space \"" + string2 + "\"?";
                int n3 = JOptionPane.showConfirmDialog(this.m_spaceBrowser, string4, "Clean", 0, 2);
                if (n3 == 0) {
                    this.clearSpace(iJSpace, string);
                }
            }
        }
        catch (Exception exception) {
            SpaceBrowser.showException("Cleaning class", exception);
        }
    }

    private void clearSpace(IJSpace iJSpace, String string) throws Exception {
        iJSpace.clear(new ExternalEntry(string, null, null), null);
    }

    public void setControlEnabled(boolean bl2) {
        if (this.isQueryExecutionEnabled) {
            this.queryButton.setEnabled(bl2);
        }
        this.deleteButton.setEnabled(bl2);
        this.cleanButton.setEnabled(bl2);
        this.statisticsButton.setEnabled(bl2);
    }

    public void stopStatusRuntime() {
        this.refreshPanel.stopStatusRuntime();
    }

    public void clearRuntimeDialog() {
        this.model.setDataVector((Object[][])null, this.resColumn);
    }

    public void setSpaceAdmin(IRemoteJSpaceAdmin iRemoteJSpaceAdmin, ServiceID serviceID) {
        if (iRemoteJSpaceAdmin == null) {
            return;
        }
        this.spaceAdmin = iRemoteJSpaceAdmin;
        this._spaceID = serviceID;
        this.clearRuntimeDialog();
        this.classPropertiesPanel.clearClassPropertiesDialog();
        if (this.refreshPanel.isStop()) {
            this.refreshPanel.setStartButtonEnabled(true);
        }
    }

    public boolean isStop() {
        return this.refreshPanel.isStop();
    }

    public ImageIcon getStopIcon() {
        return this.refreshPanel.getStopIcon();
    }

    public void refresh() {
        block16: {
            try {
                Object object;
                long l2;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest(" ------- in refresh() Calling spaceAdmin.getRuntimeInfo() ------");
                    l2 = System.currentTimeMillis();
                    _logger.finest("> TIME1:" + l2);
                }
                this.runtime = this.spaceAdmin.getRuntimeInfo();
                if (_logger.isLoggable(Level.FINEST)) {
                    l2 = System.currentTimeMillis();
                    _logger.finest("> TIME2:" + l2);
                }
                if (this.runtime.m_NumOFEntries.size() == 0 && this.model.getRowCount() != 0) {
                    this.clearRuntimeDialog();
                    this.classPropertiesPanel.clearClassPropertiesDialog();
                }
                int[] nArray = new int[this.runtime.m_NumOFEntries.size()];
                if (_logger.isLoggable(Level.FINEST)) {
                    long l3 = System.currentTimeMillis();
                    _logger.finest("> TIME3:" + l3);
                }
                for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
                    object = this.model.getValueAt(i2, 0);
                    int n2 = this.runtime.m_ClassNames.indexOf(object);
                    if (n2 != -1) {
                        nArray[n2] = -1;
                        Object e2 = this.runtime.m_NumOFEntries.get(n2);
                        if (e2.equals(this.model.getValueAt(i2, 1))) continue;
                        this.model.setValueAt(this.runtime.m_NumOFEntries.get(n2), i2, 1);
                        continue;
                    }
                    this.model.removeRow(i2);
                    if (!this.classPropertiesPanel.getClassName().equalsIgnoreCase((String)object)) continue;
                    this.classPropertiesPanel.clearClassPropertiesDialog();
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    long l4 = System.currentTimeMillis();
                    _logger.finest("> TIME4:" + l4);
                }
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    Object e3 = this.runtime.m_NumOFEntries.get(i3);
                    if (nArray[i3] == -1) continue;
                    object = (String)this.runtime.m_ClassNames.get(i3);
                    this.model.addRow(new Object[]{object, e3});
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    long l5 = System.currentTimeMillis();
                    _logger.finest("> TIME5:" + l5);
                }
            }
            catch (UnmarshalException unmarshalException) {
                this.stopStatusRuntime();
                if (this.m_spaceBrowser != null) {
                    this.m_spaceBrowser.conTree.repaint();
                    SpaceBrowser.showException("getting rintime information", unmarshalException);
                }
            }
            catch (RemoteException remoteException) {
                this.stopStatusRuntime();
                if (this.m_spaceBrowser != null) {
                    this.m_spaceBrowser.conTree.repaint();
                    this.m_spaceBrowser.showStatus("Connection with space lost! Reason: The space maybe was destroyed.");
                }
            }
            catch (InternalSpaceException internalSpaceException) {
                this.stopStatusRuntime();
                if (this.m_spaceBrowser == null) break block16;
                this.m_spaceBrowser.showStatus("InternalSpaceError: " + internalSpaceException.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block16;
                _logger.log(Level.FINE, internalSpaceException.toString(), internalSpaceException);
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            long l6 = System.currentTimeMillis();
            _logger.finest("> TIME6:" + l6);
        }
    }

    public boolean isRunning() {
        return false;
    }

    public void start() {
        this.clearRuntimeDialog();
        this.classPropertiesPanel.clearClassPropertiesDialog();
        if (this.m_spaceBrowser != null) {
            this.m_spaceBrowser.statusBar.setIcon(this.refreshPanel.getStartIcon());
        }
    }

    public void stop() {
        if (this.m_spaceBrowser != null) {
            this.m_spaceBrowser.statusBar.setIcon(this.refreshPanel.getStopIcon());
        }
    }

    public class TableButton
    extends JButton {
        public TableButton(String string, String string2) {
            super(string);
            SpaceRuntimePanel.this.querys.put(this, "select uid,* from " + string2);
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (clickCount > 0) {
                        clickCount = 0;
                        ((SpaceRuntimePanel)SpaceRuntimePanel.this).m_spaceBrowser.conTree.setSelectionRow(((SpaceRuntimePanel)SpaceRuntimePanel.this).m_spaceBrowser.conTree.getSelectionRows()[0] + 1);
                        SpaceRuntimePanel.this.m_spaceBrowser.showQueryPanel((String)SpaceRuntimePanel.this.querys.get(mouseEvent.getSource()), SpaceRuntimePanel.this.m_spaceBrowser.getSelectedSpaceNode());
                    } else {
                        ++clickCount;
                    }
                }
            });
        }
    }

    public class RuntimeTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }
    }
}

