/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.CreateException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.exception.InvalidSpaceNameException;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.filters.SortFiltersDialog;
import com.j_spaces.tools.spacebrowser.ICreateSpace;
import com.j_spaces.tools.spacebrowser.NewSchemaNameDialog;
import com.j_spaces.tools.spacebrowser.ProgressMonitorBar;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.jini.core.lookup.ServiceID;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;

public class NewSpaceDialog
extends JDialog
implements ICreateSpace,
ActionListener {
    public final String TITLE = "Create New Space in Container ";
    public JButton butCreate;
    public JButton butCancel;
    public SpaceBrowser m_spaceBrowser;
    public SpaceConfigPanel m_spaceConfigPanel;
    public SpaceConfig m_spaceConfig;
    public IJSpaceContainer m_containerProxy;
    public String m_containerName;
    private List allSchamasList;
    private NewSchemaNameDialog newSchemaNameDialog;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
    private String selSchemaName;

    public NewSpaceDialog(SpaceBrowser spaceBrowser) {
        block2: {
            super((Frame)spaceBrowser, true);
            this.TITLE = "Create New Space in Container ";
            this.butCreate = new JButton();
            this.butCancel = new JButton();
            this.m_spaceBrowser = spaceBrowser;
            try {
                this.init();
                this.initDialogActions();
                this.cleanup();
                this.pack();
                this.setSize(new Dimension(this.getSize().width, (int)((double)this.getSize().height / 1.7)));
                JSpaceUtilities.setLocationRelativeTo(this, this.m_spaceBrowser);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    public void init() throws Exception {
        this.m_spaceConfigPanel = new SpaceConfigPanel(this.m_spaceBrowser, this);
        this.butCreate.setEnabled(false);
        this.butCreate.setText("Create");
        this.butCancel.setText("Cancel");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.butCreate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.butCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.m_spaceConfigPanel, "Center");
        jPanel2.add((Component)jPanel, "South");
    }

    public void setGenericPrincipal(GenericPrincipal[] genericPrincipalArray) {
        this.m_spaceConfigPanel.getAdvanced().setGenericPrincipal(genericPrincipalArray);
    }

    public void setUserDefinedRoles(UserDefinedRole[] userDefinedRoleArray) {
        this.m_spaceConfigPanel.getAdvanced().setUserDefinedRoles(userDefinedRoleArray);
    }

    public void cleanup() {
        this.m_spaceConfigPanel.cleanup();
        this.butCreate.setEnabled(false);
    }

    public void setDefaultSettings(ContainerConfig containerConfig) {
        Iterator iterator;
        Map map = containerConfig.getSpaceSchemasMap();
        this.initSchemasList(map);
        SpaceConfig spaceConfig = (SpaceConfig)map.get("default");
        if (spaceConfig == null && (iterator = map.values().iterator()).hasNext()) {
            spaceConfig = (SpaceConfig)iterator.next();
        }
        try {
            if (spaceConfig != null) {
                this.m_spaceConfigPanel.updateDialog(spaceConfig, false);
                this.m_spaceConfigPanel.setDefaultSpaceConfig(spaceConfig, map);
                this.m_spaceConfigPanel.setLoadOnStartupCheckBoxSelected(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        this.butCreate.setEnabled(false);
    }

    private void initDialogActions() {
        this.butCancel.addActionListener(this);
        this.butCreate.addActionListener(this);
        this.butCreate.setMnemonic(67);
        this.m_spaceConfigPanel.txtfSpaceName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (NewSpaceDialog.this.m_spaceConfigPanel.getSpaceName().trim().length() == 0) {
                    NewSpaceDialog.this.butCreate.setEnabled(false);
                } else {
                    if (NewSpaceDialog.this.m_spaceConfigPanel.getSelectedSchemaName() != null) {
                        NewSpaceDialog.this.butCreate.setEnabled(true);
                    }
                    if (keyEvent.getKeyCode() == 10 && NewSpaceDialog.this.butCreate.isEnabled()) {
                        NewSpaceDialog.this.performAction_Create();
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.butCancel) {
            this.dispose();
        } else if (object == this.butCreate) {
            this.performAction_Create();
        }
    }

    private void performAction_Create() {
        this.m_spaceConfig = this.m_spaceConfigPanel.getConfig();
        if (this.m_spaceConfig == null) {
            return;
        }
        final String string = this.m_spaceConfig.getSpaceName();
        SpaceConfig spaceConfig = this.m_spaceConfigPanel.getSelectedSpaceSchemaConfig();
        boolean bl2 = this.m_spaceConfig.isSpaceDefinitionEqual(spaceConfig);
        this.selSchemaName = null;
        if (!bl2) {
            if (this.newSchemaNameDialog == null) {
                this.newSchemaNameDialog = new NewSchemaNameDialog(this);
                JSpaceUtilities.setCenterAWTWindow(this.newSchemaNameDialog);
            }
            this.newSchemaNameDialog.setVisible(true);
            this.selSchemaName = this.newSchemaNameDialog.getNewSchemaName();
            if (this.selSchemaName == null) {
                this.m_spaceConfig = null;
            } else {
                this.m_spaceConfig.setSchemaName(this.selSchemaName);
            }
        } else {
            this.selSchemaName = this.m_spaceConfigPanel.getSelectedSchemaName();
            this.m_spaceConfig.setSchemaName(this.selSchemaName);
        }
        if (this.m_spaceConfig == null) {
            return;
        }
        String string2 = " ";
        String string3 = this.m_spaceConfig.getClusterConfigURL();
        if (this.m_spaceConfig.isClustered() && string3 != null && !string3.equals("none") && string3.trim().length() > 0) {
            string2 = " CLUSTERED ";
        }
        final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(this.m_spaceBrowser, "Creating" + string2 + "space: " + string, "Container name: " + this.m_containerName);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    IJSpaceContainer iJSpaceContainer = NewSpaceDialog.this.m_containerProxy;
                    IJSpace iJSpace = iJSpaceContainer.createSpace(string, NewSpaceDialog.this.m_spaceConfig);
                    iJSpace.ping();
                    Uuid uuid = ((ReferentUuid)((Object)iJSpace)).getReferentUuid();
                    ServiceID serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                    NewSpaceDialog.this.m_spaceBrowser.addSpaceNode(iJSpaceContainer, iJSpace, serviceID);
                    NewSpaceDialog.this.m_spaceBrowser.addSpaceConfigToContainerConfig(NewSpaceDialog.this.m_containerName, NewSpaceDialog.this.selSchemaName, NewSpaceDialog.this.m_spaceConfig);
                    NewSpaceDialog.this.m_spaceBrowser.getSpaceConfigDialog().updateDialog(NewSpaceDialog.this.m_spaceConfig, false);
                    NewSpaceDialog.this.m_spaceBrowser.showStatus(string + " space created in " + NewSpaceDialog.this.m_containerName + " successfully");
                    progressMonitorBar.terminate();
                }
                catch (CreateException createException) {
                    NewSpaceDialog.this.m_spaceBrowser.showStatus("Create " + string + " space failed: " + createException.getMessage());
                    progressMonitorBar.terminate();
                    Throwable throwable = createException.getCause();
                    if (throwable instanceof InvalidSpaceNameException) {
                        String string2 = throwable.getMessage();
                        JOptionPane.showMessageDialog(NewSpaceDialog.this.m_spaceBrowser, string2, "Invalid space name", 2);
                    } else {
                        SpaceBrowser.expDialog.showException("creating " + string + " space", createException);
                    }
                }
                catch (Exception exception) {
                    NewSpaceDialog.this.m_spaceBrowser.showStatus("Create " + string + " space failed: " + exception.getMessage());
                    progressMonitorBar.terminate();
                    SpaceBrowser.expDialog.showException("creating " + string + " space", exception);
                }
            }
        });
        this.dispose();
        progressMonitorBar.start();
        thread.start();
    }

    public void setContainer(String string, IJSpaceContainer iJSpaceContainer) {
        this.m_containerName = string;
        this.m_containerProxy = iJSpaceContainer;
        this.setTitle("Create New Space in Container " + string);
    }

    public SortFiltersDialog getFiltersDialog() {
        return this.m_spaceConfigPanel.getAdvanced().getFiltersDialog();
    }

    private void initSchemasList(Map map) {
        this.allSchamasList = new ArrayList(map.keySet());
    }

    public boolean isSchemaNameExists(String string) {
        boolean bl2 = this.allSchamasList.contains(string);
        return bl2;
    }
}

