/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.gk;
import com.j_spaces.obf.li;
import com.j_spaces.tools.spacebrowser.ProgressMonitorBar;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.StaleContainerService;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.XMLFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContainerConfigPanel
extends JPanel
implements ActionListener {
    private static final String DIALOG_CONTAINERCONFIG_LABEL = "dialog.containerconfig.labels";
    private static final String DIALOG_CONTAINERCONFIG_TOOLTIP = "dialog.containerconfig.tooltip";
    private static final String DIALOG_CONTAINERCONFIG_BUTTON = "dialog.containerconfig.button";
    public String[] resLabel;
    public String[] resButton;
    public String[] resTooltip;
    public JTabbedPane tabPanContainer = new JTabbedPane();
    public JScrollPane scrollPanGeneral = new JScrollPane();
    public JScrollPane scrollPanDirectoryServices = new JScrollPane();
    public JScrollPane scrollPanJms = new JScrollPane();
    public JPanel panConfigContainer = new JPanel();
    public JPanel panControlButtons = new JPanel();
    public JPanel panDirServices = new JPanel();
    public JPanel panEmbRadioBut = new JPanel();
    public JPanel panGeneral = new JPanel();
    public JPanel panJndiOptions = new JPanel();
    public JPanel panLookupOptions = new JPanel();
    public JPanel panSecurity = new JPanel();
    public JPanel panRadioButton = new JPanel();
    public JPanel panJms = new JPanel();
    public JCheckBox jndiCheckBox = new JCheckBox();
    public JCheckBox lusCheckBox = new JCheckBox();
    public JCheckBox unicastCheckBox = new JCheckBox();
    private JTextField unicastHostTextField = new JTextField();
    private JTextField jndiUrlTextField = new JTextField();
    private JTextField groupTextField = new JTextField();
    private JTextField licenseTextField = new JTextField();
    private JTextField homeDirTextField = new JTextField();
    private JTextField containerNameTxtField = new JTextField();
    private JTextField hostNameTxtField = new JTextField();
    public JLabel unicastLabel = new JLabel();
    public JLabel groupLabel = new JLabel();
    public JLabel jndiUrlLabel = new JLabel();
    public JLabel licenseLabel = new JLabel();
    public JLabel homeDirLabel = new JLabel();
    public ButtonGroup rbuttonGroup = new ButtonGroup();
    public ButtonGroup radioButtonGroup = new ButtonGroup();
    public JRadioButton fullControlRB = new JRadioButton("Full Control");
    public JRadioButton readOnlyRB = new JRadioButton("Read Only");
    private JButton saveButton = new JButton();
    private JButton saveAsButton = new JButton();
    public JCheckBox chboxJmsExtJndiEnabled = new JCheckBox();
    public JCheckBox chboxJmsEnabled = new JCheckBox();
    public JCheckBox chboxJmsIntJndiEnabled = new JCheckBox();
    public JTabbedPane tabbedPane = new JTabbedPane();
    private SpaceBrowser m_spaceBrowser;
    private JTextField containerSocketPortTextField = new WholeNumberField();
    public final int JNDI_MODE = 1;
    public final int LUS_MODE = 2;
    public final int JNDI_MODE_AND_LUS_MODE = 3;
    private JFileChooser fileChooser;
    private static final String CONTAINER_SCHEMA_POSTFIX_FILE_NAME = "*-container-schema.xml";
    private static final String CONTAINER_CONFIG_SUFFIX = "-config.xml";
    private static final String CONTAINER_CONFIG_POSTFIX_FILE_NAME = "*-config.xml";
    private final XMLFileFilter containerSchemaFileFilter = new XMLFileFilter("Schema File( *-container-schema.xml )");
    private final XMLFileFilter containerConfigFileFilter = new XMLFileFilter("Configuration File( *-config.xml )");

    public ContainerConfigPanel(SpaceBrowser spaceBrowser) {
        this.m_spaceBrowser = spaceBrowser;
        try {
            this.init();
            this.cleanup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            this.invokeSave();
        } else if (object == this.saveAsButton) {
            this.invokeSaveAs();
        } else if (object == this.chboxJmsEnabled) {
            this.chboxJmsExtJndiEnabled.setEnabled(this.chboxJmsEnabled.isSelected());
            this.chboxJmsIntJndiEnabled.setEnabled(this.chboxJmsEnabled.isSelected());
        } else if (object == this.jndiCheckBox) {
            JSpaceUtilities.setAWTComponentsStatus(this.panJndiOptions, this.jndiCheckBox.isSelected());
            this.jndiUrlTextField.setEditable(this.jndiCheckBox.isSelected());
        } else if (object == this.lusCheckBox) {
            JSpaceUtilities.setAWTComponentsStatus(this.panLookupOptions, this.lusCheckBox.isSelected());
            this.groupTextField.setEditable(this.lusCheckBox.isSelected());
            this.unicastHostTextField.setEditable(this.unicastCheckBox.isEnabled() && this.unicastCheckBox.isSelected());
        } else if (object == this.unicastCheckBox) {
            this.unicastHostTextField.setEditable(this.unicastCheckBox.isSelected());
        }
    }

    public void init() throws Exception {
        this.resLabel = SpaceBrowser.getResources(DIALOG_CONTAINERCONFIG_LABEL);
        this.resButton = SpaceBrowser.getResources(DIALOG_CONTAINERCONFIG_BUTTON);
        this.resTooltip = SpaceBrowser.getResources(DIALOG_CONTAINERCONFIG_TOOLTIP);
        this.saveButton.setText(this.resButton[0]);
        this.saveButton.setEnabled(false);
        this.saveAsButton.setText(this.resButton[1]);
        this.saveAsButton.setEnabled(false);
        this.panControlButtons.setLayout(new GridBagLayout());
        this.homeDirLabel.setText(this.resLabel[1]);
        this.licenseLabel.setText(this.resLabel[2]);
        this.groupLabel.setText(this.resLabel[7]);
        this.unicastLabel.setText(this.resLabel[9]);
        this.homeDirTextField.setEditable(false);
        this.containerNameTxtField.setEditable(false);
        this.hostNameTxtField.setEditable(false);
        this.homeDirTextField.setToolTipText(this.resTooltip[0]);
        this.licenseTextField.setToolTipText(this.resTooltip[1]);
        this.jndiCheckBox.setToolTipText(this.resTooltip[2]);
        this.jndiUrlTextField.setToolTipText(this.resTooltip[3]);
        this.lusCheckBox.setToolTipText(this.resTooltip[4]);
        this.groupTextField.setToolTipText(this.resTooltip[5]);
        this.unicastCheckBox.setToolTipText(this.resTooltip[6]);
        this.unicastHostTextField.setToolTipText(this.resTooltip[7]);
        this.jndiUrlLabel.setText(this.resLabel[5]);
        this.jndiCheckBox.setText(this.resLabel[4]);
        this.lusCheckBox.setText(this.resLabel[6]);
        this.unicastCheckBox.setText(this.resLabel[8]);
        this.panGeneral.setLayout(new GridBagLayout());
        this.panDirServices.setLayout(new GridBagLayout());
        this.panLookupOptions.setLayout(new GridBagLayout());
        this.panEmbRadioBut.setLayout(new BoxLayout2());
        this.panJndiOptions.setLayout(new BorderLayout());
        this.panConfigContainer.setLayout(new VerticalFlowLayout());
        this.panJms.setLayout(new GridBagLayout());
        this.panJndiOptions.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "JNDI Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panLookupOptions.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Lookup Service Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panDirServices.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), this.resLabel[3]), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panSecurity.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Security Mode"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.unicastCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.jndiUrlLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.panGeneral.add((Component)new JLabel("Container name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.containerNameTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)new JLabel("Host name: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.hostNameTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.homeDirLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.licenseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)new JLabel("Container Socket Port:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.homeDirTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.licenseTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.containerSocketPortTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panSecurity.setLayout(new BorderLayout());
        this.radioButtonGroup.add(this.fullControlRB);
        this.radioButtonGroup.add(this.readOnlyRB);
        this.panSecurity.add((Component)this.panRadioButton, "West");
        this.panRadioButton.add((Component)this.fullControlRB, null);
        this.panRadioButton.add((Component)this.readOnlyRB, null);
        this.fullControlRB.setSelected(true);
        this.readOnlyRB.setRequestFocusEnabled(false);
        this.fullControlRB.setRequestFocusEnabled(false);
        this.panJndiOptions.add((Component)this.jndiUrlLabel, "West");
        this.panJndiOptions.add((Component)this.jndiUrlTextField, "Center");
        this.panLookupOptions.add((Component)this.groupLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.unicastCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.unicastLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.groupTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.unicastHostTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panDirServices.add((Component)this.jndiCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.panDirServices.add((Component)this.panJndiOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panDirServices.add((Component)this.lusCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 5, 0), 0, 0));
        this.panDirServices.add((Component)this.panLookupOptions, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.chboxJmsEnabled.setText("JMS Enabled");
        this.chboxJmsIntJndiEnabled.setText("Internal JNDI Enabled");
        this.chboxJmsExtJndiEnabled.setText("External JNDI Enabled");
        this.panJms.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "JMS"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panJms.setLayout(new GridBagLayout());
        this.panJms.add((Component)this.chboxJmsEnabled, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.chboxJmsIntJndiEnabled, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.chboxJmsExtJndiEnabled, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.chboxJmsEnabled.addActionListener(this);
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.add(this.panGeneral);
        jPanel.add(this.panSecurity);
        this.scrollPanGeneral.getViewport().add((Component)jPanel, null);
        this.scrollPanDirectoryServices.getViewport().setLayout(new VerticalFlowLayout());
        this.scrollPanDirectoryServices.getViewport().add((Component)this.panDirServices, null);
        this.scrollPanJms.getViewport().setLayout(new VerticalFlowLayout());
        this.scrollPanJms.getViewport().add((Component)this.panJms, null);
        this.tabPanContainer.add((Component)this.scrollPanGeneral, "General");
        this.tabPanContainer.add((Component)this.scrollPanDirectoryServices, "Directory Services");
        this.tabPanContainer.add((Component)this.scrollPanJms, "JMS");
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addTab("Container Configuration", this.tabPanContainer);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 0.0;
        this.panControlButtons.add((Component)this.saveButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.panControlButtons.add(this.saveAsButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panControlButtons, "South");
        this.add((Component)this.tabbedPane, "Center");
        this.jndiCheckBox.setSelected(true);
        this.lusCheckBox.setSelected(true);
        this.unicastHostTextField.setEditable(false);
        this.jndiUrlTextField.setEditable(this.jndiCheckBox.isSelected());
        this.unicastCheckBox.setRequestFocusEnabled(false);
        this.lusCheckBox.setRequestFocusEnabled(false);
        this.jndiCheckBox.setRequestFocusEnabled(false);
        this.saveButton.addActionListener(this);
        this.saveAsButton.addActionListener(this);
        this.jndiCheckBox.addActionListener(this);
        this.lusCheckBox.addActionListener(this);
        this.unicastCheckBox.addActionListener(this);
    }

    private void invokeSave() {
        this.saveButton.setEnabled(false);
        this.saveAsButton.setEnabled(false);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_spaceBrowser.getSelectedTreeNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof StaleContainerService) {
            return;
        }
        JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)object;
        jSpaceProxyWrapper.isContainerConfigUpdated = true;
        IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)jSpaceProxyWrapper.proxy();
        ContainerConfig containerConfig = this.getConfig(defaultMutableTreeNode.toString());
        if (containerConfig != null) {
            Thread thread = new Thread(new ConfigUpdater(containerConfig, defaultMutableTreeNode, iJSpaceContainerAdmin, null));
            thread.start();
        }
    }

    private ContainerConfig getConfig(String string) {
        ContainerConfig containerConfig = SpaceBrowser.getContainerConfig(string);
        if (containerConfig == null) {
            return null;
        }
        containerConfig.homeDir = this.homeDirTextField.getText();
        containerConfig.containerHostName = this.hostNameTxtField.getText();
        String string2 = containerConfig.securityMode = this.fullControlRB.isSelected() ? "FULL_CONTROL" : "READ_ONLY";
        if (this.jndiUrlTextField.getText().trim().length() != 0) {
            containerConfig.jndiUrl = this.jndiUrlTextField.getText();
        }
        if (this.groupTextField.getText().trim().length() != 0) {
            containerConfig.lookupGroups = this.groupTextField.getText();
        }
        if (this.licenseTextField.getText().trim().length() != 0) {
            containerConfig.license = this.licenseTextField.getText();
        }
        if (this.containerSocketPortTextField.getText().trim().length() != 0) {
            containerConfig.socketPort = Integer.parseInt(this.containerSocketPortTextField.getText());
        }
        containerConfig.setJndiEnabled(this.jndiCheckBox.isSelected());
        containerConfig.setJiniLusEnabled(this.lusCheckBox.isSelected());
        containerConfig.unicastEnabled = this.unicastCheckBox.isEnabled() && this.unicastCheckBox.isSelected();
        if (this.unicastHostTextField.getText().trim().length() != 0) {
            containerConfig.unicastURL = this.unicastHostTextField.getText();
        }
        containerConfig.jmsEnabled = this.chboxJmsEnabled.isSelected();
        containerConfig.jmsInternalJndiEnabled = this.chboxJmsIntJndiEnabled.isSelected();
        containerConfig.jmsExtJndiEnabled = this.chboxJmsExtJndiEnabled.isSelected();
        return containerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSaveAs() {
        Object object;
        if (this.fileChooser == null) {
            try {
                this.m_spaceBrowser.setCursor(Cursor.getPredefinedCursor(3));
                this.fileChooser = new JFileChooser();
                this.fileChooser.addChoosableFileFilter(this.containerSchemaFileFilter);
                this.fileChooser.addChoosableFileFilter(this.containerConfigFileFilter);
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.setDialogTitle("Save Container As");
                this.fileChooser.setFileFilter(this.containerSchemaFileFilter);
                object = li.b();
                this.fileChooser.setCurrentDirectory(new File((String)object));
            }
            finally {
                this.m_spaceBrowser.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.fileChooser.showSaveDialog(this.m_spaceBrowser);
        object = this.fileChooser.getFileFilter();
        File file = this.fileChooser.getSelectedFile();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_spaceBrowser.getSelectedTreeNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof StaleContainerService) {
            return;
        }
        JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)object2;
        jSpaceProxyWrapper.isContainerConfigUpdated = true;
        ContainerConfig containerConfig = this.getConfig(defaultMutableTreeNode.toString());
        if (file != null) {
            String string = file.getName();
            String string2 = file.getPath();
            if (object.equals(this.containerSchemaFileFilter)) {
                string2 = string2 + "-container-schema.xml";
            } else if (object.equals(this.containerConfigFileFilter)) {
                string2 = string2 + CONTAINER_CONFIG_SUFFIX;
            }
            gk.a(string, string2, containerConfig);
        }
    }

    public void updateConfig(IJSpaceContainerAdmin iJSpaceContainerAdmin) {
        if (iJSpaceContainerAdmin == null) {
            return;
        }
        this.saveButton.setEnabled(true);
        this.saveAsButton.setEnabled(true);
        String string = null;
        try {
            string = iJSpaceContainerAdmin.getName();
            ContainerConfig containerConfig = SpaceBrowser.addContainerToMap(iJSpaceContainerAdmin);
            if (containerConfig != null) {
                this.tabbedPane.setSelectedIndex(0);
            }
            if (containerConfig.securityMode.equalsIgnoreCase("FULL_CONTROL")) {
                this.fullControlRB.setSelected(true);
            } else {
                this.readOnlyRB.setSelected(true);
            }
            this.jndiCheckBox.setSelected(false);
            this.lusCheckBox.setSelected(false);
            boolean bl2 = containerConfig.isJndiEnabled();
            boolean bl3 = containerConfig.isJiniLusEnabled();
            this.jndiCheckBox.setSelected(bl2);
            JSpaceUtilities.setAWTComponentsStatus(this.panJndiOptions, bl2);
            this.jndiUrlTextField.setEditable(bl2);
            this.lusCheckBox.setSelected(bl3);
            JSpaceUtilities.setAWTComponentsStatus(this.panLookupOptions, bl3);
            this.groupTextField.setEditable(bl3);
            if (containerConfig.usersInfo != null) {
                this.m_spaceBrowser.newSpaceDialog.setGenericPrincipal(containerConfig.usersInfo);
                this.m_spaceBrowser.spaceConfigPanel.setGenericPrincipal(containerConfig.usersInfo);
            }
            if (containerConfig.userDefinedRoles != null) {
                this.m_spaceBrowser.newSpaceDialog.setUserDefinedRoles(containerConfig.userDefinedRoles);
                this.m_spaceBrowser.spaceConfigPanel.getAdvanced().setUserDefinedRoles(containerConfig.userDefinedRoles);
            }
            this.containerSocketPortTextField.setText("" + containerConfig.socketPort);
            GenericPrincipal genericPrincipal = new GenericPrincipal(containerConfig.adminName, containerConfig.adminPassword);
            this.m_spaceBrowser.newSpaceDialog.getFiltersDialog().setAdminAccount(genericPrincipal);
            this.m_spaceBrowser.spaceConfigPanel.getAdvanced().getFiltersDialog().setAdminAccount(genericPrincipal);
            this.containerNameTxtField.setText(string);
            this.hostNameTxtField.setText(containerConfig.containerHostName);
            this.homeDirTextField.setText(containerConfig.homeDir);
            this.licenseTextField.setText(containerConfig.license);
            this.jndiUrlTextField.setText(containerConfig.jndiUrl);
            this.groupTextField.setText(containerConfig.lookupGroups);
            this.unicastCheckBox.setSelected(containerConfig.unicastEnabled);
            this.unicastHostTextField.setText(containerConfig.unicastURL);
            this.unicastHostTextField.setEditable(containerConfig.unicastEnabled);
            this.chboxJmsEnabled.setSelected(containerConfig.jmsEnabled);
            this.chboxJmsIntJndiEnabled.setSelected(containerConfig.jmsInternalJndiEnabled);
            this.chboxJmsExtJndiEnabled.setSelected(containerConfig.jmsExtJndiEnabled);
            JSpaceUtilities.setAWTComponentsStatus(this.panJms, this.chboxJmsEnabled.isSelected());
        }
        catch (Exception exception) {
            this.saveButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            SpaceBrowser.expDialog.showException("updating container configuration", exception);
        }
    }

    public void cleanup() {
        this.saveButton.setEnabled(false);
        this.saveAsButton.setEnabled(false);
        this.jndiCheckBox.setSelected(true);
        this.lusCheckBox.setSelected(true);
        this.unicastCheckBox.setSelected(false);
        this.unicastCheckBox.setEnabled(false);
        this.unicastHostTextField.setEditable(false);
        this.containerNameTxtField.setText("");
        this.hostNameTxtField.setText("");
        this.homeDirTextField.setText("");
        this.licenseTextField.setText("");
        this.groupTextField.setText("");
        this.jndiUrlTextField.setText("");
        this.unicastHostTextField.setText("");
        JSpaceUtilities.setAWTComponentsStatus(this.panJms, this.chboxJmsEnabled.isSelected());
    }

    public String getContainerName() {
        return this.containerNameTxtField.getText();
    }

    public static class 1 {
    }

    private class ConfigUpdater
    implements Runnable {
        private ContainerConfig config;
        private DefaultMutableTreeNode conNode;
        private IJSpaceContainerAdmin conAdmin;
        private ProgressMonitorBar progressBar;
        private String containerName;

        private ConfigUpdater(ContainerConfig containerConfig, DefaultMutableTreeNode defaultMutableTreeNode, IJSpaceContainerAdmin iJSpaceContainerAdmin) {
            this.config = containerConfig;
            this.conNode = defaultMutableTreeNode;
            this.conAdmin = iJSpaceContainerAdmin;
            this.containerName = defaultMutableTreeNode.toString();
            this.progressBar = new ProgressMonitorBar(ContainerConfigPanel.this.m_spaceBrowser, "Updating container configuration:", defaultMutableTreeNode.toString());
            this.progressBar.start();
        }

        public void run() {
            block5: {
                try {
                    SpaceBrowser.addContainerToMap(this.config, this.containerName);
                    this.conAdmin.setConfig(this.config);
                    Thread.sleep(2000L);
                    this.progressBar.terminate();
                    ContainerConfigPanel.this.m_spaceBrowser.showStatus("Configuration of " + this.conNode + " container updated successfully!");
                    int n2 = JOptionPane.showConfirmDialog(ContainerConfigPanel.this.m_spaceBrowser, this.conNode + " container updated successfully!" + "\nYou need to restart the GigaSpaces Server in order for the new configuration to take effect.", "Updating container configuration...", 2);
                    if (n2 == 0) {
                        ContainerConfigPanel.this.m_spaceBrowser.restartSelectedContainer();
                    }
                }
                catch (Exception exception) {
                    Throwable throwable;
                    String string;
                    boolean bl2 = false;
                    if (exception instanceof RemoteException && (string = (throwable = ((RemoteException)exception).detail).getMessage()).indexOf("Access is denied") != -1) {
                        bl2 = true;
                        this.progressBar.terminate();
                        String string2 = "Unable to change container schema/configuration file since it has read-only permission.";
                        String string3 = "Do you want to save container configuration locally?";
                        int n3 = JOptionPane.showConfirmDialog(ContainerConfigPanel.this.m_spaceBrowser, string2 + "\n" + string3, "Access is denied", 0, 2);
                        if (n3 == 0) {
                            ContainerConfigPanel.this.invokeSaveAs();
                        }
                    }
                    if (bl2) break block5;
                    ContainerConfigPanel.this.m_spaceBrowser.showStatus("Updating configuration of " + this.conNode + " container failed: " + exception.getMessage());
                    this.progressBar.terminate();
                    SpaceBrowser.expDialog.showException("updating configuration of " + this.conNode + " container", exception);
                }
            }
            ContainerConfigPanel.this.saveButton.setEnabled(true);
            ContainerConfigPanel.this.saveAsButton.setEnabled(true);
        }

        public /* synthetic */ ConfigUpdater(ContainerConfig containerConfig, DefaultMutableTreeNode defaultMutableTreeNode, IJSpaceContainerAdmin iJSpaceContainerAdmin, 1 var5_5) {
            this(containerConfig, defaultMutableTreeNode, iJSpaceContainerAdmin);
        }
    }
}

