/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.view.ClusterViewMenuBar;
import com.j_spaces.tools.cluster.view.Edge;
import com.j_spaces.tools.cluster.view.GraphPanel;
import com.j_spaces.tools.cluster.view.GroupPanel;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.Node;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MembersGraphPanel
extends GraphPanel
implements IRefreshable {
    private GroupPanel m_owner;
    private ClusterMemberInfo[] m_membersInfo;
    private char[] m_memberType = new char[]{' '};
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public MembersGraphPanel(Component component, ClusterMemberInfo[] clusterMemberInfoArray) {
        this.setGraphPanel(component, 23, 80);
        this.setFont(new Font("Tahoma", 0, 11));
        this.m_owner = (GroupPanel)component;
        this.init(clusterMemberInfoArray);
    }

    public void init(ClusterMemberInfo[] clusterMemberInfoArray) {
        if (clusterMemberInfoArray != null && this.m_membersInfo != clusterMemberInfoArray) {
            this.m_membersInfo = clusterMemberInfoArray;
            this.clearTransmTable();
            this.reset();
            ClusterMemberInfo[] clusterMemberInfoArray2 = this.m_membersInfo;
            int n2 = clusterMemberInfoArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ClusterMemberInfo clusterMemberInfo = clusterMemberInfoArray2[i2];
                this.addNode(clusterMemberInfo.memberName, clusterMemberInfo.getClusterName(), clusterMemberInfo.getGroupName(), clusterMemberInfo.getSpaceID(), clusterMemberInfo.isMirror());
            }
        }
    }

    public void paintNode(Graphics graphics, Node node, FontMetrics fontMetrics) {
        if (ClusterViewMenuBar.SHOW_OVAL) {
            this.paintOvalNode(graphics, node, fontMetrics);
        } else {
            this.paintRectNode(graphics, node, fontMetrics);
        }
    }

    private void paintOvalNode(Graphics graphics, Node node, FontMetrics fontMetrics) {
        int n2 = (int)node.x;
        int n3 = (int)node.y;
        int n4 = this.nodeRadius;
        int n5 = this.nodeRadius;
        graphics.setColor(MembersLegend.getColor(node.status));
        graphics.fillOval(n2 - n4 / 2, n3 - n5 / 2, n4, n5);
        if (node.equals(this.source)) {
            graphics.setColor(MembersLegend.getColor("Source"));
            graphics.drawOval(n2 - n4 / 2, n3 - n5 / 2, n4 - 1, n5 - 1);
        } else if (node.isTarget) {
            graphics.setColor(MembersLegend.getColor("Target"));
            graphics.drawOval(n2 - n4 / 2, n3 - n5 / 2, n4 - 1, n5 - 1);
        }
        graphics.setColor(Color.black);
        graphics.drawString(node.token1, n2 - fontMetrics.stringWidth(node.token1) / 2, n3 + (n5 + 4) / 2 + fontMetrics.getAscent());
        graphics.drawString(node.token2, n2 - fontMetrics.stringWidth(node.token2) / 2, n3 + (n5 + 4) / 2 + fontMetrics.getAscent() * 2);
        if (node.status.equals("Alive") || node.status.equals("MirrorAlive")) {
            graphics.drawChars(this.m_memberType, 0, 1, n2 - n4 / 7, n3 + n5 / 5);
        }
    }

    private void paintRectNode(Graphics graphics, Node node, FontMetrics fontMetrics) {
        int n2 = (int)node.x;
        int n3 = (int)node.y;
        int n4 = fontMetrics.stringWidth(node.lbl) + 10;
        int n5 = this.nodeRadius;
        graphics.setColor(MembersLegend.getColor(ServiceManagerImpl.getMemberStatus(node.lbl, node.isMirror())));
        graphics.fillRect(n2 - n4 / 2, n3 - n5 / 2, n4, n5);
        if (node.equals(this.source)) {
            graphics.setColor(MembersLegend.getColor("Source"));
            graphics.drawRect(n2 - n4 / 2, n3 - n5 / 2, n4 - 1, n5 - 1);
        } else if (node.isTarget) {
            graphics.setColor(MembersLegend.getColor("Target"));
            graphics.drawRect(n2 - n4 / 2, n3 - n5 / 2, n4 - 1, n5 - 1);
        }
        graphics.setColor(Color.black);
        graphics.drawString(node.lbl, n2 - (n4 - 10) / 2, n3 - (n5 - 4) / 2 + fontMetrics.getAscent());
    }

    public void clearEdgesList() {
        this.edgesList.clear();
        this.nedges = 0;
        this.source = null;
        int n2 = this.nodesList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.nodesList.get((int)i2)).isTarget = false;
        }
    }

    public void performNodeAction(String string) {
        this.performNodeAction(this.getNodebyId(string));
    }

    public void performNodeAction(Node node) {
        this.m_owner.setMemberForRuntimePanel(node.lbl);
        if (!this.m_owner.isReplicationGroup()) {
            return;
        }
        this.m_owner.setClusterTreeNode(node.getNodeId());
        this.m_owner.getTrasmissionPanel().updateTransmTable(node.lbl);
        this.source = node;
        this.pick = null;
        this.nedges = 0;
        this.edgesList = new ArrayList(100);
        for (int i2 = 0; i2 < this.nnodes; ++i2) {
            ((Node)this.nodesList.get((int)i2)).isTarget = false;
        }
        ClusterMemberInfo clusterMemberInfo = this.getMemberInfo(node.lbl);
        if (clusterMemberInfo == null) {
            return;
        }
        ArrayList arrayList = this.checkForTargets(clusterMemberInfo, this.m_membersInfo);
        String string = clusterMemberInfo.getClusterName();
        String string2 = clusterMemberInfo.getGroupName();
        if (!node.isMirror()) {
            String string3;
            int n2;
            if (arrayList != null && arrayList.size() > 0) {
                n2 = arrayList.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    string3 = JSpaceUtilities.createClusterGuiId(string, string2, clusterMemberInfo.memberName);
                    String string4 = JSpaceUtilities.createClusterGuiId(string, string2, (String)arrayList.get(i3));
                    this.addEdge(string3, string4, this.edgeLength, true, false);
                }
            }
            if (ClusterViewMenuBar.SHOW_BACKWARD_REPLICATION) {
                for (n2 = 0; n2 < this.m_membersInfo.length; ++n2) {
                    arrayList = this.checkForTargets(this.m_membersInfo[n2], new ClusterMemberInfo[]{clusterMemberInfo});
                    if (arrayList == null || arrayList.size() != 1) continue;
                    String string5 = JSpaceUtilities.createClusterGuiId(string, string2, this.m_membersInfo[n2].memberName);
                    string3 = JSpaceUtilities.createClusterGuiId(string, string2, clusterMemberInfo.memberName);
                    this.addEdge(string5, string3, this.edgeLength, true, true);
                }
            }
        }
        this.refresh();
    }

    public void clearTransmTable() {
        this.m_owner.getTrasmissionPanel().clearTransmDetails();
    }

    private ArrayList checkForTargets(ClusterMemberInfo clusterMemberInfo, ClusterMemberInfo[] clusterMemberInfoArray) {
        Hashtable<String, ReplicationTransmissionPolicy> hashtable = new Hashtable<String, ReplicationTransmissionPolicy>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (clusterMemberInfo != null && clusterMemberInfo.m_replTransmissionPolicies != null && clusterMemberInfo.m_replTransmissionPolicies.size() > 0) {
            ReplicationTransmissionPolicy replicationTransmissionPolicy;
            Iterator iterator = clusterMemberInfo.m_replTransmissionPolicies.iterator();
            while (iterator.hasNext()) {
                replicationTransmissionPolicy = (ReplicationTransmissionPolicy)iterator.next();
                hashtable.put(replicationTransmissionPolicy.m_TargetSpace, replicationTransmissionPolicy);
            }
            for (int i2 = 0; i2 < clusterMemberInfoArray.length; ++i2) {
                replicationTransmissionPolicy = null;
                if (clusterMemberInfoArray[i2].memberName.equals(clusterMemberInfo.memberName)) continue;
                if (hashtable.containsKey(clusterMemberInfoArray[i2].memberName)) {
                    replicationTransmissionPolicy = (ReplicationTransmissionPolicy)hashtable.get(clusterMemberInfoArray[i2].memberName);
                    if (replicationTransmissionPolicy.m_DisableTransmission) continue;
                    arrayList.add(replicationTransmissionPolicy.m_TargetSpace);
                    continue;
                }
                arrayList.add(clusterMemberInfoArray[i2].memberName);
            }
        } else {
            for (int i3 = 0; i3 < clusterMemberInfoArray.length; ++i3) {
                arrayList.add(clusterMemberInfoArray[i3].memberName);
            }
        }
        return arrayList;
    }

    public boolean isRunning() {
        return !this.paused;
    }

    public void refresh() {
        block8: {
            SpaceConfig spaceConfig = null;
            for (int i2 = 0; i2 < this.nnodes; ++i2) {
                Node node = (Node)this.nodesList.get(i2);
                node.status = ServiceManagerImpl.getMemberStatus(node.lbl, node.isMirror());
                if (!node.status.equals("Alive") && !node.status.equals("MirrorAlive")) continue;
                spaceConfig = ServiceManagerImpl.getSpaceConfig(node.lbl);
            }
            if (this.source != null) {
                try {
                    ServiceManagerImpl.ReplicationStatus replicationStatus = ServiceManagerImpl.getReplicationStatus(this.source.lbl);
                    Hashtable hashtable = this.findEdges(this.source);
                    if (replicationStatus != null) {
                        for (int i3 = 0; i3 < replicationStatus.targets.length; ++i3) {
                            Edge edge = (Edge)hashtable.get(replicationStatus.targets[i3]);
                            if (edge == null) continue;
                            edge.setStatus(replicationStatus.tstatus[i3]);
                        }
                    } else {
                        Enumeration enumeration = hashtable.elements();
                        while (enumeration.hasMoreElements()) {
                            ((Edge)enumeration.nextElement()).setStatus(1);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block8;
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }
    }

    private ClusterMemberInfo getMemberInfo(String string) {
        for (int i2 = 0; i2 < this.m_membersInfo.length; ++i2) {
            if (!this.m_membersInfo[i2].memberName.equals(string)) continue;
            return this.m_membersInfo[i2];
        }
        return null;
    }

    public void addClusterMember(ClusterMemberInfo clusterMemberInfo) {
        ClusterMemberInfo[] clusterMemberInfoArray = new ClusterMemberInfo[this.m_membersInfo.length + 1];
        for (int i2 = 0; i2 < this.m_membersInfo.length; ++i2) {
            clusterMemberInfoArray[i2] = this.m_membersInfo[i2];
        }
        clusterMemberInfoArray[i2] = clusterMemberInfo;
        this.m_membersInfo = clusterMemberInfoArray;
        int n2 = this.addNode(clusterMemberInfo.memberName, clusterMemberInfo.getClusterName(), clusterMemberInfo.getGroupName(), clusterMemberInfo.getSpaceID(), clusterMemberInfo.isMirror());
        this.performNodeAction(this.getNodeByIndex(n2));
    }

    public void removeClusterMember() {
    }
}

