/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnSortListener
extends MouseAdapter {
    public boolean ascending = false;

    public void mouseClicked(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        JTable jTable = jTableHeader.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        TableColumn tableColumn = tableColumnModel.getColumn(n2);
        this.sortAllRowsBy((DefaultTableModel)jTable.getModel(), n2, this.ascending);
        this.ascending = !this.ascending;
    }

    public void sortAllRowsBy(DefaultTableModel defaultTableModel, int n2, boolean bl2) {
        Vector<Vector> vector = defaultTableModel.getDataVector();
        Collections.sort(vector, new ColumnSorter(n2, bl2));
        defaultTableModel.fireTableStructureChanged();
    }

    public class ColumnSorter
    implements Comparator {
        public int colIndex;
        public boolean ascending;

        public ColumnSorter(int n2, boolean bl2) {
            this.colIndex = n2;
            this.ascending = bl2;
        }

        public int compare(Object object, Object object2) {
            Vector vector = (Vector)object;
            Vector vector2 = (Vector)object2;
            Object e2 = vector.get(this.colIndex);
            Object e3 = vector2.get(this.colIndex);
            if (e2 instanceof String && ((String)e2).length() == 0) {
                e2 = null;
            }
            if (e3 instanceof String && ((String)e3).length() == 0) {
                e3 = null;
            }
            if (e2 == null && e3 == null) {
                return 0;
            }
            if (e2 == null) {
                return 1;
            }
            if (e3 == null) {
                return -1;
            }
            if (e2 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)e2).compareTo(e3);
                }
                return ((Comparable)e3).compareTo(e2);
            }
            if (this.ascending) {
                return e2.toString().compareTo(e3.toString());
            }
            return e3.toString().compareTo(e2.toString());
        }
    }
}

