/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.core.cluster.dynamic.IMemberData;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.GroupPanel;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClusterTree
extends JPanel {
    private DefaultMutableTreeNode[] m_groupTreeNodes;
    private JTree m_tree;
    private Vector m_DynamicMembers;
    private ClusterViewDlg m_owner;
    private GroupInfo[] m_groupsInfo;
    private String m_clusterName;
    private SpaceBrowser _spaceBrowser;
    private Map _allGroupsNodesMap;
    private Map _allMembersNodesMap;
    private Map _allGroupInfoMap;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public ClusterTree(ClusterViewDlg clusterViewDlg, String string, GroupInfo[] groupInfoArray, SpaceBrowser spaceBrowser) {
        block2: {
            this._allGroupsNodesMap = new HashMap(3);
            this._allMembersNodesMap = new HashMap(5);
            this._allGroupInfoMap = new HashMap(3);
            try {
                this.m_owner = clusterViewDlg;
                this.m_clusterName = string;
                this.m_groupsInfo = groupInfoArray;
                this._spaceBrowser = spaceBrowser;
                this.m_DynamicMembers = new Vector();
                this.init();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    private void init() throws Exception {
        int n2 = this.m_groupsInfo.length;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.m_clusterName);
        this.m_tree = new JTree(defaultMutableTreeNode);
        this.m_groupTreeNodes = new DefaultMutableTreeNode[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.m_groupsInfo[i2].groupName;
            this.m_groupTreeNodes[i2] = new DefaultMutableTreeNode(string, true);
            defaultMutableTreeNode.add(this.m_groupTreeNodes[i2]);
            this._allGroupsNodesMap.put(string, this.m_groupTreeNodes[i2]);
            this._allGroupInfoMap.put(string, this.m_groupsInfo[i2]);
            for (int i3 = 0; i3 < this.m_groupsInfo[i2].groupMembers.length; ++i3) {
                String string2 = this.m_groupsInfo[i2].groupMembers[i3].memberName;
                this.createAndAddMemberNode(this.m_groupTreeNodes[i2], string2);
            }
        }
        this.m_tree.setCellRenderer(new ClusterTreeCellRenderer());
        this.m_tree.setAutoscrolls(true);
        this.m_tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                block3: {
                    try {
                        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            ClusterTree.this.performNodeAction(ClusterTree.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
                        }
                    }
                    catch (Exception exception) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block3;
                        _logger.log(Level.SEVERE, mouseEvent.toString(), mouseEvent);
                    }
                }
            }
        });
        this.m_tree.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ClusterTree.this.performNodeAction(ClusterTree.this.m_tree.getSelectionPath());
            }

            public void keyTyped(KeyEvent keyEvent) {
                ClusterTree.this.performNodeAction(ClusterTree.this.m_tree.getSelectionPath());
            }
        });
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setSelectionRow(0);
    }

    public JTree getTree() {
        return this.m_tree;
    }

    private void createAndAddMemberNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string, true);
        defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
        this._allMembersNodesMap.put(string, defaultMutableTreeNode2);
    }

    private void removeMemberNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeFromParent();
        this._allMembersNodesMap.remove(defaultMutableTreeNode.toString());
    }

    public synchronized boolean updateTree(List list) {
        Object object;
        Object object2;
        int n2;
        Object object3;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._allGroupsNodesMap.values().iterator().next();
        DefaultTreeModel defaultTreeModel = this._spaceBrowser.getContainersTreeModel();
        JTree jTree = this._spaceBrowser.getContainerTree();
        HashSet<String> hashSet = new HashSet<String>(list.size());
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (IMemberData)iterator.next();
            String string = object3.getName();
            hashSet.add(string);
            if (this._allMembersNodesMap.get(string) != null) continue;
            bl2 = true;
            arrayList.add(string);
        }
        boolean bl3 = false;
        object3 = null;
        int n3 = defaultMutableTreeNode.getChildCount();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        for (n2 = 0; n2 < n3; ++n2) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            object2 = defaultMutableTreeNode2.toString();
            object = defaultTreeModel.getPathToRoot(defaultMutableTreeNode2);
            TreePath treePath = new TreePath((Object[])object);
            boolean bl4 = jTree.isPathSelected(treePath);
            if (!hashSet.contains(object2)) {
                bl2 = true;
                if (!bl3) {
                    bl3 = bl4;
                }
                arrayList2.add(defaultMutableTreeNode2);
                continue;
            }
            if (!bl4 || object3 != null) continue;
            object3 = defaultMutableTreeNode2;
        }
        if (bl2) {
            int n4;
            n2 = arrayList2.size();
            for (n4 = 0; n4 < n2; ++n4) {
                object2 = (DefaultMutableTreeNode)arrayList2.get(n4);
                this.removeMemberNode((DefaultMutableTreeNode)object2);
            }
            n4 = arrayList.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                object = (String)arrayList.get(i2);
                this.createAndAddMemberNode(defaultMutableTreeNode, (String)object);
            }
            Object[] objectArray = defaultTreeModel.getPathToRoot(defaultMutableTreeNode);
            object = new TreePath(objectArray);
            boolean bl5 = jTree.isExpanded((TreePath)object);
            defaultTreeModel.reload(defaultMutableTreeNode);
            if (bl5) {
                jTree.expandPath((TreePath)object);
            }
            if (bl3) {
                this._spaceBrowser.setSelectedTreeNode(defaultMutableTreeNode, true, false);
            } else if (object3 != null) {
                this._spaceBrowser.setSelectedTreeNode((DefaultMutableTreeNode)object3, true, false);
            }
        }
        return bl2;
    }

    public void performNodeAction(TreePath treePath) {
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TreeNode treeNode = defaultMutableTreeNode.getParent();
            TreeNode treeNode2 = null;
            if (treeNode != null) {
                treeNode2 = treeNode.getParent();
            }
            if (treeNode2 != null && ((DefaultMutableTreeNode)treeNode2).getUserObject() instanceof EditCluster) {
                this.showHighLevelNode((DefaultMutableTreeNode)treeNode, treeNode.toString());
                GroupPanel groupPanel = this.getGroupPanel();
                groupPanel.performActionOnMember(treePath, defaultMutableTreeNode.getUserObject().toString());
                groupPanel.addRuntimePanel();
            } else {
                this.showHighLevelNode(defaultMutableTreeNode, defaultMutableTreeNode.toString());
                GroupPanel groupPanel = this.getGroupPanel();
                groupPanel.clearReplicationDetails();
                groupPanel.removeRunimePanel();
            }
        }
    }

    public void performSelectedNodeAction() {
        JTree jTree = this.m_owner.getBrowser().getContainerTree();
        TreePath treePath = jTree.getSelectionPath();
        this.performNodeAction(treePath);
    }

    public void showHighLevelNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String string2 = "CLUSTER_MEMEBER_VIEW";
        if (this._spaceBrowser.getClustersRootNode().equals(defaultMutableTreeNode.getParent())) {
            string2 = "CLUSTER_ROOT_VIEW";
        }
        JPanel jPanel = this.m_owner.getClusterPanel();
        ((CardLayout)jPanel.getLayout()).show(jPanel, string2);
        if (string != null) {
            this.m_owner.setGroupInfo((GroupInfo)this._allGroupInfoMap.get(string));
        }
        this.m_owner.startGraphTread(defaultMutableTreeNode.getUserObject().toString());
    }

    private boolean findGroup(String string) {
        for (int i2 = 0; i2 < this.m_groupsInfo.length; ++i2) {
            if (!this.m_groupsInfo[i2].groupName.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedNode(String string) {
        block8: {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
                if (defaultMutableTreeNode == null || defaultMutableTreeNode.getUserObject().toString().equals(string)) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                boolean bl2 = false;
                if (defaultMutableTreeNode.isRoot()) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                    bl2 = true;
                } else {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2.isRoot()) {
                        defaultMutableTreeNode2 = defaultMutableTreeNode;
                    }
                }
                for (int i2 = 0; i2 < defaultMutableTreeNode2.getChildCount(); ++i2) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i2);
                    if (!defaultMutableTreeNode.getUserObject().toString().equals(string)) continue;
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    this.m_tree.setSelectionPath(treePath);
                    if (bl2) {
                        this.performNodeAction(treePath);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block8;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    private GroupPanel getGroupPanel() {
        return this.m_owner.getGroupPanel();
    }

    private DefaultMutableTreeNode getGroup(String string) {
        return (DefaultMutableTreeNode)this._allGroupsNodesMap.get(string);
    }

    public boolean isExistGroup(String string) {
        for (int i2 = 0; i2 < this.m_groupsInfo.length; ++i2) {
            if (!this.m_groupsInfo[i2].groupName.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistMember(String string) {
        return this.m_owner.isExistMember(string);
    }

    public boolean isExistDynamicMember(String string) {
        return this.m_DynamicMembers.contains(string);
    }

    public void addDynamicMember(IRemoteJSpaceAdmin iRemoteJSpaceAdmin) {
        block7: {
            try {
                ClusterPolicy clusterPolicy = iRemoteJSpaceAdmin.getClusterPolicy();
                ReplicationPolicy replicationPolicy = clusterPolicy.m_ReplicationPolicy;
                SpaceConfig spaceConfig = iRemoteJSpaceAdmin.getConfig();
                String string = null;
                String string2 = null;
                if (clusterPolicy.m_ReplicationPolicy == null) {
                    return;
                }
                string = clusterPolicy.m_ReplicationPolicy.m_ReplicationGroupName;
                string2 = clusterPolicy.m_ClusterName;
                if (!this.isExistGroup(string)) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_tree.getModel();
                if (string != null) {
                    String string3 = clusterPolicy.m_ClusterGroupMember;
                    ServiceManagerImpl.ReplicationStatus replicationStatus = new ServiceManagerImpl.ReplicationStatus(iRemoteJSpaceAdmin.getReplicationStatus());
                    String string4 = replicationStatus.getMemberName(0);
                    String string5 = "WTN";
                    ReplicationTransmissionPolicy replicationTransmissionPolicy = new ReplicationTransmissionPolicy(string3, string4, string5, replicationPolicy.m_SyncOnCommit, false);
                    Vector<ReplicationTransmissionPolicy> vector = new Vector<ReplicationTransmissionPolicy>();
                    vector.add(replicationTransmissionPolicy);
                    ClusterMemberInfo clusterMemberInfo = new ClusterMemberInfo(string3, null, string2, string, null, spaceConfig.isMirrorServiceEnabled());
                    clusterMemberInfo.createClusterMemberAttributes(vector, null, null);
                    this.getGroupPanel().addClusterMember(clusterMemberInfo);
                    defaultMutableTreeNode = this.getGroup(string);
                    if (defaultMutableTreeNode != null) {
                        defaultTreeModel.insertNodeInto(new DefaultMutableTreeNode(clusterPolicy.m_ClusterGroupMember), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    }
                    this.m_DynamicMembers.add(string3);
                }
                this.m_tree.validate();
                this.m_tree.repaint();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ClusterTree | addDynamicMember(): " + iRemoteJSpaceAdmin.getName());
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block7;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    public class ClusterTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final String RESOURCE_DIR = "/image";
        private ImageIcon spaceIcon;
        private ImageIcon groupIcon;
        private ImageIcon clusterIcon;

        public ClusterTreeCellRenderer() {
            block2: {
                try {
                    this.clusterIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clusterIcon.gif"));
                    this.groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/groupTree.gif"));
                    this.spaceIcon = new ImageIcon(this.getClass().getResource("/image/browser/spaceTreeIcon.gif"));
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            if (((DefaultMutableTreeNode)object).isRoot()) {
                this.setIcon(this.clusterIcon);
            } else if (ClusterTree.this.findGroup(object.toString())) {
                this.setIcon(this.groupIcon);
            } else {
                this.setIcon(this.spaceIcon);
            }
            return this;
        }
    }
}

