/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ResourcesInfo {
    public static final String RESOURCE_DIR = "/image/cluster-wizard";
    public static ImageIcon WARNING_ICON;
    public static ImageIcon ERROR_ICON;
    public static ImageIcon INFO_ICON;
    public static ImageIcon QUESTION_ICON;
    public static final String PARAM_NAME = "Param Name";
    public static final String PARAM_VALUE = "Param Value";
    private static ResourceBundle m_resource;
    public static NewCluster newCluster;
    public static ModifyCluster modifyCluster;
    public static NewGroup newGroup;
    public static NewMember newMember;
    public static CreateGroup createGroup;
    public static CreateMembers createMembers;
    public static ReportError reportError;
    private static Logger _logger;

    public ResourcesInfo() {
        try {
            m_resource = ResourceBundle.getBundle("ClusterWizardResources");
        }
        catch (MissingResourceException missingResourceException) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Can't find the ClusterWizardResources.properties file that contains all resource names.", missingResourceException);
            }
            System.exit(1);
        }
        newCluster = new NewCluster();
        modifyCluster = new ModifyCluster();
        newGroup = new NewGroup();
        newMember = new NewMember();
        createGroup = new CreateGroup();
        createMembers = new CreateMembers();
        reportError = new ReportError();
        WARNING_ICON = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/warning.gif"));
        ERROR_ICON = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/error.gif"));
        INFO_ICON = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/info.gif"));
        QUESTION_ICON = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/question.gif"));
    }

    static {
        _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");
    }

    public static class ReportError
    extends ResInfo {
        public ReportError() {
            super("ReportError");
        }
    }

    public static class NewGroup
    extends ResInfo {
        public NewGroup() {
            super("NewGroup");
        }
    }

    public static class CreateGroup
    extends ResInfo {
        public CreateGroup() {
            super("CreateGroup");
        }
    }

    public static class NewMember
    extends ResInfo {
        public NewMember() {
            super("NewMember");
        }
    }

    public static class CreateMembers
    extends ResInfo {
        public CreateMembers() {
            super("CreateMember");
        }
    }

    public static class ModifyCluster
    extends ResInfo {
        public ModifyCluster() {
            super("ModifyCluster");
        }
    }

    public static class NewCluster
    extends ResInfo {
        public NewCluster() {
            super("NewCluster");
        }
    }

    public static class ResInfo {
        private String stepName;
        private String[] labels;
        private String[] buttons;
        private String[] tooltip;
        private String[] aboutStep;
        private String[] stepDesc;

        public ResInfo(String string) {
            this.stepName = string;
            this.labels = this.getResources(string + ".label");
            this.buttons = this.getResources(string + ".button");
            this.tooltip = this.getResources(string + ".tooltip");
            this.aboutStep = this.getResources(string + ".aboutstep");
            this.stepDesc = this.getResources(string + ".stepDesc");
        }

        public String[] getLabels() {
            return this.labels;
        }

        public String[] getButtons() {
            return this.buttons;
        }

        public String[] getToolTips() {
            return this.tooltip;
        }

        public String getAboutStep() {
            return this.aboutStep[0];
        }

        public String[] getStepDescription() {
            return this.stepDesc;
        }

        public String[] getResources(String string) {
            String[] stringArray = null;
            String string2 = m_resource.getString(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken().trim();
                ++n2;
            }
            return stringArray;
        }
    }
}

