/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClusterTopologiesPanel
extends JPanel {
    private static final long serialVersionUID = 3833470608427004473L;
    public Border border1;
    public JComboBox cmboxTopologyUserDefined;
    public GridBagLayout gridBagLayout1;
    public GridBagLayout gridBagLayout2;
    public GridBagLayout gridBagLayout3;
    public GridBagLayout gridBagLayout4;
    public JLabel labClusterName;
    public JLabel labNumOfBackups;
    public JLabel labNumOfMembers;
    public JTextArea labTopologyDescription;
    public JScrollPane scrollPanTopologyDescription;
    public JPanel panClusterMembers;
    public JPanel panClusterName;
    public JPanel panTopology;
    public TitledBorder titledBorder1;
    public JTextField txtfClusterName;
    private JSpinner numOfBackupsSpinner;
    private JSpinner numOfPrimaryMembersSpinner;
    public DocumentBuilderFactory docFactory;
    public DocumentBuilder docBuilder;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public ClusterTopologiesPanel() {
        block2: {
            this.cmboxTopologyUserDefined = new JComboBox();
            this.gridBagLayout1 = new GridBagLayout();
            this.gridBagLayout2 = new GridBagLayout();
            this.gridBagLayout3 = new GridBagLayout();
            this.gridBagLayout4 = new GridBagLayout();
            this.labClusterName = new JLabel();
            this.labNumOfBackups = new JLabel();
            this.labNumOfMembers = new JLabel();
            this.labTopologyDescription = new JTextArea();
            this.scrollPanTopologyDescription = new JScrollPane(this.labTopologyDescription);
            this.panClusterMembers = new JPanel();
            this.panClusterName = new JPanel();
            this.panTopology = new JPanel();
            this.txtfClusterName = new JTextField();
            this.docFactory = null;
            this.docBuilder = null;
            try {
                this.jbInit();
                this.createListeners();
                this.docFactory = DocumentBuilderFactory.newInstance();
                this.docBuilder = this.docFactory.newDocumentBuilder();
                this.setDefaultValues();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void jbInit() throws Exception {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(2, 1, 1000000, 1);
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0, 0, 1000000, 1);
        this.numOfPrimaryMembersSpinner = new JSpinner(spinnerNumberModel);
        this.numOfBackupsSpinner = new JSpinner(spinnerNumberModel2);
        this.numOfPrimaryMembersSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Integer n2 = (Integer)ClusterTopologiesPanel.this.numOfPrimaryMembersSpinner.getValue();
                int n3 = n2;
                if (ClusterTopologiesPanel.this.numOfBackupsSpinner.isEnabled()) {
                    if (n3 == 1) {
                        spinnerNumberModel2.setMinimum(_Integer.valueOf(1));
                        if ((Integer)spinnerNumberModel2.getValue() == 0) {
                            spinnerNumberModel2.setValue(_Integer.valueOf(1));
                        }
                    } else if (n3 > 1) {
                        spinnerNumberModel2.setMinimum(_Integer.valueOf(0));
                    }
                }
            }
        });
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Cluster Members");
        this.setLayout(this.gridBagLayout1);
        this.panClusterName.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "General settings"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panClusterName.setLayout(this.gridBagLayout2);
        this.labClusterName.setText("Cluster Name");
        this.panTopology.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Select Topology"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panTopology.setLayout(this.gridBagLayout3);
        this.scrollPanTopologyDescription.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Description"));
        this.panClusterMembers.setBorder(this.titledBorder1);
        this.panClusterMembers.setLayout(this.gridBagLayout4);
        this.labNumOfMembers.setText("Number of primary members:");
        this.labNumOfBackups.setText("Number of backup members per primary:");
        this.numOfPrimaryMembersSpinner.setToolTipText("");
        this.labTopologyDescription.setLineWrap(true);
        this.labTopologyDescription.setWrapStyleWord(true);
        this.labTopologyDescription.setEditable(false);
        this.labTopologyDescription.setRows(7);
        this.labTopologyDescription.setFont(this.labClusterName.getFont());
        this.labTopologyDescription.setBackground(this.labClusterName.getBackground());
        Dimension dimension = new Dimension(100, 150);
        this.scrollPanTopologyDescription.setPreferredSize(dimension);
        this.scrollPanTopologyDescription.setMinimumSize(dimension);
        this.cmboxTopologyUserDefined.setRenderer(new TopologyComboboxRendered());
        this.panClusterName.add((Component)this.labClusterName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panClusterName.add((Component)this.txtfClusterName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panTopology.add((Component)this.scrollPanTopologyDescription, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panTopology.add((Component)this.cmboxTopologyUserDefined, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panClusterMembers.add((Component)this.labNumOfMembers, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panClusterMembers.add((Component)this.numOfPrimaryMembersSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panClusterMembers.add((Component)this.labNumOfBackups, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panClusterMembers.add((Component)this.numOfBackupsSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.panClusterName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panTopology, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panClusterMembers, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createListeners() {
        this.cmboxTopologyUserDefined.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Topology topology = (Topology)itemEvent.getItem();
                ClusterTopologiesPanel.this.setTopologyDescription(topology.description);
                ClusterTopologiesPanel.this.numOfBackupsSpinner.setEnabled(topology.isWithBackupMembersOnly());
                if (!topology.isWithBackupMembersOnly()) {
                    ClusterTopologiesPanel.this.numOfBackupsSpinner.setValue(new Integer(0));
                }
            }
        });
    }

    public void setDefaultValues() throws ParserConfigurationException, IOException, SAXException {
        Document document;
        InputStream inputStream;
        int n2;
        this.setEnabled(true);
        String[] stringArray = ResourceLoader.getClusterSchemas();
        Vector<Topology> vector = new Vector<Topology>(stringArray.length);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            try {
                inputStream = ResourceLoader.findClusterXSLSchema(stringArray[n2]);
                document = this.docBuilder.parse(inputStream);
                vector.addElement(new Topology(stringArray[n2], this.getTopologyDescription(document), true, this.hasBackupMembers(document)));
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Failed to proceed \"" + stringArray[n2] + "\" cluster schema. " + exception.toString(), exception);
            }
        }
        vector.ensureCapacity(vector.size() + ClusterXML.CLUSTER_PREDEFINED_SCHEMAS.length);
        for (n2 = 0; n2 < ClusterXML.CLUSTER_PREDEFINED_SCHEMAS.length; ++n2) {
            try {
                inputStream = ResourceLoader.findClusterXSLSchema(ClusterXML.CLUSTER_PREDEFINED_SCHEMAS[n2]);
                document = this.docBuilder.parse(inputStream);
                String string = this.getTopologyDescription(document);
                Topology topology = new Topology(ClusterXML.CLUSTER_PREDEFINED_SCHEMAS[n2], string, false, this.hasBackupMembers(document));
                if (vector.contains(topology)) continue;
                vector.addElement(topology);
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Failed to proceed \"" + ClusterXML.CLUSTER_PREDEFINED_SCHEMAS[n2] + "\" cluster schema. " + exception.toString(), exception);
            }
        }
        this.setTopologyUserDefined(vector);
    }

    private String getTopologyDescription(Document document) {
        return ClusterXML.getNodeValueIfExists(document.getDocumentElement(), "description");
    }

    private boolean hasBackupMembers(Document document) {
        String string = ClusterXML.getNodeValueIfExists(document.getDocumentElement(), "backup-member-only");
        return string != null;
    }

    public String getClusterName() {
        return this.txtfClusterName.getText().trim();
    }

    public void setClusterName(String string) {
        this.txtfClusterName.setText(string);
    }

    public int getNumOfBackups() throws ParseException {
        if (this.numOfBackupsSpinner.isEnabled()) {
            try {
                this.numOfBackupsSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                throw new ParseException("Number of backup members is not valid.", 1);
            }
        }
        return (Integer)this.numOfBackupsSpinner.getValue();
    }

    public void setNumOfBackups(int n2) {
        this.numOfBackupsSpinner.setValue(new Integer(n2));
    }

    public int getNumOfMembers() throws ParseException {
        if (this.numOfPrimaryMembersSpinner.isEnabled()) {
            try {
                this.numOfPrimaryMembersSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                throw new ParseException("Number of primary members is not valid.", 1);
            }
        }
        return (Integer)this.numOfPrimaryMembersSpinner.getValue();
    }

    public void setNumOfMembers(int n2) {
        this.numOfPrimaryMembersSpinner.setValue(new Integer(n2));
    }

    public String getSelectedTopology() {
        return this.cmboxTopologyUserDefined.getSelectedItem().toString();
    }

    public void setTopologyUserDefined(Vector vector) {
        this.cmboxTopologyUserDefined.setModel(new DefaultComboBoxModel(vector));
        if (vector != null && vector.size() > 0) {
            Topology topology = (Topology)vector.get(0);
            this.setTopologyDescription(topology.description);
            this.numOfBackupsSpinner.setEnabled(topology.isWithBackupMembersOnly());
        }
    }

    public void setSelectedTopology(String string) {
        Object var2_2 = null;
        for (int i2 = 0; i2 < this.cmboxTopologyUserDefined.getModel().getSize(); ++i2) {
            if (!((Topology)this.cmboxTopologyUserDefined.getItemAt((int)i2)).name.equals(string)) continue;
            var2_2 = this.cmboxTopologyUserDefined.getItemAt(i2);
        }
        if (var2_2 == null) {
            throw new IllegalArgumentException("The " + string + " don't exists");
        }
        this.cmboxTopologyUserDefined.setEnabled(true);
        this.cmboxTopologyUserDefined.setSelectedItem(var2_2);
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        JSpaceUtilities.setAWTComponentsStatus(this, bl2);
        JSpaceUtilities.setAWTComponentsStatus(this.panClusterName, true);
        if (bl2 && this.cmboxTopologyUserDefined.getModel().getSize() > 0) {
            Topology topology = (Topology)this.cmboxTopologyUserDefined.getItemAt(0);
            this.numOfBackupsSpinner.setEnabled(topology.isWithBackupMembersOnly());
        }
    }

    public void reset() {
        this.setEnabled(true);
        this.txtfClusterName.setText("");
        if (this.cmboxTopologyUserDefined.getModel().getSize() > 0) {
            this.cmboxTopologyUserDefined.setSelectedIndex(0);
        }
        this.numOfPrimaryMembersSpinner.setValue(new Integer(2));
        this.numOfBackupsSpinner.setValue(new Integer(0));
    }

    public void setEnabledMembersPanel(boolean bl2) {
        JSpaceUtilities.setAWTComponentsStatus(this.panClusterMembers, bl2);
    }

    private void setTopologyDescription(String string) {
        this.labTopologyDescription.setText(string);
        this.labTopologyDescription.setCaretPosition(0);
    }

    public class TopologyComboboxRendered
    extends DefaultListCellRenderer {
        public Font regularFont = new Font(this.getFont().getName(), 0, this.getFont().getSize());
        public Font boldFont = new Font(this.getFont().getName(), 1, this.getFont().getSize());

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            if (object != null && object instanceof Topology) {
                component.setFont(((Topology)object).isUserDefined ? this.regularFont : this.boldFont);
            }
            return component;
        }
    }

    public class Topology {
        public String name;
        public String description;
        public boolean isUserDefined;
        private boolean _isWithBackupMembersOnly;

        public Topology(String string) {
            this(string, null, false, false);
        }

        public Topology(String string, String string2, boolean bl2, boolean bl3) {
            if (string == null) {
                throw new NullPointerException("Topology name is null");
            }
            this.name = string;
            this.description = string2 != null ? string2 : "No description";
            this.isUserDefined = bl2;
            this._isWithBackupMembersOnly = bl3;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Topology)) {
                return false;
            }
            return this.name.equals(((Topology)object).name);
        }

        public boolean isWithBackupMembersOnly() {
            return this._isWithBackupMembersOnly;
        }
    }
}

