/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSConnectionImpl;
import com.j_spaces.jms.GSQueueBrowserImpl;
import com.j_spaces.jms.GSQueueImpl;
import com.j_spaces.jms.GSQueueReceiverImpl;
import com.j_spaces.jms.GSQueueSenderImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSTemporaryQueueImpl;
import com.j_spaces.jms.utils.StringsUtils;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import net.jini.core.transaction.Transaction;

public class GSQueueSessionImpl
extends GSSessionImpl
implements QueueSession {
    private static Logger e = Logger.getLogger("com.gigaspaces.jms");

    public GSQueueSessionImpl(GSConnectionImpl gSConnectionImpl, boolean bl2, int n2, Transaction transaction) throws JMSException {
        super(gSConnectionImpl, bl2, n2, transaction);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        GSQueueReceiverImpl gSQueueReceiverImpl;
        GSQueueSessionImpl gSQueueSessionImpl = this;
        synchronized (gSQueueSessionImpl) {
            this.ensureOpen();
            String string2 = this.d();
            String string3 = "";
            if (queue != null) {
                string3 = queue.getQueueName();
            }
            if (this.getConn() != null) {
                String string4 = this.getConn().getClientID();
                if (string4.indexOf(":") != -1) {
                    this.getConn().updateClientIDInternally(string4.substring(0, string4.indexOf(":")) + ":" + string3);
                } else {
                    this.getConn().updateClientIDInternally(string4 + ":" + string3);
                }
            }
            gSQueueReceiverImpl = new GSQueueReceiverImpl((GSSessionImpl)this, (GSQueueImpl)queue, string2, string, this.f());
            this.addReceiver(gSQueueReceiverImpl);
        }
        return gSQueueReceiverImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        GSQueueSenderImpl gSQueueSenderImpl;
        GSQueueSessionImpl gSQueueSessionImpl = this;
        synchronized (gSQueueSessionImpl) {
            this.ensureOpen();
            String string = this.e();
            String string2 = "";
            if (queue != null) {
                string2 = queue.getQueueName();
            }
            if (this.getConn() != null) {
                String string3 = this.getConn().getClientID();
                if (string3.indexOf(":") != -1) {
                    this.getConn().updateClientIDInternally(string3.substring(0, string3.indexOf(":")) + ":" + string2);
                } else {
                    this.getConn().updateClientIDInternally(string3 + ":" + string2);
                }
            }
            gSQueueSenderImpl = new GSQueueSenderImpl((GSSessionImpl)this, (GSQueueImpl)queue, string);
            this.addSender(gSQueueSenderImpl);
        }
        return gSQueueSenderImpl;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl2) throws JMSException {
        throw new IllegalStateException("Forbidden call on a QueueSession.");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        throw new IllegalStateException("Forbidden call on a QueueSession.");
    }

    public Topic createTopic(String string) throws JMSException {
        throw new IllegalStateException("Forbidden call on a QueueSession.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String string) throws JMSException {
        GSQueueImpl gSQueueImpl;
        GSQueueSessionImpl gSQueueSessionImpl = this;
        synchronized (gSQueueSessionImpl) {
            this.ensureOpen();
            if (StringsUtils.isEmpty(string)) {
                throw new JMSException("Invalid or null queue name specified");
            }
            gSQueueImpl = new GSQueueImpl(string);
        }
        return gSQueueImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        GSQueueBrowserImpl gSQueueBrowserImpl;
        GSQueueSessionImpl gSQueueSessionImpl = this;
        synchronized (gSQueueSessionImpl) {
            this.ensureOpen();
            if (queue == null) {
                throw new InvalidDestinationException("Cannot browse a null queue.");
            }
            gSQueueBrowserImpl = new GSQueueBrowserImpl(this, queue, null);
            this.addBrowser(gSQueueBrowserImpl);
        }
        return gSQueueBrowserImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        GSQueueBrowserImpl gSQueueBrowserImpl;
        GSQueueSessionImpl gSQueueSessionImpl = this;
        synchronized (gSQueueSessionImpl) {
            this.ensureOpen();
            if (queue == null) {
                throw new InvalidDestinationException("Cannot browse a null queue.");
            }
            gSQueueBrowserImpl = new GSQueueBrowserImpl(this, queue, string);
            this.addBrowser(gSQueueBrowserImpl);
        }
        return gSQueueBrowserImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        GSTemporaryQueueImpl gSTemporaryQueueImpl;
        GSQueueSessionImpl gSQueueSessionImpl = this;
        synchronized (gSQueueSessionImpl) {
            this.ensureOpen();
            gSTemporaryQueueImpl = new GSTemporaryQueueImpl(this.m_sessionID + ":" + this.getRandomInt(), this.m_sessionID);
            try {
                this.getConn().getConnFacParent().getAdmin().rebindToJNDI(this.getConn().getConnFacParent().getAdmin().getBondedDestPrefixName() + gSTemporaryQueueImpl.toString(), gSTemporaryQueueImpl);
            }
            catch (NamingException namingException) {
                if (e.isLoggable(Level.FINE)) {
                    e.log(Level.FINE, "NamingException inside GSQueueSessionImpl.createTemporaryQueue(): " + namingException.toString(), namingException);
                }
                JMSException jMSException = new JMSException("NamingException : ");
                jMSException.setLinkedException(namingException);
                throw jMSException;
            }
        }
        return gSTemporaryQueueImpl;
    }

    public void unsubscribe(String string) throws JMSException {
        throw new IllegalStateException("Forbidden call on a QueueSession.");
    }

    public void addReceiver(GSQueueReceiverImpl gSQueueReceiverImpl) throws JMSException {
        this.addConsumer(gSQueueReceiverImpl);
    }

    public void addSender(GSQueueSenderImpl gSQueueSenderImpl) {
        this.addProducer(gSQueueSenderImpl);
    }

    public void addBrowser(GSQueueBrowserImpl gSQueueBrowserImpl) {
        if (this.m_browsers == null) {
            this.m_browsers = new Vector();
        }
        this.m_browsers.addElement(gSQueueBrowserImpl);
    }

    public void removeBrower(GSQueueBrowserImpl gSQueueBrowserImpl) {
        this.m_browsers.remove(gSQueueBrowserImpl);
        gSQueueBrowserImpl = null;
    }

    public void removeReceiver(GSQueueReceiverImpl gSQueueReceiverImpl) throws JMSException {
        this.removeConsumer(gSQueueReceiverImpl);
    }

    public void removeSender(GSQueueSenderImpl gSQueueSenderImpl) {
        this.removeProducer(gSQueueSenderImpl);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Forbidden call on a QueueSession.");
    }
}

