/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.ExternalEntryPool;
import com.j_spaces.jdbc.ExternalEntrySet;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.parser.ExpNode;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.Transaction;

public class DeleteQuery
extends AbstractDMLQuery {
    private static Logger a = Logger.getLogger("com.gigaspaces.persistent");

    public ResponsePacket executeOnSpace(IJSpace iJSpace, Transaction transaction, Hashtable hashtable) {
        ResponsePacket responsePacket = new ResponsePacket();
        try {
            Object object;
            ExternalEntrySet externalEntrySet;
            if (this.isPrepared()) {
                this.expTree.prepareValues(this.preparedValues);
            }
            this.setTableInfos(hashtable);
            if (this.expTree != null) {
                externalEntrySet = this.expTree.executeRead(new String[]{this.tableName}, iJSpace, null, this);
            } else {
                object = ExternalEntryPool.getExternalEntry(this.getTableName(), null, null);
                externalEntrySet = new ExternalEntrySet(iJSpace.readMultiple((Entry)object, null, Integer.MAX_VALUE));
                ExternalEntryPool.release((ExternalEntry)object);
            }
            if (this.rownum != null) {
                this.a(externalEntrySet);
            }
            object = externalEntrySet.iterator();
            int n2 = 0;
            while (object.hasNext()) {
                ExternalEntry externalEntry = (ExternalEntry)object.next();
                Entry entry = iJSpace.take(externalEntry, transaction, 0L);
                if (entry != null) {
                    ++n2;
                    continue;
                }
                object.remove();
            }
            responsePacket.setResultSet(externalEntrySet);
            responsePacket.setIntResult(n2);
        }
        catch (SQLException sQLException) {
            responsePacket.setException(new SQLException("Can't Delete row", "GSP", -104));
        }
        catch (Exception exception) {
            if (a.isLoggable(Level.FINE)) {
                a.log(Level.FINE, "Error occurred on delete", exception);
            }
            SQLException sQLException = new SQLException("Delete failed!", "GSP", -104);
            sQLException.initCause(exception);
            responsePacket.setException(sQLException);
        }
        return responsePacket;
    }

    public Object clone() {
        DeleteQuery deleteQuery = new DeleteQuery();
        deleteQuery.tables = this.tables;
        deleteQuery.rownum = this.rownum;
        deleteQuery.isPrepared = this.isPrepared;
        deleteQuery.isJoined = this.isJoined;
        deleteQuery.tableName = this.getTableName();
        deleteQuery.isPrepared = this.isPrepared;
        deleteQuery.queryColumns = this.getQueryColumns();
        if (this.getExpTree() != null) {
            deleteQuery.setExpTree((ExpNode)this.getExpTree().clone());
        }
        return deleteQuery;
    }

    public void validateQuery(IJSpace iJSpace, Hashtable hashtable) throws SQLException {
        try {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)hashtable.get(this.tableName);
            if (basicTypeInfo == null && (basicTypeInfo = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getClassTypeInfo(this.tableName)) != null) {
                hashtable.put(this.tableName, basicTypeInfo);
            }
            this.setTableInfos(hashtable);
            if (basicTypeInfo == null) {
                throw new SQLException("Table does not exist!", "GSP", -105);
            }
        }
        catch (RemoteException remoteException) {
            SQLException sQLException = new SQLException("Remote Exception occurred", "GSP", -106);
            sQLException.initCause(remoteException);
            throw sQLException;
        }
    }

    private void a(ExternalEntrySet externalEntrySet) {
        if (this.rownum != null) {
            ExternalEntry externalEntry = null;
            Vector<ExternalEntry> vector = new Vector<ExternalEntry>();
            Iterator iterator = externalEntrySet.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                externalEntry = (ExternalEntry)iterator.next();
                ++n2;
                if (this.rownum.getStartIndex() > this.rownum.getEndIndex()) {
                    if (n2 >= this.rownum.getStartIndex()) continue;
                    vector.add(externalEntry);
                    continue;
                }
                if (this.rownum.getStartIndex() < this.rownum.getEndIndex()) {
                    if (n2 <= this.rownum.getEndIndex()) continue;
                    vector.add(externalEntry);
                    continue;
                }
                if (this.rownum.getStartIndex() != this.rownum.getEndIndex() || n2 <= this.rownum.getEndIndex()) continue;
                vector.add(externalEntry);
            }
            if (!vector.isEmpty()) {
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    externalEntrySet.remove(iterator.next());
                }
            }
        }
    }
}

