/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.sync_replication;

import com.j_spaces.core.cluster.sync_replication.PAdaptorEvent;
import com.j_spaces.obf.bx;
import com.j_spaces.obf.et;
import com.j_spaces.obf.nl;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastEvent
extends PAdaptorEvent
implements Serializable {
    public static final long serialVersionUID = 8175102445636269461L;
    public transient InetAddress _address;
    public transient int _port;
    public static final String PROTOCOL_ADAPTER_NAME;
    private static final Logger _logger;
    static /* synthetic */ Class class$com$j_spaces$obf$et;

    public MulticastEvent(short s2, String string, String string2, String string3, long l2, String string4, Object object, InetAddress inetAddress, int n2, boolean bl2, boolean bl3, long l3) {
        super(PROTOCOL_ADAPTER_NAME, string, string2, string3, l2, object, s2, string4, bl2, bl3, l3);
        if (inetAddress != null) {
            this.setDataGramInfo(inetAddress, n2);
        }
    }

    public MulticastEvent(short s2, String string, String string2, String string3, String string4, InetAddress inetAddress, int n2) {
        super(PROTOCOL_ADAPTER_NAME, string, string2, string3, s2, string4);
        if (inetAddress != null) {
            this.setDataGramInfo(inetAddress, n2);
        }
    }

    public void setDataGramInfo(InetAddress inetAddress, int n2) {
        this._address = inetAddress;
        this._port = n2;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public void setSerializedData(byte[] byArray) {
        this.serializedData = byArray;
    }

    public byte[] getSerializedData() {
        return this.serializedData;
    }

    public boolean equals(Object object) {
        if (object instanceof MulticastEvent) {
            MulticastEvent multicastEvent = (MulticastEvent)object;
            return this.eventUID.equals(multicastEvent.eventUID);
        }
        return false;
    }

    public int hashCode() {
        return this.eventUID.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MessageEvent:");
        stringBuffer.append(" Type: " + MulticastEvent.getEventType(this.eventType));
        stringBuffer.append(" | GroupName: " + this.groupName);
        stringBuffer.append(" | SourceName: " + this.sourceName);
        if (this.eventType == 1) {
            stringBuffer.append(" | isAsyncMode: " + this.isAsyncMode);
            stringBuffer.append(" | isOneWay: " + this.isOneWay);
            stringBuffer.append(" | replSessionID: " + this.eventSessionID);
            stringBuffer.append(" | SeqNum: " + this.seqNum);
        }
        if (this.serializedData != null) {
            stringBuffer.append(" | Size: " + this.serializedData.length + " bytes");
        }
        stringBuffer.append(" | UID: " + this.eventUID);
        if (this._address != null) {
            stringBuffer.append(" | SourceAddress: " + this._address + ":" + this._port);
        }
        return stringBuffer.toString();
    }

    public void serializeEvent(ObjectOutput objectOutput) throws IOException {
        if (this.serializedData != null) {
            objectOutput.write(this.serializedData);
            return;
        }
        objectOutput.writeUTF(this.groupName);
        objectOutput.writeUTF(this.sourceName);
        objectOutput.writeUTF(this.sourceUID);
        objectOutput.writeShort(this.eventType);
        objectOutput.writeBoolean(this.isAsyncMode);
        if (1 == this.eventType) {
            objectOutput.writeLong(this.eventSessionID);
            objectOutput.writeLong(this.seqNum);
            if (!this.isAsyncMode) {
                objectOutput.writeBoolean(this.isOneWay);
                objectOutput.writeInt(this.replyPort);
            }
        } else {
            objectOutput.writeUTF(this.eventUID);
        }
        objectOutput.writeObject(this.eventObj);
    }

    public static boolean validateEventHeader(String string, String string2, String string3, String string4, short s2, long l2, String string5) {
        if (s2 == 1) {
            if (string != null && string.equals(string4)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("VALIDATE-HEADER IGNORE - Received " + MulticastEvent.getEventType(s2) + " packed: seqNum " + l2 + " routed back to sender. SourceUID: " + string4);
                }
                return false;
            }
        } else if (!string5.endsWith(string)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("VALIDATE-HEADER IGNORE - Received " + MulticastEvent.getEventType(s2) + " packed: UID " + string5 + " not owner of this reply.");
            }
            return false;
        }
        return true;
    }

    public static MulticastEvent deserializeEvent(byte[] byArray) throws IOException, ClassNotFoundException {
        return MulticastEvent.deserializeEvent(null, null, byArray);
    }

    public static MulticastEvent deserializeEvent(String string, InetAddress inetAddress, byte[] byArray) throws IOException, ClassNotFoundException {
        long l2 = 0L;
        String string2 = null;
        Object object = null;
        long l3 = 0L;
        int n2 = -1;
        boolean bl2 = false;
        bx bx2 = new bx(byArray, byArray.length);
        nl nl2 = new nl(bx2);
        String string3 = nl2.readUTF();
        String string4 = nl2.readUTF();
        String string5 = nl2.readUTF();
        short s2 = nl2.readShort();
        boolean bl3 = nl2.readBoolean();
        if (s2 == 1) {
            l3 = nl2.readLong();
            l2 = nl2.readLong();
            if (!bl3) {
                bl2 = nl2.readBoolean();
                n2 = nl2.readInt();
            }
        } else {
            string2 = nl2.readUTF();
        }
        if (!MulticastEvent.validateEventHeader(string, string3, string4, string5, s2, l2, string2)) {
            return null;
        }
        if (s2 != 2) {
            object = nl2.readObject();
        }
        return new MulticastEvent(s2, string3, string4, string5, l2, string2, object, inetAddress, n2, bl3, bl2, l3);
    }

    static {
        Class<?> clazz = class$com$j_spaces$obf$et;
        if (clazz == null) {
            clazz = class$com$j_spaces$obf$et = new et[0].getClass().getComponentType();
        }
        PROTOCOL_ADAPTER_NAME = clazz.getName();
        _logger = Logger.getLogger("com.gigaspaces.core.cluster.sync_replication");
    }
}

