/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.dynamic.mapping;

import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.core.cluster.dynamic.NotLogicOwnerException;
import com.j_spaces.core.cluster.dynamic.mapping.PhysicalSpace;
import com.j_spaces.obf.ha;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LogicSpace
implements Serializable {
    private final LinkedList _copies;
    private final ReadWriteLock _usage = new ReentrantReadWriteLock();
    private boolean isValid = true;
    private final Integer _logicID;
    private final ConcurrentHashMap _proxies;
    private static final ha _locker = new ha();

    public LogicSpace(ConcurrentHashMap concurrentHashMap, Integer n2, LinkedList linkedList) {
        this._copies = linkedList;
        this._logicID = n2;
        this._proxies = concurrentHashMap;
    }

    public PhysicalSpace setPhyical(int n2, PhysicalSpace physicalSpace) {
        return this._copies.set(n2, physicalSpace);
    }

    public PhysicalSpace getPhyical(int n2) {
        return (PhysicalSpace)this._copies.get(n2);
    }

    public PhysicalSpace removePhyical(int n2) {
        PhysicalSpace physicalSpace = (PhysicalSpace)this._copies.remove(n2);
        PhysicalSpace physicalSpace2 = (PhysicalSpace)this._copies.getFirst();
        this._copies.addLast(physicalSpace2);
        return physicalSpace;
    }

    public boolean removePhyical(PhysicalSpace physicalSpace) {
        boolean bl2 = this._copies.remove(physicalSpace);
        PhysicalSpace physicalSpace2 = (PhysicalSpace)this._copies.getFirst();
        this._copies.addLast(physicalSpace2);
        return bl2;
    }

    public void use() throws NotLogicOwnerException {
        this._usage.readLock().lock();
        if (!this.isValid) {
            this._usage.readLock().unlock();
            throw new NotLogicOwnerException((JSpaceClusteredProxy.LBProxyHolder)this._proxies.get((Object)this.getOwnerName()), this._logicID, 0);
        }
    }

    public void unUse() {
        this._usage.readLock().unlock();
    }

    public void lock() {
        _locker.a(this._usage.writeLock(), true);
    }

    public void unLock() {
        this.isValid = false;
        _locker.a(this._usage.writeLock(), false);
    }

    public boolean isOwner(String string) {
        return string.equals(this.getOwnerName());
    }

    public String getOwnerName() {
        return ((PhysicalSpace)this._copies.get(0)).getName();
    }

    public boolean isHolder(String string) {
        Iterator iterator = this._copies.iterator();
        while (iterator.hasNext()) {
            PhysicalSpace physicalSpace = (PhysicalSpace)iterator.next();
            if (!string.equals(physicalSpace.getName())) continue;
            return true;
        }
        return false;
    }

    public List getPhysicalSpaces() {
        return this._copies;
    }

    static {
        _locker.start();
    }
}

