/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.cache.map;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.core.client.CacheTimeoutException;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.client.MulticastNotifyDelegator;
import com.j_spaces.core.client.NotifyDelegator;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.cache.map.BaseCacheEntry;
import com.j_spaces.core.client.cache.map.DummyCacheEntry;
import com.j_spaces.core.client.cache.map.EvictionCacheManager;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.javax.cache.CacheListener;
import com.j_spaces.javax.cache.EvictionStrategy;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.kernel.weaklistener.WeakRemoteEventListener;
import com.j_spaces.map.AbstractMap;
import com.j_spaces.map.Attribute;
import com.j_spaces.map.Envelope;
import com.j_spaces.obf.io;
import com.j_spaces.obf.jd;
import com.j_spaces.obf.u;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;

public final class MapCache
extends AbstractMap
implements RemoteEventListener,
LeaseListener {
    public static final int DEFAULT_MAX_CONNECTION_RETRY = 3;
    private int a = 3;
    private long b = 5000L;
    private static final long c = 60000L;
    private final io d;
    private final SizeConcurrentHashMap e;
    private final Set f;
    private final int g;
    private final EvictionStrategy h;
    private final String i;
    private final boolean j;
    private final int k;
    private final String l;
    private Lease m;
    private final LeaseRenewalManager n = new LeaseRenewalManager();
    private NotifyDelegator o;
    private MulticastNotifyDelegator p;
    private static Logger q = Logger.getLogger("com.gigaspaces.cache");

    public MapCache(IJSpace iJSpace, boolean bl2, int n2, EvictionStrategy evictionStrategy, boolean bl3, boolean bl4, int n3, int n4, String string) throws RemoteException {
        super(iJSpace, -1L, null, n4, bl2);
        Object object;
        if (JProperties.getSpaceProperties(iJSpace.getName()) == null) {
            object = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getConfig();
            JProperties.setSpaceProperties(iJSpace.getName(), ((JSpaceAttributes)object).getDCacheProperties());
        }
        object = new EvictionCacheManager(evictionStrategy, this);
        String string2 = iJSpace.getName() + "_DCache";
        this.d = new io(string2, (jd)object);
        this.k = n3;
        this.l = string;
        this.i = iJSpace instanceof IDirectSpaceProxy ? ((IDirectSpaceProxy)iJSpace).getRemoteJSpace().getUniqueID() : "";
        this.e = new SizeConcurrentHashMap();
        this.f = Collections.synchronizedSet(new HashSet());
        this.j = bl4;
        this.g = n2;
        this.h = evictionStrategy;
        String string3 = JProperties.getSpaceProperty(string2, "dist-cache.retry-connections", null);
        String string4 = JProperties.getSpaceProperty(string2, "dist-cache.delay-between-retries", null);
        this.a = string3 != null ? Integer.parseInt(string3) : this.a;
        this.b = string4 != null ? Long.parseLong(string4) : this.b;
        this.a(bl3);
    }

    private void a(boolean bl2) throws RemoteException {
        block5: {
            try {
                EventRegistration eventRegistration;
                if (bl2 && !this._spaceProxy.isEmbedded()) {
                    this.p = MulticastNotifyDelegator.getInstance(this._spaceProxy);
                    eventRegistration = this.p.notify(new Envelope(), null, new WeakRemoteEventListener(this), Long.MAX_VALUE, null, false, 14);
                } else {
                    if (this.o != null) {
                        this.o.close();
                    }
                    this.o = new NotifyDelegator(this._spaceProxy, new Envelope(), null, (RemoteEventListener)new WeakRemoteEventListener(this), 60000L, null, false, 14);
                    eventRegistration = this.o.getEventRegistration();
                }
                this.m = eventRegistration.getLease();
                this.n.renewUntil(this.m, Long.MAX_VALUE, 60000L, new u(this));
            }
            catch (TransactionException transactionException) {
                if (!q.isLoggable(Level.SEVERE)) break block5;
                q.log(Level.SEVERE, "Fail to register notification to space.", transactionException);
            }
        }
    }

    public Object internalPut(Object object, Object object2, Attribute[] attributeArray, long l2) {
        try {
            Envelope envelope = this.buildEnvelope(object, object2, attributeArray, this.i);
            ExternalEntry externalEntry = null;
            try {
                externalEntry = (ExternalEntry)this._spaceProxy.update((Entry)envelope, this._transaction, l2, this._timeout, 4096);
            }
            catch (OperationTimeoutException operationTimeoutException) {
                throw new CacheTimeoutException(envelope.getUID());
            }
            if (this._transaction == null) {
                CacheEntry cacheEntry = this.h.createEntry(object, object2, attributeArray, Long.MAX_VALUE, envelope.m_VersionID);
                if (this._isVersioned) {
                    this.a(envelope, externalEntry, object, object2, cacheEntry);
                } else {
                    this.b(envelope, externalEntry, object, object2, cacheEntry);
                }
                if (this.d.a) {
                    this.d.a(true);
                }
                if (this.f.size() != 0) {
                    Iterator iterator = this.f.iterator();
                    while (iterator.hasNext()) {
                        CacheListener cacheListener = (CacheListener)iterator.next();
                        cacheListener.onPut(object);
                    }
                }
            } else {
                this.evict(object);
            }
            if (externalEntry == null) {
                return null;
            }
            return Envelope.getValue(externalEntry);
        }
        catch (Exception exception) {
            if (exception instanceof CacheTimeoutException) {
                throw (CacheTimeoutException)exception;
            }
            throw new CacheException(exception);
        }
    }

    private void a(Envelope envelope, ExternalEntry externalEntry, Object object, Object object2, CacheEntry cacheEntry) {
        Object object3;
        Object object4;
        if (externalEntry != null) {
            object4 = Envelope.getValue(externalEntry);
            _entryInfos.setEntryVersion(object4, object, externalEntry.m_VersionID);
        }
        _entryInfos.setEntryVersion(object2, object, envelope.m_VersionID);
        object4 = new VersionCacheEntry(envelope.m_VersionID);
        boolean bl2 = this.e.replace(object, object4, cacheEntry);
        if (!((VersionCacheEntry)object4).isChecked() && this.j) {
            if (this.e.size() >= this.k) {
                this.h.evict(this);
            }
            if ((object3 = this.e.putIfAbsent(object, cacheEntry)) != null) {
                bl2 = this.e.replace(object, object4, cacheEntry);
            }
        }
        if (bl2 && !((object3 = ((VersionCacheEntry)object4).getOldEntry()) instanceof DummyCacheEntry)) {
            this.h.discardEntry((CacheEntry)object3);
        }
    }

    private void b(Envelope envelope, ExternalEntry externalEntry, Object object, Object object2, CacheEntry cacheEntry) {
        Object object3 = this.j ? this.e.put(object, cacheEntry) : this.e.replace(object, cacheEntry);
        if (object3 == null && this.j) {
            if (this.e.size() >= this.k) {
                this.h.evict(this);
            }
        } else if (!(object3 instanceof DummyCacheEntry)) {
            this.h.discardEntry((CacheEntry)object3);
        }
    }

    public int size() {
        return this.e.size();
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean bl2) {
        if (bl2) {
            try {
                this._spaceProxy.clear(null, null);
            }
            catch (Exception exception) {
                new CacheException(exception);
            }
        }
        this.e.clear();
        this.h.clear();
        if (this.f.size() != 0) {
            Iterator iterator = this.f.iterator();
            while (iterator.hasNext()) {
                CacheListener cacheListener = (CacheListener)iterator.next();
                cacheListener.onClear();
            }
        }
    }

    public boolean containsKey(Object object) {
        return this.e.containsKey(object);
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        Collection collection = this.e.values();
        ArrayList arrayList = new ArrayList(this.e.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)iterator.next();
            if (cacheEntry instanceof DummyCacheEntry) continue;
            arrayList.add(cacheEntry.getValue());
        }
        return arrayList;
    }

    public Set entrySet() {
        Collection collection = this.e.values();
        HashSet<CacheEntry> hashSet = new HashSet<CacheEntry>(this.e.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)iterator.next();
            if (cacheEntry instanceof DummyCacheEntry) continue;
            hashSet.add(cacheEntry);
        }
        return hashSet;
    }

    public Set keySet() {
        Collection collection = this.e.values();
        HashSet hashSet = new HashSet(this.e.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)iterator.next();
            if (cacheEntry instanceof DummyCacheEntry) continue;
            hashSet.add(cacheEntry.getKey());
        }
        return hashSet;
    }

    public void addListener(CacheListener cacheListener) {
        this.f.add(cacheListener);
    }

    public boolean evict(Object object) {
        boolean bl2;
        boolean bl3 = bl2 = this.e.remove(object) != null;
        if (bl2 && this.f.size() != 0) {
            Iterator iterator = this.f.iterator();
            while (iterator.hasNext()) {
                CacheListener cacheListener = (CacheListener)iterator.next();
                cacheListener.onEvict(object);
            }
        }
        return bl2;
    }

    public CacheEntry getCacheEntry(Object object) {
        return (CacheEntry)this.e.get(object);
    }

    public void load(Object object) throws com.j_spaces.javax.cache.CacheException {
        this.internalGet(object, Long.MAX_VALUE, false);
    }

    public void loadAll(Collection collection) throws com.j_spaces.javax.cache.CacheException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            this.load(e2);
        }
    }

    public Object peek(Object object) {
        CacheEntry cacheEntry = (CacheEntry)this.e.get(object);
        if (cacheEntry != null) {
            return cacheEntry.getValue();
        }
        return null;
    }

    public void removeListener(CacheListener cacheListener) {
        this.f.remove(cacheListener);
    }

    public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
        this.a((EntryArrivedRemoteEvent)remoteEvent);
    }

    private void a(EntryArrivedRemoteEvent entryArrivedRemoteEvent) throws UnknownEventException, RemoteException {
        try {
            Object object;
            ExternalEntry externalEntry = (ExternalEntry)entryArrivedRemoteEvent.getEntry(true);
            if (entryArrivedRemoteEvent.getNotifyType() != 4 && entryArrivedRemoteEvent.getNotifyType() != 8 && this.i.equals(object = Envelope.getCacheID(externalEntry))) {
                return;
            }
            object = Envelope.getKey(externalEntry);
            if (this.g == 2 && entryArrivedRemoteEvent.getNotifyType() == 2) {
                if (!this.e.containsKey(object)) {
                    return;
                }
                Object object2 = Envelope.getValue(externalEntry);
                if (this._isVersioned) {
                    _entryInfos.setEntryVersion(object2, object, externalEntry.m_VersionID);
                }
                Attribute[] attributeArray = Envelope.getAttributes(externalEntry);
                CacheEntry cacheEntry = this.h.createEntry(object, object2, attributeArray, Long.MAX_VALUE, externalEntry.m_VersionID);
                if (this._isVersioned) {
                    this.e.replace(object, new VersionCacheEntry(externalEntry.m_VersionID), cacheEntry);
                } else {
                    this.e.replace(object, cacheEntry);
                }
            } else {
                this.e.remove(object);
            }
        }
        catch (UnusableEntryException unusableEntryException) {
            throw new CacheException(unusableEntryException);
        }
    }

    public Object internalRemove(Object object, long l2) {
        ExternalEntry externalEntry;
        try {
            Envelope envelope = this.buildEnvelope(object, null, null, null);
            externalEntry = null;
            externalEntry = this._transaction == null ? (ExternalEntry)this._spaceProxy.take(envelope, (Transaction)null, l2) : (ExternalEntry)this._spaceProxy.takeIfExists(envelope, this._transaction, l2);
            if (externalEntry == null) {
                if (this._transaction == null) {
                    Object var6_7 = null;
                    return var6_7;
                }
                throw new CacheTimeoutException(envelope.m_UID);
            }
            Object object2 = Envelope.getValue(externalEntry);
            return object2;
        }
        catch (EntryNotInSpaceException entryNotInSpaceException) {
            externalEntry = null;
            return externalEntry;
        }
        catch (Exception exception) {
            if (exception instanceof CacheTimeoutException) {
                throw (CacheTimeoutException)exception;
            }
            throw new CacheException(exception);
        }
        finally {
            CacheEntry cacheEntry = (CacheEntry)this.e.remove(object);
            if (cacheEntry != null && !(cacheEntry instanceof DummyCacheEntry)) {
                this.h.discardEntry(cacheEntry);
                if (this.f.size() != 0) {
                    Iterator iterator = this.f.iterator();
                    while (iterator.hasNext()) {
                        CacheListener cacheListener = (CacheListener)iterator.next();
                        cacheListener.onRemove(object);
                    }
                }
            }
        }
    }

    private Object a(CacheEntry cacheEntry, boolean bl2) {
        this.h.touchEntry(cacheEntry);
        if (bl2) {
            if (cacheEntry instanceof BaseCacheEntry) {
                return ((BaseCacheEntry)cacheEntry).getAttributes();
            }
            return null;
        }
        return cacheEntry.getValue();
    }

    public Object internalGet(Object object, long l2, boolean bl2) {
        Transaction transaction = this._transaction;
        try {
            if (transaction == null) {
                return this.a(object, l2, bl2);
            }
            return this.a(object, l2, bl2, transaction);
        }
        catch (EntryNotInSpaceException entryNotInSpaceException) {
            return null;
        }
        catch (CacheTimeoutException cacheTimeoutException) {
            throw cacheTimeoutException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a(Object object, long l2, boolean bl2, Transaction transaction) throws Exception {
        try {
            ExternalEntry externalEntry;
            Envelope envelope = this.buildKeyEnvelope(object);
            if (this.d.a) {
                this.d.a(true);
            }
            if ((externalEntry = (ExternalEntry)this._spaceProxy.readIfExists(envelope, this._transaction, l2)) == null) {
                throw new CacheTimeoutException(envelope.m_UID);
            }
            Object object2 = Envelope.getValue(externalEntry);
            try {
                object2 = JSpaceProxyUtil.deSerializeFieldValue(object2, this._compression, false);
            }
            catch (IOException iOException) {
                throw new CacheException(iOException);
            }
            if (this._isVersioned) {
                _entryInfos.setEntryVersion(object2, object, externalEntry.m_VersionID);
            }
            if (bl2) {
                Attribute[] attributeArray = Envelope.getAttributes(externalEntry);
                return attributeArray;
            }
            Object object3 = object2;
            return object3;
        }
        finally {
            this.evict(object);
        }
    }

    private Object a(Object object, long l2, boolean bl2) throws Exception {
        Attribute[] attributeArray;
        CacheEntry cacheEntry;
        ExternalEntry externalEntry;
        DummyCacheEntry dummyCacheEntry = null;
        CacheEntry cacheEntry2 = (CacheEntry)this.e.get(object);
        if (cacheEntry2 == null ? (cacheEntry2 = (CacheEntry)this.e.putIfAbsent(object, dummyCacheEntry = new DummyCacheEntry())) != null && !(cacheEntry2 instanceof DummyCacheEntry) : !(cacheEntry2 instanceof DummyCacheEntry)) {
            return this.a(cacheEntry2, bl2);
        }
        Envelope envelope = this.buildKeyEnvelope(object);
        if (this.d.a) {
            this.d.a(true);
        }
        if ((externalEntry = (ExternalEntry)this._spaceProxy.read(envelope, (Transaction)null, l2)) == null) {
            if (dummyCacheEntry != null) {
                this.e.remove(object, dummyCacheEntry);
            }
            return null;
        }
        if (this.e.size() >= this.k) {
            this.h.evict(this);
        }
        Object object2 = Envelope.getValue(externalEntry);
        try {
            object2 = JSpaceProxyUtil.deSerializeFieldValue(object2, this._compression, false);
        }
        catch (IOException iOException) {
            throw new CacheException(iOException);
        }
        if (this._isVersioned) {
            _entryInfos.setEntryVersion(object2, object, externalEntry.m_VersionID);
        }
        if (!this.e.replace(object, new VersionCacheEntry(externalEntry.m_VersionID, dummyCacheEntry), cacheEntry = this.h.createEntry(object, object2, attributeArray = Envelope.getAttributes(externalEntry), Long.MAX_VALUE, externalEntry.m_VersionID))) {
            this.h.discardEntry(cacheEntry);
        } else if (this.f.size() != 0) {
            Iterator iterator = this.f.iterator();
            while (iterator.hasNext()) {
                CacheListener cacheListener = (CacheListener)iterator.next();
                cacheListener.onLoad(object);
            }
        }
        if (bl2) {
            return attributeArray;
        }
        return object2;
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        this.log("LRM: Failed to renew lease.");
        try {
            Lease lease = leaseRenewalEvent.getLease();
            try {
                this.n.cancel(lease);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean bl2 = false;
            int n2 = 0;
            boolean bl3 = false;
            while (!bl2 && n2++ < this.a) {
                try {
                    if (!bl3) {
                        this._spaceProxy.ping();
                    } else {
                        this._spaceProxy = (IJSpace)SpaceFinder.find(this.l);
                    }
                    bl2 = true;
                }
                catch (FinderException finderException) {
                    this.log("SpaceFinder Retry: " + n2, finderException);
                    Thread.sleep(this.b);
                }
                catch (RemoteException remoteException) {
                    n2 = 0;
                    bl3 = true;
                    this.log("Ping failed to : " + this.l, remoteException);
                }
            }
            if (!bl2) {
                throw new com.j_spaces.javax.cache.CacheException("_remoteSpace [" + this.l + "] is not accessible. Giving up after trying " + this.a + " times.");
            }
            this.a(this.p != null);
            this.clear();
            this.log("Reinitialized successfully.");
        }
        catch (Exception exception) {
            this.log("Failed to initialize space", exception);
        }
    }

    public void finalize() throws Throwable {
        if (this.o != null) {
            this.o.close();
        }
        if (this.d != null) {
            this.d.a();
        }
        if (this.m != null) {
            if (this.n != null) {
                this.n.cancel(this.m);
            } else {
                this.m.cancel();
            }
        }
    }

    private static final class VersionCacheEntry
    extends DummyCacheEntry {
        private final int a;
        private final DummyCacheEntry b;
        private Object c;
        private boolean d = false;

        public VersionCacheEntry(int n2) {
            this(n2, null);
        }

        public VersionCacheEntry(int n2, DummyCacheEntry dummyCacheEntry) {
            this.a = n2;
            this.b = dummyCacheEntry;
        }

        public boolean equals(Object object) {
            this.d = true;
            this.c = object;
            if (!(object instanceof DummyCacheEntry)) {
                long l2 = ((CacheEntry)object).getVersion();
                return (long)this.a > l2;
            }
            return this.b == object;
        }

        public Object getOldEntry() {
            return this.c;
        }

        public boolean isChecked() {
            return this.d;
        }
    }
}

