/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.EntrySerializationException;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.JSpaceProxyUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.sf.retrotranslator.runtime.java.lang._Byte;
import net.sf.retrotranslator.runtime.java.lang._Character;
import net.sf.retrotranslator.runtime.java.lang._Double;
import net.sf.retrotranslator.runtime.java.lang._Float;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._Long;

public class ExternalEntry
implements Entry,
IGSEntry {
    private static final long serialVersionUID = 1L;
    public String m_UID;
    public String m_ClassName;
    public String[] m_SuperClassesNames;
    public String[] m_FieldsNames;
    public String[] m_FieldsTypes;
    public Object[] m_FieldsValues;
    public boolean[] m_IndexIndicators;
    public String m_PrimaryKeyName;
    public boolean m_Replicatable;
    public String[] m_MultipleUIDs;
    public boolean m_ReturnOnlyUids;
    public boolean m_isFifo;
    public int m_VersionID;
    public short[] m_ExtendedMatchCodes;
    public Object[] m_RangeValues;
    public long m_TimeToLive;
    public boolean m_isTransient;
    public boolean m_NOWriteLeaseMode;
    public short _objectFormat;
    public String routingFieldName;
    private static final byte OBJECT_BIT = 0;
    private static final byte INTEGER_BIT = 1;
    private static final byte DOUBLE_BIT = 2;
    private static final byte FLOAT_BIT = 3;
    private static final byte LONG_BIT = 4;
    private static final byte STRING_BIT = 5;
    private static final byte SHORT_BIT = 6;
    private static final byte BOOLEAN_BIT = 7;
    private static final byte CHAR_BIT = 8;
    private static final byte BYTE_BIT = 9;

    public ExternalEntry() {
    }

    public ExternalEntry(String string) {
        this.m_UID = string;
    }

    public ExternalEntry(String[] stringArray) {
        this.m_MultipleUIDs = stringArray;
    }

    public ExternalEntry(String string, Object[] objectArray, String[] stringArray, String[] stringArray2) {
        this(string, objectArray, stringArray);
        this.m_FieldsTypes = stringArray2;
    }

    public ExternalEntry(String string, Object[] objectArray, String[] stringArray) {
        int n2;
        if (string == null) {
            throw new RuntimeException("ExternalEntry problem, Class Name is NULL !");
        }
        this.m_ClassName = string;
        int n3 = objectArray == null ? 0 : objectArray.length;
        int n4 = n2 = stringArray == null ? 0 : stringArray.length;
        if (n3 != 0 && n2 != 0 && n3 != n2) {
            throw new RuntimeException("ExternalEntry problem, values do not match fields names !");
        }
        this.m_FieldsValues = objectArray;
        this.m_FieldsNames = stringArray;
    }

    public ExternalEntry(String string, Object[] objectArray) {
        this(string, objectArray, null);
    }

    private void writePrimitiveObject(ObjectOutput objectOutput, Object object, int n2) throws IOException {
        try {
            if (object instanceof Integer) {
                objectOutput.writeByte(1);
                objectOutput.writeInt((Integer)object);
            } else if (object instanceof Double) {
                objectOutput.writeByte(2);
                objectOutput.writeDouble((Double)object);
            } else if (object instanceof Float) {
                objectOutput.writeByte(3);
                objectOutput.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Long) {
                objectOutput.writeByte(4);
                objectOutput.writeLong((Long)object);
            } else if (object instanceof String && (long)((String)object).length() <= 65535L) {
                objectOutput.writeByte(5);
                objectOutput.writeUTF((String)object);
            } else if (object instanceof Short) {
                objectOutput.writeByte(6);
                objectOutput.writeShort(((Short)object).shortValue());
            } else if (object instanceof Boolean) {
                objectOutput.writeByte(7);
                objectOutput.writeBoolean((Boolean)object);
            } else if (object instanceof Character) {
                objectOutput.writeByte(8);
                objectOutput.writeChar(((Character)object).charValue());
            } else if (object instanceof Byte) {
                objectOutput.writeByte(9);
                objectOutput.writeByte(((Byte)object).byteValue());
            } else {
                objectOutput.writeByte(0);
                if (objectOutput instanceof ObjectOutputStream) {
                    ((ObjectOutputStream)objectOutput).writeUnshared(object);
                } else {
                    objectOutput.writeObject(object);
                }
            }
        }
        catch (IOException iOException) {
            String string = "";
            String string2 = "";
            if (this.m_FieldsNames != null && this.m_FieldsNames[n2] != null) {
                string = "\nField Name      : " + this.m_FieldsNames[n2];
            }
            if (this.m_FieldsValues != null && this.m_FieldsValues[n2] != null) {
                string2 = "\nField Type     : " + this.m_FieldsValues[n2].getClass().getName();
            }
            throw new EntrySerializationException("Failed to serialize Entry field.\nEntry Classname : " + this.m_ClassName + string2 + string, iOException);
        }
    }

    private Object readPrimitiveObject(ObjectInput objectInput, int n2) throws IOException, ClassNotFoundException {
        try {
            byte by2 = objectInput.readByte();
            switch (by2) {
                case 1: {
                    return _Integer.valueOf(objectInput.readInt());
                }
                case 2: {
                    return _Double.valueOf(objectInput.readDouble());
                }
                case 3: {
                    return _Float.valueOf(objectInput.readFloat());
                }
                case 4: {
                    return _Long.valueOf(objectInput.readLong());
                }
                case 5: {
                    return objectInput.readUTF();
                }
                case 6: {
                    return new Short(objectInput.readShort());
                }
                case 7: {
                    return objectInput.readBoolean();
                }
                case 8: {
                    return _Character.valueOf(objectInput.readChar());
                }
                case 9: {
                    return _Byte.valueOf(objectInput.readByte());
                }
            }
            if (objectInput instanceof ObjectInputStream) {
                return ((ObjectInputStream)objectInput).readUnshared();
            }
            return objectInput.readObject();
        }
        catch (IOException iOException) {
            String string = "";
            String string2 = "";
            if (this.m_FieldsNames != null && this.m_FieldsNames[n2] != null) {
                string = "\nField Name      : " + this.m_FieldsNames[n2];
            }
            if (this.m_FieldsValues != null && this.m_FieldsValues[n2] != null) {
                string2 = "\nField Type     : " + this.m_FieldsValues[n2].getClass().getName();
            }
            throw new EntrySerializationException("Failed to deserialize Entry field.\nEntry Classname : " + this.m_ClassName + string2 + string, iOException);
        }
    }

    private int buildFlags() {
        int n2 = 0;
        if (this.m_UID != null) {
            n2 |= 0x10000000;
        }
        if (this.m_ClassName != null) {
            n2 |= 0x20000000;
        }
        if (this.m_SuperClassesNames != null) {
            n2 |= 0x40000000;
        }
        if (this.m_FieldsNames != null) {
            n2 |= Integer.MIN_VALUE;
        }
        if (this.m_FieldsTypes != null) {
            n2 |= 0x1000000;
        }
        if (this.m_FieldsValues != null) {
            n2 |= 0x2000000;
        }
        if (this.m_IndexIndicators != null) {
            n2 |= 0x4000000;
        }
        if (this.m_Replicatable) {
            n2 |= 0x8000000;
        }
        if (this.m_MultipleUIDs != null) {
            n2 |= 0x100000;
        }
        if (this.m_ReturnOnlyUids) {
            n2 |= 0x200000;
        }
        if (this.m_isFifo) {
            n2 |= 0x400000;
        }
        if (this.m_ExtendedMatchCodes != null) {
            n2 |= 0x800000;
        }
        if (this.m_RangeValues != null) {
            n2 |= 0x10000;
        }
        if (this.m_TimeToLive != 0L) {
            n2 |= 0x20000;
        }
        if (this.m_isTransient) {
            n2 |= 0x40000;
        }
        if (this.m_NOWriteLeaseMode) {
            n2 |= 0x80000;
        }
        return n2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            int n2;
            objectOutput.writeInt(this.buildFlags());
            if (this.m_UID != null) {
                objectOutput.writeUTF(this.m_UID);
                objectOutput.writeInt(this.m_VersionID);
                if (this.m_TimeToLive != 0L) {
                    objectOutput.writeLong(this.m_TimeToLive);
                }
            }
            if (this.m_ClassName != null) {
                objectOutput.writeUTF(this.m_ClassName);
            }
            if (this.m_FieldsValues != null) {
                int n3;
                n2 = this.m_FieldsValues.length;
                objectOutput.writeInt(n2);
                int n4 = 0;
                boolean bl2 = false;
                if (n2 > 3) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (this.m_FieldsValues[n3] == null) continue;
                        ++n4;
                    }
                    if (n4 < n2 / 2) {
                        bl2 = true;
                    }
                    objectOutput.writeBoolean(bl2);
                    if (bl2) {
                        objectOutput.writeInt(n4);
                    }
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    if (this.m_FieldsValues[n3] != null) {
                        if (bl2) {
                            objectOutput.writeInt(n3);
                        } else {
                            objectOutput.writeBoolean(true);
                        }
                        this.writePrimitiveObject(objectOutput, this.m_FieldsValues[n3], n3);
                        continue;
                    }
                    if (bl2) continue;
                    objectOutput.writeBoolean(false);
                }
            }
            if (this.m_FieldsNames != null) {
                objectOutput.writeInt(this.m_FieldsNames.length);
                for (n2 = 0; n2 < this.m_FieldsNames.length; ++n2) {
                    objectOutput.writeUTF(this.m_FieldsNames[n2]);
                }
            }
            if (this.m_FieldsTypes != null) {
                objectOutput.writeInt(this.m_FieldsTypes.length);
                for (n2 = 0; n2 < this.m_FieldsTypes.length; ++n2) {
                    objectOutput.writeUTF(this.m_FieldsTypes[n2]);
                }
            }
            if (this.m_IndexIndicators != null) {
                objectOutput.writeInt(this.m_IndexIndicators.length);
                for (n2 = 0; n2 < this.m_IndexIndicators.length; ++n2) {
                    objectOutput.writeBoolean(this.m_IndexIndicators[n2]);
                }
            }
            objectOutput.writeShort(this._objectFormat);
            if (this.m_SuperClassesNames != null) {
                objectOutput.writeInt(this.m_SuperClassesNames.length);
                for (n2 = 0; n2 < this.m_SuperClassesNames.length; ++n2) {
                    objectOutput.writeUTF(this.m_SuperClassesNames[n2]);
                }
            }
            if (this.m_MultipleUIDs != null) {
                objectOutput.writeInt(this.m_MultipleUIDs.length);
                for (n2 = 0; n2 < this.m_MultipleUIDs.length; ++n2) {
                    objectOutput.writeUTF(this.m_MultipleUIDs[n2]);
                }
            }
            if (this.m_ExtendedMatchCodes != null) {
                objectOutput.writeInt(this.m_ExtendedMatchCodes.length);
                for (n2 = 0; n2 < this.m_ExtendedMatchCodes.length; ++n2) {
                    objectOutput.writeShort(this.m_ExtendedMatchCodes[n2]);
                }
            }
            if (this.m_RangeValues != null) {
                objectOutput.writeInt(this.m_RangeValues.length);
                for (n2 = 0; n2 < this.m_RangeValues.length; ++n2) {
                    objectOutput.writeObject(this.m_RangeValues[n2]);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof EntrySerializationException) {
                throw (EntrySerializationException)exception;
            }
            String string = this.m_ClassName != null ? this.m_ClassName : ".";
            throw new EntrySerializationException("Failed to serialize Entry " + string, exception);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            int n2;
            int n3;
            int n4 = objectInput.readInt();
            if ((n4 & 0x10000000) != 0) {
                this.m_UID = objectInput.readUTF();
                this.m_VersionID = objectInput.readInt();
                if ((n4 & 0x20000) != 0) {
                    this.m_TimeToLive = objectInput.readLong();
                }
            }
            if ((n4 & 0x20000000) != 0) {
                this.m_ClassName = objectInput.readUTF();
            }
            this.m_Replicatable = (n4 & 0x8000000) != 0;
            this.m_ReturnOnlyUids = (n4 & 0x200000) != 0;
            this.m_isFifo = (n4 & 0x400000) != 0;
            this.m_isTransient = (n4 & 0x40000) != 0;
            boolean bl2 = this.m_NOWriteLeaseMode = (n4 & 0x80000) != 0;
            if ((n4 & 0x2000000) != 0) {
                int n5;
                n3 = objectInput.readInt();
                this.m_FieldsValues = new Object[n3];
                n2 = 0;
                boolean bl3 = false;
                if (n3 > 3 && (bl3 = objectInput.readBoolean())) {
                    n2 = objectInput.readInt();
                }
                if (bl3) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        int n6 = objectInput.readInt();
                        this.m_FieldsValues[n6] = this.readPrimitiveObject(objectInput, n6);
                    }
                } else {
                    for (n5 = 0; n5 < n3; ++n5) {
                        if (!objectInput.readBoolean()) continue;
                        this.m_FieldsValues[n5] = this.readPrimitiveObject(objectInput, n5);
                    }
                }
            }
            if ((n4 & Integer.MIN_VALUE) != 0) {
                n3 = objectInput.readInt();
                this.m_FieldsNames = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_FieldsNames[n2] = objectInput.readUTF();
                }
            }
            if ((n4 & 0x1000000) != 0) {
                n3 = objectInput.readInt();
                this.m_FieldsTypes = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_FieldsTypes[n2] = objectInput.readUTF();
                }
            }
            if ((n4 & 0x4000000) != 0) {
                n3 = objectInput.readInt();
                this.m_IndexIndicators = new boolean[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_IndexIndicators[n2] = objectInput.readBoolean();
                }
            }
            this._objectFormat = objectInput.readShort();
            if ((n4 & 0x40000000) != 0) {
                n3 = objectInput.readInt();
                this.m_SuperClassesNames = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_SuperClassesNames[n2] = objectInput.readUTF();
                }
            }
            if ((n4 & 0x100000) != 0) {
                n3 = objectInput.readInt();
                this.m_MultipleUIDs = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_MultipleUIDs[n2] = objectInput.readUTF();
                }
            }
            if ((n4 & 0x800000) != 0) {
                n3 = objectInput.readInt();
                this.m_ExtendedMatchCodes = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_ExtendedMatchCodes[n2] = objectInput.readShort();
                }
            }
            if ((n4 & 0x10000) != 0) {
                n3 = objectInput.readInt();
                this.m_RangeValues = new Object[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_RangeValues[n2] = objectInput.readObject();
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof EntrySerializationException) {
                throw (EntrySerializationException)exception;
            }
            String string = this.m_ClassName != null ? this.m_ClassName : ".";
            throw new EntrySerializationException("Failed to deserialize Entry " + string, exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ExternalEntry) {
            ExternalEntry externalEntry = (ExternalEntry)object;
            if (this.m_UID == null && externalEntry.m_UID != null) {
                return false;
            }
            if (this.m_UID != null && !this.m_UID.equals(externalEntry.m_UID)) {
                return false;
            }
            if (this.m_FieldsValues == null && externalEntry.m_FieldsValues == null) {
                return true;
            }
            if (this.m_FieldsValues != null && externalEntry.m_FieldsValues != null) {
                if (this.m_FieldsValues.length != externalEntry.m_FieldsValues.length) {
                    return false;
                }
                for (int i2 = 0; i2 < this.m_FieldsValues.length; ++i2) {
                    if (this.m_FieldsValues[i2] == null && externalEntry.m_FieldsValues[i2] != null) {
                        return false;
                    }
                    if (this.m_FieldsValues[i2] == null || this.m_FieldsValues[i2].equals(externalEntry.m_FieldsValues[i2])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.m_UID != null ? this.m_UID.hashCode() : 10;
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public void setClassName(String string) {
        this.m_ClassName = string;
    }

    public short[] getExtendedMatchCodes() {
        return this.m_ExtendedMatchCodes;
    }

    public void setExtendedMatchCodes(short[] sArray) {
        this.m_ExtendedMatchCodes = sArray;
    }

    public String[] getFieldsNames() {
        return this.m_FieldsNames;
    }

    public void setFieldsNames(String[] stringArray) {
        this.m_FieldsNames = stringArray;
    }

    public String[] getFieldsTypes() {
        return this.m_FieldsTypes;
    }

    public void setFieldsTypes(String[] stringArray) {
        this.m_FieldsTypes = stringArray;
    }

    public Object[] getFieldsValues() {
        return this.m_FieldsValues;
    }

    public void setFieldsValues(Object[] objectArray) {
        this.m_FieldsValues = objectArray;
    }

    public Object[] getRangeValues() {
        return this.m_RangeValues;
    }

    public void setRangeValues(Object[] objectArray) {
        this.m_RangeValues = objectArray;
    }

    public boolean isFifo() {
        return this.m_isFifo;
    }

    public void setFifo(boolean bl2) {
        this.m_isFifo = bl2;
    }

    public boolean[] getIndexIndicators() {
        return this.m_IndexIndicators;
    }

    public void setIndexIndicators(boolean[] blArray) {
        this.m_IndexIndicators = blArray;
    }

    public String getPrimaryKeyName() {
        return this.m_PrimaryKeyName;
    }

    public void setPrimaryKeyName(String string) {
        this.m_PrimaryKeyName = string;
    }

    public String[] getMultipleUIDs() {
        return this.m_MultipleUIDs;
    }

    public void setMultipleUIDs(String[] stringArray) {
        this.m_MultipleUIDs = stringArray;
    }

    public boolean isReplicatable() {
        return this.m_Replicatable;
    }

    public void setReplicatable(boolean bl2) {
        this.m_Replicatable = bl2;
    }

    public boolean isReturnOnlyUids() {
        return this.m_ReturnOnlyUids;
    }

    public void setReturnOnlyUids(boolean bl2) {
        this.m_ReturnOnlyUids = bl2;
    }

    public String[] getSuperClassesNames() {
        return this.m_SuperClassesNames;
    }

    public String getCodebase() {
        return null;
    }

    public void setSuperClassesNames(String[] stringArray) {
        this.m_SuperClassesNames = stringArray;
    }

    public long getTimeToLive() {
        return this.m_TimeToLive;
    }

    public void setTimeToLive(long l2) {
        this.m_TimeToLive = l2;
    }

    public int getVersion() {
        return this.getVersionID();
    }

    public boolean isTransient() {
        return this.m_isTransient;
    }

    public void makeTransient() {
        this.m_isTransient = true;
    }

    public void makePersistent() {
        this.m_isTransient = false;
    }

    public Map.Entry getMapEntry() {
        return null;
    }

    public short getFormat() {
        return this._objectFormat;
    }

    public void setFormat(short s2) {
        this._objectFormat = s2;
    }

    public String getUID() {
        return this.m_UID;
    }

    public void setUID(String string) {
        this.m_UID = string;
    }

    public int getVersionID() {
        return this.m_VersionID;
    }

    public void setVersionID(int n2) {
        this.m_VersionID = n2;
    }

    public void setNOWriteLeaseMode(boolean bl2) {
        this.m_NOWriteLeaseMode = bl2;
    }

    public boolean isNOWriteLeaseMode() {
        return this.m_NOWriteLeaseMode;
    }

    public Object getFieldValue(String string) {
        return this.getFieldValue(this.getFieldPosition(string));
    }

    public Object setFieldValue(String string, Object object) {
        return this.setFieldValue(this.getFieldPosition(string), object);
    }

    public String getFieldType(String string) {
        int n2 = this.getFieldPosition(string);
        try {
            return this.m_FieldsTypes[n2];
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("The field types array was not properly set");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public boolean isIndexedField(String string) {
        int n2 = this.getFieldPosition(string);
        try {
            return this.m_IndexIndicators[n2];
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("The field indexes array was not properly set");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public Object getFieldValue(int n2) throws IllegalArgumentException, IllegalStateException {
        try {
            return this.m_FieldsValues[n2];
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("The field values array was not properly set");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public Object setFieldValue(int n2, Object object) throws IllegalArgumentException, IllegalStateException {
        try {
            Object object2 = this.m_FieldsValues[n2];
            this.m_FieldsValues[n2] = object;
            return object2;
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("The field values array was not properly set");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public int getFieldPosition(String string) {
        if (this.m_FieldsNames != null) {
            for (int i2 = 0; i2 < this.m_FieldsNames.length; ++i2) {
                if (!this.m_FieldsNames[i2].equals(string)) continue;
                return i2;
            }
        }
        throw new IllegalArgumentException("Field name " + string + " is not avaliable");
    }

    public Entry getEntry(IJSpace iJSpace) throws UnusableEntryException {
        IDirectSpaceProxy iDirectSpaceProxy;
        if (iJSpace instanceof DCacheSpaceImpl) {
            DCacheSpaceImpl dCacheSpaceImpl = (DCacheSpaceImpl)iJSpace;
            iDirectSpaceProxy = (IDirectSpaceProxy)dCacheSpaceImpl.getLocalSpace();
        } else {
            iDirectSpaceProxy = (IDirectSpaceProxy)iJSpace;
        }
        return iDirectSpaceProxy.getEntry(this);
    }

    public Object getObject(IJSpace iJSpace) throws UnusableEntryException {
        if (this._objectFormat == 1) {
            return JSpaceProxyUtil.converter.toPojo(this);
        }
        return this.getEntry(iJSpace);
    }

    public ExternalEntry getExternalEntry(IJSpace iJSpace) throws UnusableEntryException {
        return this;
    }

    public String getRoutingFieldName() {
        return this.routingFieldName;
    }

    public void setRoutingFieldName(String string) {
        this.routingFieldName = string;
    }

    private static final class BitMap {
        private static final int a = 0x10000000;
        private static final int b = 0x20000000;
        private static final int c = 0x40000000;
        private static final int d = Integer.MIN_VALUE;
        private static final int e = 0x1000000;
        private static final int f = 0x2000000;
        private static final int g = 0x4000000;
        private static final int h = 0x8000000;
        private static final int i = 0x100000;
        private static final int j = 0x200000;
        private static final int k = 0x400000;
        private static final int l = 0x800000;
        private static final int m = 65536;
        private static final int n = 131072;
        private static final int o = 262144;
        private static final int p = 524288;

        private BitMap() {
        }
    }
}

