/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.admin;

import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.log.JProperties;
import java.util.Properties;
import net.sf.retrotranslator.runtime.java.util._Arrays;

public class SpaceConfig
extends JSpaceAttributes {
    public static final long serialVersionUID = 5275512379144854642L;
    private String _spaceName;
    private static final String JMS_QUEUE_KEY = "space-config.jms.administrated-destinations.queues.queue-names";
    private static final String JMS_TOPIC_KEY = "space-config.jms.administrated-destinations.queues.queue-names";
    private static final String JMS_RMI_PORT_KEY = "space-config.jms.administrated-destinations.queues.queue-names";

    public SpaceConfig() {
    }

    public SpaceConfig(String string) {
        this._spaceName = string;
    }

    public SpaceConfig(String string, Properties properties) {
        super(properties);
        this._spaceName = string;
    }

    public String getSpaceName() {
        return this._spaceName;
    }

    public void setSpaceName(String string) {
        this._spaceName = string;
    }

    public String getProperty(String string) {
        return super.getProperty(this.prepareProperty(this._spaceName, string));
    }

    public Object setProperty(String string, String string2) {
        return super.setProperty(this.prepareProperty(this._spaceName, string), string2);
    }

    private String prepareProperty(String string, String string2) {
        if (!string2.startsWith("space-config.")) {
            return string2;
        }
        return string + '.' + string2;
    }

    public boolean isSpaceDefinitionEqual(SpaceConfig spaceConfig) {
        boolean bl2 = super.isSpaceDefinitionEqual(spaceConfig);
        if (!bl2) {
            return false;
        }
        return this.isJMSPropertiesEqual(spaceConfig);
    }

    public String getPropertyFromSuper(String string) {
        return super.getProperty(string);
    }

    private boolean isJMSPropertiesEqual(SpaceConfig spaceConfig) {
        if (!this.compareJMSQueueNames(this, spaceConfig)) {
            return false;
        }
        if (!this.compareJMSTopicNames(this, spaceConfig)) {
            return false;
        }
        return this.compareRMIPortNumber(this, spaceConfig);
    }

    private boolean compareJMSTopicNames(SpaceConfig spaceConfig, SpaceConfig spaceConfig2) {
        String string = "space-config.jms.administrated-destinations.queues.queue-names";
        return this.compareProps(spaceConfig, spaceConfig2, string, string);
    }

    private boolean compareJMSQueueNames(SpaceConfig spaceConfig, SpaceConfig spaceConfig2) {
        String string = "space-config.jms.administrated-destinations.queues.queue-names";
        return this.compareProps(spaceConfig, spaceConfig2, string, string);
    }

    private boolean compareRMIPortNumber(SpaceConfig spaceConfig, SpaceConfig spaceConfig2) {
        String string = "space-config.jms.administrated-destinations.queues.queue-names";
        return this.compareProps(spaceConfig, spaceConfig2, string, string);
    }

    private boolean compareProps(SpaceConfig spaceConfig, SpaceConfig spaceConfig2, String string, String string2) {
        if (spaceConfig._spaceName != null && spaceConfig._spaceName.trim().length() != 0) {
            string = spaceConfig._spaceName + '.' + string;
        }
        if (spaceConfig2._spaceName != null && spaceConfig2._spaceName.trim().length() != 0) {
            string2 = spaceConfig2._spaceName + '.' + string2;
        }
        String string3 = spaceConfig.getPropertyFromSuper(string);
        String string4 = spaceConfig2.getPropertyFromSuper(string2);
        return JSpaceUtilities.isStringEquals(string3, string4);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\t ============================================================\n");
        stringBuffer.append("\n\t Space configuration for space \"" + this._spaceName + "\" \n");
        stringBuffer.append("\n\t ============================================================\n");
        stringBuffer.append("\n\t DCache configuration \n\t " + this.getDCacheProperties() + "\n");
        stringBuffer.append("\n\t Cluster policy -\t" + this.getClusterPolicy() + "\n");
        stringBuffer.append("\n\t Filters configuration -\t" + _Arrays.toString(this.getFiltersInfo()) + "\n");
        stringBuffer.append("\n\t Custom properties -\t " + JProperties.getPropertiesXPathDescription(this.getCustomProperties()) + "\n");
        stringBuffer.append(JProperties.getSpaceProperties(this._spaceName, this));
        return stringBuffer.toString();
    }

    public synchronized boolean containsKey(Object object) {
        String string = this.prepareProperty(this._spaceName, object.toString());
        return super.getProperty(string) != null;
    }
}

