/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.SSLStubHandlerImpl;
import com.j_spaces.core.filters.DefaultSecurityFilter;
import com.j_spaces.core.lrmi.LRMIStubHandlerImpl;
import com.j_spaces.kernel.PlatformVersion;
import com.j_spaces.kernel.logfile.LogFileImpl;
import com.j_spaces.sadapter.GenericJDBC.JDBCStorageAdapter;

public interface Constants {
    public static final String SPACE_CONFIG_PREFIX = "space-config.";
    public static final String CONTAINER_CONFIG_PREFIX = "com.j_spaces.core.container.";
    public static final String SPACE_PERSISTENT_PREFIX = "persistent.";
    public static final String QUERY_PROCESSOR_PREFIX = "QueryProcessor.";
    public static final String IS_SPACE_LOAD_ON_STARTUP = "load-on-startup";

    public static interface Security {
        public static final int PASSWORD_SYMBOLS_MIN = 4;
        public static final int PASSWORD_SYMBOLS_MAX = 256;
        public static final String CONTAINER_SECURITY_ADMIN_NAME_PROP = "com.j_spaces.core.container.admin-name";
        public static final String CONTAINER_SECURITY_ADMIN_NAME_DEFAULT = "gsadmin";
        public static final String CONTAINER_SECURITY_ADMIN_PASSWORD_PROP = "com.j_spaces.core.container.admin-password";
        public static final String CONTAINER_SECURITY_ADMIN_PASSWORD_DEFAULT = "admin";
    }

    public static interface Statistics {
        public static final String STATISTICS_FILTER_NAME = "Statistics";
        public static final Long DEFAULT_PERIOD = new Long(10000L);
    }

    public static interface ServiceUI {
        public static final String SERVICE_UI_CLASS_NAME_PROP = "service-ui.class-name";
        public static final String SERVICE_UI_CLASS_NAME_DEFAULT = "com.j_spaces.core.service.ui.JSpaceServiceUI";
        public static final String SERVICE_UI_EXPORT_URLS_PROP = "service-ui.export-urls";
    }

    public static interface SpaceBrowser {
        public static final String HTTP_DEAMON_PORT_DEFAULT = "9813";
        public static final String HTTP_DEAMON_PORT_SYS_PROP = "com.gs.browser.httpd.port";
        public static final String HTTP_DEAMON_ENABLED_SYS_PROP = "com.gs.browser.httpd.enabled";
        public static final String UNICAST_DISCOVERY_PROP = "com.gs.browser.unicast_discovery";
        public static final String BROWSER_LAF_IS_CROSS_PLATFORM = "com.gs.browser.laf.isCross";
        public static final String CONTAINER_NAME = "com.gs.browser.containername";
    }

    public static interface WorkerManager {
        public static final String WORKER_PREFIX = "workers.";
        public static final String IS_INTERRUPT_THREADS_ON_SHUTDOWN = "workers.interrupt";
        public static final String WORKER_NAMES_PROP = "workers.worker-names";
        public static final String WORKER_ENABLED = "enabled";
        public static final String WORKER_ACTIVE_WHEN_BACKUP = "active-when-backup";
        public static final String WORKER_CLASSNAME = "class-name";
        public static final String WORKER_SHUTDOWN_ON_INIT_FAILURE = "shutdown-space-on-init-failure";
        public static final String WORKER_INSTANCES = "instances";
        public static final String WORKER_ARG = "arg";
        public static final String WORKER_DESCRIPTION = "description";
        public static final String MULTICAST_WORKER_PREFIX = "workers.MulticastNotifyWorker.";
        public static final String DISPATCH_INTERVAL_TIME = "workers.MulticastNotifyWorker.interval-dispatch-time";
        public static final String DISPATCH_INTERVAL_TIME_DEFAULT = "500";
        public static final String DISPATCH_EVENT_CHUNK_SIZE = "workers.MulticastNotifyWorker.chunk-event-size";
        public static final String DISPATCH_EVENT_CHUNK_SIZE_DEFAULT = "100";
        public static final String MULTICAST_GROUP = "workers.MulticastNotifyWorker.multicast-group";
        public static final String MULTICAST_GROUP_DEFAULT = "224.0.0.1";
        public static final String MULTICAST_PORT = "workers.MulticastNotifyWorker.multicast-port";
        public static final String MULTICAST_PORT_DEFAULT = "34721";
        public static final String MULTICAST_TTL = "workers.MulticastNotifyWorker.ttl";
        public static final String MULTICAST_TTL_DEFAULT = "4";
        public static final String DISCOVERY_INTERFACE = "workers.MulticastNotifyWorker.discovery-interface";
        public static final String DISCOVERY_INTERFACE_DEFAULT = "localhost";
        public static final String DEFAULT_WORKER_ENABLED = "true";
        public static final String DEFAULT_WORKER_ACTIVE_WHEN_BACKUP = "true";
        public static final String DEFAULT_WORKER_SHUTDOWN_ON_INIT_FAILURE = "false";
        public static final String DEFAULT_WORKER_INSTANCES = "1";
    }

    public static interface Client {
        public static final String CLIENT_RETRY_CONNECTION_DEFAULT = "10";
        public static final String CLIENT_RETRY_CONNECTION_PROP = "retries";
        public static final String FULL_CLIENT_RETRY_CONNECTION_PROP = "space-config.retries";
        public static final String NUMBER_OF_IMPLICIT_INDEXES_PROP = "number-implicit-indexes";
        public static final String NUMBER_OF_IMPLICIT_INDEXES_DEFAULT = String.valueOf(0);
        public static final String FULL_NUMBER_OF_IMPLICIT_INDEXES_PROP = "space-config.number-implicit-indexes";
    }

    public static interface Cluster {
        public static final String IS_CLUSTER_SPACE_PROP = "cluster.enabled";
        public static final String FULL_IS_CLUSTER_SPACE_PROP = "space-config.cluster.enabled";
        public static final String IS_CLUSTER_SPACE_DEFAULT = Boolean.FALSE.toString();
        public static final String CLUSTER_CONFIG_URL_PROP = "cluster.config-url";
        public static final String FULL_CLUSTER_CONFIG_URL_PROP = "space-config.cluster.config-url";
        public static final String CLUSTER_CONFIG_URL_DEFAULT = "none";
        public static final String CLUSTER_XML_SCHEMA_VALIDATION_DEFAULT = "true";
        public static final String CLUSTER_XML_SCHEMA_VALIDATION_SYS_PROP = "com.gs.xmlschema.validation";
        public static final String SYNC_REPL_MULTICAST_DISCOVERY_INTERFACE = "cluster.multicast.discovery-interface";
        public static final String SYNC_REPL_MULTICAST_DISCOVERY_INTERFACE_DEFAULT = "localhost";
        public static final String CLUSTER_TOPOLOGY_REPLICATED = "replicated";
        public static final String CLUSTER_TOPOLOGY_PARTITIONED = "partitioned";
    }

    public static interface DCache {
        public static final String SPACE_SUFFIX = "_DCache";
        public static final String FILE_SUFFIX_EXTENTION = "_DCache.xml";
        public static final String DCACHE_CONFIG_NAME_DEFAULT = "DefaultConfig";
        public static final String DCACHE_CONFIG_FILE_DEFAULT = "DefaultConfig_DCache.xml";
        public static final String CONFIG_NAME_PROP = "dist-cache.config-name";
        public static final String FULL_DCACHE_CONFIG_NAME_PROP = "space-config.dist-cache.config-name";
        public static final String UPDATE_MODE_PROP = "dist-cache.update-mode";
        public static final String UPDATE_MODE_DEFUALT = Integer.toString(1);
        public static final String VERSIONED_PROP = "dist-cache.versioned";
        public static final String VERSIONED_DEFUALT = "false";
        public static final String COMMAND_OBJECT_TIMEOUT_PROP = "dist-cache.command-object-timeout";
        public static final String MAX_OBJECT_TIMEOUT_PROP = "dist-cache.max-object-timeout";
        public static final String RETRY_CONNECTIONS_PROP = "dist-cache.retry-connections";
        public static final String DELAY_BETWEEN_RETRIES_PROP = "dist-cache.delay-between-retries";
        public static final String EVICTION_STRATEGY_PROP = "dist-cache.eviction-strategy";
        public static final String EVICTION_STRATEGY_DEFUALT = "com.j_spaces.map.eviction.FIFOEvictionStrategy";
        public static final String MULTICAST_NOTIFY_PROP = "dist-cache.multicast-notify";
        public static final String MULTICAST_NOTIFY_DEFUALT = "false";
        public static final String PUT_FIRST_PROP = "dist-cache.put-first";
        public static final String PUT_FIRST_DEFUALT = "true";
        public static final String COMPRESSION_PROP = "dist-cache.compression";
        public static final String COMPRESSION_DEFUALT = "0";
    }

    public static interface CacheManager {
        public static final int CACHE_POLICY_LRU = 0;
        public static final int CACHE_POLICY_ALL_IN_CACHE = 1;
        public static final int MAX_CACHE_POLICY_VALUE = 1;
        public static final int DEFAULT_CACHE_POLICY_WITHOUT_LOG = 0;
        public static final int DEFAULT_CACHE_POLICY_WITH_LOG = 1;
        public static final String CACHE_MANAGER_CLASS = "com.gs.engine.cache_manager_class";
        public static final String CACHE_MANAGER_SIZE_DEFAULT = "100000";
        public static final String CACHE_MANAGER_SIZE_PROP = "engine.cache_size";
        public static final String FULL_CACHE_MANAGER_SIZE_PROP = "space-config.engine.cache_size";
        public static final String CACHE_POLICY_PROP = "engine.cache_policy";
        public static final String FULL_CACHE_POLICY_PROP = "space-config.engine.cache_policy";
        public static final String CACHE_MANAGER_INITIAL_LOAD_DEFAULT = "50";
        public static final String CACHE_MANAGER_INITIAL_LOAD_PROP = "engine.initial_load";
        public static final String CACHE_MANAGER_INITIAL_LOAD_CLASS_PROP = "engine.initial_load_class";
        public static final String CACHE_MANAGER_MIN_EXTENDED_INDEX_ACTIVATION_DEFAULT = "1";
        public static final String CACHE_MANAGER_MIN_EXTENDED_INDEX_ACTIVATION_PROP = "engine.extended-match.min_ext_index_activation_size";
        public static final String SA_RESET_ON_FAILURE_DEFAULT = "false";
        public static final String SA_RESET_ON_FAILURE_PROP = "sa_reset_on_failure";
        public static final String FULL_SA_RESET_ON_FAILURE_PROP = "space-config.sa_reset_on_failure";
        public static final int PERSISTENT_GC_INTERVAL_DEFAULT = 300000;
        public static final String PERSISTENT_GC_INTERVAL_PROP = "lease_manager.expiration_time_interval";
        public static final String REPLICATION_ACCURATE_FIFO_DEFAULT = "false";
        public static final String REPLICATION_ACCURATE_FIFO_PROP = "engine.replication_accurate_fifo";
        public static final String CACHE_MANAGER_GC_EXTENDED_INDEXES_PROP = "engine.gc_extended_indexes";
        public static final String CACHE_MANAGER_GC_EXTENDED_INDEXES_DEFAULT = "true";
        public static final int PERSISTENT_GC_EXT_INDEXES_INTERVAL_DEFAULT = 300000;
        public static final String CACHE_MANAGER_TOKENS_DELIMITER_PROP = "engine.tokenized_fields_delimiter";
        public static final String CACHE_MANAGER_TOKENS_DELIMITER_DELAUT = " ";
    }

    public static interface LogBuffer {
        public static final String LOGFILE_ENABLED_DEFAULT = "false";
        public static final String LOGFILE_ENABLED_PROP = "sa-log-file.enabled";
        public static final String LOGFILE_CLASS_IMPL_DEFAULT = new LogFileImpl[0].getClass().getComponentType().getName();
        public static final String LOGFILE_CLASS_IMPL_PROP = "sa-log-file.class-impl";
        public static final String LOGFILE_LOG_DIR_DEFAULT = "/logs/sa-log";
        public static final String LOGFILE_LOG_DIR_PROP = "sa-log-file.log-dir";
        public static final String LOGFILE_BASE_NAME_DEFAULT = "./giga-log.";
        public static final String LOGFILE_BASE_NAME_PROP = "sa-log-file.base-name";
        public static final String LOGFILE_MAX_OPER_DEFAULT = "10000";
        public static final String LOGFILE_MAX_OPER_PROP = "sa-log-file.max-log-oper";
        public static final String LOGFILE_SYNC_INTER_OPER_DEFAULT = "100";
        public static final String LOGFILE_SYNC_INTER_OPER_PROP = "sa-log-file.sync-interval-oper";
        public static final String LOGFILE_SYNC_INTERVAL_TIME_DEFAULT = "5000";
        public static final String LOGFILE_SYNC_INTERVAL_TIME_PROP = "sa-log-file.sync-interval-ms";
    }

    public static interface StorageAdapter {
        public static final int DEFAULT_INIT_SA_CONNECTIONS = 10;
        public static final int DEFAULT_MAX_SA_CONNECTIONS = 100;
        public static final String MAX_SA_CONNECTIONS_PROP = "max_sa_connections";
        public static final String FULL_MAX_SA_CONNECTIONS_PROP = "space-config.max_sa_connections";
        public static final String INIT_SA_CONNECTIONS_PROP = "init_sa_connections";
        public static final String FULL_INIT_SA_CONNECTIONS_PROP = "space-config.init_sa_connections";
        public static final String STORAGE_ADAPTER_CLASS = "StorageAdapterClass";
        public static final String STORAGE_ADAPTER_CLASS_DEFAULT = "";
        public static final String STORAGE_ADAPTER_CLASS_PROP = "persistent.StorageAdapterClass";
        public static final String FULL_STORAGE_STORAGE_ADAPTER_CLASS_PROP = "space-config.persistent.StorageAdapterClass";
        public static final String ADAPTER_TYPE = "AdapterType";
        public static final String ADAPTER_TYPE_PROP = "persistent.AdapterType";
        public static final String ADAPTER_TYPE_DEFAULT = "";
        public static final String FULL_STORAGE_ADAPTER_TYPE_PROP = "space-config.persistent.AdapterType";
        public static final String DEFAULT_STORAGE_ADAPTER_CLASS = new JDBCStorageAdapter[0].getClass().getComponentType().getName();
        public static final String STORAGE_ADAPTER_URL = "StorageAdapterURL";
        public static final String STORAGE_ADAPTER_URL_PROP = "persistent.StorageAdapterURL";
        public static final String STORAGE_ADAPTER_URL_DEFAULT = "";
        public static final String FULL_STORAGE_STORAGE_ADAPTER_URL_PROP = "space-config.persistent.StorageAdapterURL";
        public static final String SPACE_STORAGE_ADAPTER_URL_PROP = "space-config.persistent.StorageAdapterURL";
        public static final String FULL_STORAGE_SPACE_STORAGE_ADAPTER_URL_PROP = "space-config.space-config.persistent.StorageAdapterURL";
        public static final String STORAGE_ADAPTER_MEMORY_SA_CLASS = "com.j_spaces.core.sadapter.MemorySA";
        public static final String XARESOURCE_TIMEOUT = "xaresource_timeout";
        public static final String DB_NAME = "DataBaseName";
        public static final String DB_NAME_PROP = "persistent.DataBaseName";
        public static final String DB_NAME_DEFAULT = "";
        public static final String FULL_STORAGE_DB_NAME_PROP = "space-config.persistent.DataBaseName";
        public static final String DB_USER_NAME = "userName";
        public static final String DB_PASSWORD = "password";
        public static final String DB_USER_NAME_PROP = "persistent.userName";
        public static final String DB_USER_NAME_DEFAULT = "";
        public static final String FULL_STORAGE_DB_USER_NAME_PROP = "space-config.persistent.userName";
        public static final String DB_PASSWORD_PROP = "persistent.password";
        public static final String DB_PASSWORD_DEFAULT = "";
        public static final String FULL_STORAGE_DB_PASSWORD_PROP = "space-config.persistent.password";
        public static final String PERSISTENT_ENABLED = "enabled";
        public static final String PERSISTENT_ENABLED_PROP = "persistent.enabled";
        public static final String PERSISTENT_ENABLED_DEFAULT = Boolean.FALSE.toString();
        public static final String FULL_STORAGE_PERSISTENT_ENABLED_PROP = "space-config.persistent.enabled";
        public static final String NUMBER_OF_SYNC_OBJECTS = "Number_Sync_Objects";
        public static final String NUMBER_OF_SYNC_OBJECTS_PROP = "persistent.Number_Sync_Objects";
        public static final String FULL_STORAGE_NUMBER_OF_SYNC_OBJECTS_PROP = "space-config.persistent.Number_Sync_Objects";
        public static final String CHECK_POINT_PERIOD = "Check_Point_Period";
        public static final String CHECK_POINT_PERIOD_PROP = "persistent.Check_Point_Period";
        public static final String FULL_STORAGE_CHECK_POINT_PERIOD_PROP = "space-config.persistent.Check_Point_Period";
        public static final String PAGE_POOL_SIZE = "Page_Pool_Size";
        public static final String PAGE_POOL_SIZE_PROP = "persistent.Page_Pool_Size";
        public static final String FULL_STORAGE_PAGE_POOL_SIZE_PROP = "space-config.persistent.Page_Pool_Size";
        public static final String SYNC_ON_COMMIT = "Sync_On_Commit";
        public static final String SYNC_ON_COMMIT_PROP = "persistent.Sync_On_Commit";
        public static final String SYNC_ON_COMMIT_DEFAULT = Boolean.TRUE.toString();
        public static final String FULL_STORAGE_SYNC_ON_COMMIT_PROP = "space-config.persistent.Sync_On_Commit";
        public static final int DEFAULT_PAGE_POOL_SIZE = 4096;
        public static final int DEFAULT_NUMBER_SYNC_OBJECTS = -1;
        public static final int DEFAULT_CHECK_POINT_PERIOD = -1;
        public static final String CACHE_LOADER_CLASS = "CacheLoaderClass";
        public static final String CACHE_LOADER_CLASS_PROP = "persistent.CacheLoaderClass";
        public static final String CACHE_LOADER_CLASS_DEFAULT = "";
        public static final String FULL_STORAGE_CACHE_LOADER_CLASS_PROP = "space-config.persistent.CacheLoaderClass";
        public static final String ENTITY_CLASS_TAG = "entity-class";
        public static final String ENTITY_CLASS_PROP = "persistent.entity-class";
        public static final String ENTITY_CLASS_DEFAULT = "";
        public static final String ENTITY_CLASS_XPATH = "space-config.persistent.entity-class";
        public static final String PERSISTENT_FORCE_COLD_INIT = "persistent.force-cold-init";
        public static final String PERSISTENT_FORCE_COLD_INIT_DEFAULT = "false";
    }

    public static interface LRMIStubHandler {
        public static final String SERVER_PORT_PROP = "lrmi-stub-handler.server-port";
        public static final String FULL_LRMI_SERVER_PORT_PROP = "space-config.lrmi-stub-handler.server-port";
        public static final String CLIENT_PORT_PROP = "lrmi-stub-handler.client-port";
        public static final String FULL_LRMI_CLIENT_PORT_PROP = "space-config.lrmi-stub-handler.client-port";
        public static final String PROTOCOL_NAME_PROP = "lrmi-stub-handler.protocol-name";
        public static final String FULL_LRMI_PROTOCOL_NAME_PROP = "space-config.lrmi-stub-handler.protocol-name";
        public static final String MIN_WORKER_THREADS_PROP = "lrmi-stub-handler.min-worker-threads";
        public static final String MAX_WORKER_THREADS_PROP = "lrmi-stub-handler.max-worker-threads";
        public static final String WORKER_THREADS_QUEUE_SIZE_PROP = "lrmi-stub-handler.worker-threads-queue-size";
        public static final String MAX_POOL_CONNECTIONS_PROP = "lrmi-stub-handler.max-pool-connections";
        public static final String MULTIPLEX_CONNECTION_PROP = "lrmi-stub-handler.is-multiplex-connection";
        public static final String SLOWCONSUMER_THROUGHPUT_PROP = "lrmi-stub-handler.slowconsumer.throughput";
        public static final String SLOWCONSUMER_LATENCY_PROP = "lrmi-stub-handler.slowconsumer.latency";
        public static final String SLOWCONSUMER_RETRIES_PROP = "lrmi-stub-handler.slowconsumer.retries";
        public static final String FULL_LRMI_MULTIPLEX_CONNECTION_PROP = "space-config.lrmi-stub-handler.is-multiplex-connection";
        public static final String PROTOCOL_RMI = "RMI";
        public static final String PROTOCOL_NIO = "NIO";
        public static final String MANUFACTUR_PROTOCOL_DEFAULT = "com.j_spaces.kernel.lrmi";
        public static final String LRMI_DEFAULT_STUB_HANDLER_CLASS = new LRMIStubHandlerImpl[0].getClass().getComponentType().getName();
        public static final String LRMI_DEFAULT_PROTOCOL = "NIO";
        public static final String LRMI_DEFAULT_SERVER_PORT = "0";
        public static final String LRMI_DEFAULT_CLIENT_PORT = "0";
        public static final String MULTIPLEX_DEFAULT_CONNECTION = Boolean.TRUE.toString();
        public static final String LRMI_DEFAULT_MAX_POOL_CONNECTIONS = "20";
        public static final String LRMI_DEFAULT_MIN_WORKER_THREADS = "1";
        public static final String LRMI_DEFAULT_MAX_WORKER_THREADS = "64";
        public static final String LRMI_DEFAULT_WORKER_THREADS_QUEUE_SIZE = String.valueOf(Integer.MAX_VALUE);
        public static final String LRMI_DEFAULT_SLOWCONSUMER_THROUGHPUT = "0";
        public static final String LRMI_DEFAULT_SLOWCONSUMER_LATENCY = "100";
        public static final String LRMI_DEFAULT_SLOWCONSUMER_RETRIES = "3";
    }

    public static interface SSLStubHandler {
        public static final String SSL_KEY_STORE_PROP = "ssl-stub-handler.keystore";
        public static final String FULL_SSL_KEY_STORE_PROP = "space-config.ssl-stub-handler.keystore";
        public static final String SSL_TRUST_STORE_PROP = "ssl-stub-handler.truststore";
        public static final String FULL_SSL_TRUST_STORE_PROP = "space-config.ssl-stub-handler.truststore";
        public static final String SSL_PASSWORD_PROP = "ssl-stub-handler.password";
        public static final String FULL_SSL_PASSWORD_PROP = "space-config.ssl-stub-handler.password";
        public static final String SSL_PROTOCOL_NAME_PROP = "ssl-stub-handler.protocol-name";
        public static final String SSL_KEYSTORE_TYPE_PROP = "ssl-stub-handler.keystore-type";
        public static final String SSL_KEY_MANAGMENT_METHOD_PROP = "ssl-stub-handler.key-managment-method";
        public static final String SSL_SYS_PASSWORD_PROP = "com.gs.security.ssl.password";
        public static final String SSL_STUB_HANDLER_CLASS_DEFAULT = new SSLStubHandlerImpl[0].getClass().getComponentType().getName();
        public static final String SSL_DEFAULT_PROTOCOL_NAME = "TLS";
        public static final String SSL_DEFAULT_KEYSTORE_TYPE = "JKS";
        public static final String SSL_DEFAULT_KEY_MANAGMENT_METHOD = "SunX509";
        public static final String SSL_DEFAULT_KEYSTORE = "testkeys";
        public static final String SSL_DEFAULT_TRUSTSTORE = "testkeys";
        public static final String SSL_DEFAULT_PASSWORD = "passphrase";
        public static final String SSL_DEFAULT_KEYSTORE_FILE = "gigaspaces_server.keystore";
        public static final String SSL_DEFAULT_TRUSTSTORE_FILE = "gigaspaces_server.truststore";
        public static final String IS_SSL_ENABLED = "is_ssl_enabled";
    }

    public static interface SystemTime {
        public static final String SYSTEM_TIME_PROVIDER_PROP = "com.j_spaces.kernel.time-provider";
        public static final String SYSTEM_TIME_PROVIDER_DEFAULT = "";
    }

    public static interface LeaseManager {
        public static final long LM_EXPIRATION_TIME_INTERVAL_DEFAULT = 60000L;
        public static final long LM_EXPIRATION_TIME_PUMPSPACE_DEFAULT = 300000L;
        public static final long LM_EXPIRATION_TIME_PENDING_ANSWERS_DEFAULT = 60000L;
        public static final long LM_EXPIRATION_TIME_RECENT_DELETES_DEFAULT = 180000L;
        public static final long LM_EXPIRATION_TIME_RECENT_UPDATES_DEFAULT = 180000L;
        public static final long LM_EXPIRATION_TIME_FIFOENTRY_XTNINFO = 60000L;
        public static final String LM_EXPIRATION_TIME_INTERVAL_PROP = "lease_manager.expiration_time_interval";
        public static final String FULL_LM_EXPIRATION_TIME_INTERVAL_PROP = "space-config.lease_manager.expiration_time_interval";
    }

    public static interface Filter {
        public static final String FILTER_NAMES_PROP = "filters.filter-names";
        public static final String FILTER_ACCOUNT_DRIVER_PROP = "filters.userAccountDriver";
        public static final String FILTER_MEMORY_REALM_DRIVER_DEFAULT = "com.j_spaces.core.filters.MemoryRealm";
        public static final String FILTER_SECURITY_NAME_DEFAULT = "DefaultSecurityFilter";
        public static final String FILTER_SECURITY_CLASSNAME_DEFAULT = new DefaultSecurityFilter[0].getClass().getComponentType().getName();
        public static final String FILTER_SECURITY_FILENAME_DEFAULT = "default-users";
        public static final String FILTER_ACTIVE_WHEN_BACKUP = "active-when-backup";
        public static final String FILTER_SHUTDOWN_ON_INIT_FAILURE = "shutdown-space-on-init-failure";
        public static final String DEFAULT_ACTIVE_WHEN_BACKUP = "true";
        public static final String DEFAULT_SHUTDOWN_ON_INIT_FAILURE = "false";
    }

    public static interface Engine {
        public static final int NOTIFIER_TIME_LIMIT = 2000;
        public static final long LOCAL_XTN_ADDITIONAL_TIMEOUT = 1L;
        public static final long DEFAULT_PROXY_ALIVE_TIME_TO_WAIT = 60000L;
        public static final long MEMORY_RECOVERY_WAIT_TIME_LIMIT = 600000L;
        public static final int MEMORY_RECOVERY_CHUNK_SIZE_DEFAULT = 1000;
        public static final long UPDATE_NO_LEASE = 0L;
        public static final String ENGINE_MIN_THREADS_DEFAULT = "4";
        public static final String ENGINE_MAX_THREADS_DEFAULT = "64";
        public static final String ENGINE_MIN_THREADS_PROP = "engine.min_threads";
        public static final String FULL_ENGINE_MIN_THREADS_PROP = "space-config.engine.min_threads";
        public static final String ENGINE_MAX_THREADS_PROP = "engine.max_threads";
        public static final String FULL_ENGINE_MAX_THREADS_PROP = "space-config.engine.max_threads";
        public static final String ENGINE_NOTIFY_MIN_THREADS_DEFAULT = "4";
        public static final String ENGINE_NOTIFY_MAX_THREADS_DEFAULT = "64";
        public static final String ENGINE_NOTIFY_MIN_THREADS_PROP = "engine.notify_min_threads";
        public static final String ENGINE_NOTIFY_MAX_THREADS_PROP = "engine.notify_max_threads";
        public static final String ENGINE_THREADS_HIGHER_PRIORITY_DEFAULT = "false";
        public static final String ENGINE_THREADS_HIGHER_PRIORITY_PROP = "engine.threads_higher_priority";
        public static final String ENGINE_RELIABLE_TAKE_DEFAULT = "true";
        public static final String ENGINE_VERIFY_RELIABLE_TAKE_PROP = "engine.reliable_take";
        public static final String ENGINE_REINSERT_FAILED_ENTRIES_DEFAULT = "true";
        public static final String ENGINE_REINSERT_FAILED_ENTRIES_PROP = "engine.reinsert_failed_entries";
        public static final String ENGINE_SERIAL_REMOVE_SA_DEFAULT = "true";
        public static final String ENGINE_SERIAL_REMOVE_SA_PROP = "engine.serial_remove_sa_entries";
        public static final String ENGINE_SYNC_ON_COMMIT_EXCEPTIONS_DEFAULT = "false";
        public static final String ENGINE_SYNC_ON_COMMIT_EXCEPTIONS_PROP = "engine.sync_on_commit_exceptions";
        public static final String ENGINE_DIRTY_READ_DEFAULT = "false";
        public static final String ENGINE_DIRTY_READ_PROP = "engine.dirty_read";
        public static final String ENGINE_ROLLBACK_ON_TM_FAILED_DEFAULT = "false";
        public static final String ENGINE_ROLLBACK_ON_TM_FAILED_PROP = "engine.rollback_on_tm_failed";
        public static final String ENGINE_LOCAL_CACHE_MODE_DEFAULT = "false";
        public static final String ENGINE_LOCAL_CACHE_MODE_PROP = "engine.local_cache_mode";
        public static final String ENGINE_MEMORY_USAGE_ENABLED_DEFAULT = "false";
        public static final String ENGINE_MEMORY_USAGE_ENABLED_PROP = "engine.memory_usage.enabled";
        public static final String FULL_ENGINE_MEMORY_USAGE_ENABLED_PROP = "space-config.engine.memory_usage.enabled";
        public static final String ENGINE_MEMORY_USAGE_HIGH_PERCENTAGE_RATIO_DEFAULT = "95";
        public static final String ENGINE_MEMORY_USAGE_HIGH_PERCENTAGE_RATIO_PROP = "engine.memory_usage.high_watermark_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_HIGH_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.high_watermark_percentage";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_BLOCK_PERCENTAGE_RATIO_DEFAULT = "85";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_BLOCK_PERCENTAGE_RATIO_PROP = "engine.memory_usage.write_only_block_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_WR_ONLY_BLOCK_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.write_only_block_percentage";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_CHECK_PERCENTAGE_RATIO_DEFAULT = "76";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_CHECK_PERCENTAGE_RATIO_PROP = "engine.memory_usage.write_only_check_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_WR_ONLY_CHECK_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.write_only_check_percentage";
        public static final String ENGINE_MEMORY_USAGE_LOW_PERCENTAGE_RATIO_DEFAULT = "75";
        public static final String ENGINE_MEMORY_USAGE_LOW_PERCENTAGE_RATIO_PROP = "engine.memory_usage.low_watermark_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_LOW_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.low_watermark_percentage";
        public static final String ENGINE_MEMORY_USAGE_EVICTION_BATCH_SIZE_DEFAULT = "500";
        public static final String ENGINE_MEMORY_USAGE_EVICTION_BATCH_SIZE_PROP = "engine.memory_usage.eviction_batch_size";
        public static final String FULL_ENGINE_MEMORY_USAGE_EVICTION_BATCH_SIZE_PROP = "space-config.engine.memory_usage.eviction_batch_size";
        public static final String ENGINE_MEMORY_USAGE_RETRY_COUNT_DEFAULT = "5";
        public static final String ENGINE_MEMORY_USAGE_RETRY_COUNT_PROP = "engine.memory_usage.retry_count";
        public static final String FULL_ENGINE_MEMORY_USAGE_RETRY_COUNT_PROP = "space-config.engine.memory_usage.retry_count";
        public static final String ENGINE_MEMORY_EXPLICIT_GC_DEFAULT = "false";
        public static final String ENGINE_MEMORY_EXPLICIT_GC_PROP = "engine.memory_usage.explicit-gc";
        public static final String FULL_ENGINE_MEMORY_EXPLICIT_GC_PROP = "space-config.engine.memory_usage.explicit-gc";
        public static final String ENGINE_STUB_HANDLER_CLASS_DEFAULT = new LRMIStubHandlerImpl[0].getClass().getComponentType().getName();
        public static final String ENGINE_STUB_HANDLER_CLASS_PROP = "stub-handler";
        public static final String FULL_ENGINE_STUB_HANDLER_CLASS_PROP = "space-config.stub-handler";
        public static final String ENGINE_SERIALIZATION_TYPE_DEFAULT = String.valueOf(2);
        public static final String ENGINE_SERIALIZATION_TYPE_PROP = "serialization-type";
        public static final String FULL_ENGINE_SERIALIZATION_TYPE_PROP = "space-config.serialization-type";
        public static final String ENGINE_NOTIFIER_RETRIES_DEFAULT = "3";
        public static final String ENGINE_NOTIFIER_TTL_PROP = "notifier-retries";
        public static final String FULL_ENGINE_NOTIFIER_TTL_PROP = "space-config.notifier-retries";
        public static final String ENGINE_EXTENDEDMATCH_CLASSES_PROP = "engine.extended-match.enabled-classes";
        public static final String FULL_ENGINE_EXTENDEDMATCH_CLASSES_PROP = "space-config.engine.extended-match.enabled-classes";
        public static final String ENGINE_EXTENDEDMATCH_CLASSES_PROP_DEFAULT = "";
        public static final String ENGINE_REGULAR_EXPRESSIONS_CACHE_SIZE_PROP = "engine.extended-match.regular-expressions-cache-size";
        public static final String ENGINE_REGULAR_EXPRESSIONS_CACHE_SIZE_DEFAULT = "300";
        public static final String ENGINE_CROSS_XTN_FIFO_NOTIFY_PROP = "engine.cross_xtns_notify_fifo";
        public static final String ENGINE_CROSS_XTN_FIFO_NOTIFY_DEFAULT = "true";
        public static final String ENGINE_INSERT_SHORT_LEASE_RETRY_PROP = "engine.insert_short_lease_retry";
        public static final String ENGINE_INSERT_SHORT_LEASE_RETRY_DEFAULT = "3";
        public static final String ENGINE_SEQUENTIAL_FIFO_XTNS_PROP = "engine.sequential_fifo_xtns";
        public static final String ENGINE_SEQUENTIAL_FIFO_XTNS_DEFAULT = "true";
    }

    public static interface Management {
        public static final String JMX_MBEAN_DESCRIPTORS_CONTAINER = "ContainerMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_JAVASPACE = "JavaSpaceMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_JAVASPACE_EXT = "JavaSpaceExtMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_CLUSTER = "ClusterMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_JINISERVER = "JiniConnectorMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_JMS_CLIENT = "JmsClientMBeanDescriptors.xml";
        public static final String JMX_HTML_ADAPTOR_DEFAULT_OBJECT_NAME = "Adaptor:type=HTML,port=8082";
        public static final String JMX_JINI_CONNECTOR_DEFAULT_OBJECT_NAME = "Connector:type=JINI";
        public static final String JMX_CONNECTOR_PROTOCOL_RMI = "rmi";
        public static final String JMX_CONNECTOR_PROTOCOL_IIOP = "iiop";
        public static final String JMX_REG_INTERNAL_ENABLED_PROP = "com.j_spaces.core.container.jmx.registration.internal.enabled";
        public static final String JMX_REG_INTERNAL_ENABLED_DEFAULT = "false";
        public static final String JMX_REG_EXTERANL_ENABLED_PROP = "com.j_spaces.core.container.jmx.registration.external.enabled";
        public static final String JMX_REG_EXTERNAL_ENABLED_DEFAULT = "false";
        public static final String JMX_REGISTRATION_EXT_URLS_PROP = "com.j_spaces.core.container.jmx.registration.external.url";
    }

    public static interface Server {
        public static final String SERVER_CONFIG_FILE_SUFFIX = "-server.xml";
        public static final String SERVER_WEB_CONTAINER_ENABLED = "setup.web_container.enabled";
        public static final String SERVER_WEB_CONTAINER_MODE = "setup.web_container.mode";
        public static final String SERVER_ACTIVATION_ENABLED = "setup.activation.enabled";
        public static final String SERVER_JNDI_ENABLED = "setup.directory_services.jndi.enabled";
        public static final String SERVER_LOOKUP_ENABLED = "setup.directory_services.jini_lus.enabled";
        public static final String SERVER_LOOKUP_PERSIST = "setup.directory_services.jini_lus.persistent";
        public static final String SERVER_SHAREDVM_ENABLED = "setup.shared_vm.enabled";
        public static final String SERVER_SHAREDVM_LOGPATH = "setup.shared_vm.logPath";
        public static final String SERVER_SHAREDVM_POLICY_FILE = "setup.shared_vm.policy";
        public static final String SERVER_ACTIVATION_LOGPATH = "setup.activation.logPath";
        public static final String SERVER_ACTIVATION_PORT = "setup.activation.port";
        public static final String SERVER_ACTIVATION_CMD_PARAM = "setup.activation.cmd_param";
        public static final String SERVER_JNDI_PORT = "setup.directory_services.jndi.port";
        public static final String SERVER_LOOKUP_LOGPATH = "setup.directory_services.jini_lus.logPath";
        public static final String SERVER_LOOKUP_GROUPS = "setup.directory_services.jini_lus.groups";
        public static final String SERVER_XTN_MANAGER_ENABLED = "setup.transaction_manager.enabled";
        public static final String SERVER_XTN_MANAGER_LOGPATH = "setup.transaction_manager.logPath";
        public static final String SERVER_XTN_MANAGER_GROUPS = "setup.transaction_manager.groups";
        public static final String SERVER_XTN_MANAGER_PERSIST = "setup.transaction_manager.persistent";
        public static final String SERVER_POLICY_FILE = "setup.policy";
        public static final String SERVER_FILE_PATH = "server.setup.filePath";
        public static final String TRANSIENT_CONFIG_FILE = "setup.directory_services.jini_lus.transient.config";
        public static final String JMX_ENABLED_PROP = "setup.jmx.enabled";
        public static final String JMX_AGENT_DOMAIN_PROP = "setup.jmx.agent_domain";
        public static final String JMX_DOMAIN_PROP = "setup.jmx.domain";
        public static final String JMX_ADAPTOR_HTML_ENABLED_PROP = "setup.jmx.adaptor.html.enabled";
        public static final String JMX_ADAPTOR_HTML_OBJECTNAME_PROP = "setup.jmx.adaptor.html.objectname";
        public static final String JMX_ADAPTOR_HTML_AUTHENTICATION_ENABLED_PROP = "setup.jmx.adaptor.html.authentication.enabled";
        public static final String JMX_ADAPTOR_HTML_AUTHENTICATION_USERNAME_PROP = "setup.jmx.adaptor.html.authentication.username";
        public static final String JMX_ADAPTOR_HTML_AUTHENTICATION_PASSWORD_PROP = "setup.jmx.adaptor.html.authentication.password";
        public static final String JMX_ADAPTOR_SNMP_ENABLED_PROP = "setup.jmx.adaptor.snmp.enabled";
        public static final String JMX_ADAPTOR_SNMP_OBJECTNAME_PROP = "setup.jmx.adaptor.snmp.objectname";
        public static final String JMX_CONNECTOR_RMI_ENABLED_PROP = "setup.jmx.connector.rmi.enabled";
        public static final String JMX_CONNECTOR_RMI_OBJECTNAME_PROP = "setup.jmx.connector.rmi.objectname";
        public static final String JMX_CONNECTOR_JINI_ENABLED_PROP = "setup.jmx.connector.jini.enabled";
        public static final String JMX_CONNECTOR_JINI_OBJECTNAME_PROP = "setup.jmx.connector.jini.objectname";
    }

    public static interface Jmx {
        public static final String JMX_ENABLED_PROP = "com.gs.jmx.enabled";
        public static final String JMX_ENABLED_DEFAULT_VALUE = Boolean.TRUE.toString();
    }

    public static interface Jms {
        public static final String CLUSTERED_JMS_CONFIG_NAME_DEFAULT = "DefaultConfig";
        public static final String CLUSTERED_JMS_CONFIG_NAME_PROP = "jms.config-name";
        public static final String CLUSTERED_JMS_CONFIG_FILE_SUFFIX = "_ClusteredJMS";
        public static final String CLUSTERED_JMS_FILE_SUFFIX_EXTENTION = "_ClusteredJMS.xml";
        public static final String CLUSTERED_JMS_CONFIG_FILE_DEFAULT = "DefaultConfig_ClusteredJMS.xml";
        public static final String JMS_DELIMITER = ";";
        public static final String JMS_CONFIG_PREFIX = "com.j_spaces.jms.";
        public static final String JMS_CONFIG_FILE_NAME = "jms-config.xml";
        public static final String JMS_CONFIG_DIRECTORY = "config/jms/";
        public static final String JMS_RMI_PORT_PROP = "jms.connections.rmi-port";
        public static final String JMS_RMI_PORT_DEFAULT = "10098";
        public static final String JMS_TOPIC_NAMES_PROP = "jms.administrated-destinations.topics.topic-names";
        public static final String JMS_QUEUE_NAMES_PROP = "jms.administrated-destinations.queues.queue-names";
        public static final String JMS_CLIENT_CONTAINER_PREFIX_PROP = "com.j_spaces.jms.jndi-bonded-names.connections.container-prefix";
        public static final String JMS_CLIENT_CONTAINER_PREFIX_PROP_DEFAULT = "myJMS_container";
        public static final String JMS_CLIENT_SPACE_PREFIX_PROP_DEFAULT = "myJMS";
        public static final String JMS_CLIENT_SPACE_PREFIX_PROP = "com.j_spaces.jms.jndi-bonded-names.connections.space-prefix";
        public static final String JMS_CLIENT_OVERWRITE_SPACE_URL_PROP = "com.j_spaces.jms.jndi-bonded-names.connections.overwrite-space-url";
        public static final String JMS_CLIENT_OVERWRITE_SPACE_URL_PROP_DEFAULT = "/./myJMS?schema=default";
        public static final String JMS_DURABLE_SUBSCRIBERS_PROP = "com.j_spaces.jms.durable-subscribers";
        public static final String FULL_JMS_QUEUE_NAMES_PROP = "space-config.jms.administrated-destinations.queues.queue-names";
        public static final String FULL_JMS_RMI_PORT_PROP = "space-config.jms.connections.rmi-port";
        public static final String FULL_JMS_TOPIC_NAMES_PROP = "space-config.jms.administrated-destinations.topics.topic-names";
        public static final String JMS_QUEUE_NAMES_DEFAULT = "MyQueue,TempQueue";
        public static final String JMS_TOPIC_NAMES_DEFAULT = "MyTopic,TempTopic";
        public static final String JMS_JMS_NAME = "jms";
        public static final String JMS_DESTINATIONS_NAME = "destinations";
        public static final String JMS_TOPIC_CON_FAC_NAME = "GSTopicConnectionFactoryImpl";
        public static final String JMS_XATOPIC_CON_FAC_NAME = "GSXATopicConnectionFactoryImpl";
        public static final String JMS_QUEUE_CON_FAC_NAME = "GSQueueConnectionFactoryImpl";
        public static final String JMS_XAQUEUE_CON_FAC_NAME = "GSXAQueueConnectionFactoryImpl";
    }

    public static interface LookupManager {
        public static final String MANUFACTURE = "GigaSpaces Technologies Ltd.";
        public static final String VENDOR = "GigaSpaces";
        public static final String PUBLIC = "public";
        public static final String PUBLIC_GROUP = "";
        public static final String NONE_GROUP = "none";
        public static final String ALL_GROUP = "all";
        public static final String LOOKUP_ENABLED_DEFAULT = "true";
        public static final String START_EMBEDDED_LOOKUP_DEFAULT = "true";
        public static final String LOOKUP_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jini_lus.enabled";
        public static final String START_EMBEDDED_LOOKUP_PROP = "com.j_spaces.core.container.directory_services.jini_lus.start-embedded-lus";
        public static final String LOOKUP_GROUPS_SYS_PROP = "com.gs.jini_lus.groups";
        public static final String LOOKUP_GROUP_PROP = "com.j_spaces.core.container.directory_services.jini_lus.groups";
        public static final String LOOKUP_GROUP_DEFAULT = "gigaspaces-" + PlatformVersion.V_NUM;
        public static final String LOOKUP_UNICAST_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_UNICAST_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled";
        public static final String LOOKUP_UNICAST_URL_DEFAULT = "";
        public static final String LOOKUP_UNICAST_URL_PROP = "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host";
        public static final String LOOKUP_JNDI_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JNDI_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jndi.enabled";
        public static final String LOOKUP_JNDI_URL_DEFAULT = "localhost:10098";
        public static final String LOOKUP_JNDI_URL_PROP = "com.j_spaces.core.container.directory_services.jndi.url";
        public static final String LOOKUP_JMS_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JMS_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jms_services.enabled";
        public static final String LOOKUP_JMS_INTERNAL_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JMS_INTERNAL_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jms_services.internal-jndi.internal-jndi-enabled";
        public static final String LOOKUP_JMS_EXT_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JMS_EXT_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jms_services.ext-jndi.ext-jndi-enabled";
        public static final String LOOKUP_IS_PRIVATE_PROP = "isPrivate";
        public static final String FULL_LOOKUP_IS_PRIVATE_PROP = "space-config.isPrivate";
        public static final String LOOKUP_IS_PRIVATE_DEFAULT = Boolean.FALSE.toString();
    }

    public static interface QueryProcessorInfo {
        public static final String QP_MAX_CONNECTIONS = "max_connections";
        public static final String QP_MAX_CONNECTIONS_DEFAULT = String.valueOf(50);
        public static final String QP_MAX_CONNECTIONS_PROP = "QueryProcessor.max_connections";
        public static final String FULL_QP_MAX_CONNECTIONS_PROP = "space-config.QueryProcessor.max_connections";
        public static final String QP_MIN_CONNECTIONS = "min_connections";
        public static final String QP_MIN_CONNECTIONS_DEFAULT = String.valueOf(1);
        public static final String QP_MIN_CONNECTIONS_PROP = "QueryProcessor.min_connections";
        public static final String FULL_QP_MIN_CONNECTIONS_PROP = "space-config.QueryProcessor.min_connections";
        public static final String QP_SPACE_READ_LEASE_TIME = "space_read_lease_time";
        public static final String QP_SPACE_READ_LEASE_TIME_DEFAULT = String.valueOf(0);
        public static final String QP_SPACE_READ_LEASE_TIME_PROP = "QueryProcessor.space_read_lease_time";
        public static final String FULL_QP_SPACE_READ_LEASE_TIME_PROP = "space-config.QueryProcessor.space_read_lease_time";
        public static final String QP_SPACE_WRITE_LEASE = "space_write_lease";
        public static final long lease = Long.MAX_VALUE;
        public static final String QP_SPACE_WRITE_LEASE_DEFAULT = String.valueOf(Long.MAX_VALUE);
        public static final String QP_SPACE_WRITE_LEASE_PROP = "QueryProcessor.space_write_lease";
        public static final String FULL_QP_SPACE_WRITE_LEASE_PROP = "space-config.QueryProcessor.space_write_lease";
        public static final String QP_TRANSACTION_TIMEOUT = "transaction_timeout";
        public static final String QP_TRANSACTION_TIMEOUT_DEFAULT = String.valueOf(30000);
        public static final String QP_TRANSACTION_TIMEOUT_PROP = "QueryProcessor.transaction_timeout";
        public static final String FULL_QP_TRANSACTION_TIMEOUT_PROP = "space-config.QueryProcessor.transaction_timeout";
        public static final String QP_PORT = "port";
        public static final String QP_PORT_DEFAULT = String.valueOf(2872);
        public static final String QP_PORT_PROP = "QueryProcessor.port";
        public static final String FULL_QP_PORT_PROP = "space-config.QueryProcessor.port";
        public static final String QP_INIT_JMX = "init_jmx";
        public static final String QP_INIT_JMX_DEFAULT = String.valueOf(false);
        public static final String QP_INIT_JMX_PROP = "QueryProcessor.port";
        public static final String FULL_QP_INIT_JMX_PROP = "space-config.QueryProcessor.port";
        public static final String QP_TRACE_EXEC_TIME = "trace_exec_time";
        public static final String QP_TRACE_EXEC_TIME_DEFAULT = String.valueOf(false);
        public static final String QP_TRACE_EXEC_TIME_PROP = "QueryProcessor.trace_exec_time";
        public static final String FULL_QP_TRACE_EXEC_TIME_PROP = "space-config.QueryProcessor.trace_exec_time";
        public static final String QP_PARSER_CASE_SENSETIVITY = "parser_case_sensetivity";
        public static final String QP_PARSER_CASE_SENSETIVITY_DEFAULT = String.valueOf(true);
        public static final String QP_PARSER_CASE_SENSETIVITY_PROP = "QueryProcessor.parser_case_sensetivity";
        public static final String FULL_QP_PARSER_CASE_SENSETIVITY_PROP = "space-config.QueryProcessor.parser_case_sensetivity";
        public static final String QP_AUTO_COMMIT = "auto_commit";
        public static final String QP_AUTO_COMMIT_DEFAULT = String.valueOf(true);
        public static final String QP_AUTO_COMMIT_PROP = "QueryProcessor.auto_commit";
        public static final String FULL_QP_AUTO_COMMIT_PROP = "space-config.QueryProcessor.auto_commit";
        public static final String QP_DATE_FORMAT = "date_format";
        public static final String QP_DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
        public static final String QP_DATE_FORMAT_PROP = "QueryProcessor.date_format";
        public static final String FULL_QP_DATE_FORMAT_PROP = "space-config.QueryProcessor.date_format";
        public static final String QP_DATETIME_FORMAT = "datetime_format";
        public static final String QP_DATETIME_FORMAT_DEFAULT = "yyyy-MM-dd hh:mm:ss";
        public static final String QP_DATETIME_FORMAT_PROP = "QueryProcessor.datetime_format";
        public static final String FULL_QP_DATETIME_FORMAT_PROP = "space-config.QueryProcessor.datetime_format";
        public static final String QP_TIME_FORMAT = "time_format";
        public static final String QP_TIME_FORMAT_DEFAULT = "hh:mm:ss";
        public static final String QP_TIME_FORMAT_PROP = "QueryProcessor.time_format";
        public static final String FULL_QP_TIME_FORMAT_PROP = "space-config.QueryProcessor.time_format";
    }

    public static interface Space {
        public static final String SPACE_NAME_SYSTEM_PROPERTY = "com.gs.space.name";
        public static final String FULL_SPACE_STATE = "space-config.space_state";
    }

    public static interface Mirror {
        public static final String MIRROR_SERVICE_ENABLED_PROP = "mirror-service.enabled";
        public static final String MIRROR_SERVICE_ENABLED_DEFAULT = "false";
        public static final String FULL_MIRROR_SERVICE_ENABLED_PROP = "space-config.mirror-service.enabled";
    }

    public static interface Container {
        public static final String CONTAINER_CONFIG_DIRECTORY = "config";
        public static final String CONTAINER_CONFIG_FILE_SUFFIX = "-config.xml";
        public static final String CONTAINER_LICENSEKEY_PROP = "com.j_spaces.kernel.licensekey";
        public static final String LICENSE_KEY_SYS_PROP = "com.gs.licensekey";
        public static final String CONTAINER_LICENSEKEY_FILE_NAME = "gslicense.xml";
        public static final String JSPACE_HOME_SYS_PROP = "com.gs.home";
        public static final String CONTAINER_NAME_PROP = "com.j_spaces.core.container.name";
        public static final String CONTAINER_SECURITY_MODE_PROP = "com.j_spaces.core.container.security";
        public static final String CONTAINER_CONNECTION_TCP_PORT = "com.j_spaces.core.container.connection.tcp-port";
        public static final String CONTAINER_CONNECTION_TCP_PORT_DEFAULT = "0";
        public static final String CONTAINER_NAME_SYSTEM_PROPERTY = "com.gs.container.name";
        public static final String CONTAINER_SHUTDOWN_HOOK_PROP = "com.j_spaces.core.container.shutdown_hook";
        public static final String CONTAINER_SHUTDOWN_HOOK_PROP_DEFAULT = "true";
        public static final String CONTAINER_EMBEDDED_HTTPD_ENABLED_PROP = "com.j_spaces.core.container.embedded-services.httpd.enabled";
        public static final String CONTAINER_EMBEDDED_HTTPD_ENABLED_DEFAULT = "true";
        public static final String CONTAINER_EMBEDDED_HTTPD_ADDITIONAL_ROOTS_PROP = "com.j_spaces.core.container.embedded-services.httpd.additional-roots";
        public static final String CONTAINER_EMBEDDED_HTTPD_EXPLICIT_BINDING_ADDRESS_PROP = "com.j_spaces.core.container.embedded-services.httpd.explicit-binding-address";
    }

    public static interface Schemas {
        public static final String SCHEMA_ELEMENT = "schema";
        public static final String FULL_SCHEMA_ELEMENT = "space-config.schema";
        public static final String SCHEMAS_FOLDER = "schemas";
        public static final String DEFAULT_SCHEMA = "default";
        public static final String PERSISTENT_SCHEMA = "persistent";
        public static final String SWAP_SCHEMA = "swap";
        public static final String MIRROR_SCHEMA = "mirror";
        public static final String CACHE_SCHEMA = "cache";
        public static final String JAVASPACE_SCHEMA = "javaspace";
        public static final String SPACE_SCHEMA_FILE_SUFFIX = "-space-schema.xml";
        public static final String CONTAINER_SCHEMA_FILE_SUFFIX = "-container-schema.xml";
        public static final String SPACE_SCHEMA_DEFAULT_RESOURCES_FILE_NAME = "schemas/default-space-schema.xml";
        public static final String CONTAINER_SCHEMA_DEFAULT_RESOURCES_FILE_NAME = "schemas/default-container-schema.xml";
        public static final String[] ALL_SCHEMAS_ARRAY = new String[]{"default", "javaspace", "cache", "persistent", "swap", "mirror"};
    }

    public static interface System {
        public static final String SYSTEM_GS_POLICY = "policy/gigaspaces.policy";
        public static final String ENV_REPORT_SYSTEM_PROP = "com.gs.env.report";
    }
}

